/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MDocumentStatusAccess;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_PA_DocumentStatus;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MDocumentStatus
extends X_PA_DocumentStatus
implements ImmutablePOSupport {
    private static final long serialVersionUID = 4028519324986534673L;
    private static ImmutableIntPOCache<Integer, MDocumentStatus> s_cache = new ImmutableIntPOCache("PA_DocumentStatus", 20);

    public MDocumentStatus(Properties ctx, int PA_DocumentStatus_ID, String trxName) {
        super(ctx, PA_DocumentStatus_ID, trxName);
    }

    public MDocumentStatus(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDocumentStatus(MDocumentStatus copy) {
        this(Env.getCtx(), copy);
    }

    public MDocumentStatus(Properties ctx, MDocumentStatus copy) {
        this(ctx, copy, null);
    }

    public MDocumentStatus(Properties ctx, MDocumentStatus copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MDocumentStatus get(Properties ctx, int PA_DocumentStatus_ID) {
        Integer ii = PA_DocumentStatus_ID;
        MDocumentStatus retValue = s_cache.get(ctx, ii, e -> new MDocumentStatus(ctx, (MDocumentStatus)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDocumentStatus(ctx, PA_DocumentStatus_ID, null);
        if (retValue.get_ID() == PA_DocumentStatus_ID) {
            s_cache.put(PA_DocumentStatus_ID, retValue, e -> new MDocumentStatus(Env.getCtx(), (MDocumentStatus)e));
            return retValue;
        }
        return null;
    }

    public static MDocumentStatus[] getDocumentStatusIndicators(Properties ctx, int AD_User_ID, int AD_Role_ID) {
        return MDocumentStatus.getDocumentStatusIndicators(ctx, AD_User_ID, AD_Role_ID, null);
    }

    public static MDocumentStatus[] getDocumentStatusIndicators(Properties ctx, int AD_User_ID, int AD_Role_ID, String trxName) {
        if (AD_User_ID < 0) {
            return new MDocumentStatus[0];
        }
        String whereClause = "AD_Client_ID IN (0,?)";
        List list = new Query(ctx, "PA_DocumentStatus", whereClause, trxName).setOnlyActiveRecords(true).setOrderBy("SeqNo").setParameters(Env.getAD_Client_ID(ctx)).list();
        ArrayList<MDocumentStatus> listWithAccess = new ArrayList<MDocumentStatus>();
        for (MDocumentStatus ds : list) {
            Boolean access;
            if (!ds.canAccess(ctx, AD_User_ID, AD_Role_ID, trxName)) continue;
            if (ds.getAD_Window_ID() > 0) {
                access = MRole.getDefault().getWindowAccess(ds.getAD_Window_ID());
                if (access == null) continue;
                listWithAccess.add(ds);
                continue;
            }
            if (ds.getAD_Form_ID() <= 0 || (access = MRole.getDefault().getFormAccess(ds.getAD_Form_ID())) == null) continue;
            listWithAccess.add(ds);
        }
        MDocumentStatus[] retValue = new MDocumentStatus[listWithAccess.size()];
        listWithAccess.toArray(retValue);
        return retValue;
    }

    public static int evaluate(MDocumentStatus documentStatus) {
        StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM ");
        String tableName = MTable.getTableName(Env.getCtx(), documentStatus.getAD_Table_ID());
        sql.append(tableName);
        String where = MDocumentStatus.getWhereClause(documentStatus);
        if (where != null && where.trim().length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        String sqlS = MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, true);
        return DB.getSQLValue(null, sqlS);
    }

    public static String getWhereClause(MDocumentStatus documentStatus) {
        String extra;
        String tableName = MTable.getTableName(Env.getCtx(), documentStatus.getAD_Table_ID());
        StringBuilder where = new StringBuilder(" ").append(tableName).append(".AD_Client_ID=" + Env.getAD_Client_ID(Env.getCtx()));
        if (documentStatus.getC_Project_ID() > 0) {
            where.append(" AND ").append(tableName).append(".C_Project_ID=").append(documentStatus.getC_Project_ID());
        }
        if (documentStatus.getAD_Org_ID() > 0) {
            where.append(" AND ").append(tableName).append(".AD_Org_ID=").append(documentStatus.getAD_Org_ID());
        }
        if ((extra = documentStatus.getWhereClause()) != null && extra.trim().length() > 0) {
            where.append(" AND ( ").append(extra).append(" ) ");
        }
        return Env.parseContext(Env.getCtx(), 0, where.toString(), false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDocumentStatus[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    private boolean canAccess(Properties ctx, int userId, int roleId, String trxName) {
        List accessList = new Query(ctx, "PA_DocumentStatusAccess", "PA_DocumentStatus_ID=? AND AD_Client_ID IN (0,?)", trxName).setOnlyActiveRecords(true).setParameters(this.getPA_DocumentStatus_ID(), Env.getAD_Client_ID(ctx)).list();
        if (accessList.size() == 0) {
            return true;
        }
        for (MDocumentStatusAccess access : accessList) {
            if (!(access.getAD_Role_ID() == roleId && access.getAD_User_ID() == userId || access.getAD_Role_ID() == roleId && access.getAD_User_ID() == 0) && (access.getAD_Role_ID() != 0 || access.getAD_User_ID() != userId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

