/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.X_C_DocTypeCounter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MDocTypeCounter
extends X_C_DocTypeCounter
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3999273279386464393L;
    private static ImmutableIntPOCache<Integer, MDocTypeCounter> s_cache = new ImmutableIntPOCache("C_DocTypeCounter", 20);
    private static ImmutableIntPOCache<Integer, MDocTypeCounter> s_counter = new ImmutableIntPOCache("C_DocTypeCounter", "C_DocTypeCounter_Relation", 20);
    private static CLogger s_log = CLogger.getCLogger(MDocTypeCounter.class);

    public static int getCounterDocType_ID(Properties ctx, int C_DocType_ID) {
        MDocTypeCounter dtCounter = MDocTypeCounter.getCounterDocType(ctx, C_DocType_ID);
        if (dtCounter != null) {
            if (!dtCounter.isCreateCounter() || !dtCounter.isValid()) {
                return -1;
            }
            return dtCounter.getCounter_C_DocType_ID();
        }
        int Counter_C_DocType_ID = 0;
        MDocType dt = MDocType.get(C_DocType_ID);
        if (!dt.isCreateCounter()) {
            return -1;
        }
        String cDocBaseType = MDocTypeCounter.getCounterDocBaseType(dt.getDocBaseType());
        if (cDocBaseType == null) {
            return 0;
        }
        MDocType[] counters = MDocType.getOfDocBaseType(ctx, cDocBaseType);
        int i2 = 0;
        while (i2 < counters.length) {
            MDocType counter = counters[i2];
            if (counter.isDefaultCounterDoc()) {
                Counter_C_DocType_ID = counter.getC_DocType_ID();
                break;
            }
            if (counter.isDefault()) {
                Counter_C_DocType_ID = counter.getC_DocType_ID();
            } else if (i2 == 0) {
                Counter_C_DocType_ID = counter.getC_DocType_ID();
            }
            ++i2;
        }
        return Counter_C_DocType_ID;
    }

    public static MDocTypeCounter getCounterDocType(Properties ctx, int C_DocType_ID) {
        return MDocTypeCounter.getCounterDocType(C_DocType_ID);
    }

    public static MDocTypeCounter getCounterDocType(int C_DocType_ID) {
        MDocTypeCounter temp;
        MDocTypeCounter retValue;
        block10: {
            Integer key = C_DocType_ID;
            retValue = (MDocTypeCounter)s_counter.get(key);
            if (retValue != null) {
                return retValue;
            }
            temp = null;
            String sql = "SELECT * FROM C_DocTypeCounter WHERE IsActive = 'Y' and C_DocType_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_DocType_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next() && retValue == null) {
                        retValue = new MDocTypeCounter(Env.getCtx(), rs, null);
                        if (!retValue.isCreateCounter() || !retValue.isValid()) {
                            temp = retValue;
                            retValue = null;
                            continue;
                        }
                        s_counter.put(key, retValue);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "getCounterDocType", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            return retValue;
        }
        if (temp != null) {
            return temp;
        }
        return null;
    }

    public static MDocTypeCounter get(int C_DocTypeCounter_ID) {
        return MDocTypeCounter.get(C_DocTypeCounter_ID, null);
    }

    public static MDocTypeCounter get(int C_DocTypeCounter_ID, String trxName) {
        return MDocTypeCounter.get(Env.getCtx(), C_DocTypeCounter_ID, trxName);
    }

    public static MDocTypeCounter get(Properties ctx, int C_DocTypeCounter_ID, String trxName) {
        Integer key = C_DocTypeCounter_ID;
        MDocTypeCounter retValue = s_cache.get(ctx, key, e -> new MDocTypeCounter(ctx, (MDocTypeCounter)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDocTypeCounter(ctx, C_DocTypeCounter_ID, trxName);
        if (retValue.get_ID() == C_DocTypeCounter_ID) {
            s_cache.put(key, retValue, e -> new MDocTypeCounter(Env.getCtx(), (MDocTypeCounter)e));
            return retValue;
        }
        return null;
    }

    public static String getCounterDocBaseType(String DocBaseType) {
        if (DocBaseType == null) {
            return null;
        }
        String retValue = null;
        if ("SOO".equals(DocBaseType)) {
            retValue = "POO";
        } else if ("POO".equals(DocBaseType)) {
            retValue = "SOO";
        } else if ("API".equals(DocBaseType)) {
            retValue = "ARI";
        } else if ("ARI".equals(DocBaseType)) {
            retValue = "API";
        } else if ("MMS".equals(DocBaseType)) {
            retValue = "MMR";
        } else if ("MMR".equals(DocBaseType)) {
            retValue = "MMS";
        } else if ("APC".equals(DocBaseType)) {
            retValue = "ARC";
        } else if ("ARC".equals(DocBaseType)) {
            retValue = "APC";
        } else if ("ARR".equals(DocBaseType)) {
            retValue = "APP";
        } else if ("APP".equals(DocBaseType)) {
            retValue = "ARR";
        } else {
            s_log.log(Level.SEVERE, "getCounterDocBaseType for " + DocBaseType + ": None found");
        }
        return retValue;
    }

    public MDocTypeCounter(Properties ctx, int C_DocTypeCounter_ID, String trxName) {
        super(ctx, C_DocTypeCounter_ID, trxName);
        if (C_DocTypeCounter_ID == 0) {
            this.setIsCreateCounter(true);
            this.setIsValid(false);
        }
    }

    public MDocTypeCounter(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDocTypeCounter(MDocTypeCounter copy) {
        this(Env.getCtx(), copy);
    }

    public MDocTypeCounter(Properties ctx, MDocTypeCounter copy) {
        this(ctx, copy, null);
    }

    public MDocTypeCounter(Properties ctx, MDocTypeCounter copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    public void setC_DocType_ID(int C_DocType_ID) {
        super.setC_DocType_ID(C_DocType_ID);
        if (this.isValid()) {
            this.setIsValid(false);
        }
    }

    @Override
    public void setCounter_C_DocType_ID(int Counter_C_DocType_ID) {
        super.setCounter_C_DocType_ID(Counter_C_DocType_ID);
        if (this.isValid()) {
            this.setIsValid(false);
        }
    }

    public MDocType getDocType() {
        MDocType dt = null;
        if (this.getC_DocType_ID() > 0 && (dt = MDocType.get(this.getCtx(), this.getC_DocType_ID())).get_ID() == 0) {
            dt = null;
        }
        return dt;
    }

    public MDocType getCounterDocType() {
        MDocType dt = null;
        if (this.getCounter_C_DocType_ID() > 0 && (dt = MDocType.get(this.getCtx(), this.getCounter_C_DocType_ID())).get_ID() == 0) {
            dt = null;
        }
        return dt;
    }

    public String validate() {
        MDocType dt = this.getDocType();
        if (dt == null) {
            this.log.log(Level.SEVERE, "No DocType=" + this.getC_DocType_ID());
            this.setIsValid(false);
            return "No Document Type";
        }
        MDocType c_dt = this.getCounterDocType();
        if (c_dt == null) {
            this.log.log(Level.SEVERE, "No Counter DocType=" + this.getCounter_C_DocType_ID());
            this.setIsValid(false);
            return "No Counter Document Type";
        }
        String dtBT = dt.getDocBaseType();
        String c_dtBT = c_dt.getDocBaseType();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(dtBT) + " -> " + c_dtBT);
        }
        if ("SOO".equals(dtBT) && "POO".equals(c_dtBT) || "SOO".equals(c_dtBT) && "POO".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("API".equals(dtBT) && "ARI".equals(c_dtBT) || "API".equals(c_dtBT) && "ARI".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("MMS".equals(dtBT) && "MMR".equals(c_dtBT) || "MMS".equals(c_dtBT) && "MMR".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("APC".equals(dtBT) && "ARC".equals(c_dtBT) || "APC".equals(c_dtBT) && "ARC".equals(dtBT)) {
            this.setIsValid(true);
        } else if ("ARR".equals(dtBT) && "APP".equals(c_dtBT) || "ARR".equals(c_dtBT) && "APP".equals(dtBT)) {
            this.setIsValid(true);
        } else {
            this.log.warning("NOT - " + dtBT + " -> " + c_dtBT);
            this.setIsValid(false);
            return "Not valid";
        }
        if (!c_dt.isDocNoControlled()) {
            return "Counter Document Type should be automatically Document Number controlled";
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDocTypeCounter[");
        sb.append(this.get_ID()).append(",").append(this.getName()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(",Counter=").append(this.getCounter_C_DocType_ID()).append(",DocAction=").append(this.getDocAction()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (!newRecord && (this.is_ValueChanged("C_DocType_ID") || this.is_ValueChanged("Counter_C_DocType_ID"))) {
            this.setIsValid(false);
        }
        if (!this.isValid()) {
            this.validate();
        }
        return true;
    }

    @Override
    public MDocTypeCounter markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

