/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.MColumn;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_DocType;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MDocType
extends X_C_DocType
implements ImmutablePOSupport {
    private static final long serialVersionUID = 1830844263371227816L;
    private static ImmutableIntPOCache<Integer, MDocType> s_cache = new ImmutableIntPOCache("C_DocType", 20);

    public static int getDocType(String DocBaseType) {
        MDocType[] doc = MDocType.getOfDocBaseType(Env.getCtx(), DocBaseType);
        return doc.length > 0 ? doc[0].get_ID() : 0;
    }

    public static MDocType[] getOfDocBaseType(Properties ctx, String DocBaseType) {
        String whereClause = "AD_Client_ID=? AND DocBaseType=?";
        List<MDocType> list = new Query(ctx, "C_DocType", "AD_Client_ID=? AND DocBaseType=?", null).setParameters(Env.getAD_Client_ID(ctx), DocBaseType).setOnlyActiveRecords(true).setOrderBy("IsDefault DESC, C_DocType_ID").list();
        return list.toArray(new MDocType[list.size()]);
    }

    public static MDocType[] getOfClient(Properties ctx) {
        List<MDocType> list = new Query(ctx, "C_DocType", null, null).setClient_ID().setOnlyActiveRecords(true).list();
        return list.toArray(new MDocType[list.size()]);
    }

    public static MDocType get(int C_DocType_ID) {
        return MDocType.get(Env.getCtx(), C_DocType_ID);
    }

    public static MDocType get(Properties ctx, int C_DocType_ID) {
        MDocType retValue = s_cache.get(ctx, C_DocType_ID, e -> new MDocType(ctx, (MDocType)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDocType(ctx, C_DocType_ID, null);
        if (retValue.getC_DocType_ID() == C_DocType_ID) {
            s_cache.put(C_DocType_ID, retValue, e -> new MDocType(Env.getCtx(), (MDocType)e));
            return retValue;
        }
        return null;
    }

    public MDocType(Properties ctx, int C_DocType_ID, String trxName) {
        super(ctx, C_DocType_ID, trxName);
        if (C_DocType_ID == 0) {
            this.setDocumentCopies(0);
            this.setHasCharges(false);
            this.setIsDefault(false);
            this.setIsDocNoControlled(false);
            this.setIsSOTrx(false);
            this.setIsPickQAConfirm(false);
            this.setIsShipConfirm(false);
            this.setIsSplitWhenDifference(false);
            this.setIsCreateCounter(true);
            this.setIsDefaultCounterDoc(false);
            this.setIsIndexed(true);
        }
    }

    public MDocType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDocType(Properties ctx, String DocBaseType, String Name2, String trxName) {
        this(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setDocBaseType(DocBaseType);
        this.setName(Name2);
        this.setPrintName(Name2);
        this.setGL_Category_ID();
    }

    public MDocType(MDocType copy) {
        this(Env.getCtx(), copy);
    }

    public MDocType(Properties ctx, MDocType copy) {
        this(ctx, copy, null);
    }

    public MDocType(Properties ctx, MDocType copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public void setGL_Category_ID() {
        String sql = "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC, GL_Category_ID";
        int GL_Category_ID = DB.getSQLValue(this.get_TrxName(), "SELECT GL_Category_ID FROM GL_Category WHERE AD_Client_ID=? ORDER BY IsDefault DESC, GL_Category_ID", this.getAD_Client_ID());
        this.setGL_Category_ID(GL_Category_ID);
    }

    public void setIsSOTrx() {
        boolean isSOTrx = "SOO".equals(this.getDocBaseType()) || "MMS".equals(this.getDocBaseType()) || this.getDocBaseType().startsWith("AR");
        super.setIsSOTrx(isSOTrx);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDocType[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",DocNoSequence_ID=").append(this.getDocNoSequence_ID()).append("]");
        return sb.toString();
    }

    public boolean isQuotation() {
        return "OB".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isProposal() {
        return "ON".equals(this.getDocSubTypeSO()) && "SOO".equals(this.getDocBaseType());
    }

    public boolean isOffer() {
        return ("ON".equals(this.getDocSubTypeSO()) || "OB".equals(this.getDocSubTypeSO())) && "SOO".equals(this.getDocBaseType());
    }

    public String getPrintName(String AD_Language) {
        if (AD_Language == null || AD_Language.length() == 0) {
            return super.getPrintName();
        }
        return this.get_Translation("PrintName", AD_Language);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            StringBuilder sqlDocAction = new StringBuilder("INSERT INTO AD_Document_Action_Access ").append("(AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,").append("C_DocType_ID , AD_Ref_List_ID, AD_Role_ID) ").append("(SELECT ").append(this.getAD_Client_ID()).append(",0,'Y', getDate(),").append(this.getUpdatedBy()).append(", getDate(),").append(this.getUpdatedBy()).append(", doctype.C_DocType_ID, action.AD_Ref_List_ID, rol.AD_Role_ID ").append("FROM AD_Client client ").append("INNER JOIN C_DocType doctype ON (doctype.AD_Client_ID=client.AD_Client_ID) ").append("INNER JOIN AD_Ref_List action ON (action.AD_Reference_ID=135) ").append("INNER JOIN AD_Role rol ON (rol.AD_Client_ID=client.AD_Client_ID) ").append("WHERE client.AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND doctype.C_DocType_ID=").append(this.get_ID()).append(" AND rol.IsManual='N'").append(")");
            int docact = DB.executeUpdate(sqlDocAction.toString(), this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("AD_Document_Action_Access=" + docact);
            }
            if (DB.isGenerateUUIDSupported()) {
                DB.executeUpdateEx("UPDATE AD_Document_Action_Access SET AD_Document_Action_Access_UU=generate_uuid() WHERE AD_Document_Action_Access_UU IS NULL", this.get_TrxName());
            } else {
                UUIDGenerator.updateUUID(MColumn.get(this.getCtx(), "AD_Document_Action_Access", PO.getUUIDColumnName("AD_Document_Action_Access")), this.get_TrxName());
            }
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        StringBuilder msgdb = new StringBuilder("DELETE FROM AD_Document_Action_Access WHERE C_DocType_ID=").append(this.get_ID());
        int docactDel = DB.executeUpdate(msgdb.toString(), this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Delete AD_Document_Action_Access=" + docactDel + " for C_DocType_ID: " + this.get_ID());
        }
        return docactDel >= 0;
    }

    public static int getShipmentReceiptDocType(int docTypeId) {
        int relatedDocTypeId = 0;
        if (docTypeId != 0) {
            MDocType docType = MDocType.get(docTypeId);
            if ("Return Material".equals(docType.getName()) || "Vendor Return".equals(docType.getName()) || !docType.isSOTrx()) {
                String relatedDocTypeName = null;
                if ("Purchase Order".equals(docType.getName())) {
                    relatedDocTypeName = "MM Receipt";
                } else if ("Return Material".equals(docType.getName())) {
                    relatedDocTypeName = "MM Returns";
                } else if ("Vendor Return".equals(docType.getName())) {
                    relatedDocTypeName = "MM Vendor Returns";
                }
                if (relatedDocTypeName != null) {
                    StringBuilder whereClause = new StringBuilder(30);
                    whereClause.append("Name='").append(relatedDocTypeName).append("' ");
                    whereClause.append("and AD_Client_ID=").append(Env.getAD_Client_ID(Env.getCtx()));
                    whereClause.append(" AND IsActive='Y'");
                    int[] relDocTypeIds = MDocType.getAllIDs("C_DocType", whereClause.toString(), null);
                    if (relDocTypeIds.length > 0) {
                        relatedDocTypeId = relDocTypeIds[0];
                    }
                }
            } else {
                relatedDocTypeId = docType.getC_DocTypeShipment_ID();
            }
        }
        return relatedDocTypeId;
    }

    public String getNameTrl() {
        return this.get_Translation("Name", Env.getAD_Language(this.getCtx()));
    }

    @Override
    public MDocType markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

