/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MDistributionLine;
import org.compiere.model.Query;
import org.compiere.model.X_GL_Distribution;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MDistribution
extends X_GL_Distribution {
    private static final long serialVersionUID = -5964912910470166735L;
    private static CLogger s_log = CLogger.getCLogger(MDistribution.class);
    private static CCache<Integer, MDistribution[]> s_accounts = new CCache("GL_Distribution", 100);
    private MDistributionLine[] m_lines = null;

    public static MDistribution[] get(MAccount acct, String PostingType, int C_DocType_ID, Timestamp dateAcct) {
        return MDistribution.get(acct.getCtx(), acct.getC_AcctSchema_ID(), PostingType, C_DocType_ID, dateAcct, acct.getAD_Org_ID(), acct.getAccount_ID(), acct.getM_Product_ID(), acct.getC_BPartner_ID(), acct.getC_Project_ID(), acct.getC_Campaign_ID(), acct.getC_Activity_ID(), acct.getAD_OrgTrx_ID(), acct.getC_SalesRegion_ID(), acct.getC_LocTo_ID(), acct.getC_LocFrom_ID(), acct.getUser1_ID(), acct.getUser2_ID());
    }

    public static MDistribution[] get(int C_AcctSchema_ID, String PostingType, int C_DocType_ID, Timestamp dateAcct, int AD_Org_ID, int Account_ID, int M_Product_ID, int C_BPartner_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int AD_OrgTrx_ID, int C_SalesRegion_ID, int C_LocTo_ID, int C_LocFrom_ID, int User1_ID, int User2_ID) {
        return MDistribution.get(Env.getCtx(), C_AcctSchema_ID, PostingType, C_DocType_ID, dateAcct, AD_Org_ID, Account_ID, M_Product_ID, C_BPartner_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, AD_OrgTrx_ID, C_SalesRegion_ID, C_LocTo_ID, C_LocFrom_ID, User1_ID, User2_ID);
    }

    public static MDistribution[] get(Properties ctx, int C_AcctSchema_ID, String PostingType, int C_DocType_ID, Timestamp dateAcct, int AD_Org_ID, int Account_ID, int M_Product_ID, int C_BPartner_ID, int C_Project_ID, int C_Campaign_ID, int C_Activity_ID, int AD_OrgTrx_ID, int C_SalesRegion_ID, int C_LocTo_ID, int C_LocFrom_ID, int User1_ID, int User2_ID) {
        MDistribution[] acctList = MDistribution.getAll();
        if (acctList == null || acctList.length == 0) {
            return null;
        }
        ArrayList<MDistribution> list = new ArrayList<MDistribution>();
        int i2 = 0;
        while (i2 < acctList.length) {
            MDistribution distribution = acctList[i2];
            if (!(!distribution.isActive() || !distribution.isValid() || distribution.getC_AcctSchema_ID() != C_AcctSchema_ID || distribution.getPostingType() != null && !distribution.getPostingType().equals(PostingType) || distribution.getC_DocType_ID() != 0 && distribution.getC_DocType_ID() != C_DocType_ID || distribution.getValidFrom() != null && distribution.getValidFrom().after(dateAcct) || distribution.getValidTo() != null && distribution.getValidTo().before(dateAcct) || !distribution.isAnyOrg() && distribution.getOrg_ID() != AD_Org_ID || !distribution.isAnyAcct() && distribution.getAccount_ID() != Account_ID || !distribution.isAnyProduct() && distribution.getM_Product_ID() != M_Product_ID || !distribution.isAnyBPartner() && distribution.getC_BPartner_ID() != C_BPartner_ID || !distribution.isAnyProject() && distribution.getC_Project_ID() != C_Project_ID || !distribution.isAnyCampaign() && distribution.getC_Campaign_ID() != C_Campaign_ID || !distribution.isAnyActivity() && distribution.getC_Activity_ID() != C_Activity_ID || !distribution.isAnyOrgTrx() && distribution.getAD_OrgTrx_ID() != AD_OrgTrx_ID || !distribution.isAnySalesRegion() && distribution.getC_SalesRegion_ID() != C_SalesRegion_ID || !distribution.isAnyLocTo() && distribution.getC_LocTo_ID() != C_LocTo_ID || !distribution.isAnyLocFrom() && distribution.getC_LocFrom_ID() != C_LocFrom_ID || !distribution.isAnyUser1() && distribution.getUser1_ID() != User1_ID || !distribution.isAnyUser2() && distribution.getUser2_ID() != User2_ID)) {
                list.add(distribution);
            }
            ++i2;
        }
        MDistribution[] retValue = new MDistribution[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MDistribution[] get(Properties ctx, int Account_ID) {
        return MDistribution.get(Account_ID);
    }

    public static MDistribution[] get(int Account_ID) {
        Properties ctx = Env.getCtx();
        Integer key = Account_ID;
        MDistribution[] retValue = s_accounts.get(key);
        if (retValue != null) {
            return retValue;
        }
        String whereClause = "";
        Object[] parameters = null;
        if (Account_ID >= 0) {
            whereClause = "Account_ID=?";
            parameters = new Object[]{Account_ID};
        }
        List<MDistribution> list = new Query(ctx, "GL_Distribution", whereClause, null).setClient_ID().setParameters(parameters).setOrderBy("SeqNo, GL_Distribution_ID").list();
        retValue = new MDistribution[list.size()];
        retValue = list.toArray(retValue);
        s_accounts.put(key, retValue);
        return retValue;
    }

    @Deprecated
    public static MDistribution[] getAll(Properties ctx) {
        return MDistribution.getAll();
    }

    public static MDistribution[] getAll() {
        return MDistribution.get(-1);
    }

    public MDistribution(Properties ctx, int GL_Distribution_ID, String trxName) {
        super(ctx, GL_Distribution_ID, trxName);
        if (GL_Distribution_ID == 0) {
            this.setAnyAcct(true);
            this.setAnyActivity(true);
            this.setAnyBPartner(true);
            this.setAnyCampaign(true);
            this.setAnyLocFrom(true);
            this.setAnyLocTo(true);
            this.setAnyOrg(true);
            this.setAnyOrgTrx(true);
            this.setAnyProduct(true);
            this.setAnyProject(true);
            this.setAnySalesRegion(true);
            this.setAnyUser1(true);
            this.setAnyUser2(true);
            this.setIsValid(false);
            this.setPercentTotal(Env.ZERO);
        }
    }

    public MDistribution(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDistribution(MDistribution copy) {
        this(Env.getCtx(), copy);
    }

    public MDistribution(Properties ctx, MDistribution copy) {
        this(ctx, copy, null);
    }

    public MDistribution(Properties ctx, MDistribution copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_lines = copy.m_lines != null ? (MDistributionLine[])Arrays.stream(copy.m_lines).map(e -> {
            MDistributionLine v = new MDistributionLine(ctx, (MDistributionLine)e, trxName);
            v.setParent(this);
            return v;
        }).toArray(MDistributionLine[]::new) : null;
    }

    public MDistributionLine[] getLines(boolean reload) {
        if (this.m_lines != null && !reload) {
            MDistribution.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        BigDecimal PercentTotal = Env.ZERO;
        String whereClause = "GL_Distribution_ID=?";
        List<MDistributionLine> list = new Query(this.getCtx(), "GL_DistributionLine", "GL_Distribution_ID=?", this.get_TrxName()).setParameters(this.getGL_Distribution_ID()).setOrderBy("Line,GL_DistributionLine_ID").list();
        boolean hasNullRemainder = false;
        for (MDistributionLine dl : list) {
            if (dl.isActive()) {
                PercentTotal = PercentTotal.add(dl.getPercent());
                hasNullRemainder = Env.ZERO.compareTo(dl.getPercent()) == 0;
            }
            dl.setParent(this);
        }
        if (hasNullRemainder) {
            PercentTotal = Env.ONEHUNDRED;
        }
        if (this.get_ID() != 0 && PercentTotal.compareTo(this.getPercentTotal()) != 0) {
            this.setPercentTotal(PercentTotal);
            this.saveEx();
        }
        this.m_lines = new MDistributionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public String validate() {
        String retValue = null;
        this.getLines(true);
        if (this.m_lines.length == 0) {
            retValue = "@NoLines@";
        } else if (this.getPercentTotal().compareTo(Env.ONEHUNDRED) != 0) {
            retValue = "@PercentTotal@ <> 100";
        } else {
            int lineFound = -1;
            int i2 = 0;
            while (i2 < this.m_lines.length) {
                if (this.m_lines[i2].getPercent().compareTo(Env.ZERO) == 0) {
                    if (lineFound >= 0 && this.m_lines[i2].getPercent().compareTo(Env.ZERO) == 0) {
                        retValue = "@Line@ " + lineFound + " + " + this.m_lines[i2].getLine() + ": == 0";
                        break;
                    }
                    lineFound = this.m_lines[i2].getLine();
                }
                ++i2;
            }
        }
        this.setIsValid(retValue == null);
        return retValue;
    }

    public void distribute(MAccount acct, BigDecimal Amt, BigDecimal Qty, int C_Currency_ID) {
        BigDecimal differenceQty;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("distribute - Amt=" + Amt + " - Qty=" + Qty + " - " + acct);
        }
        this.getLines(false);
        int precision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
        BigDecimal total = Env.ZERO;
        BigDecimal totalQty = Env.ZERO;
        int indexBiggest = -1;
        int indexZeroPercent = -1;
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            MDistributionLine dl = this.m_lines[i2];
            if (dl.isActive()) {
                dl.setAccount(acct);
                dl.calculateAmt(Amt, precision);
                dl.calculateQty(Qty);
                total = total.add(dl.getAmt());
                totalQty = totalQty.add(dl.getQty());
                if (dl.getPercent().compareTo(Env.ZERO) == 0) {
                    indexZeroPercent = i2;
                }
                if (indexZeroPercent == -1) {
                    if (indexBiggest == -1) {
                        indexBiggest = i2;
                    } else if (dl.getAmt().compareTo(this.m_lines[indexBiggest].getAmt()) > 0) {
                        indexBiggest = i2;
                    }
                }
            }
            ++i2;
        }
        BigDecimal difference = Amt.subtract(total);
        if (difference.compareTo(Env.ZERO) != 0) {
            if (indexZeroPercent != -1) {
                this.m_lines[indexZeroPercent].setAmt(difference);
            } else if (indexBiggest != -1) {
                this.m_lines[indexBiggest].setAmt(this.m_lines[indexBiggest].getAmt().add(difference));
            } else {
                this.log.warning("distribute - Remaining Difference=" + difference);
            }
        }
        if ((differenceQty = Qty.subtract(totalQty)).compareTo(Env.ZERO) != 0) {
            if (indexZeroPercent != -1) {
                this.m_lines[indexZeroPercent].setQty(differenceQty);
            } else if (indexBiggest != -1) {
                this.m_lines[indexBiggest].setQty(this.m_lines[indexBiggest].getQty().add(differenceQty));
            } else {
                this.log.warning("distribute - Remaining Qty Difference=" + differenceQty);
            }
        }
        if (CLogMgt.isLevelFinest()) {
            int i3 = 0;
            while (i3 < this.m_lines.length) {
                if (this.m_lines[i3].isActive() && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("distribute = Amt=" + this.m_lines[i3].getAmt() + " - " + this.m_lines[i3].getAccount());
                }
                ++i3;
            }
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isAnyAcct() && this.getAccount_ID() != 0) {
            this.setAccount_ID(0);
        }
        if (this.isAnyActivity() && this.getC_Activity_ID() != 0) {
            this.setC_Activity_ID(0);
        }
        if (this.isAnyBPartner() && this.getC_BPartner_ID() != 0) {
            this.setC_BPartner_ID(0);
        }
        if (this.isAnyCampaign() && this.getC_Campaign_ID() != 0) {
            this.setC_Campaign_ID(0);
        }
        if (this.isAnyLocFrom() && this.getC_LocFrom_ID() != 0) {
            this.setC_LocFrom_ID(0);
        }
        if (this.isAnyLocTo() && this.getC_LocTo_ID() != 0) {
            this.setC_LocTo_ID(0);
        }
        if (this.isAnyOrg() && this.getOrg_ID() != 0) {
            this.setOrg_ID(0);
        }
        if (this.isAnyOrgTrx() && this.getAD_OrgTrx_ID() != 0) {
            this.setAD_OrgTrx_ID(0);
        }
        if (this.isAnyProduct() && this.getM_Product_ID() != 0) {
            this.setM_Product_ID(0);
        }
        if (this.isAnyProject() && this.getC_Project_ID() != 0) {
            this.setC_Project_ID(0);
        }
        if (this.isAnySalesRegion() && this.getC_SalesRegion_ID() != 0) {
            this.setC_SalesRegion_ID(0);
        }
        if (this.isAnyUser1() && this.getUser1_ID() != 0) {
            this.setUser1_ID(0);
        }
        if (this.isAnyUser2() && this.getUser2_ID() != 0) {
            this.setUser2_ID(0);
        }
        return true;
    }
}

