/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Method;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MDepreciationMethod
extends X_A_Depreciation_Method
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7477974832683140825L;
    private static ImmutableIntPOCache<Integer, MDepreciationMethod> s_cache = new ImmutableIntPOCache("A_Depreciation_Method", 5);
    private static ImmutablePOCache<String, MDepreciationMethod> s_cache_forType = new ImmutablePOCache("A_Depreciation_Method", "A_Depreciation_Method_DepreciationType", 5);

    public MDepreciationMethod(Properties ctx, int A_Depreciation_Method_ID, String trxName) {
        super(ctx, A_Depreciation_Method_ID, trxName);
    }

    public MDepreciationMethod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDepreciationMethod(MDepreciationMethod copy) {
        this(Env.getCtx(), copy);
    }

    public MDepreciationMethod(Properties ctx, MDepreciationMethod copy) {
        this(ctx, copy, null);
    }

    public MDepreciationMethod(Properties ctx, MDepreciationMethod copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    private static void addToCache(MDepreciationMethod depr) {
        if (depr == null) {
            return;
        }
        s_cache.put(depr.get_ID(), depr, e -> new MDepreciationMethod(Env.getCtx(), (MDepreciationMethod)e));
        s_cache_forType.put(depr.getDepreciationType(), depr, e -> new MDepreciationMethod(Env.getCtx(), (MDepreciationMethod)e));
    }

    private static int getPrecision() {
        return 2;
    }

    public static MDepreciationMethod get(int A_Depreciation_Method_ID) {
        return MDepreciationMethod.get(Env.getCtx(), A_Depreciation_Method_ID);
    }

    public static MDepreciationMethod get(Properties ctx, int A_Depreciation_Method_ID) {
        MDepreciationMethod depr = s_cache.get(ctx, A_Depreciation_Method_ID, e -> new MDepreciationMethod(ctx, (MDepreciationMethod)e));
        if (depr != null) {
            return depr;
        }
        depr = new MDepreciationMethod(ctx, A_Depreciation_Method_ID, null);
        if (depr.get_ID() == A_Depreciation_Method_ID) {
            MDepreciationMethod.addToCache(depr);
            return depr;
        }
        return null;
    }

    public static MDepreciationMethod get(String depreciationType) {
        return MDepreciationMethod.get(Env.getCtx(), depreciationType);
    }

    public static MDepreciationMethod get(Properties ctx, String depreciationType) {
        String key = depreciationType;
        MDepreciationMethod depr = s_cache_forType.get(ctx, key, e -> new MDepreciationMethod(ctx, (MDepreciationMethod)e));
        if (depr != null) {
            return depr;
        }
        depr = (MDepreciationMethod)new Query(ctx, "A_Depreciation_Method", "DepreciationType=?", null).setParameters(depreciationType).firstOnly();
        MDepreciationMethod.addToCache(depr);
        return depr.markImmutable();
    }

    public static BigDecimal invoke(Properties ctx, String depreciationType, int A_Asset_ID, BigDecimal A_Asset_Adjustment, int A_PeriodNo, String PostingType, int A_Asset_Acct_ID) {
        MDepreciationMethod depr = MDepreciationMethod.get(ctx, depreciationType);
        if (depr == null) {
            throw new IllegalArgumentException("@NotFound@ @DepreciationType@ " + depreciationType);
        }
        return depr.invoke(A_Asset_ID, A_Asset_Adjustment, A_PeriodNo, PostingType, A_Asset_Acct_ID);
    }

    public BigDecimal invoke(MDepreciationWorkfile assetwk, MAssetAcct assetAcct, BigDecimal A_Asset_Adjustment, int A_PeriodNo) {
        return this.invoke(assetwk.getA_Asset_ID(), A_Asset_Adjustment, A_PeriodNo, assetAcct.getPostingType(), assetAcct.get_ID());
    }

    public BigDecimal invoke(int A_Asset_ID, BigDecimal A_Asset_Adjustment, int A_PeriodNo, String PostingType, int A_Asset_Acct_ID) {
        String depreciationType = this.getDepreciationType();
        BigDecimal retValue = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: DepreciationMethodType=" + depreciationType + ", A_Asset_ID=" + A_Asset_ID + ", A_Asset_Adjustment=" + A_Asset_Adjustment + ", A_PeriodNo=" + A_PeriodNo + ", PostingType=" + PostingType + ", A_Asset_Acct_ID=" + A_Asset_Acct_ID);
        }
        if (depreciationType.equalsIgnoreCase("MDI")) {
            retValue = this.apply_MDI(A_Asset_ID, A_Asset_Adjustment, A_PeriodNo, PostingType, A_Asset_Acct_ID);
        } else if (depreciationType.equalsIgnoreCase("YDI")) {
            retValue = this.apply_YDI(A_Asset_ID, A_Asset_Adjustment, A_PeriodNo, PostingType, A_Asset_Acct_ID);
        } else if (depreciationType.equalsIgnoreCase("LDI")) {
            retValue = this.apply_LDI(A_Asset_ID, A_Asset_Adjustment, A_PeriodNo, PostingType, A_Asset_Acct_ID);
        } else {
            String sql = "{ ? = call " + depreciationType + "(?, ?, ?, ?, ?) }";
            CallableStatement cs = null;
            try {
                try {
                    cs = DB.prepareCall(sql);
                    cs.registerOutParameter(1, 3);
                    cs.setInt(2, A_Asset_ID);
                    cs.setBigDecimal(3, A_Asset_Adjustment);
                    cs.setInt(4, A_PeriodNo);
                    cs.setString(5, PostingType);
                    cs.setInt(6, A_Asset_Acct_ID);
                    cs.execute();
                    retValue = cs.getBigDecimal(1);
                }
                catch (SQLException e) {
                    throw new DBException(e);
                }
            }
            finally {
                DB.close(cs);
                cs = null;
            }
        }
        if (retValue == null) {
            retValue = BigDecimal.ZERO;
        }
        if (CLogMgt.isLevelFine() && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving: retValue=" + retValue);
        }
        return retValue;
    }

    public BigDecimal apply_MDI(int A_Asset_ID, BigDecimal A_Asset_Adjustment, int A_PeriodNo, String PostingType, int A_Asset_Acct_ID) {
        return A_Asset_Adjustment;
    }

    public BigDecimal apply_YDI(int A_Asset_ID, BigDecimal A_Asset_Adjustment, int A_PeriodNo, String PostingType, int A_Asset_Acct_ID) {
        BigDecimal remainingPeriods = new BigDecimal(12 - A_PeriodNo);
        if (remainingPeriods.signum() == 0) {
            this.log.warning("A_PeriodNo=" + A_PeriodNo + " => remainingPeriods=" + remainingPeriods);
        }
        BigDecimal periodAdjustment = A_Asset_Adjustment.divide(remainingPeriods, MDepreciationMethod.getPrecision(), RoundingMode.HALF_UP);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("A_Asset_Adjustment=" + A_Asset_Adjustment + ", remainingPeriods=" + remainingPeriods + " => periodAdjustment=" + periodAdjustment);
        }
        return periodAdjustment;
    }

    public BigDecimal apply_LDI(int A_Asset_ID, BigDecimal A_Asset_Adjustment, int A_PeriodNo, String PostingType, int A_Asset_Acct_ID) {
        int A_Period_Posted;
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(this.getCtx(), A_Asset_ID, PostingType);
        int A_Life_Period = wk.getA_Life_Period();
        BigDecimal remainingPeriods = new BigDecimal(A_Life_Period - (A_Period_Posted = wk.getA_Period_Posted()) + 1);
        if (remainingPeriods.signum() == 0) {
            this.log.warning("A_Life_Period=" + A_Life_Period + ", A_Period_Posted=" + A_Period_Posted + " => remainingPeriods=" + remainingPeriods);
            return BigDecimal.ZERO;
        }
        BigDecimal periodAdjustment = A_Asset_Adjustment.divide(remainingPeriods, MDepreciationMethod.getPrecision(), RoundingMode.HALF_UP);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("A_Asset_Adjustment=" + A_Asset_Adjustment + ", remainingPeriods=" + remainingPeriods + " => periodAdjustment=" + periodAdjustment);
        }
        return periodAdjustment;
    }

    @Override
    public MDepreciationMethod markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

