/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.model.X_AD_CtxHelpMsg;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCtxHelpMsg
extends X_AD_CtxHelpMsg
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3148838750037103261L;
    private static CLogger s_log = CLogger.getCLogger(MCtxHelpMsg.class);
    private static ImmutablePOCache<String, MCtxHelpMsg> s_cache = new ImmutablePOCache("AD_CtxHelpMsg", 10);

    public MCtxHelpMsg(Properties ctx, int AD_CtxHelpMsg_ID, String trxName) {
        super(ctx, AD_CtxHelpMsg_ID, trxName);
    }

    public MCtxHelpMsg(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCtxHelpMsg(MCtxHelpMsg copy) {
        this(Env.getCtx(), copy);
    }

    public MCtxHelpMsg(Properties ctx, MCtxHelpMsg copy) {
        this(ctx, copy, null);
    }

    public MCtxHelpMsg(Properties ctx, MCtxHelpMsg copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MCtxHelpMsg get(String ctxType, int recordId) {
        return MCtxHelpMsg.get(Env.getCtx(), ctxType, recordId);
    }

    public static MCtxHelpMsg get(Properties ctx, String ctxType, int recordId) {
        StringBuilder key = new StringBuilder().append(ctxType).append("|").append(recordId).append("|").append(Env.getAD_Client_ID(ctx)).append("|").append(Env.getAD_Org_ID(ctx));
        MCtxHelpMsg retValue = null;
        if (s_cache.containsKey(key.toString())) {
            retValue = s_cache.get(ctx, key.toString(), e -> new MCtxHelpMsg(ctx, (MCtxHelpMsg)e));
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest("Cache: " + retValue);
            }
            return retValue;
        }
        int AD_CtxHelp_ID = MCtxHelpMsg.getCtxHelpID(ctxType, recordId);
        if (AD_CtxHelp_ID > 0) {
            Query query = new Query(ctx, "AD_CtxHelpMsg", "IsActive = 'Y' AND AD_Client_ID IN (0, ?)  AND AD_Org_ID IN (0, ?)  AND AD_CtxHelp_ID = ? ", null);
            retValue = (MCtxHelpMsg)query.setOrderBy("AD_Client_ID DESC, AD_Org_ID DESC, AD_CtxHelpMsg_ID DESC").setParameters(Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx), AD_CtxHelp_ID).first();
        }
        s_cache.put(key.toString(), retValue, e -> new MCtxHelpMsg(Env.getCtx(), (MCtxHelpMsg)e));
        return retValue;
    }

    private static int getCtxHelpID(String ctxType, int recordId) {
        String table2;
        String column;
        Properties ctx = Env.getCtx();
        if (ctxType == "T") {
            column = "AD_Tab_ID";
            table2 = "AD_Tab";
        } else if (ctxType == "P") {
            column = "AD_Process_ID";
            table2 = "AD_Process";
        } else if (ctxType == "F") {
            column = "AD_Form_ID";
            table2 = "AD_Form";
        } else if (ctxType == "I") {
            column = "AD_InfoWindow_ID";
            table2 = "AD_InfoWindow";
        } else if (ctxType == "W") {
            column = "AD_Workflow_ID";
            table2 = "AD_Workflow";
        } else if (ctxType == "K") {
            column = "AD_Task_ID";
            table2 = "AD_Task";
        } else if (ctxType == "N") {
            column = "AD_WF_Node_ID";
            table2 = "AD_WF_Node";
        } else {
            column = "";
            table2 = "AD_CtxHelp";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t.AD_CtxHelp_ID FROM ");
        sql.append(table2);
        sql.append(" t, AD_CtxHelp h WHERE t.AD_CtxHelp_ID=h.AD_CtxHelp_ID AND t.IsActive='Y' AND h.IsActive='Y' AND h.AD_Client_ID IN (0, ?) AND h.AD_Org_ID IN (0, ?) ");
        if (ctxType == "H") {
            sql.append("AND h.CtxType");
        } else if (ctxType == "T" || ctxType == "P" || ctxType == "F" || ctxType == "I" || ctxType == "W" || ctxType == "K" || ctxType == "N") {
            sql.append("AND t.");
            sql.append(column);
        } else {
            sql.append("AND 1");
        }
        sql.append("=? ");
        sql.append("ORDER BY h.AD_Client_ID DESC, h.AD_Org_ID DESC, h.AD_CtxHelp_ID DESC");
        return DB.getSQLValue(null, sql.toString(), Env.getAD_Client_ID(ctx), Env.getAD_Org_ID(ctx), ctxType == "H" ? ctxType : Integer.valueOf(recordId));
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public MCtxHelpMsg markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        super.makeImmutable();
        return this;
    }
}

