/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Conversion_Rate;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class MConversionRate
extends X_C_Conversion_Rate {
    private static final long serialVersionUID = -3866898973541150020L;
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);
    private static volatile boolean recursiveCall = false;

    public static BigDecimal convertBase(Properties ctx, BigDecimal Amt, int CurFrom_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, MClient.get(ctx).getC_Currency_ID(), ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, CurTo_ID, null, 0, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID, false);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID, boolean isCosting) {
        int stdPrecision;
        if (Amt == null) {
            throw new IllegalArgumentException("Required parameter missing - Amt");
        }
        if (CurFrom_ID == CurTo_ID || Amt.compareTo(Env.ZERO) == 0) {
            return Amt;
        }
        BigDecimal retValue = MConversionRate.getRate(CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        if (retValue == null) {
            return null;
        }
        retValue = retValue.multiply(Amt);
        int n = stdPrecision = isCosting ? MCurrency.getCostingPrecision(ctx, CurTo_ID) : MCurrency.getStdPrecision(ctx, CurTo_ID);
        if (retValue.scale() > stdPrecision) {
            retValue = retValue.setScale(stdPrecision, RoundingMode.HALF_UP);
        }
        return retValue;
    }

    public static void setRate(String CurFrom_ISO, String CurTo_ISO, Date spotDate, BigDecimal MultiplyRate) throws Exception {
        String trxName = Trx.createTrxName();
        Trx trx = Trx.get(trxName, true);
        trx.setDisplayName(String.valueOf(MConversionRate.class.getName()) + "_setRate");
        Properties ctx = Env.getCtx();
        MCurrency curFrom = MCurrency.get(ctx, CurFrom_ISO);
        if (curFrom == null) {
            throw new Exception("Invalid currency " + CurFrom_ISO);
        }
        MCurrency curTo = MCurrency.get(ctx, CurTo_ISO);
        if (curTo == null) {
            throw new Exception("Invalid currency " + CurTo_ISO);
        }
        if (spotDate == null) {
            spotDate = Calendar.getInstance().getTime();
        }
        Calendar spotCal = Calendar.getInstance();
        spotCal.setTime(spotDate);
        spotCal.set(11, 0);
        spotCal.set(12, 0);
        spotCal.set(13, 0);
        spotCal.set(14, 0);
        Timestamp startTs = new Timestamp(spotCal.getTimeInMillis());
        String whereClause = "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?";
        MConversionRate updateRate = null;
        List rates = new Query(ctx, "C_Conversion_Rate", "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?", trxName).setParameters(curFrom.get_ID(), curTo.get_ID(), startTs, startTs, 114).list();
        if (rates.size() > 0) {
            for (MConversionRate rate : rates) {
                if (!rate.getValidFrom().equals(rate.getValidTo())) {
                    rate.deleteEx(true, trxName);
                    continue;
                }
                updateRate = rate;
            }
        }
        if (updateRate == null) {
            updateRate = new MConversionRate(ctx, 0, trxName);
            updateRate.setAD_Client_ID(0);
            updateRate.setAD_Org_ID(0);
            updateRate.setC_Currency_ID(curFrom.get_ID());
            updateRate.setC_Currency_ID_To(curTo.get_ID());
            updateRate.setValidFrom(startTs);
            updateRate.setValidTo(startTs);
            updateRate.setC_ConversionType_ID(114);
        }
        updateRate.setMultiplyRate(MultiplyRate);
        updateRate.saveEx(trxName);
        trx.commit(true);
        trx.close();
    }

    public static BigDecimal getRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        BigDecimal retValue;
        int C_ConversionType_ID;
        block10: {
            if (CurFrom_ID == CurTo_ID) {
                return Env.ONE;
            }
            C_ConversionType_ID = ConversionType_ID;
            if (C_ConversionType_ID == 0) {
                C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
            }
            if (ConvDate == null) {
                ConvDate = TimeUtil.getDay(null);
            }
            String sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? BETWEEN ValidFrom AND ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?)  AND IsActive = 'Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
            retValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, CurFrom_ID);
                    pstmt.setInt(2, CurTo_ID);
                    pstmt.setInt(3, C_ConversionType_ID);
                    pstmt.setTimestamp(4, TimeUtil.getDay(ConvDate));
                    pstmt.setInt(5, AD_Client_ID);
                    pstmt.setInt(6, AD_Org_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "getRate", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null && s_log.isLoggable(Level.INFO)) {
            s_log.info("getRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }

    public MConversionRate(Properties ctx, int C_Conversion_Rate_ID, String trxName) {
        super(ctx, C_Conversion_Rate_ID, trxName);
        if (C_Conversion_Rate_ID == 0) {
            super.setDivideRate(Env.ZERO);
            super.setMultiplyRate(Env.ZERO);
            this.setValidFrom(new Timestamp(System.currentTimeMillis()));
        }
    }

    public MConversionRate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MConversionRate(PO po, int C_ConversionType_ID, int C_Currency_ID, int C_Currency_ID_To, BigDecimal MultiplyRate, Timestamp ValidFrom) {
        this(po.getCtx(), 0, po.get_TrxName());
        this.setClientOrg(po);
        this.setC_ConversionType_ID(C_ConversionType_ID);
        this.setC_Currency_ID(C_Currency_ID);
        this.setC_Currency_ID_To(C_Currency_ID_To);
        this.setMultiplyRate(MultiplyRate);
        this.setValidFrom(ValidFrom);
    }

    public MConversionRate(Properties ctx, int C_Conversion_Rate_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_Conversion_Rate_ID, trxName, virtualColumns);
    }

    @Override
    public void setMultiplyRate(BigDecimal MultiplyRate) {
        if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) == 0 || MultiplyRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setMultiplyRate(MultiplyRate);
            double dd = 1.0 / MultiplyRate.doubleValue();
            super.setDivideRate(BigDecimal.valueOf(dd));
        }
    }

    @Override
    public void setDivideRate(BigDecimal DivideRate) {
        if (DivideRate == null || DivideRate.compareTo(Env.ZERO) == 0 || DivideRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setDivideRate(DivideRate);
            double dd = 1.0 / DivideRate.doubleValue();
            super.setMultiplyRate(BigDecimal.valueOf(dd));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MConversionRate[");
        sb.append(this.get_ID()).append(",Currency=").append(this.getC_Currency_ID()).append(",To=").append(this.getC_Currency_ID_To()).append(", Multiply=").append(this.getMultiplyRate()).append(",Divide=").append(this.getDivideRate()).append(", ValidFrom=").append(this.getValidFrom());
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Currency_ID() == this.getC_Currency_ID_To()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@C_Currency_ID@ = @C_Currency_ID@"));
            return false;
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@MultiplyRate@ <= 0"));
            return false;
        }
        Timestamp from = this.getValidFrom();
        if (this.getValidTo() == null) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "ValidTo"));
            return false;
        }
        Timestamp to = this.getValidTo();
        if (to.before(from)) {
            SimpleDateFormat df = DisplayType.getDateFormat(15);
            this.log.saveError("Error", String.valueOf(df.format(to)) + " < " + df.format(from));
            return false;
        }
        if (this.isActive()) {
            String whereClause = "(? BETWEEN ValidFrom AND ValidTo OR ? BETWEEN ValidFrom AND ValidTo) AND C_Currency_ID=? AND C_Currency_ID_To=? AND C_Conversiontype_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
            List convs = new Query(this.getCtx(), "C_Conversion_Rate", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getValidFrom(), this.getValidTo(), this.getC_Currency_ID(), this.getC_Currency_ID_To(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()).list();
            for (MConversionRate conv : convs) {
                if (conv.getC_Conversion_Rate_ID() == this.getC_Conversion_Rate_ID()) continue;
                this.log.saveError("Error", "Conversion rate overlaps with: " + conv.getValidFrom());
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success && !recursiveCall) {
            String whereClause = "ValidFrom=? AND ValidTo=? AND C_Currency_ID=? AND C_Currency_ID_To=? AND C_ConversionType_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
            MConversionRate reciprocal = (MConversionRate)new Query(this.getCtx(), "C_Conversion_Rate", whereClause, this.get_TrxName()).setParameters(this.getValidFrom(), this.getValidTo(), this.getC_Currency_ID_To(), this.getC_Currency_ID(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()).firstOnly();
            if (reciprocal == null) {
                reciprocal = new MConversionRate(this.getCtx(), 0, this.get_TrxName());
                reciprocal.setValidFrom(this.getValidFrom());
                reciprocal.setValidTo(this.getValidTo());
                reciprocal.setC_ConversionType_ID(this.getC_ConversionType_ID());
                reciprocal.setAD_Client_ID(this.getAD_Client_ID());
                reciprocal.setAD_Org_ID(this.getAD_Org_ID());
                reciprocal.setC_Currency_ID(this.getC_Currency_ID_To());
                reciprocal.setC_Currency_ID_To(this.getC_Currency_ID());
            }
            reciprocal.set_Value("DivideRate", (Object)this.getMultiplyRate());
            reciprocal.set_Value("MultiplyRate", (Object)this.getDivideRate());
            recursiveCall = true;
            try {
                reciprocal.saveEx();
            }
            finally {
                recursiveCall = false;
            }
        }
        return success;
    }
}

