/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Locale;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MYear;
import org.compiere.model.X_C_Calendar;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MCalendar
extends X_C_Calendar
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6036302512252100576L;
    private static ImmutableIntPOCache<Integer, MCalendar> s_cache = new ImmutableIntPOCache("C_Calendar", 20);

    public static MCalendar get(int C_Calendar_ID) {
        return MCalendar.get(Env.getCtx(), C_Calendar_ID);
    }

    public static MCalendar get(Properties ctx, int C_Calendar_ID) {
        Integer key = C_Calendar_ID;
        MCalendar retValue = s_cache.get(ctx, key, e -> new MCalendar(ctx, (MCalendar)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MCalendar(ctx, C_Calendar_ID, null);
        if (retValue.get_ID() == C_Calendar_ID) {
            s_cache.put(key, retValue, e -> new MCalendar(Env.getCtx(), (MCalendar)e));
            return retValue;
        }
        return null;
    }

    public static MCalendar getCopy(Properties ctx, int C_Calendar_ID, String trxName) {
        MCalendar calendar = MCalendar.get(C_Calendar_ID);
        if (calendar != null) {
            calendar = new MCalendar(ctx, calendar, trxName);
        }
        return calendar;
    }

    public static MCalendar getDefault(Properties ctx, int AD_Client_ID) {
        MClientInfo info = MClientInfo.get(ctx, AD_Client_ID);
        return MCalendar.getCopy(ctx, info.getC_Calendar_ID(), null);
    }

    public static MCalendar getDefault(Properties ctx) {
        return MCalendar.getDefault(ctx, Env.getAD_Client_ID(ctx));
    }

    public MCalendar(Properties ctx, int C_Calendar_ID, String trxName) {
        super(ctx, C_Calendar_ID, trxName);
    }

    public MCalendar(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCalendar(MClient client) {
        super(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        StringBuilder msgset = new StringBuilder().append(client.getName()).append(" ").append(Msg.translate(client.getCtx(), "C_Calendar_ID"));
        this.setName(msgset.toString());
    }

    public MCalendar(MCalendar copy) {
        this(Env.getCtx(), copy);
    }

    public MCalendar(Properties ctx, MCalendar copy) {
        this(ctx, copy, null);
    }

    public MCalendar(Properties ctx, MCalendar copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public MYear createYear(Locale locale) {
        if (this.get_ID() == 0) {
            return null;
        }
        MYear year = new MYear(this);
        year.saveEx();
        year.createStdPeriods(locale);
        return year;
    }

    @Override
    public MCalendar markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

