/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_C_BankTransfer;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MBankTransfer
extends X_C_BankTransfer
implements DocAction {
    private static final long serialVersionUID = -6091468617167291836L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MBankTransfer(Properties ctx, int C_BankTransfer_ID, String trxName) {
        super(ctx, C_BankTransfer_ID, trxName);
        if (C_BankTransfer_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPayDate(new Timestamp(System.currentTimeMillis()));
            this.setProcessed(false);
        }
    }

    public MBankTransfer(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int C_BPartner_ID;
        int To_C_Currency_ID;
        int To_AD_Org_ID;
        int From_C_Currency_ID;
        if (!super.beforeSave(newRecord)) {
            return false;
        }
        if (this.getTo_C_BankAccount_ID() == this.getFrom_C_BankAccount_ID()) {
            this.log.saveError("From Bank Account and To Bank Account must be different", this.toString());
            return false;
        }
        if (this.getFrom_C_BankAccount().getAD_Org_ID() != 0 && this.getFrom_C_BankAccount().getAD_Org_ID() != this.getFrom_AD_Org_ID()) {
            this.log.saveError("From Organization does not matches the organization of the From Bank Account", this.toString());
            return false;
        }
        if (this.getFrom_C_Currency_ID() == 0 && (From_C_Currency_ID = this.getFrom_C_BankAccount().getC_Currency_ID()) > 0) {
            this.setFrom_C_Currency_ID(From_C_Currency_ID);
        }
        if (this.getTo_AD_Org_ID() == 0 && (To_AD_Org_ID = this.getTo_C_BankAccount().getAD_Org_ID()) > 0) {
            this.setTo_AD_Org_ID(To_AD_Org_ID);
        }
        if (this.getTo_C_Currency_ID() == 0 && (To_C_Currency_ID = this.getTo_C_BankAccount().getC_Currency_ID()) > 0) {
            this.setTo_C_Currency_ID(To_C_Currency_ID);
        }
        if (this.getFrom_C_BPartner_ID() == 0) {
            String sql = "SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.AD_OrgBP_ID IN (SELECT ba.AD_Org_ID FROM C_BankAccount ba WHERE ba.C_BankAccount_ID = ?)) AND bp.IsActive = 'Y'";
            C_BPartner_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getFrom_C_BankAccount_ID());
            if (C_BPartner_ID > 0) {
                this.setFrom_C_BPartner_ID(C_BPartner_ID);
            }
        }
        if (this.getTo_C_BPartner_ID() == 0) {
            String sql = "SELECT bp.C_BPartner_ID FROM C_BPartner bp WHERE bp.AD_OrgBP_ID IN (SELECT ba.AD_Org_ID FROM C_BankAccount ba WHERE ba.C_BankAccount_ID = ?)) AND bp.IsActive = 'Y'";
            C_BPartner_ID = DB.getSQLValue(this.get_TrxName(), sql, this.getTo_C_BankAccount_ID());
            if (C_BPartner_ID > 0) {
                this.setTo_C_BPartner_ID(C_BPartner_ID);
            } else if (this.getFrom_AD_Org_ID() == this.getTo_AD_Org_ID() && this.getFrom_C_BPartner_ID() > 0) {
                this.setTo_C_BPartner_ID(this.getFrom_C_BPartner_ID());
            }
        }
        if (this.getRate().doubleValue() == 0.0) {
            if (this.getFrom_Amt().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal rate = this.getTo_Amt().divide(this.getFrom_Amt(), 12, RoundingMode.HALF_UP);
                this.setRate(rate);
            }
        } else {
            MCurrency cur;
            BigDecimal toAmt = this.getRate().multiply(this.getFrom_Amt());
            Integer To_C_Currency_ID2 = this.getTo_C_Currency_ID();
            if (To_C_Currency_ID2 != null && To_C_Currency_ID2 > 0 && (cur = MCurrency.get(this.p_ctx, To_C_Currency_ID2)) != null) {
                toAmt = toAmt.setScale(cur.getStdPrecision(), RoundingMode.HALF_UP);
            }
            this.setTo_Amt(toAmt);
        }
        if (this.getTo_C_Charge_ID() == 0 && this.getFrom_C_Charge_ID() > 0) {
            this.setTo_C_Charge_ID(this.getFrom_C_Charge_ID());
        }
        return true;
    }

    @Override
    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        MAcctSchema as = MAcctSchema.get(this.getCtx(), info.getC_AcctSchema1_ID(), this.get_TrxName());
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankTransfer_ID(this.getC_BankTransfer_ID());
        paymentBankFrom.setC_BankAccount_ID(this.getFrom_C_BankAccount_ID());
        paymentBankFrom.setAD_Org_ID(this.getFrom_AD_Org_ID());
        paymentBankFrom.setDocumentNo(this.getDocumentNo());
        paymentBankFrom.setDateAcct(this.getDateAcct());
        paymentBankFrom.setDateTrx(this.getPayDate());
        paymentBankFrom.setTenderType(this.getFrom_TenderType());
        paymentBankFrom.setDescription(this.getDescription());
        paymentBankFrom.setC_BPartner_ID(this.getTo_C_BPartner_ID());
        paymentBankFrom.setC_Currency_ID(this.getFrom_C_Currency_ID());
        paymentBankFrom.setPayAmt(this.getFrom_Amt());
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.getFrom_C_Charge_ID());
        if (as.getC_Currency_ID() != this.getFrom_C_Currency_ID()) {
            paymentBankFrom.setC_ConversionType_ID(this.getC_ConversionType_ID());
            paymentBankFrom.setIsOverrideCurrencyRate(this.isOverrideCurrencyRate());
            if (this.isOverrideCurrencyRate()) {
                paymentBankFrom.setCurrencyRate(this.getRate());
                paymentBankFrom.setConvertedAmt(this.getTo_Amt());
            }
        }
        paymentBankFrom.saveEx();
        if (!paymentBankFrom.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + paymentBankFrom + " - " + paymentBankFrom.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + paymentBankFrom + " - " + paymentBankFrom.getProcessMsg());
        }
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankTransfer_ID(this.getC_BankTransfer_ID());
        paymentBankTo.setC_BankAccount_ID(this.getTo_C_BankAccount_ID());
        paymentBankTo.setAD_Org_ID(this.getTo_AD_Org_ID());
        paymentBankTo.setDocumentNo(this.getDocumentNo());
        paymentBankTo.setDateAcct(this.getDateAcct());
        paymentBankTo.setDateTrx(this.getPayDate());
        paymentBankTo.setTenderType(this.getTo_TenderType());
        paymentBankTo.setDescription(this.getDescription());
        paymentBankTo.setC_BPartner_ID(this.getFrom_C_BPartner_ID());
        paymentBankTo.setC_Currency_ID(this.getTo_C_Currency_ID());
        paymentBankTo.setPayAmt(this.getTo_Amt());
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.getTo_C_Charge_ID());
        if (as.getC_Currency_ID() != this.getTo_C_Currency_ID()) {
            paymentBankTo.setC_ConversionType_ID(this.getC_ConversionType_ID());
            paymentBankTo.setIsOverrideCurrencyRate(this.isOverrideCurrencyRate());
            if (this.isOverrideCurrencyRate()) {
                double dd = 1.0 / this.getRate().doubleValue();
                paymentBankTo.setCurrencyRate(BigDecimal.valueOf(dd));
                paymentBankTo.setConvertedAmt(this.getFrom_Amt());
            }
        }
        paymentBankTo.saveEx();
        if (!paymentBankTo.processIt("CO")) {
            this.log.warning("Payment Process Failed: " + paymentBankTo + " - " + paymentBankTo.getProcessMsg());
            throw new IllegalStateException("Payment Process Failed: " + paymentBankTo + " - " + paymentBankTo.getProcessMsg());
        }
        paymentBankTo.saveEx();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        int[] ids;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        int[] nArray = ids = MPayment.getAllIDs("C_Payment", "C_BankTransfer_ID=" + this.getC_BankTransfer_ID(), this.get_TrxName());
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            MPayment payment = new MPayment(this.getCtx(), id, this.get_TrxName());
            if (!payment.voidIt()) {
                throw new IllegalStateException("Void Payment Failed: " + payment.getProcessMsg());
            }
            payment.saveEx();
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        int[] ids;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        int[] nArray = ids = MPayment.getAllIDs("C_Payment", "C_BankTransfer_ID=" + this.getC_BankTransfer_ID(), this.get_TrxName());
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            MPayment payment = new MPayment(this.getCtx(), id, this.get_TrxName());
            if (!payment.reverseCorrectIt()) {
                throw new IllegalStateException("Reverse Payment Failed: " + payment.getProcessMsg());
            }
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        int[] ids;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        int[] nArray = ids = MPayment.getAllIDs("C_Payment", "C_BankTransfer_ID=" + this.getC_BankTransfer_ID(), this.get_TrxName());
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            MPayment payment = new MPayment(this.getCtx(), id, this.get_TrxName());
            if (!payment.reverseAccrualIt()) {
                throw new IllegalStateException("Reverse Payment Failed: " + payment.getProcessMsg());
            }
            ++n2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(Msg.getElement(this.getCtx(), "C_BankTransfer_ID")) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return this.getFrom_C_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getFrom_Amt();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBankTransfer[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo());
        return sb.toString();
    }
}

