/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_C_BankAccount;
import org.compiere.model.X_C_BankStatementLoader;
import org.compiere.model.X_C_Currency;
import org.compiere.model.X_I_BankStatement;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MBankStatementLoader
extends X_C_BankStatementLoader {
    private static final long serialVersionUID = 8482717913976119270L;
    private int loadCount = 0;
    private String errorMessage = "";
    private String errorDescription = "";
    private BankStatementLoaderInterface m_loader = null;
    private String localFileName = null;
    private List<X_C_BankAccount> bankAccountList;
    private HashMap<String, Integer> currencyMap;
    private X_I_BankStatement m_lastSavedLine;

    public MBankStatementLoader(Properties ctx, int C_BankStatementLoader_ID, String trxName) {
        super(ctx, C_BankStatementLoader_ID, trxName);
        this.init(null);
    }

    public MBankStatementLoader(Properties ctx, int C_BankStatementLoader_ID, String fileName, String trxName) {
        super(ctx, C_BankStatementLoader_ID, trxName);
        this.init(fileName);
    }

    public MBankStatementLoader(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.init(null);
    }

    private void init(String fileName) {
        this.localFileName = fileName;
        try {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("MBankStatementLoader Class Name=" + this.getStmtLoaderClass());
            }
            this.m_loader = Core.getBankStatementLoader(this.getStmtLoaderClass());
            if (this.m_loader == null) {
                Class<?> bsrClass = Class.forName(this.getStmtLoaderClass());
                this.m_loader = (BankStatementLoaderInterface)bsrClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.errorMessage = "ClassNotLoaded";
            this.errorDescription = e.getMessage();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBankStatementLoader[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public boolean loadLines() {
        boolean result = false;
        this.log.info("MBankStatementLoader.loadLines");
        if (this.m_loader == null) {
            this.errorMessage = "ClassNotLoaded";
            return result;
        }
        MTable table2 = MTable.get(Env.getCtx(), 297);
        Query query = table2.createQuery(null, this.get_TrxName());
        this.bankAccountList = query.setOnlyActiveRecords(true).setClient_ID().list();
        table2 = MTable.get(Env.getCtx(), 141);
        query = table2.createQuery("AD_Client_ID IN (0, ?)", this.get_TrxName());
        List currencyList = query.setOnlyActiveRecords(true).setParameters(this.getAD_Client_ID()).list();
        this.currencyMap = new HashMap();
        for (X_C_Currency currency : currencyList) {
            this.currencyMap.put(currency.getISO_Code(), currency.get_ID());
        }
        if (!this.m_loader.init(this)) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        if (!this.m_loader.isValid()) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        if (!this.m_loader.loadLines()) {
            this.errorMessage = this.m_loader.getLastErrorMessage();
            this.errorDescription = this.m_loader.getLastErrorDescription();
            return result;
        }
        result = true;
        return result;
    }

    public boolean saveLine() {
        this.log.info("MBankStatementLoader.importLine");
        boolean result = false;
        X_I_BankStatement imp = new X_I_BankStatement(this.getCtx(), 0, this.get_TrxName());
        if (this.m_loader == null) {
            this.errorMessage = "LoadError";
            return result;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Bank Account=" + this.m_loader.getBankAccountNo());
        }
        imp.setBankAccountNo(this.m_loader.getBankAccountNo());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Routing No=" + this.m_loader.getRoutingNo());
        }
        imp.setRoutingNo(this.m_loader.getRoutingNo());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine IBAN=" + this.m_loader.getIBAN());
        }
        imp.setIBAN(this.m_loader.getIBAN());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine EFT Statement Reference No=" + this.m_loader.getStatementReference());
        }
        imp.setEftStatementReference(this.m_loader.getStatementReference());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine EFT Statement Date=" + this.m_loader.getStatementDate());
        }
        imp.setEftStatementDate(this.m_loader.getStatementDate());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Statement Date=" + this.m_loader.getStatementDate());
        }
        imp.setStatementDate(this.m_loader.getStatementDate());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine EFT Transaction ID=" + this.m_loader.getTrxID());
        }
        imp.setEftTrxID(this.m_loader.getTrxID());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Statement Line Date=" + this.m_loader.getStatementLineDate());
        }
        imp.setStatementLineDate(this.m_loader.getStatementLineDate());
        imp.setEftStatementLineDate(this.m_loader.getStatementLineDate());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Valuta Date=" + this.m_loader.getValutaDate());
        }
        imp.setValutaDate(this.m_loader.getValutaDate());
        imp.setEftValutaDate(this.m_loader.getValutaDate());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Statement Amount=" + this.m_loader.getStmtAmt());
        }
        imp.setStmtAmt(this.m_loader.getStmtAmt());
        imp.setEftAmt(this.m_loader.getStmtAmt());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Transaction Amount=" + this.m_loader.getTrxAmt());
        }
        imp.setTrxAmt(this.m_loader.getTrxAmt());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Interest Amount=" + this.m_loader.getInterestAmt());
        }
        imp.setInterestAmt(this.m_loader.getInterestAmt());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Reference No=" + this.m_loader.getReference());
        }
        imp.setReferenceNo(this.m_loader.getReference());
        imp.setEftReference(this.m_loader.getReference());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Check No=" + this.m_loader.getCheckNo());
        }
        imp.setEftCheckNo(this.m_loader.getCheckNo());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Memo=" + this.m_loader.getMemo());
        }
        imp.setMemo(this.m_loader.getMemo());
        imp.setEftMemo(this.m_loader.getMemo());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Payee Name=" + this.m_loader.getPayeeName());
        }
        imp.setEftPayee(this.m_loader.getPayeeName());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Payee Account No=" + this.m_loader.getPayeeAccountNo());
        }
        imp.setEftPayeeAccount(this.m_loader.getPayeeAccountNo());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine EFT Transaction Type=" + this.m_loader.getTrxType());
        }
        imp.setEftTrxType(this.m_loader.getTrxType());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Currency=" + this.m_loader.getCurrency());
        }
        imp.setEftCurrency(this.m_loader.getCurrency());
        imp.setISO_Code(this.m_loader.getCurrency());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Charge Name=" + this.m_loader.getChargeName());
        }
        imp.setChargeName(this.m_loader.getChargeName());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("MBankStatementLoader.importLine Charge Amount=" + this.m_loader.getChargeAmt());
        }
        imp.setChargeAmt(this.m_loader.getChargeAmt());
        for (X_C_BankAccount bankAccount : this.bankAccountList) {
            if ((Util.isEmpty(imp.getIBAN()) || !imp.getIBAN().equalsIgnoreCase(bankAccount.getIBAN())) && (Util.isEmpty(imp.getBankAccountNo()) || Util.isEmpty(imp.getRoutingNo()) || !imp.getBankAccountNo().equalsIgnoreCase(bankAccount.getAccountNo()) || !imp.getRoutingNo().equalsIgnoreCase(bankAccount.getC_Bank().getRoutingNo()))) continue;
            imp.setC_BankAccount_ID(bankAccount.get_ID());
            break;
        }
        if (!Util.isEmpty(imp.getEftCurrency())) {
            imp.setC_Currency_ID(this.currencyMap.get(imp.getEftCurrency()));
        }
        imp.setProcessed(false);
        imp.setI_IsImported(false);
        result = imp.save();
        this.m_lastSavedLine = imp;
        if (result) {
            ++this.loadCount;
        } else {
            this.errorMessage = "LoadError";
        }
        imp = null;
        return result;
    }

    public X_I_BankStatement getLastSavedLine() {
        return this.m_lastSavedLine;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public int getLoadCount() {
        return this.loadCount;
    }
}

