/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner_Location;
import org.compiere.util.Env;

public class MBPartnerLocation
extends X_C_BPartner_Location {
    private static final long serialVersionUID = -8412652367051443276L;
    private MLocation m_location = null;
    private String m_uniqueName = null;
    private int m_unique = 0;

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID) {
        return MBPartnerLocation.getForBPartner(ctx, C_BPartner_ID, null);
    }

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MBPartnerLocation> list = new Query(ctx, "C_BPartner_Location", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        MBPartnerLocation[] retValue = new MBPartnerLocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPartnerLocation(Properties ctx, int C_BPartner_Location_ID, String trxName) {
        super(ctx, C_BPartner_Location_ID, trxName);
        if (C_BPartner_Location_ID == 0) {
            this.setName(".");
            this.setIsShipTo(true);
            this.setIsRemitTo(true);
            this.setIsPayFrom(true);
            this.setIsBillTo(true);
        }
    }

    public MBPartnerLocation(MBPartner bp) {
        this(bp.getCtx(), 0, bp.get_TrxName());
        this.setClientOrg(bp);
        this.set_ValueNoCheck("C_BPartner_ID", bp.getC_BPartner_ID());
    }

    public MBPartnerLocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPartnerLocation(MBPartnerLocation copy) {
        this(Env.getCtx(), copy);
    }

    public MBPartnerLocation(Properties ctx, MBPartnerLocation copy) {
        this(ctx, copy, null);
    }

    public MBPartnerLocation(Properties ctx, MBPartnerLocation copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_location = copy.m_location != null ? new MLocation(ctx, copy.m_location, trxName) : null;
        this.m_uniqueName = copy.m_uniqueName;
        this.m_unique = copy.m_unique;
    }

    public MBPartnerLocation(Properties ctx, int C_BPartner_Location_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_BPartner_Location_ID, trxName, virtualColumns);
    }

    public MLocation getLocation(boolean requery) {
        if (requery || this.m_location == null) {
            this.m_location = MLocation.getCopy(this.getCtx(), this.getC_Location_ID(), this.get_TrxName());
        }
        return this.m_location;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBPartner_Location[ID=").append(this.get_ID()).append(",C_Location_ID=").append(this.getC_Location_ID()).append(",Name=").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Location_ID() == 0) {
            return false;
        }
        if (".".equals(this.getName()) && !this.isPreserveCustomName()) {
            MLocation address = this.getLocation(true);
            this.setName(this.getBPLocName(address));
        }
        return true;
    }

    private void makeUnique(MLocation address) {
        String xx;
        this.m_uniqueName = "";
        if ((this.m_unique >= 0 || this.m_uniqueName.length() == 0) && (xx = address.getCity()) != null && xx.length() > 0) {
            this.m_uniqueName = xx;
        }
        if ((this.m_unique >= 1 || this.m_uniqueName.length() == 0) && (xx = address.getAddress1()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = String.valueOf(this.m_uniqueName) + " ";
            }
            this.m_uniqueName = String.valueOf(this.m_uniqueName) + xx;
        }
        if ((this.m_unique >= 2 || this.m_uniqueName.length() == 0) && (xx = address.getAddress2()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = String.valueOf(this.m_uniqueName) + " ";
            }
            this.m_uniqueName = String.valueOf(this.m_uniqueName) + xx;
        }
        if ((this.m_unique >= 3 || this.m_uniqueName.length() == 0) && (xx = address.getRegionName(true)) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = String.valueOf(this.m_uniqueName) + " ";
            }
            this.m_uniqueName = String.valueOf(this.m_uniqueName) + xx;
        }
        if (this.m_unique >= 4 || this.m_uniqueName.length() == 0) {
            int id = this.get_ID();
            if (id == 0) {
                id = address.get_ID();
            }
            this.m_uniqueName = String.valueOf(this.m_uniqueName) + "#" + id;
        }
    }

    public String getBPLocName(MLocation address) {
        MBPartnerLocation[] locations;
        if (this.isPreserveCustomName()) {
            return this.getName();
        }
        this.m_uniqueName = this.getName();
        this.m_unique = MSysConfig.getIntValue("START_VALUE_BPLOCATION_NAME", 0, this.getAD_Client_ID(), this.getAD_Org_ID());
        if (this.m_unique < 0 || this.m_unique > 4) {
            this.m_unique = 0;
        }
        if (this.m_uniqueName != null) {
            this.m_uniqueName = null;
            this.makeUnique(address);
        }
        boolean unique = (locations = MBPartnerLocation.getForBPartner(this.getCtx(), this.getC_BPartner_ID())).length == 0;
        block0: while (!unique) {
            unique = true;
            int i2 = 0;
            while (i2 < locations.length) {
                MBPartnerLocation location = locations[i2];
                if (location.getC_BPartner_Location_ID() != this.get_ID() && this.m_uniqueName.equals(location.getName())) {
                    ++this.m_unique;
                    this.makeUnique(address);
                    unique = false;
                    continue block0;
                }
                ++i2;
            }
        }
        return this.m_uniqueName.toString();
    }
}

