/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.util.PaymentUtil;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BP_BankAccount;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.IBAN;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MBPBankAccount
extends X_C_BP_BankAccount {
    private static final long serialVersionUID = 6826961806519015878L;
    private static CLogger s_log = CLogger.getCLogger(MBPBankAccount.class);
    private MBank m_bank = null;

    public static MBPBankAccount[] getOfBPartner(Properties ctx, int C_BPartner_ID) {
        String whereClause = "C_BPartner_ID=?";
        List<MBPBankAccount> list = new Query(ctx, "C_BP_BankAccount", "C_BPartner_ID=?", null).setParameters(C_BPartner_ID).setOnlyActiveRecords(true).list();
        MBPBankAccount[] retValue = new MBPBankAccount[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPBankAccount(Properties ctx, int C_BP_BankAccount_ID, String trxName) {
        super(ctx, C_BP_BankAccount_ID, trxName);
        if (C_BP_BankAccount_ID == 0) {
            this.setIsACH(false);
            this.setBPBankAcctUse("B");
        }
    }

    public MBPBankAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPBankAccount(Properties ctx, MBPartner bp, MUser bpc, MLocation location) {
        this(ctx, 0, bp.get_TrxName());
        this.setIsACH(false);
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        this.setA_Name(bpc.getName());
        this.setA_EMail(bpc.getEMail());
        this.setA_Street(location.getAddress1());
        this.setA_City(location.getCity());
        this.setA_Zip(location.getPostal());
        this.setA_State(location.getRegionName(true));
        this.setA_Country(location.getCountryName());
    }

    public MBPBankAccount(MBPBankAccount copy) {
        this(Env.getCtx(), copy);
    }

    public MBPBankAccount(Properties ctx, MBPBankAccount copy) {
        this(ctx, copy, null);
    }

    public MBPBankAccount(Properties ctx, MBPBankAccount copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_bank = copy.m_bank != null ? new MBank(ctx, copy.m_bank, trxName) : null;
    }

    public boolean isDirectDeposit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("T");
    }

    public boolean isDirectDebit() {
        if (!this.isACH()) {
            return false;
        }
        String s = this.getBPBankAcctUse();
        if (s == null) {
            return true;
        }
        return s.equals("B") || s.equals("D");
    }

    public MBank getBank() {
        int C_Bank_ID = this.getC_Bank_ID();
        if (C_Bank_ID == 0) {
            return null;
        }
        if (this.m_bank == null) {
            this.m_bank = new MBank(this.getCtx(), C_Bank_ID, this.get_TrxName());
        }
        return this.m_bank;
    }

    @Override
    public String getRoutingNo() {
        MBank bank = this.getBank();
        String rt = super.getRoutingNo();
        if (bank != null) {
            rt = bank.getRoutingNo();
        }
        return rt;
    }

    public String getSwiftCode() {
        MBank bank = this.getBank();
        if (bank != null) {
            return bank.getSwiftCode();
        }
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String encrpytedCvv;
        String encrpytedCCNo;
        if (this.isACH() && this.getBank() != null) {
            this.setRoutingNo(null);
        }
        if (this.getCreditCardNumber() != null && !(encrpytedCCNo = PaymentUtil.encrpytCreditCard(this.getCreditCardNumber())).equals(this.getCreditCardNumber())) {
            this.setCreditCardNumber(encrpytedCCNo);
        }
        if (this.getCreditCardVV() != null && !(encrpytedCvv = PaymentUtil.encrpytCvv(this.getCreditCardVV())).equals(this.getCreditCardVV())) {
            this.setCreditCardVV(encrpytedCvv);
        }
        if (MSysConfig.getBooleanValue("IBAN_VALIDATION", true, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(this.getIBAN())) {
            this.setIBAN(IBAN.normalizeIBAN(this.getIBAN()));
            if (!IBAN.isValid(this.getIBAN())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "InvalidIBAN"));
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBP_BankAccount[").append(this.get_ID()).append(", Name=").append(this.getA_Name()).append("]");
        return sb.toString();
    }
}

