/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_M_BOM;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MBOM
extends X_M_BOM
implements ImmutablePOSupport {
    private static final long serialVersionUID = -6311001492891936078L;
    private static ImmutableIntPOCache<Integer, MBOM> s_cache = new ImmutableIntPOCache("M_BOM", 20);
    private static CLogger s_log = CLogger.getCLogger(MBOM.class);

    public static MBOM get(int M_BOM_ID) {
        return MBOM.get(Env.getCtx(), M_BOM_ID);
    }

    public static MBOM get(Properties ctx, int M_BOM_ID) {
        Integer key = M_BOM_ID;
        MBOM retValue = s_cache.get(ctx, key, e -> new MBOM(ctx, (MBOM)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBOM(ctx, M_BOM_ID, null);
        if (retValue.get_ID() == M_BOM_ID) {
            s_cache.put(key, retValue, e -> new MBOM(Env.getCtx(), (MBOM)e));
            return retValue.markImmutable();
        }
        return null;
    }

    public static MBOM getCopy(Properties ctx, int M_BOM_ID, String trxName) {
        MBOM bom = MBOM.get(M_BOM_ID);
        if (bom != null) {
            bom = new MBOM(ctx, bom, trxName);
        }
        return bom;
    }

    public static MBOM[] getOfProduct(Properties ctx, int M_Product_ID, String trxName, String whereClause) {
        StringBuilder where = new StringBuilder("M_Product_ID=?");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        List<MBOM> list = new Query(ctx, "M_BOM", where.toString(), trxName).setParameters(M_Product_ID).list();
        MBOM[] retValue = new MBOM[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBOM(Properties ctx, int M_BOM_ID, String trxName) {
        super(ctx, M_BOM_ID, trxName);
        if (M_BOM_ID == 0) {
            this.setBOMType("A");
            this.setBOMUse("A");
        }
    }

    public MBOM(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBOM(MBOM copy) {
        this(Env.getCtx(), copy);
    }

    public MBOM(Properties ctx, MBOM copy) {
        this(ctx, copy, null);
    }

    public MBOM(Properties ctx, MBOM copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("BOMType")) {
            MBOM[] boms;
            if (this.getBOMType().equals("A")) {
                StringBuilder msgofp = new StringBuilder("BOMType='A' AND BOMUse='").append(this.getBOMUse()).append("' AND IsActive='Y'");
                MBOM[] boms2 = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), msgofp.toString());
                if (boms2.length != 0 && (boms2.length != 1 || boms2[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                    this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "Can only have one Current Active BOM for Product BOM Use (" + this.getBOMType() + ")"));
                    return false;
                }
            } else if (this.getBOMType().equals("O") && (boms = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), "IsActive='Y'")).length != 0 && (boms.length != 1 || boms[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "Can only have single Make-to-Order BOM for Product"));
                return false;
            }
        }
        return true;
    }

    @Override
    public MBOM markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

