/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.upload.IUploadService;
import org.compiere.model.MAuthorizationCredential;
import org.compiere.model.MAuthorizationProvider;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.model.X_AD_AuthorizationAccount;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.SecureEngine;

public class MAuthorizationAccount
extends X_AD_AuthorizationAccount {
    private static final long serialVersionUID = -6808970904951033494L;

    public MAuthorizationAccount(Properties ctx, int AD_AuthorizationAccount_ID, String trxName) {
        super(ctx, AD_AuthorizationAccount_ID, trxName);
    }

    public MAuthorizationAccount(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String findRefreshToken() {
        String where = "AD_AuthorizationCredential_ID=? AND EMail=? AND AD_AuthorizationAccount_ID!=? AND IsAuthorized='Y' AND AccessToken IS NOT NULL AND RefreshToken IS NOT NULL";
        MAuthorizationAccount other = (MAuthorizationAccount)new Query(Env.getCtx(), "AD_AuthorizationAccount", "AD_AuthorizationCredential_ID=? AND EMail=? AND AD_AuthorizationAccount_ID!=? AND IsAuthorized='Y' AND AccessToken IS NOT NULL AND RefreshToken IS NOT NULL", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_AuthorizationCredential_ID(), this.getEMail(), this.getAD_AuthorizationAccount_ID()).first();
        return other != null ? other.getRefreshToken() : null;
    }

    public void syncOthers() {
        String clientSql = "SELECT DISTINCT AD_Client_ID FROM AD_AuthorizationAccount WHERE AD_AuthorizationAccount_ID!=? AND EMail=? AND AD_AuthorizationCredential_ID=? AND IsAuthorized='Y' AND RefreshToken IS NOT NULL";
        int[] clientIds = DB.getIDsEx(this.get_TrxName(), "SELECT DISTINCT AD_Client_ID FROM AD_AuthorizationAccount WHERE AD_AuthorizationAccount_ID!=? AND EMail=? AND AD_AuthorizationCredential_ID=? AND IsAuthorized='Y' AND RefreshToken IS NOT NULL", this.getAD_AuthorizationAccount_ID(), this.getEMail(), this.getAD_AuthorizationCredential_ID());
        if (clientIds.length > 0) {
            String script = "UPDATE AD_AuthorizationAccount SET AccessToken=?, AccessTokenTimestamp=?, ExpireInSeconds=? WHERE AD_AuthorizationAccount_ID!=? AND EMail=? AND AD_AuthorizationCredential_ID=? AND IsAuthorized='Y' AND RefreshToken IS NOT NULL AND AD_Client_ID=?";
            MColumn column = MColumn.get(this.getCtx(), "AD_AuthorizationAccount", "AccessToken");
            int[] nArray = clientIds;
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                int clientId = nArray[n2];
                String accessToken = this.getAccessToken();
                if (column.isEncrypted()) {
                    accessToken = SecureEngine.encrypt(accessToken, clientId);
                }
                DB.executeUpdateEx("UPDATE AD_AuthorizationAccount SET AccessToken=?, AccessTokenTimestamp=?, ExpireInSeconds=? WHERE AD_AuthorizationAccount_ID!=? AND EMail=? AND AD_AuthorizationCredential_ID=? AND IsAuthorized='Y' AND RefreshToken IS NOT NULL AND AD_Client_ID=?".toString(), new Object[]{accessToken, this.getAccessTokenTimestamp(), this.getExpireInSeconds(), this.getAD_AuthorizationAccount_ID(), this.getEMail(), this.getAD_AuthorizationCredential_ID(), clientId}, this.get_TrxName());
                ++n2;
            }
        }
    }

    public synchronized void refresh() throws GeneralSecurityException, IOException {
        Timestamp ts = this.getAccessTokenTimestamp();
        long seconds = this.getExpireInSeconds().longValue();
        long expire = ts.getTime() + seconds * 1000L;
        if (System.currentTimeMillis() >= expire) {
            ts = new Timestamp(System.currentTimeMillis());
            MAuthorizationCredential credential = new MAuthorizationCredential(this.getCtx(), this.getAD_AuthorizationCredential_ID(), this.get_TrxName());
            MAuthorizationProvider provider = new MAuthorizationProvider(this.getCtx(), credential.getAD_AuthorizationProvider_ID(), this.get_TrxName());
            GenericUrl url = new GenericUrl(provider.getTokenEndpoint());
            RefreshTokenRequest request = new RefreshTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)GsonFactory.getDefaultInstance(), url, this.getRefreshToken());
            String clientId = credential.getAuthorizationClientId();
            String clientSecret = credential.getAuthorizationClientSecret();
            request.setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret));
            TokenResponse response = request.execute();
            if (response.getRefreshToken() != null) {
                this.setRefreshToken(response.getRefreshToken());
            }
            this.setAccessToken(response.getAccessToken());
            this.setAccessTokenTimestamp(ts);
            this.setExpireInSeconds(new BigDecimal(response.getExpiresInSeconds()));
            this.saveEx();
        }
    }

    public static MAuthorizationAccount getEMailAccount(String email) {
        String where = "EMail=? AND IsIntersectCSV(AD_AuthorizationScopes," + DB.TO_STRING("EMail") + ")='Y' AND AD_Client_ID IN (0,?) AND IsAccessRevoked='N' AND IsAuthorized='Y'";
        MAuthorizationAccount account = (MAuthorizationAccount)new Query(Env.getCtx(), "AD_AuthorizationAccount", where, null).setOnlyActiveRecords(true).setParameters(email, Env.getAD_Client_ID(Env.getCtx())).setOrderBy("AD_Client_ID DESC, Updated DESC").first();
        return account;
    }

    public static List<MAuthorizationAccount> getAuthorizedAccouts(int AD_User_ID, String scopes) {
        String where = "AD_User_ID=? AND IsIntersectCSV(AD_AuthorizationScopes," + DB.TO_STRING(scopes) + ")='Y' AND AD_Client_ID IN (0,?) AND IsAccessRevoked='N' AND IsAuthorized='Y'";
        List<MAuthorizationAccount> accounts = new Query(Env.getCtx(), "AD_AuthorizationAccount", where, null).setOnlyActiveRecords(true).setParameters(AD_User_ID, Env.getAD_Client_ID(Env.getCtx())).setOrderBy("AD_Client_ID DESC, Updated DESC").list();
        return accounts;
    }

    public String refreshAndGetAccessToken() throws GeneralSecurityException, IOException {
        this.refresh();
        return this.getAccessToken();
    }

    public static Map<MAuthorizationAccount, IUploadService> getUserUploadServices() {
        HashMap<MAuthorizationAccount, IUploadService> uploadServicesMap = new HashMap<MAuthorizationAccount, IUploadService>();
        List<MAuthorizationAccount> accounts = MAuthorizationAccount.getAuthorizedAccouts(Env.getAD_User_ID(Env.getCtx()), "Document");
        for (MAuthorizationAccount account : accounts) {
            IUploadService service = Core.getUploadService(account);
            if (service == null) continue;
            uploadServicesMap.put(account, service);
        }
        return uploadServicesMap;
    }
}

