/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAttribute;
import org.compiere.model.MRole;
import org.compiere.model.X_M_AttributeUse;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MAttributeUse
extends X_M_AttributeUse {
    private static final long serialVersionUID = -9159120094145438975L;

    public MAttributeUse(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MAttributeUse(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MAttribute att;
        if ((newRecord || this.is_ValueChanged("M_Attribute_ID")) && !MRole.getDefault().isAccessAdvanced() && "R".equals((att = MAttribute.get(this.getCtx(), this.getM_Attribute_ID())).getAttributeValueType())) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
            return false;
        }
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0)+10 FROM M_AttributeUse WHERE M_AttributeSet_ID=?";
            int seqNo = DB.getSQLValue(this.get_TrxName(), sql, this.getM_AttributeSet_ID());
            this.setSeqNo(seqNo);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        StringBuilder sql = new StringBuilder("UPDATE M_AttributeSet mas").append(" SET IsInstanceAttribute='Y' ").append("WHERE M_AttributeSet_ID=").append(this.getM_AttributeSet_ID()).append(" AND IsInstanceAttribute='N'").append(" AND (IsSerNo='Y' OR IsLot='Y' OR IsGuaranteeDate='Y'").append(" OR EXISTS (SELECT * FROM M_AttributeUse mau").append(" INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) ").append("WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID").append(" AND mau.IsActive='Y' AND ma.IsActive='Y'").append(" AND ma.IsInstanceAttribute='Y')").append(")");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.fine("afterSave - Set Instance Attribute");
        }
        if ((no = DB.executeUpdate((sql = new StringBuilder("UPDATE M_AttributeSet mas").append(" SET IsInstanceAttribute='N' ").append("WHERE M_AttributeSet_ID=").append(this.getM_AttributeSet_ID()).append(" AND IsInstanceAttribute='Y'").append("\tAND IsSerNo='N' AND IsLot='N' AND IsGuaranteeDate='N'").append(" AND NOT EXISTS (SELECT * FROM M_AttributeUse mau").append(" INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) ").append("WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID").append(" AND mau.IsActive='Y' AND ma.IsActive='Y'").append(" AND ma.IsInstanceAttribute='Y')")).toString(), this.get_TrxName())) != 0) {
            this.log.fine("afterSave - Reset Instance Attribute");
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.afterSave(false, success);
        return success;
    }
}

