/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeSetExclude;
import org.compiere.model.MAttributeUse;
import org.compiere.model.MColumn;
import org.compiere.model.MLotCtlExclude;
import org.compiere.model.MSerNoCtlExclude;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSet;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MAttributeSet
extends X_M_AttributeSet
implements ImmutablePOSupport {
    private static final long serialVersionUID = -6570475541239019293L;
    private static ImmutableIntPOCache<Integer, MAttributeSet> s_cache = new ImmutableIntPOCache("M_AttributeSet", 20);
    private MAttribute[] m_instanceAttributes = null;
    private MAttribute[] m_productAttributes = null;
    private MAttributeSetExclude[] m_excludes = null;
    private MLotCtlExclude[] m_excludeLots = null;
    private MSerNoCtlExclude[] m_excludeSerNos = null;

    public static MAttributeSet get(int M_AttributeSet_ID) {
        return MAttributeSet.get(Env.getCtx(), M_AttributeSet_ID);
    }

    public static MAttributeSet get(Properties ctx, int M_AttributeSet_ID) {
        Integer key = M_AttributeSet_ID;
        MAttributeSet retValue = s_cache.get(ctx, key, e -> new MAttributeSet(ctx, (MAttributeSet)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MAttributeSet(ctx, M_AttributeSet_ID, null);
        if (retValue.get_ID() == M_AttributeSet_ID) {
            s_cache.put(key, retValue, e -> new MAttributeSet(Env.getCtx(), (MAttributeSet)e));
            return retValue;
        }
        return null;
    }

    public static MAttributeSet getCopy(Properties ctx, int M_AttributeSet_ID, String trxName) {
        MAttributeSet mas = MAttributeSet.get(M_AttributeSet_ID);
        if (mas != null) {
            mas = new MAttributeSet(ctx, mas, trxName);
        }
        return mas;
    }

    public MAttributeSet(Properties ctx, int M_AttributeSet_ID, String trxName) {
        super(ctx, M_AttributeSet_ID, trxName);
        if (M_AttributeSet_ID == 0) {
            this.setIsGuaranteeDate(false);
            this.setIsGuaranteeDateMandatory(false);
            this.setIsLot(false);
            this.setIsLotMandatory(false);
            this.setIsSerNo(false);
            this.setIsSerNoMandatory(false);
            this.setIsInstanceAttribute(false);
            this.setMandatoryType("N");
        }
    }

    public MAttributeSet(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttributeSet(MAttributeSet copy) {
        this(Env.getCtx(), copy);
    }

    public MAttributeSet(Properties ctx, MAttributeSet copy) {
        this(ctx, copy, null);
    }

    public MAttributeSet(Properties ctx, MAttributeSet copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_instanceAttributes = copy.m_instanceAttributes != null ? (MAttribute[])Arrays.stream(copy.m_instanceAttributes).map(e -> new MAttribute(ctx, (MAttribute)e, trxName)).toArray(MAttribute[]::new) : null;
        this.m_productAttributes = copy.m_productAttributes != null ? (MAttribute[])Arrays.stream(copy.m_productAttributes).map(e -> new MAttribute(ctx, (MAttribute)e, trxName)).toArray(MAttribute[]::new) : null;
        this.m_excludes = copy.m_excludes != null ? Arrays.copyOf(copy.m_excludes, copy.m_excludes.length) : null;
        this.m_excludeLots = copy.m_excludeLots != null ? Arrays.copyOf(copy.m_excludeLots, copy.m_excludeLots.length) : null;
        this.m_excludeSerNos = copy.m_excludeSerNos != null ? Arrays.copyOf(copy.m_excludeSerNos, copy.m_excludeSerNos.length) : null;
    }

    public MAttribute[] getMAttributes(boolean instanceAttributes) {
        if (this.m_instanceAttributes == null && instanceAttributes || this.m_productAttributes == null && !instanceAttributes) {
            String sql = "SELECT mau.M_Attribute_ID FROM M_AttributeUse mau INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) WHERE mau.IsActive='Y' AND ma.IsActive='Y' AND mau.M_AttributeSet_ID=? AND ma.IsInstanceAttribute=? ORDER BY mau.SeqNo";
            ArrayList<MAttribute> list = new ArrayList<MAttribute>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_AttributeSet_ID());
                    pstmt.setString(2, instanceAttributes ? "Y" : "N");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MAttribute ma = new MAttribute(this.getCtx(), rs.getInt(1), this.get_TrxName());
                        list.add(ma);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException(ex, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (instanceAttributes) {
                this.m_instanceAttributes = new MAttribute[list.size()];
                list.toArray(this.m_instanceAttributes);
                if (this.m_instanceAttributes.length > 0 && this.is_Immutable()) {
                    Arrays.stream(this.m_instanceAttributes).forEach(e -> {
                        MAttribute mAttribute = e.markImmutable();
                    });
                }
            } else {
                this.m_productAttributes = new MAttribute[list.size()];
                list.toArray(this.m_productAttributes);
                if (this.m_productAttributes.length > 0 && this.is_Immutable()) {
                    Arrays.stream(this.m_productAttributes).forEach(e -> {
                        MAttribute mAttribute = e.markImmutable();
                    });
                }
            }
        }
        if (instanceAttributes && this.isInstanceAttribute() != this.m_instanceAttributes.length > 0) {
            this.setIsInstanceAttribute(this.m_instanceAttributes.length > 0);
        }
        if (instanceAttributes) {
            return this.m_instanceAttributes;
        }
        return this.m_productAttributes;
    }

    public boolean isMandatory() {
        return !"N".equals(this.getMandatoryType()) || this.isLotMandatory() || this.isSerNoMandatory() || this.isGuaranteeDateMandatory();
    }

    public boolean isMandatoryAlways() {
        return "Y".equals(this.getMandatoryType());
    }

    public boolean isMandatoryShipping() {
        return "S".equals(this.getMandatoryType());
    }

    public boolean excludeEntry(int AD_Column_ID, boolean isSOTrx) {
        MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
        return this.excludeTableEntry(column.getAD_Table_ID(), isSOTrx);
    }

    public boolean excludeTableEntry(int AD_Table_ID, boolean isSOTrx) {
        this.loadExcludes();
        if (this.m_excludes != null && this.m_excludes.length > 0) {
            int i2 = 0;
            while (i2 < this.m_excludes.length) {
                if (this.m_excludes[i2].getAD_Table_ID() == AD_Table_ID && this.m_excludes[i2].isSOTrx() == isSOTrx) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    private void loadExcludes() {
        if (this.m_excludes == null) {
            String whereClause = "M_AttributeSet_ID=?";
            List<MAttributeSetExclude> list = new Query(this.getCtx(), "M_AttributeSetExclude", "M_AttributeSet_ID=?", null).setParameters(this.get_ID()).setOnlyActiveRecords(true).list();
            this.m_excludes = new MAttributeSetExclude[list.size()];
            list.toArray(this.m_excludes);
        }
    }

    public boolean isExcludeLot(int AD_Column_ID, boolean isSOTrx) {
        if (this.getM_LotCtl_ID() == 0) {
            return true;
        }
        if (this.m_excludeLots == null) {
            String whereClause = "M_LotCtl_ID=?";
            List<MLotCtlExclude> list = new Query(this.getCtx(), "M_LotCtlExclude", "M_LotCtl_ID=?", null).setParameters(this.getM_LotCtl_ID()).setOnlyActiveRecords(true).list();
            this.m_excludeLots = new MLotCtlExclude[list.size()];
            list.toArray(this.m_excludeLots);
        }
        if (this.m_excludeLots != null && this.m_excludeLots.length > 0) {
            MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
            int i2 = 0;
            while (i2 < this.m_excludeLots.length) {
                if (this.m_excludeLots[i2].getAD_Table_ID() == column.getAD_Table_ID() && this.m_excludeLots[i2].isSOTrx() == isSOTrx) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public boolean isExcludeSerNo(int AD_Column_ID, boolean isSOTrx) {
        if (this.getM_SerNoCtl_ID() == 0) {
            return true;
        }
        if (this.m_excludeSerNos == null) {
            String whereClause = "M_SerNoCtl_ID=?";
            List<MSerNoCtlExclude> list = new Query(this.getCtx(), "M_SerNoCtlExclude", "M_SerNoCtl_ID=?", null).setParameters(this.getM_SerNoCtl_ID()).setOnlyActiveRecords(true).list();
            this.m_excludeSerNos = new MSerNoCtlExclude[list.size()];
            list.toArray(this.m_excludeSerNos);
        }
        if (this.m_excludeSerNos != null && this.m_excludeSerNos.length > 0) {
            MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
            int i2 = 0;
            while (i2 < this.m_excludeSerNos.length) {
                if (this.m_excludeSerNos[i2].getAD_Table_ID() == column.getAD_Table_ID() && this.m_excludeSerNos[i2].isSOTrx() == isSOTrx) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public String getLotCharStart() {
        String s = super.getLotCharSOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "\u00ab";
    }

    public String getLotCharEnd() {
        String s = super.getLotCharEOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "\u00bb";
    }

    public String getSerNoCharStart() {
        String s = super.getSerNoCharSOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "#";
    }

    public String getSerNoCharEnd() {
        String s = super.getSerNoCharEOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isInstanceAttribute() && (this.isSerNo() || this.isLot() || this.isGuaranteeDate())) {
            this.setIsInstanceAttribute(true);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        StringBuilder sql;
        int no;
        if (!success) {
            return success;
        }
        if (!this.isInstanceAttribute() && (no = DB.executeUpdate((sql = new StringBuilder("UPDATE M_AttributeSet mas").append(" SET IsInstanceAttribute='Y' ").append("WHERE M_AttributeSet_ID=").append(this.getM_AttributeSet_ID()).append(" AND IsInstanceAttribute='N'").append(" AND (IsSerNo='Y' OR IsLot='Y' OR IsGuaranteeDate='Y'").append(" OR EXISTS (SELECT * FROM M_AttributeUse mau").append(" INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) ").append("WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID").append(" AND mau.IsActive='Y' AND ma.IsActive='Y'").append(" AND ma.IsInstanceAttribute='Y')").append(")")).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Set Instance Attribute");
            this.setIsInstanceAttribute(true);
        }
        if (this.isInstanceAttribute() && !this.isSerNo() && !this.isLot() && !this.isGuaranteeDate() && (no = DB.executeUpdate((sql = new StringBuilder("UPDATE M_AttributeSet mas").append(" SET IsInstanceAttribute='N' ").append("WHERE M_AttributeSet_ID=").append(this.getM_AttributeSet_ID()).append(" AND IsInstanceAttribute='Y'").append("\tAND IsSerNo='N' AND IsLot='N' AND IsGuaranteeDate='N'").append(" AND NOT EXISTS (SELECT * FROM M_AttributeUse mau").append(" INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) ").append("WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID").append(" AND mau.IsActive='Y' AND ma.IsActive='Y'").append(" AND ma.IsInstanceAttribute='Y')")).toString(), this.get_TrxName())) != 0) {
            this.log.warning("Reset Instance Attribute");
            this.setIsInstanceAttribute(false);
        }
        return success;
    }

    @Override
    public MAttributeSet markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_instanceAttributes != null && this.m_instanceAttributes.length > 0) {
            Arrays.stream(this.m_instanceAttributes).forEach(e -> {
                MAttribute mAttribute = e.markImmutable();
            });
        }
        if (this.m_productAttributes != null && this.m_productAttributes.length > 0) {
            Arrays.stream(this.m_productAttributes).forEach(e -> {
                MAttribute mAttribute = e.markImmutable();
            });
        }
        return this;
    }

    public MAttributeUse[] getMAttributeUse() {
        Query query = new Query(this.getCtx(), "M_AttributeUse", "M_AttributeSet_ID=?", this.get_TrxName());
        List<MAttributeUse> list = query.setOnlyActiveRecords(true).setParameters(this.get_ID()).list();
        return list.toArray(new MAttributeUse[0]);
    }
}

