/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Zip;
import org.compiere.Adempiere;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClientInfo;
import org.compiere.model.MStorageProvider;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Attachment;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.compiere.util.Util;

public class MAttachment
extends X_AD_Attachment {
    private static final long serialVersionUID = -1685512419870004665L;
    private static CLogger s_log = CLogger.getCLogger(MAttachment.class);
    private MStorageProvider provider;
    public static final String NONE = ".";
    public static final String ZIP = "zip";
    public static final String XML = "xml";
    public ArrayList<MAttachmentEntry> m_items = null;
    public final String ATTACHMENT_FOLDER_PLACEHOLDER = "%ATTACHMENT_FOLDER%";

    public static MAttachment get(Properties ctx, int AD_Table_ID, int Record_ID) {
        return MAttachment.get(ctx, AD_Table_ID, Record_ID, null);
    }

    public static MAttachment get(Properties ctx, int AD_Table_ID, int Record_ID, String trxName) {
        String whereClause = "AD_Table_ID=? AND Record_ID=?";
        MAttachment retValue = (MAttachment)new Query(ctx, "AD_Attachment", "AD_Table_ID=? AND Record_ID=?", trxName).setParameters(AD_Table_ID, Record_ID).first();
        return retValue;
    }

    public MAttachment(Properties ctx, int AD_Attachment_ID, String trxName) {
        super(ctx, AD_Attachment_ID, trxName);
        this.initAttachmentStoreDetails(ctx, trxName);
    }

    public MAttachment(Properties ctx, int AD_Table_ID, int Record_ID, String trxName) {
        this(ctx, MAttachment.getID(AD_Table_ID, Record_ID) > 0 ? MAttachment.getID(AD_Table_ID, Record_ID) : 0, trxName);
        if (this.get_ID() == 0) {
            this.setAD_Table_ID(AD_Table_ID);
            this.setRecord_ID(Record_ID);
        }
    }

    public MAttachment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initAttachmentStoreDetails(ctx, trxName);
    }

    public MAttachment(MAttachment copy) {
        this(Env.getCtx(), 0, null);
        this.copyPO(copy);
        this.m_items = copy.m_items != null ? copy.m_items.stream().map(MAttachmentEntry::new).collect(Collectors.toCollection(ArrayList::new)) : null;
    }

    private void initAttachmentStoreDetails(Properties ctx, String trxName) {
        if (this.is_new()) {
            MClientInfo clientInfo = MClientInfo.get(ctx, this.getAD_Client_ID());
            this.setStorageProvider(MStorageProvider.get(ctx, clientInfo.getAD_StorageProvider_ID()));
        } else {
            this.setStorageProvider(MStorageProvider.get(ctx, this.getAD_StorageProvider_ID()));
        }
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
        this.initAttachmentStoreDetails(this.getCtx(), this.get_TrxName());
    }

    public void addTextMsg(String added) {
        String oldTextMsg = this.getTextMsg();
        if (oldTextMsg == null) {
            this.setTextMsg(added);
        } else if (added != null) {
            this.setTextMsg(String.valueOf(oldTextMsg) + added);
        }
    }

    @Override
    public String getTextMsg() {
        String msg = super.getTextMsg();
        if (msg == null) {
            return null;
        }
        return msg.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAttachment[");
        sb.append(this.getAD_Attachment_ID()).append(",Title=").append(this.getTitle()).append(",Entries=").append(this.getEntryCount());
        int i2 = 0;
        while (i2 < this.getEntryCount()) {
            if (i2 == 0) {
                sb.append(":");
            } else {
                sb.append(",");
            }
            sb.append(this.getEntryName(i2));
            ++i2;
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean addEntry(File file) {
        byte[] data;
        String name;
        block27: {
            if (file == null) {
                this.log.warning("No File");
                return false;
            }
            if (!file.exists() || file.isDirectory() || !file.canRead()) {
                this.log.warning("not added - " + file + ", Exists=" + file.exists() + ", Directory=" + file.isDirectory());
                return false;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("addEntry - " + file);
            }
            name = file.getName();
            data = null;
            FileInputStream fis = null;
            ByteArrayOutputStream os = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int length = -1;
                    while ((length = fis.read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                    data = os.toByteArray();
                }
                catch (IOException ioe) {
                    this.log.log(Level.SEVERE, "(file)", ioe);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex) {
                            this.log.log(Level.SEVERE, "(file)", ex);
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            this.log.log(Level.SEVERE, "(file)", ex);
                        }
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        this.log.log(Level.SEVERE, "(file)", ex);
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {
                        this.log.log(Level.SEVERE, "(file)", ex);
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.log.log(Level.SEVERE, "(file)", ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    this.log.log(Level.SEVERE, "(file)", ex);
                }
            }
        }
        return this.addEntry(name, data);
    }

    public boolean addEntry(String name, byte[] data) {
        if (name == null || data == null) {
            return false;
        }
        return this.addEntry(new MAttachmentEntry(name, data));
    }

    public boolean addEntry(MAttachmentEntry item) {
        boolean replaced = false;
        boolean retValue = false;
        if (item == null) {
            return false;
        }
        item.getData();
        if (this.m_items == null) {
            this.loadLOBData();
        }
        int i2 = 0;
        while (i2 < this.m_items.size()) {
            String itemName = this.m_items.get(i2).getName();
            if (itemName.startsWith("~") && itemName.endsWith("~")) {
                itemName = itemName.substring(1, itemName.length() - 1);
            }
            if (itemName.equals(item.getName())) {
                this.m_items.set(i2, item);
                replaced = true;
            }
            ++i2;
        }
        if (!replaced) {
            retValue = this.m_items.add(item);
            item.setIndex(this.m_items.size());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(item.toStringX());
        }
        this.setBinaryData(new byte[0]);
        return retValue || replaced;
    }

    public MAttachmentEntry getEntry(int index) {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (index < 0 || index >= this.m_items.size()) {
            return null;
        }
        return this.m_items.get(index);
    }

    public MAttachmentEntry[] getEntries() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        MAttachmentEntry[] retValue = new MAttachmentEntry[this.m_items.size()];
        this.m_items.toArray(retValue);
        return retValue;
    }

    public boolean deleteEntry(int index) {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (index >= 0 && index < this.m_items.size()) {
            IAttachmentStore prov = this.provider.getAttachmentStore();
            if (prov != null) {
                if (prov.deleteEntry(this, this.provider, index)) {
                    return this.set_ValueNoCheck("Updated", new Timestamp(System.currentTimeMillis()));
                }
                return false;
            }
            return false;
        }
        this.log.warning("Not deleted Index=" + index + " - Size=" + this.m_items.size());
        return false;
    }

    public int getEntryCount() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        return this.m_items.size();
    }

    public String getEntryName(int index) {
        MAttachmentEntry item;
        String method = this.provider.getMethod();
        if (method == null) {
            method = "DB";
        }
        if ((item = this.getEntry(index)) != null) {
            String name = item.getName();
            if (name != null && "FileSystem".equals(method)) {
                name = name.substring(name.lastIndexOf(File.separator) + 1);
            }
            return name;
        }
        return null;
    }

    public void dumpEntryNames() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (this.m_items == null || this.m_items.size() == 0) {
            System.out.println("- no entries -");
            return;
        }
        StringBuilder msgout = new StringBuilder("- entries: ").append(this.m_items.size());
        System.out.println(msgout.toString());
        int i2 = 0;
        while (i2 < this.m_items.size()) {
            msgout = new StringBuilder("  - ").append(this.getEntryName(i2));
            System.out.println(msgout.toString());
            ++i2;
        }
    }

    public byte[] getEntryData(int index) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public File getEntryFile(int index, String fileName) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(fileName);
        }
        return null;
    }

    public File getEntryFile(int index, File file) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(file);
        }
        return null;
    }

    private boolean saveLOBData() {
        IAttachmentStore prov = this.provider.getAttachmentStore();
        if (prov != null) {
            return prov.save(this, this.provider);
        }
        return false;
    }

    private boolean loadLOBData() {
        IAttachmentStore prov = this.provider.getAttachmentStore();
        if (prov != null) {
            return prov.loadLOBData(this, this.provider);
        }
        return false;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (Util.isEmpty(this.getTitle())) {
            this.setTitle(NONE);
        }
        return this.saveLOBData();
    }

    @Override
    protected boolean postDelete() {
        IAttachmentStore prov;
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if ((prov = this.provider.getAttachmentStore()) != null) {
            return prov.delete(this, this.provider);
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(MimeType.getMimeType("data.xls"));
        System.out.println(MimeType.getMimeType("data.cvs"));
        System.out.println(MimeType.getMimeType("data.txt"));
        System.out.println(MimeType.getMimeType("data.log"));
        System.out.println(MimeType.getMimeType("data.html"));
        System.out.println(MimeType.getMimeType("data.htm"));
        System.out.println(MimeType.getMimeType("data.png"));
        System.out.println(MimeType.getMimeType("data.gif"));
        System.out.println(MimeType.getMimeType("data.jpg"));
        System.out.println(MimeType.getMimeType("data.xml"));
        System.out.println(MimeType.getMimeType("data.rtf"));
        System.exit(0);
        Adempiere.startupEnvironment(true);
        MAttachment att = new MAttachment(Env.getCtx(), 100, 0, null);
        att.addEntry(new File("C:\\Adempiere\\Dev.properties"));
        att.addEntry(new File("C:\\Adempiere\\index.html"));
        att.saveEx();
        System.out.println(att);
        att.dumpEntryNames();
        int AD_Attachment_ID = att.getAD_Attachment_ID();
        System.out.println("===========================================");
        att = new MAttachment(Env.getCtx(), AD_Attachment_ID, null);
        System.out.println(att);
        att.dumpEntryNames();
        System.out.println("===========================================");
        MAttachmentEntry[] entries = att.getEntries();
        int i2 = 0;
        while (i2 < entries.length) {
            MAttachmentEntry entry = entries[i2];
            entry.dump();
            ++i2;
        }
        System.out.println("===========================================");
        att.delete(true);
    }

    public boolean updateEntry(int i2, File file) {
        if (file == null) {
            this.log.warning("No File");
            return false;
        }
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            this.log.warning("not added - " + file + ", Exists=" + file.exists() + ", Directory=" + file.isDirectory());
            return false;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("updateEntry - " + file);
        }
        byte[] data = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            fis.close();
            data = os.toByteArray();
            os.close();
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "(file)", ioe);
        }
        return this.updateEntry(i2, data);
    }

    public boolean updateEntry(int i2, byte[] data) {
        MAttachmentEntry entry = this.getEntry(i2);
        if (entry == null) {
            return false;
        }
        entry.setData(data);
        entry.setUpdated(true);
        return true;
    }

    public static int getID(int Table_ID, int Record_ID) {
        String sql = "SELECT AD_Attachment_ID FROM AD_Attachment WHERE AD_Table_ID=? AND Record_ID=?";
        int attachid = DB.getSQLValue(null, sql, Table_ID, Record_ID);
        return attachid;
    }

    public File saveAsZip() {
        if (this.getEntryCount() < 1) {
            return null;
        }
        String name = String.valueOf(MTable.get(Env.getCtx(), this.getAD_Table_ID()).getTableName()) + "_" + this.getRecord_ID();
        File tempfolder = null;
        try {
            Path tempPath = Files.createTempDirectory(name, new FileAttribute[0]);
            tempfolder = tempPath.toFile();
        }
        catch (IOException e1) {
            throw new AdempiereException("Unable to create temp folder", e1);
        }
        File destZipFile = null;
        try {
            destZipFile = File.createTempFile(name, ".zip");
        }
        catch (Throwable e) {
            throw new AdempiereException("Unable to create temp file", e);
        }
        destZipFile.delete();
        MAttachmentEntry[] entries = this.getEntries();
        MAttachmentEntry entry = null;
        int index = 0;
        int i2 = 0;
        while (i2 < entries.length) {
            entry = entries[i2];
            index = i2++;
            File destinationFile = new File(tempfolder, entry.getName());
            FileUtil.copy(this, destinationFile, index);
        }
        Zip zipper = new Zip();
        zipper.setDestFile(destZipFile);
        zipper.setBasedir(tempfolder);
        zipper.setUpdate(true);
        zipper.setCompress(true);
        zipper.setCaseSensitive(false);
        zipper.setFilesonly(true);
        zipper.setTaskName(ZIP);
        zipper.setTaskType(ZIP);
        zipper.setProject(new Project());
        zipper.setOwningTarget(new Target());
        zipper.execute();
        try {
            FileUtil.deleteDirectory(tempfolder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return destZipFile;
    }

    public void setStorageProvider(MStorageProvider p2) {
        this.provider = p2;
        this.setAD_StorageProvider_ID(p2.getAD_StorageProvider_ID());
    }
}

