/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Transfer;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.idempiere.fa.exceptions.AssetAlreadyDepreciatedException;

public class MAssetTransfer
extends X_A_Asset_Transfer
implements DocAction {
    private static final long serialVersionUID = 2997284714883099922L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetTransfer(Properties ctx, int X_A_Asset_Transfer_ID, String trxName) {
        super(ctx, X_A_Asset_Transfer_ID, trxName);
        if (X_A_Asset_Transfer_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetTransfer(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        this.setC_Period_ID();
        return true;
    }

    public void setC_Period_ID() {
        MPeriod period = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID(), this.get_TrxName());
        if (period == null) {
            throw new AdempiereException("@NotFound@ @C_Period_ID@");
        }
        this.setC_Period_ID(period.get_ID());
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(this.getDocumentNo()) + "/" + this.getDateAcct();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo());
        return sb.toString();
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MAssetAcct assetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getC_AcctSchema_ID(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (assetAcct.getA_Asset_Acct() != this.getA_Asset_Acct() || assetAcct.getA_Accumdepreciation_Acct() != this.getA_Accumdepreciation_Acct() || assetAcct.getA_Depreciation_Acct() != this.getA_Depreciation_Acct() || assetAcct.getA_Disposal_Revenue_Acct() != this.getA_Disposal_Revenue_Acct() || assetAcct.getA_Disposal_Loss_Acct() != this.getA_Disposal_Loss_Acct()) {
            throw new AdempiereException("The accounts have been changed");
        }
        MAssetAcct acct = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getC_AcctSchema_ID(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        if (acct.getA_Asset_Acct() == this.getA_Asset_New_Acct() && acct.getA_Accumdepreciation_Acct() == this.getA_Accumdepreciation_New_Acct() && acct.getA_Depreciation_Acct() == this.getA_Depreciation_New_Acct() && acct.getA_Disposal_Revenue_Acct() == this.getA_Disposal_Revenue_New_Acct() && acct.getA_Disposal_Loss_Acct() == this.getA_Disposal_Loss_New_Acct()) {
            throw new AdempiereException("An account has been changed");
        }
        if (assetwk.getDateAcct().equals(this.getDateAcct())) {
            throw new AdempiereException("Last day of month. Accounts will be changed next month");
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MAssetAcct assetAcctPrev = MAssetAcct.forA_Asset_ID(this.getCtx(), this.getC_AcctSchema_ID(), this.getA_Asset_ID(), this.getPostingType(), this.getDateAcct(), this.get_TrxName());
        MAssetAcct assetAcct = new MAssetAcct(this.getCtx(), 0, this.get_TrxName());
        PO.copyValues(assetAcctPrev, assetAcct);
        assetAcct.setA_Asset_Acct(this.getA_Asset_New_Acct());
        assetAcct.setA_Accumdepreciation_Acct(this.getA_Accumdepreciation_New_Acct());
        assetAcct.setValidFrom(this.getDateAcct());
        assetAcct.saveEx();
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean processIt(String action) throws Exception {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean unlockIt() {
        return false;
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public String getDocumentNo() {
        return null;
    }
}

