/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Group;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MAssetGroup
extends X_A_Asset_Group
implements ImmutablePOSupport {
    private static final long serialVersionUID = 2605166916393528396L;
    private static ImmutableIntPOCache<Integer, MAssetGroup> s_cache = new ImmutableIntPOCache("A_Asset_Group", 10, 0);

    public MAssetGroup(Properties ctx, int A_Asset_Group_ID, String trxName) {
        super(ctx, A_Asset_Group_ID, trxName);
    }

    public MAssetGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAssetGroup(MAssetGroup copy) {
        this(Env.getCtx(), copy);
    }

    public MAssetGroup(Properties ctx, MAssetGroup copy) {
        this(ctx, copy, null);
    }

    public MAssetGroup(Properties ctx, MAssetGroup copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MAssetGroup get(int A_Asset_Group_ID) {
        return MAssetGroup.get(Env.getCtx(), A_Asset_Group_ID);
    }

    public static MAssetGroup get(Properties ctx, int A_Asset_Group_ID) {
        if (A_Asset_Group_ID <= 0) {
            return null;
        }
        MAssetGroup ag = s_cache.get(ctx, A_Asset_Group_ID, e -> new MAssetGroup(ctx, (MAssetGroup)e));
        if (ag != null) {
            return ag;
        }
        ag = new MAssetGroup(ctx, A_Asset_Group_ID, null);
        if (ag.get_ID() == A_Asset_Group_ID) {
            s_cache.put(A_Asset_Group_ID, ag, e -> new MAssetGroup(Env.getCtx(), (MAssetGroup)e));
            return ag;
        }
        return null;
    }

    public static MAssetGroup getCopy(Properties ctx, int A_Asset_Group_ID, String trxName) {
        MAssetGroup grp = MAssetGroup.get(A_Asset_Group_ID);
        if (grp != null) {
            grp = new MAssetGroup(ctx, grp, trxName);
        }
        return grp;
    }

    public static int getDefault_ID(SetGetModel m) {
        int AD_Client_ID = SetGetUtil.get_AttrValueAsInt(m, "AD_Client_ID");
        String sql = "SELECT A_Asset_Group_ID FROM A_Asset_Group WHERE AD_Client_ID=? ORDER BY IsDefault DESC, A_Asset_Group_ID ASC";
        int id = DB.getSQLValueEx(null, "SELECT A_Asset_Group_ID FROM A_Asset_Group WHERE AD_Client_ID=? ORDER BY IsDefault DESC, A_Asset_Group_ID ASC", AD_Client_ID);
        return id;
    }

    public static void updateAsset(SetGetModel m, int A_Asset_Group_ID) {
        if (A_Asset_Group_ID < 0) {
            A_Asset_Group_ID = MAssetGroup.getDefault_ID(SetGetUtil.wrap(m));
            m.set_AttrValue("A_Asset_Group_ID", A_Asset_Group_ID);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int default_id;
        if (!success) {
            return false;
        }
        if (newRecord && (default_id = MAssetGroup.getDefault_ID(SetGetUtil.wrap(this))) > 0 && default_id != this.get_ID()) {
            for (MAssetGroupAcct acct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), default_id, null, this.get_TrxName())) {
                MAssetGroupAcct newAcct = acct.copy(this);
                newAcct.saveEx(this.get_TrxName());
            }
        }
        return true;
    }

    @Override
    public MAssetGroup markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

