/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_A_Asset_Disposed;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Disposed;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.idempiere.fa.exceptions.AssetAlreadyDepreciatedException;
import org.idempiere.fa.exceptions.AssetNotImplementedException;
import org.idempiere.fa.exceptions.AssetNotSupportedException;
import org.idempiere.fa.exceptions.AssetStatusChangedException;
import org.idempiere.fa.util.POCacheLocal;

public class MAssetDisposed
extends X_A_Asset_Disposed
implements DocAction {
    private static final long serialVersionUID = 1763997880662445638L;
    private final POCacheLocal<MInvoiceLine> m_cacheInvoiceLine = POCacheLocal.newInstance(this, MInvoiceLine.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MAssetDisposed(Properties ctx, int A_Asset_Disposed_ID, String trxName) {
        super(ctx, A_Asset_Disposed_ID, trxName);
        if (A_Asset_Disposed_ID == 0) {
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public static MAssetDisposed createAssetDisposed(MInvoiceLine invLine) {
        MAssetDisposed assetDisposed = new MAssetDisposed(invLine);
        assetDisposed.dump();
        return assetDisposed;
    }

    private MAssetDisposed(MInvoiceLine invLine) {
        this(invLine.getCtx(), 0, invLine.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + invLine);
        }
        this.setAD_Org_ID(invLine.getAD_Org_ID());
        this.setPostingType("A");
        this.setDateDoc(invLine.getC_Invoice().getDateInvoiced());
        this.setDateAcct(invLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Date(invLine.getC_Invoice().getDateInvoiced());
        this.setA_Disposed_Method("T1");
        this.setA_Asset_ID(invLine.getA_Asset_ID());
        this.set_ValueNoCheck("C_Invoice_ID", invLine.getC_Invoice_ID());
        this.setM_InvoiceLine(invLine);
        this.saveEx(invLine.get_TrxName());
    }

    public MInvoiceLine getM_InvoiceLine(boolean requery) {
        return this.m_cacheInvoiceLine.get(requery);
    }

    private void setM_InvoiceLine(MInvoiceLine invLine) {
        this.set_Value("C_InvoiceLine_ID", (Object)invLine.get_ID());
        this.m_cacheInvoiceLine.set(invLine);
    }

    public MAssetDisposed(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset getAsset() {
        return MAsset.get(this.getCtx(), this.getA_Asset_ID(), null);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLD", this.getAD_Org_ID());
        MAssetDisposed.updateFromAsset(this);
        this.saveEx(this.get_TrxName());
        if (this.is_Changed()) {
            throw new AssetStatusChangedException();
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        this.setDocAction("CO");
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 7)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        MAsset asset = this.getAsset();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + asset);
        }
        if (!this.isDisposal()) {
            String method = this.getA_Activation_Method();
            if (!method.equals("AA")) throw new AssetNotSupportedException("A_Activation_Method", method);
            asset.changeStatus("AC", this.getDateDoc());
        } else {
            String method = this.getA_Disposed_Method();
            if ("PR".equals(method)) {
                asset.changeStatus("PR", this.getDateDoc());
            } else if ("S".equals(method) || "T1".equals(method)) {
                asset.changeStatus("DI", null);
                this.setA_Disposal_Amt(this.getA_Asset_Cost());
                this.setA_Accumulated_Depr_Delta(this.getA_Accumulated_Depr());
                this.setExpense(this.getA_Disposal_Amt().subtract(this.getA_Accumulated_Depr_Delta()));
                this.createDisposal();
            } else {
                if (!"PD".equals(method)) throw new AssetNotSupportedException("A_Disposed_Method", method);
                this.createDisposal();
            }
        }
        asset.saveEx(this.get_TrxName());
        valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public boolean reActivateIt() {
        throw new AssetNotImplementedException("");
    }

    @Override
    public String getSummary() {
        return this.getDocumentNo() + "/" + this.getDateDoc();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema().getC_Currency_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateAcct() == null) {
            this.setDateAcct(this.getDateDoc());
        }
        if (newRecord || this.is_ValueChanged("DateAcct")) {
            this.setC_Period_ID(MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID(), this.get_TrxName()).get_ID());
        }
        if (this.getA_Disposed_Date() == null) {
            this.setA_Disposed_Date(this.getDateAcct());
        }
        return true;
    }

    public static void updateFromAsset(I_A_Asset_Disposed bean) {
        int asset_id = bean.getA_Asset_ID();
        SetGetUtil.copyValues(SetGetUtil.wrap(bean), "A_Asset", asset_id, new String[]{"IsDisposed", "A_Asset_Status", "AD_Org_ID"});
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(Env.getCtx(), asset_id, bean.getPostingType(), null);
        if (wk != null) {
            bean.setA_Asset_Cost(wk.getA_Asset_Cost());
            bean.setA_Accumulated_Depr(wk.getA_Accumulated_Depr());
        } else {
            bean.setA_Asset_Cost(Env.ZERO);
            bean.setA_Accumulated_Depr(Env.ZERO);
        }
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo();
    }

    public boolean isDisposal() {
        return !this.isDisposed();
    }

    public static void setA_Disposal_Amt(I_A_Asset_Disposed bean) {
        int precision = 2;
        BigDecimal A_Asset_Cost = bean.getA_Asset_Cost();
        BigDecimal A_Disposal_Amt = bean.getA_Disposal_Amt();
        BigDecimal coef = Env.ZERO;
        if (A_Asset_Cost.signum() != 0) {
            coef = A_Disposal_Amt.divide(A_Asset_Cost, 12, RoundingMode.HALF_UP);
        }
        BigDecimal A_Accumulated_Depr = bean.getA_Accumulated_Depr();
        BigDecimal A_Accumulated_Depr_Delta = A_Accumulated_Depr.multiply(coef).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal Expense = A_Disposal_Amt.subtract(A_Accumulated_Depr_Delta);
        bean.setA_Accumulated_Depr_Delta(A_Accumulated_Depr_Delta);
        bean.setExpense(Expense);
    }

    private void createDisposal() {
        for (MDepreciationWorkfile assetwk : MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName())) {
            BigDecimal disposalAmt = Env.ZERO;
            BigDecimal accumDeprAmt = Env.ZERO;
            if (assetwk.getC_AcctSchema().getC_Currency_ID() != this.getC_Currency_ID()) {
                disposalAmt = assetwk.getA_Asset_Cost();
                accumDeprAmt = assetwk.getA_Accumulated_Depr();
            } else {
                disposalAmt = this.getA_Disposal_Amt();
                accumDeprAmt = this.getA_Accumulated_Depr_Delta();
            }
            MAssetChange change = new MAssetChange(this.getCtx(), 0, this.get_TrxName());
            change.setAD_Org_ID(this.getAD_Org_ID());
            change.setA_Asset_ID(this.getA_Asset_ID());
            change.setChangeType("DIS");
            change.setTextDetails(MRefList.getListDescription(this.getCtx(), "A_Update_Type", "DIS"));
            change.setPostingType(assetwk.getPostingType());
            change.setAssetValueAmt(disposalAmt);
            change.setAssetBookValueAmt(assetwk.getA_Asset_Remaining());
            change.setAssetAccumDepreciationAmt(accumDeprAmt);
            change.setA_QTY_Current(assetwk.getA_QTY_Current());
            change.setC_AcctSchema_ID(assetwk.getC_AcctSchema_ID());
            change.setAssetDisposalDate(this.getA_Disposed_Date());
            change.setIsDisposed(true);
            change.saveEx(this.get_TrxName());
            assetwk.adjustCost(disposalAmt.negate(), Env.ZERO, false);
            assetwk.adjustAccumulatedDepr(accumDeprAmt.negate(), accumDeprAmt.negate(), false);
            assetwk.saveEx();
            assetwk.buildDepreciation();
        }
        List<MDepreciationExp> list = MDepreciationExp.getNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        for (MDepreciationExp ex : list) {
            ex.deleteEx(false);
        }
    }
}

