/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset_Acct;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MAssetAcct
extends X_A_Asset_Acct
implements ImmutablePOSupport {
    private static final long serialVersionUID = -8898773839204909595L;
    private static ImmutableIntPOCache<Integer, MAssetAcct> s_cache = new ImmutableIntPOCache("A_Asset_Acct", 5);

    public MAssetAcct(Properties ctx, int X_A_Asset_Acct_ID, String trxName) {
        super(ctx, X_A_Asset_Acct_ID, trxName);
        if (X_A_Asset_Acct_ID == 0) {
            this.setA_Salvage_Value(Env.ZERO);
        }
    }

    public MAssetAcct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAssetAcct(MAssetAcct copy) {
        this(Env.getCtx(), copy);
    }

    public MAssetAcct(Properties ctx, MAssetAcct copy) {
        this(ctx, copy, null);
    }

    public MAssetAcct(Properties ctx, MAssetAcct copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MAssetAcct get(int A_Asset_Acct_ID) {
        return MAssetAcct.get(Env.getCtx(), A_Asset_Acct_ID);
    }

    public static MAssetAcct get(Properties ctx, int A_Asset_Acct_ID) {
        MAssetAcct acct = s_cache.get(ctx, A_Asset_Acct_ID, e -> new MAssetAcct(ctx, (MAssetAcct)e));
        if (acct != null) {
            return acct;
        }
        acct = new MAssetAcct(ctx, A_Asset_Acct_ID, null);
        if (acct.get_ID() == A_Asset_Acct_ID) {
            s_cache.put(A_Asset_Acct_ID, acct, e -> new MAssetAcct(Env.getCtx(), (MAssetAcct)e));
            return acct;
        }
        return null;
    }

    public static MAssetAcct forA_Asset_ID(Properties ctx, int C_AcctSchema_ID, int A_Asset_ID, String postingType, Timestamp dateAcct, String trxName) {
        MAssetAcct acct;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("A_Asset_ID=? AND PostingType=? AND C_AcctSchema_ID=? ");
        params.add(A_Asset_ID);
        params.add(postingType);
        params.add(C_AcctSchema_ID);
        if (dateAcct != null) {
            whereClause.append(" AND ValidFrom").append("<=?");
            params.add(dateAcct);
        }
        if ((acct = (MAssetAcct)new Query(ctx, "A_Asset_Acct", whereClause.toString(), trxName).setParameters(params).setOrderBy("ValidFrom DESC NULLS LAST").first()) == null) {
            throw new AdempiereException("@NoAccountOrgCurrency@");
        }
        if (acct.get_ID() > 0) {
            s_cache.put(acct.get_ID(), acct, e -> new MAssetAcct(Env.getCtx(), (MAssetAcct)e));
        }
        return acct;
    }

    public MAssetAcct(MAsset asset, MAssetGroupAcct assetgrpacct) {
        this(assetgrpacct.getCtx(), 0, asset.get_TrxName());
        SetGetUtil.copyValues(this, assetgrpacct, null, null);
        this.setA_Asset_ID(asset.getA_Asset_ID());
        if (asset.getA_Depreciation_ID() > 0) {
            this.setA_Depreciation_ID(asset.getA_Depreciation_ID());
        }
        if (asset.getA_Depreciation_F_ID() > 0) {
            this.setA_Depreciation_F_ID(asset.getA_Depreciation_F_ID());
        }
        this.setA_Period_Start(1);
        this.setA_Period_End(asset.getUseLifeMonths());
        this.dump();
    }

    public BigDecimal getA_Depreciation_Variable_Perc(boolean fiscal) {
        return fiscal ? this.getA_Depreciation_Variable_Perc_F() : this.getA_Depreciation_Variable_Perc();
    }

    @Override
    public MAcctSchema getC_AcctSchema() {
        return MAcctSchema.getCopy(this.getCtx(), this.getC_AcctSchema_ID(), this.get_TrxName());
    }

    public MAccount getP_Asset_Acct(int M_Product_ID) {
        MAcctSchema as = this.getC_AcctSchema();
        ProductCost pc = new ProductCost(this.getCtx(), M_Product_ID, 0, null);
        return pc.getAccount(3, as);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null && newRecord) {
            this.setValidFrom(TimeUtil.getDay(1970, 1, 1));
        }
        return true;
    }

    @Override
    public MAssetAcct markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

