/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetDelivery;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetType;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductDownload;
import org.compiere.model.MProject;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MAsset
extends X_A_Asset {
    public static final int CHANGETYPE_setAssetGroup = 53901;
    private int m_UseLifeMonths_F = 0;
    private int m_A_Current_Period = 0;
    private Timestamp m_DateAcct = null;
    private int m_A_Depreciation_ID = 0;
    private int m_A_Depreciation_F_ID = 0;
    private BigDecimal m_A_Asset_Cost = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr = Env.ZERO;
    private BigDecimal m_A_Accumulated_Depr_F = Env.ZERO;
    private MIFixedAsset m_I_FixedAsset = null;

    public static MAsset get(Properties ctx, int A_Asset_ID, String trxName) {
        return (MAsset)MTable.get(ctx, "A_Asset").getPO(A_Asset_ID, trxName);
    }

    public static Collection<MAsset> forASI(Properties ctx, int M_Product_ID, int M_ASI_ID) {
        ArrayList<Object> params = new ArrayList<Object>();
        String whereClause = "M_AttributeSetInstance_ID=?";
        params.add(M_ASI_ID);
        if (M_Product_ID > 0) {
            whereClause = String.valueOf(whereClause) + " AND M_Product_ID=?";
            params.add(M_Product_ID);
        }
        return new Query(ctx, "A_Asset", whereClause, null).setParameters(params).list();
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName) {
        super(ctx, A_Asset_ID, trxName);
        if (A_Asset_ID == 0) {
            this.setA_Asset_Status("NW");
        }
    }

    public MAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected MAsset(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), match.getC_InvoiceLine_ID(), this.get_TrxName());
        MInOutLine inoutLine = new MInOutLine(this.getCtx(), match.getM_InOutLine_ID(), this.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(inoutLine.getM_InOut().getMovementDate());
        this.setAD_Org_ID(invoiceLine.getAD_Org_ID());
        int A_Asset_Group_ID = invoiceLine.getA_Asset_Group_ID();
        MProduct product = MProduct.get(this.getCtx(), invoiceLine.getM_Product_ID());
        if (A_Asset_Group_ID <= 0) {
            A_Asset_Group_ID = product.getA_Asset_Group_ID();
        }
        this.setA_Asset_Group_ID(A_Asset_Group_ID);
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromInvoiceLine", new Object[]{invoiceLine.getC_Invoice().getDocumentNo(), invoiceLine.getLine()}));
        String name = "";
        if (inoutLine.getM_Product_ID() > 0) {
            name = String.valueOf(name) + product.getName() + "-";
            this.setM_Product_ID(inoutLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(inoutLine.getM_AttributeSetInstance_ID());
        }
        MBPartner bp = new MBPartner(this.getCtx(), invoiceLine.getC_Invoice().getC_BPartner_ID(), null);
        name = String.valueOf(name) + bp.getName() + "-" + invoiceLine.getC_Invoice().getDocumentNo();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("name=" + name);
        }
        this.setValue(name);
        this.setName(name);
        this.setDescription(invoiceLine.getDescription());
    }

    protected MAsset(MIFixedAsset ifa) {
        this(ifa.getCtx(), 0, ifa.get_TrxName());
        this.setAD_Org_ID(ifa.getAD_Org_ID());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        String inventoryNo = ifa.getInventoryNo();
        if (inventoryNo != null) {
            inventoryNo = inventoryNo.trim();
            this.setInventoryNo(inventoryNo);
            this.setValue(inventoryNo);
        }
        this.setA_Asset_CreateDate(ifa.getAssetServiceDate());
        MProduct product = ifa.getProduct();
        if (product != null) {
            this.setM_Product_ID(product.getM_Product_ID());
            this.setA_Asset_Group_ID(ifa.getA_Asset_Group_ID());
            MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        this.setDateAcct(ifa.getDateAcct());
        this.setName(ifa.getName());
        this.setDescription(ifa.getDescription());
        this.setI_FixedAsset(ifa);
    }

    protected MAsset(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromProject", new Object[]{project.getName()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(project.getDescription());
    }

    public MAsset(MInOut mInOut, MInOutLine sLine, int deliveryCount) {
        this(mInOut.getCtx(), 0, mInOut.get_TrxName());
        this.setIsOwned(false);
        this.setIsInPosession(false);
        this.setA_Asset_CreateDate(new Timestamp(System.currentTimeMillis()));
        this.setHelp(Msg.getMsg(MClient.get(this.getCtx()).getAD_Language(), "CreatedFromShipment: ", new Object[]{mInOut.getDocumentNo()}));
        this.setDateAcct(new Timestamp(System.currentTimeMillis()));
        this.setDescription(sLine.getDescription());
    }

    public MAsset(MInventory inventory, MInventoryLine invLine, BigDecimal qty, BigDecimal costs) {
        super(invLine.getCtx(), 0, invLine.get_TrxName());
        this.setClientOrg(invLine);
        MProduct product = MProduct.get(this.getCtx(), invLine.getM_Product_ID());
        MAssetGroup assetGroup = MAssetGroup.get(invLine.getCtx(), invLine.getM_Product().getM_Product_Category().getA_Asset_Group_ID());
        if (assetGroup == null) {
            assetGroup = MAssetGroup.get(invLine.getCtx(), product.getA_Asset_Group_ID());
        }
        this.setAssetGroup(assetGroup);
        this.setName(product.getName());
        this.setHelp(invLine.getDescription());
        this.setAssetServiceDate(inventory.getMovementDate());
        this.setIsOwned(true);
        this.setIsInPosession(true);
        this.setM_Product_ID(product.getM_Product_ID());
        this.setVersionNo(product.getVersionNo());
        if (invLine.getM_AttributeSetInstance_ID() != 0) {
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), invLine.getM_AttributeSetInstance_ID(), this.get_TrxName());
            this.setASI(asi);
        }
        this.setQty(qty);
        if (inventory.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(inventory.getC_Activity_ID());
        }
        if (MAssetType.isFixedAsset(this)) {
            this.setA_Asset_Status("NW");
        } else {
            this.setA_Asset_Status("AC");
            this.setProcessed(true);
        }
        this.setA_Asset_Status("NW");
    }

    public MAsset(MAsset copy) {
        this(Env.getCtx(), copy);
    }

    public MAsset(Properties ctx, MAsset copy) {
        this(ctx, copy, null);
    }

    public MAsset(Properties ctx, MAsset copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_DateAcct = copy.m_DateAcct;
    }

    public MAsset(Properties ctx, int A_Asset_ID, String trxName, String ... virtualColumns) {
        super(ctx, A_Asset_ID, trxName, virtualColumns);
    }

    public void setAssetGroup(MAssetGroup assetGroup) {
        this.setA_Asset_Group_ID(assetGroup.getA_Asset_Group_ID());
    }

    public MAssetGroup getAssetGroup() {
        return MAssetGroup.getCopy(this.getCtx(), this.getA_Asset_Group_ID(), this.get_TrxName());
    }

    public void setASI(MAttributeSetInstance asi) {
        this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        this.setLot(asi.getLot());
        this.setSerNo(asi.getSerNo());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String invNo;
        if (this.getA_Parent_Asset_ID() <= 0) {
            this.setA_Parent_Asset_ID(this.getA_Asset_ID());
        }
        if ((invNo = this.getInventoryNo()) != null) {
            this.setInventoryNo(invNo.trim());
        }
        if (this.getA_Asset_Group_ID() <= 0) {
            this.setA_Asset_Group_ID(MAssetGroup.getDefault_ID(SetGetUtil.wrap(this)));
        }
        if (this.is_ValueChanged("C_BPartner_Location_ID") && this.getC_BPartner_Location_ID() > 0) {
            SetGetUtil.copyValues(SetGetUtil.wrap(this), "C_BPartner_Location", this.getC_BPartner_Location_ID(), new String[]{"C_Location_ID"});
        }
        if (this.getM_Product_ID() > 0 && this.getM_AttributeSetInstance_ID() <= 0) {
            MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
            MAttributeSetInstance asi = new MAttributeSetInstance(this.getCtx(), 0, product.getM_AttributeSet_ID(), this.get_TrxName());
            asi.setSerNo(this.getSerNo());
            asi.setDescription();
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        this.updateStatus();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        String invNo;
        if (!success) {
            return success;
        }
        if (this.getA_Parent_Asset_ID() <= 0) {
            int A_Asset_ID = this.getA_Asset_ID();
            this.setA_Parent_Asset_ID(A_Asset_ID);
            DB.executeUpdateEx("UPDATE A_Asset SET A_Parent_Asset_ID=A_Asset_ID WHERE A_Asset_ID=" + A_Asset_ID, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("A_Parent_Asset_ID=" + this.getA_Parent_Asset_ID());
            }
        }
        if ((invNo = this.getInventoryNo()) == null || invNo.trim().length() == 0) {
            invNo = "" + this.get_ID();
            this.setInventoryNo(invNo);
            DB.executeUpdateEx("UPDATE A_Asset SET InventoryNo=" + DB.TO_STRING(invNo) + " WHERE A_Asset_ID=" + this.getA_Asset_ID(), this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("InventoryNo=" + this.getInventoryNo());
            }
        }
        if (newRecord) {
            MAssetGroup assetgroup = new MAssetGroup(this.getCtx(), this.getA_Asset_Group_ID(), this.get_TrxName());
            String isDepreciated = assetgroup.isDepreciated() ? "Y" : "N";
            String isOwned = assetgroup.isOwned() ? "Y" : "N";
            this.setIsDepreciated(assetgroup.isDepreciated());
            this.setIsOwned(assetgroup.isOwned());
            DB.executeUpdateEx("UPDATE A_Asset SET IsDepreciated='" + isDepreciated + "', isOwned ='" + isOwned + "' WHERE A_Asset_ID=" + this.getA_Asset_ID(), this.get_TrxName());
            for (MAssetGroupAcct assetgrpacct : MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset_Group_ID(), null, this.get_TrxName())) {
                if (assetgrpacct.getAD_Org_ID() != 0 && assetgrpacct.getAD_Org_ID() != this.getAD_Org_ID() || this.getI_FixedAsset() != null && assetgrpacct.getC_AcctSchema_ID() != this.getI_FixedAsset().getC_AcctSchema_ID()) continue;
                MAssetAcct assetacct = new MAssetAcct(this, assetgrpacct);
                assetacct.setAD_Org_ID(this.getAD_Org_ID());
                assetacct.saveEx();
                MDepreciationWorkfile assetwk = new MDepreciationWorkfile(this, assetacct.getPostingType(), assetgrpacct);
                assetwk.setAD_Org_ID(this.getAD_Org_ID());
                assetwk.setUseLifeYears(assetgrpacct.getUseLifeYears());
                assetwk.setUseLifeMonths(assetgrpacct.getUseLifeMonths());
                assetwk.setUseLifeYears_F(assetgrpacct.getUseLifeYears_F());
                assetwk.setUseLifeMonths_F(assetgrpacct.getUseLifeMonths_F());
                assetwk.saveEx();
                MAssetChange.createAndSave(this.getCtx(), "CRT", new PO[]{this, assetwk, assetacct}, null);
            }
        } else {
            MAssetChange.createAndSave(this.getCtx(), "UPD", new PO[]{this}, null);
        }
        if (!newRecord && this.is_ValueChanged("IsDepreciated")) {
            String sql = "UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?";
            DB.executeUpdateEx("UPDATE A_Depreciation_Workfile SET IsDepreciated=? WHERE A_Asset_ID=?", new Object[]{this.isDepreciated(), this.getA_Asset_ID()}, this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String sql = "DELETE FROM A_Asset_Addition WHERE Processed=? AND A_Asset_ID=?";
        int no = DB.executeUpdateEx(sql, new Object[]{false, this.getA_Asset_ID()}, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("@A_Asset_Addition@ @Deleted@ #" + no);
        }
        sql = "UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?";
        Object[] objectArray = new Object[3];
        objectArray[1] = false;
        objectArray[2] = this.getA_Asset_ID();
        no = DB.executeUpdateEx("UPDATE C_InvoiceLine SET  A_Asset_ID=?,A_Processed=? WHERE A_Asset_ID=?", objectArray, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("@C_InvoiceLine@ @Updated@ #" + no);
        }
        return true;
    }

    public void updateStatus() {
        String status = this.getA_Asset_Status();
        this.setProcessed(!status.equals("NW"));
        this.setIsDisposed(status.equals("DI"));
        this.setIsFullyDepreciated(status.equals("DP"));
        if (this.isFullyDepreciated() || status.equals("DI")) {
            this.setIsDepreciated(false);
        }
        if (status.equals("AC") || this.getAssetActivationDate() == null) {
            this.setAssetActivationDate(this.getAssetServiceDate());
        }
    }

    public void changeStatus(String newStatus, Timestamp date) {
        String status = this.getA_Asset_Status();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: " + status + "->" + newStatus + ", date=" + date);
        }
        if (date == null) {
            date = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (newStatus.equals("AC")) {
            this.setAssetActivationDate(date);
        }
        if (newStatus.equals("PR")) {
            this.setAssetDisposalDate(date);
            Collection<MDepreciationWorkfile> workFiles = MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            for (MDepreciationWorkfile assetwk : workFiles) {
                assetwk.truncDepreciation();
                assetwk.saveEx();
            }
        }
        if (newStatus.equals("DI")) {
            this.setAssetDisposalDate(date);
        }
        this.setA_Asset_Status(newStatus);
    }

    public int getUseLifeMonths_F() {
        return this.m_UseLifeMonths_F;
    }

    public void setUseLifeMonths_F(int UseLifeMonths_F) {
        this.m_UseLifeMonths_F = UseLifeMonths_F;
    }

    public int getA_Current_Period() {
        return this.m_A_Current_Period;
    }

    public void setA_Current_Period(int A_Current_Period) {
        this.m_A_Current_Period = A_Current_Period;
    }

    public Timestamp getDateAcct() {
        return this.m_DateAcct;
    }

    public void setDateAcct(Timestamp DateAcct) {
        this.m_DateAcct = DateAcct;
    }

    public int getA_Depreciation_ID() {
        return this.m_A_Depreciation_ID;
    }

    public void setA_Depreciation_ID(int A_Depreciation_ID) {
        this.m_A_Depreciation_ID = A_Depreciation_ID;
    }

    public int getA_Depreciation_F_ID() {
        return this.m_A_Depreciation_F_ID;
    }

    public void setA_Depreciation_F_ID(int A_Depreciation_F_ID) {
        this.m_A_Depreciation_F_ID = A_Depreciation_F_ID;
    }

    public BigDecimal getA_Asset_Cost() {
        return this.m_A_Asset_Cost;
    }

    public void setA_Asset_Cost(BigDecimal A_Asset_Cost) {
        this.m_A_Asset_Cost = A_Asset_Cost;
    }

    public BigDecimal getA_Accumulated_Depr() {
        return this.m_A_Accumulated_Depr;
    }

    public void setA_Accumulated_Depr(BigDecimal A_Accumulated_Depr) {
        this.m_A_Accumulated_Depr = A_Accumulated_Depr;
    }

    public BigDecimal getA_Accumulated_Depr_F() {
        return this.m_A_Accumulated_Depr_F;
    }

    public void setA_Accumulated_Depr_F(BigDecimal A_Accumulated_Depr_F) {
        this.m_A_Accumulated_Depr_F = A_Accumulated_Depr_F;
    }

    public MIFixedAsset getI_FixedAsset() {
        return this.m_I_FixedAsset;
    }

    public void setI_FixedAsset(MIFixedAsset I_FixedAsset) {
        this.m_I_FixedAsset = I_FixedAsset;
    }

    public MAssetDelivery confirmDelivery(EMail email, int ad_User_ID) {
        return null;
    }

    public MProductDownload[] getProductDownloads() {
        return null;
    }

    public MAssetDelivery confirmDelivery(HttpServletRequest request, int ad_User_ID) {
        return null;
    }

    public MAssetDelivery[] getDeliveries() {
        return null;
    }

    public static MAsset getFromShipment(Properties ctx, int i2, String trxName) {
        return null;
    }

    public int getProductR_MailText_ID() {
        return 0;
    }

    public boolean isDownloadable() {
        return false;
    }
}

