/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_AllocationHdr;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MAllocationHdr
extends X_C_AllocationHdr
implements DocAction {
    private static final long serialVersionUID = -7787519874581251920L;
    private static CLogger s_log = CLogger.getCLogger(MAllocationHdr.class);
    private MAllocationLine[] m_lines = null;
    private List<Integer> m_bps_beforeDelete = new ArrayList<Integer>();
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public static MAllocationHdr[] getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        ArrayList<MAllocationHdr> list;
        block6: {
            String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Payment_ID=?)";
            list = new ArrayList<MAllocationHdr>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Payment_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MAllocationHdr(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MAllocationHdr[] getOfInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        ArrayList<MAllocationHdr> list;
        block6: {
            String sql = "SELECT * FROM C_AllocationHdr h WHERE IsActive='Y' AND EXISTS (SELECT * FROM C_AllocationLine l WHERE h.C_AllocationHdr_ID=l.C_AllocationHdr_ID AND l.C_Invoice_ID=?)";
            list = new ArrayList<MAllocationHdr>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MAllocationHdr(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MAllocationHdr[] getOfCash(Properties ctx, int C_Cash_ID, String trxName) {
        String whereClause = "IsActive='Y' AND EXISTS (SELECT 1 FROM C_CashLine cl, C_AllocationLine al where cl.C_Cash_ID=? and al.C_CashLine_ID=cl.C_CashLine_ID and C_AllocationHdr.C_AllocationHdr_ID=al.C_AllocationHdr_ID)";
        Query query = MTable.get(ctx, 735).createQuery("IsActive='Y' AND EXISTS (SELECT 1 FROM C_CashLine cl, C_AllocationLine al where cl.C_Cash_ID=? and al.C_CashLine_ID=cl.C_CashLine_ID and C_AllocationHdr.C_AllocationHdr_ID=al.C_AllocationHdr_ID)", trxName);
        query.setParameters(C_Cash_ID);
        List<MAllocationHdr> list = query.list();
        MAllocationHdr[] retValue = new MAllocationHdr[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAllocationHdr(Properties ctx, int C_AllocationHdr_ID, String trxName) {
        super(ctx, C_AllocationHdr_ID, trxName);
        if (C_AllocationHdr_ID == 0) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setApprovalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(false);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setC_DocType_ID(MDocType.getDocType("CMA"));
        }
    }

    public MAllocationHdr(Properties ctx, boolean IsManual, Timestamp DateTrx, int C_Currency_ID, String description, String trxName) {
        this(ctx, 0, trxName);
        this.setIsManual(IsManual);
        if (DateTrx != null) {
            this.setDateTrx(DateTrx);
            this.setDateAcct(DateTrx);
        }
        this.setC_Currency_ID(C_Currency_ID);
        if (description != null) {
            this.setDescription(description);
        }
    }

    public MAllocationHdr(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAllocationLine[] getLines(boolean requery) {
        ArrayList<MAllocationLine> list;
        block7: {
            if (this.m_lines != null && this.m_lines.length != 0 && !requery) {
                MAllocationHdr.set_TrxName(this.m_lines, this.get_TrxName());
                return this.m_lines;
            }
            String sql = "SELECT * FROM C_AllocationLine WHERE C_AllocationHdr_ID=?";
            list = new ArrayList<MAllocationLine>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_AllocationHdr_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MAllocationLine line = new MAllocationLine(this.getCtx(), rs, this.get_TrxName());
                        line.setParent(this);
                        list.add(line);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MAllocationLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE C_AllocationHdr SET Processed='").append(processed ? "Y" : "N").append("' WHERE C_AllocationHdr_ID=").append(this.getC_AllocationHdr_ID());
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(processed) + " - #" + no);
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("IsActive") && this.isActive()) {
            this.log.severe("Cannot Re-Activate deactivated Allocations");
            return false;
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String trxName = this.get_TrxName();
        if (trxName == null || trxName.length() == 0) {
            this.log.warning("No transaction");
        }
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "CMA", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(735, this.get_ID(), trxName);
        }
        this.setIsActive(false);
        this.saveEx();
        this.getLines(true);
        this.m_bps_beforeDelete.clear();
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            MAllocationLine line = this.m_lines[i2];
            int C_BPartner_ID = line.getC_BPartner_ID();
            if (!this.m_bps_beforeDelete.contains(C_BPartner_ID)) {
                this.m_bps_beforeDelete.add(C_BPartner_ID);
            }
            line.deleteEx(true, trxName);
            ++i2;
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            for (int C_BPartner_ID : this.m_bps_beforeDelete) {
                MBPartner bpartner = new MBPartner(Env.getCtx(), C_BPartner_ID, this.get_TrxName());
                bpartner.setTotalOpenBalance();
                bpartner.saveEx();
            }
        }
        this.m_bps_beforeDelete.clear();
        return super.afterDelete(success);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "CMA", this.getAD_Org_ID());
        this.getLines(true);
        if (this.m_lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (!this.isReversal()) {
            MAllocationLine[] mAllocationLineArray = this.m_lines;
            int n = this.m_lines.length;
            int n2 = 0;
            while (n2 < n) {
                MAllocationLine line = mAllocationLineArray[n2];
                if (line.getC_Invoice_ID() != 0) {
                    StringBuilder whereClause = new StringBuilder("C_Invoice_ID").append("=? AND ").append("IsPaid").append("=? AND ").append("DocStatus").append(" NOT IN (?,?)");
                    boolean InvoiceIsPaid = new Query(this.getCtx(), "C_Invoice", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(line.getC_Invoice_ID(), "Y", "VO", "RE").match();
                    if (InvoiceIsPaid && line.getAmount().signum() > 0) {
                        throw new AdempiereException("@ValidationError@ @C_Invoice_ID@ @IsPaid@");
                    }
                }
                ++n2;
            }
        }
        BigDecimal approval = Env.ZERO;
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            MAllocationLine line = this.m_lines[i2];
            approval = approval.add(line.getWriteOffAmt()).add(line.getDiscountAmt());
            if (line.getC_BPartner_ID() == 0) {
                this.m_processMsg = "No Business Partner";
                return "IN";
            }
            if (line.getC_Invoice_ID() > 0 && line.getC_Invoice().getDateAcct().after(this.getDateAcct())) {
                this.m_processMsg = "Wrong allocation date";
                return "IN";
            }
            if (line.getC_Payment_ID() > 0 && line.getC_Payment().getDateAcct().after(this.getDateAcct())) {
                this.m_processMsg = "Wrong allocation date";
                return "IN";
            }
            ++i2;
        }
        this.setApprovalAmt(approval);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.getLines(false);
        if (!this.updateBP()) {
            return "IN";
        }
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            MAllocationLine line = this.m_lines[i2];
            line.processIt(this.isReversal());
            ++i2;
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        boolean retValue = false;
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MAllocationLine[] lines = this.getLines(true);
            if (!this.updateBP()) {
                return false;
            }
            int i2 = 0;
            while (i2 < lines.length) {
                MAllocationLine line = lines[i2];
                line.setAmount(Env.ZERO);
                line.setDiscountAmt(Env.ZERO);
                line.setWriteOffAmt(Env.ZERO);
                line.setOverUnderAmt(Env.ZERO);
                line.saveEx();
                line.processIt(true);
                ++i2;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "CMA", this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        retValue = true;
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean retValue = this.reverseIt(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean retValue = this.reverseIt(true);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return retValue;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAllocationHdr[");
        sb.append(this.get_ID()).append("-").append(this.getSummary()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        StringBuilder msgreturn = new StringBuilder().append(Msg.getElement(this.getCtx(), "C_AllocationHdr_ID")).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgctf = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgctf.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    private boolean reverseIt(boolean accrual) {
        Timestamp reversalDate;
        if (!this.isActive() || this.getDocStatus().equals("VO") || this.getDocStatus().equals("RE")) {
            this.log.warning("Allocation already reversed (not active)");
            return true;
        }
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getDateAcct();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, "CMA", this.getAD_Org_ID());
        if (accrual) {
            MAllocationLine[] rLines;
            MAllocationHdr reversal = MAllocationHdr.copyFrom(this, reversalDate, reversalDate, this.get_TrxName());
            if (reversal == null) {
                this.m_processMsg = "Could not create Payment Allocation Reversal";
                return false;
            }
            reversal.setReversal_ID(this.getC_AllocationHdr_ID());
            MAllocationLine[] mAllocationLineArray = rLines = reversal.getLines(false);
            int n = rLines.length;
            int n2 = 0;
            while (n2 < n) {
                MAllocationLine rLine = mAllocationLineArray[n2];
                rLine.setAmount(rLine.getAmount().negate());
                rLine.setDiscountAmt(rLine.getDiscountAmt().negate());
                rLine.setWriteOffAmt(rLine.getWriteOffAmt().negate());
                rLine.setOverUnderAmt(rLine.getOverUnderAmt().negate());
                if (!rLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not correct Payment Allocation Reversal Line";
                    return false;
                }
                ++n2;
            }
            reversal.setReversal(true);
            reversal.setDocumentNo(String.valueOf(this.getDocumentNo()) + "^");
            reversal.addDescription("{->" + this.getDocumentNo() + ")");
            if (!DocumentEngine.processIt(reversal, "CO")) {
                this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
                return false;
            }
            DocumentEngine.processIt(reversal, "CL");
            reversal.setProcessing(false);
            reversal.setDocStatus("RE");
            reversal.setDocAction("--");
            reversal.saveEx();
            this.m_processMsg = reversal.getDocumentNo();
            this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        } else {
            this.setIsActive(false);
            if (!this.isPosted()) {
                this.setPosted(true);
            }
            this.setDocumentNo(String.valueOf(this.getDocumentNo()) + "^");
            this.setDocStatus("RE");
            if (!this.save() || this.isActive()) {
                throw new IllegalStateException("Cannot de-activate allocation");
            }
            MFactAcct.deleteEx(735, this.getC_AllocationHdr_ID(), this.get_TrxName());
            this.getLines(true);
            if (!this.updateBP()) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.m_lines.length) {
                MAllocationLine line = this.m_lines[i2];
                line.setIsActive(false);
                line.setAmount(Env.ZERO);
                line.setDiscountAmt(Env.ZERO);
                line.setWriteOffAmt(Env.ZERO);
                line.setOverUnderAmt(Env.ZERO);
                line.saveEx();
                line.processIt(true);
                ++i2;
            }
            this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        }
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    private boolean updateBP() {
        ArrayList<Integer> bps = new ArrayList<Integer>();
        this.getLines(false);
        MAllocationLine[] mAllocationLineArray = this.m_lines;
        int n = this.m_lines.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationLine line = mAllocationLineArray[n2];
            int C_BPartner_ID = line.getC_BPartner_ID();
            if (!bps.contains(C_BPartner_ID)) {
                bps.add(C_BPartner_ID);
                MBPartner bpartner = new MBPartner(Env.getCtx(), C_BPartner_ID, this.get_TrxName());
                bpartner.setTotalOpenBalance();
                bpartner.saveEx();
            }
            ++n2;
        }
        return true;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public static MAllocationHdr copyFrom(MAllocationHdr from, Timestamp dateAcct, Timestamp dateTrx, String trxName) {
        MAllocationHdr to = new MAllocationHdr(from.getCtx(), 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setDateTrx(dateAcct);
        to.setDateAcct(dateTrx);
        to.setIsManual(false);
        to.setIsApproved(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.saveEx();
        if (to.copyLinesFrom(from) == 0) {
            throw new AdempiereException("Could not create Allocation Lines");
        }
        return to;
    }

    public int copyLinesFrom(MAllocationHdr otherAllocation) {
        if (this.isProcessed() || this.isPosted() || otherAllocation == null) {
            return 0;
        }
        MAllocationLine[] fromLines = otherAllocation.getLines(false);
        int count = 0;
        MAllocationLine[] mAllocationLineArray = fromLines;
        int n = fromLines.length;
        int n2 = 0;
        while (n2 < n) {
            MPayment reversal;
            MPayment payment;
            MAllocationLine fromLine = mAllocationLineArray[n2];
            MAllocationLine line = new MAllocationLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            line.setC_AllocationHdr_ID(this.getC_AllocationHdr_ID());
            line.setParent(this);
            line.set_ValueNoCheck("C_AllocationLine_ID", I_ZERO);
            if (line.getC_Payment_ID() != 0 && "RE".equals((payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName())).getDocStatus()) && (reversal = (MPayment)payment.getReversal()) != null) {
                line.setPaymentInfo(reversal.getC_Payment_ID(), 0);
            }
            line.saveEx();
            ++count;
            ++n2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.WARNING, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    public String getDescriptionForManualAllocation(int bpartnerID, String trxName) {
        String sysconfig_desc = MSysConfig.getValue("ALLOCATION_DESCRIPTION", "@#AD_User_Name@", this.getAD_Client_ID());
        String description = "";
        if (sysconfig_desc.contains("@")) {
            description = Env.parseVariable(sysconfig_desc, new MBPartner(this.getCtx(), bpartnerID, null), trxName, true);
            description = Env.parseVariable(description, this, trxName, true);
            description = Msg.parseTranslation(this.getCtx(), description);
        } else {
            description = Env.getContext(this.getCtx(), "#AD_User_Name");
        }
        return description;
    }
}

