/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAlert;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_AlertRule;
import org.compiere.util.DB;
import org.compiere.util.Util;

public class MAlertRule
extends X_AD_AlertRule {
    private static final long serialVersionUID = -1267260460210893262L;
    private MAlert m_parent = null;

    public MAlertRule(Properties ctx, int AD_AlertRule_ID, String trxName) {
        super(ctx, AD_AlertRule_ID, trxName);
    }

    public MAlertRule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAlert getParent() {
        if (this.m_parent == null || this.m_parent.get_ID() != this.getAD_Alert_ID()) {
            this.m_parent = new MAlert(this.getCtx(), this.getAD_Alert_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MAlert alert) {
        this.m_parent = alert;
    }

    public String getSql() {
        return this.getSql(false);
    }

    public String getSql(boolean applySecurity) {
        MAlert alert;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(this.getSelectClause()).append(" FROM ").append(this.getFromClause());
        if (this.getWhereClause() != null && this.getWhereClause().length() > 0) {
            sql.append(" WHERE ").append(this.getWhereClause());
        }
        StringBuilder finalSQL = new StringBuilder(sql.toString());
        if (applySecurity && ((alert = this.getParent()).isEnforceRoleSecurity() || alert.isEnforceClientSecurity())) {
            int AD_Role_ID = alert.getFirstAD_Role_ID();
            if (AD_Role_ID == -1) {
                AD_Role_ID = alert.getFirstUserAD_Role_ID();
            }
            if (AD_Role_ID != -1) {
                MRole role = MRole.get(this.getCtx(), AD_Role_ID);
                finalSQL = new StringBuilder(role.addAccessSQL(finalSQL.toString(), null, true, false));
            }
        }
        if (this.getOtherClause() != null && this.getOtherClause().length() > 0) {
            finalSQL.append(" ").append(this.getOtherClause());
        }
        return finalSQL.toString();
    }

    public File createReportFile(String extension) {
        if (Util.isEmpty(extension)) {
            throw new IllegalArgumentException("Parameter extension cannot be empty");
        }
        StringBuilder msgname = new StringBuilder(new SimpleDateFormat("yyyyMMddhhmm").format(new Timestamp(System.currentTimeMillis()))).append("_").append(Util.stripDiacritics(this.getName().trim()));
        String name = msgname.toString();
        File file = null;
        try {
            StringBuilder msgp = new StringBuilder(name).append(".").append(extension);
            file = new File(System.getProperty("java.io.tmpdir"), msgp.toString());
            file.createNewFile();
            return file;
        }
        catch (Exception e) {
            file = null;
            String filePrefix = "Alert_";
            try {
                StringBuilder msgctf = new StringBuilder(".").append(extension);
                file = File.createTempFile(filePrefix, msgctf.toString());
            }
            catch (IOException e2) {
                throw new AdempiereException(e2);
            }
            return file;
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            this.setIsValid(true);
        }
        if (this.isValid()) {
            this.setErrorMsg(null);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        return this.updateParent();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return false;
        }
        return this.updateParent();
    }

    private boolean updateParent() {
        StringBuilder sql_count = new StringBuilder("SELECT COUNT(*) FROM ").append("AD_AlertRule").append(" r").append(" WHERE r.").append("AD_Alert_ID").append("=a.").append("AD_Alert_ID").append(" AND r.").append("IsValid").append("='N'").append(" AND r.IsActive='Y'");
        StringBuilder sql = new StringBuilder("UPDATE ").append("AD_Alert").append(" a SET ").append(" ").append("IsValid").append("=(CASE WHEN (").append((CharSequence)sql_count).append(") > 0 THEN 'N' ELSE 'Y' END)").append(" WHERE a.").append("AD_Alert_ID").append("=?");
        int no = DB.executeUpdate(sql.toString(), this.getAD_Alert_ID(), this.get_TrxName());
        return no == 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAlertRule[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid()).append(",").append(this.getSql(false));
        sb.append("]");
        return sb.toString();
    }
}

