/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.MClientInfo;
import org.compiere.model.MSchedule;
import org.compiere.model.Query;
import org.compiere.model.X_AD_AlertProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class MAlertProcessor
extends X_AD_AlertProcessor
implements AdempiereProcessor,
AdempiereProcessor2 {
    private static final long serialVersionUID = -6566030540146374829L;
    private static CLogger s_log = CLogger.getCLogger(MAlertProcessor.class);
    private MAlert[] m_alerts = null;

    public static MAlertProcessor[] getActive(Properties ctx) {
        List<MAlertProcessor> list = new Query(ctx, "AD_AlertProcessor", null, null).setOnlyActiveRecords(true).list();
        MAlertProcessor[] retValue = new MAlertProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAlertProcessor(Properties ctx, int AD_AlertProcessorLog_ID, String trxName) {
        super(ctx, AD_AlertProcessorLog_ID, trxName);
    }

    public MAlertProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getServerID() {
        return "AlertProcessor" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName(), new String[0]);
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        String whereClause = "AD_AlertProcessor_ID=?";
        List<AdempiereProcessorLog> list = new Query(this.getCtx(), "AD_AlertProcessorLog", "AD_AlertProcessor_ID=?", null).setParameters(this.getAD_AlertProcessor_ID()).setOrderBy("Created DESC").list();
        AdempiereProcessorLog[] retValue = new MAlertProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE FROM AD_AlertProcessorLog WHERE AD_AlertProcessor_ID=" + this.getAD_AlertProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < getDate()";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    public MAlert[] getAlerts(boolean reload) {
        if (this.m_alerts != null && !reload) {
            return this.m_alerts;
        }
        String whereClause = "AD_AlertProcessor_ID=?";
        List<MAlert> list = new Query(this.getCtx(), "AD_Alert", "AD_AlertProcessor_ID=?", null).setParameters(this.getAD_AlertProcessor_ID()).setOnlyActiveRecords(true).list();
        this.m_alerts = new MAlert[list.size()];
        list.toArray(this.m_alerts);
        return this.m_alerts;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        long nextWork;
        if ((newRecord || this.is_ValueChanged("AD_Schedule_ID")) && (nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern(), MClientInfo.get(this.getCtx(), this.getAD_Client_ID()).getTimeZone())) > 0L) {
            this.setDateNextRun(new Timestamp(nextWork));
        }
        return true;
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }
}

