/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_C_AddressValidation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MAddressValidation
extends X_C_AddressValidation {
    private static final long serialVersionUID = 8194097022422808757L;
    private static CLogger s_log = CLogger.getCLogger(MAddressValidation.class);

    public static MAddressValidation getDefaultAddressValidation(Properties ctx, int AD_Client_ID, String trxName) {
        MAddressValidation[] validations = MAddressValidation.getAddressValidation(ctx, AD_Client_ID, trxName);
        if (validations.length == 0) {
            return null;
        }
        return validations[0];
    }

    public static MAddressValidation[] getAddressValidation(Properties ctx, int AD_Client_ID, String trxName) {
        ArrayList<MAddressValidation> list = new ArrayList<MAddressValidation>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT tp.* ");
        sql.append("FROM C_AddressValidation tp, C_AddressValidationCfg tpc ");
        sql.append("WHERE tp.C_AddressValidationCfg_ID = tpc.C_AddressValidationCfg_ID ");
        sql.append("AND tpc.IsActive = 'Y' ");
        sql.append("AND tp.IsActive = 'Y' ");
        sql.append("AND tp.AD_Client_ID = ? ");
        sql.append("ORDER BY tp.AD_Org_ID DESC, tp.SeqNo");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                pstmt.setInt(1, AD_Client_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MAddressValidation(ctx, rs, trxName));
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "find - " + sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (list.size() == 0) {
            s_log.warning("find - not found - AD_Client_ID=" + AD_Client_ID);
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("find - #" + list.size() + " - AD_Client_ID=" + AD_Client_ID);
        }
        MAddressValidation[] retValue = new MAddressValidation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAddressValidation(Properties ctx, int C_AddressValidation_ID, String trxName) {
        super(ctx, C_AddressValidation_ID, trxName);
    }

    public MAddressValidation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getAddressValidationClass() {
        return this.getC_AddressValidationCfg().getAddressValidationClass();
    }

    public String getHostAddress() {
        return this.getC_AddressValidationCfg().getHostAddress();
    }

    public int getHostPort() {
        return this.getC_AddressValidationCfg().getHostPort();
    }

    public String getProxyAddress() {
        return this.getC_AddressValidationCfg().getProxyAddress();
    }

    public int getProxyPort() {
        return this.getC_AddressValidationCfg().getProxyPort();
    }

    public String getProxyLogon() {
        return this.getC_AddressValidationCfg().getProxyLogon();
    }

    public String getProxyPassword() {
        return this.getC_AddressValidationCfg().getProxyPassword();
    }

    public String getServicePath() {
        return this.getC_AddressValidationCfg().getServicePath();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

