/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.model.X_C_AcctSchema;
import org.compiere.report.MReportTree;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MAcctSchema
extends X_C_AcctSchema
implements ImmutablePOSupport {
    private static final long serialVersionUID = 405097978362430053L;
    private static CCache<Integer, MAcctSchema[]> s_schema = new CCache("AD_ClientInfo", "AD_ClientInfo|MAcctSchema[]", 3, 120, false);
    private static ImmutableIntPOCache<Integer, MAcctSchema> s_cache = new ImmutableIntPOCache("C_AcctSchema", 3, 120);
    private MAcctSchemaGL m_gl = null;
    private MAcctSchemaDefault m_default = null;
    private MAccount m_SuspenseError_Acct = null;
    private MAccount m_CurrencyBalancing_Acct = null;
    private MAccount m_DueTo_Acct = null;
    private MAccount m_DueFrom_Acct = null;
    private int m_stdPrecision = -1;
    private int m_costPrecision = -1;
    private MOrg m_onlyOrg = null;
    private Integer[] m_onlyOrgs = null;

    public static MAcctSchema get(int C_AcctSchema_ID) {
        return MAcctSchema.get(Env.getCtx(), C_AcctSchema_ID);
    }

    public static MAcctSchema get(Properties ctx, int C_AcctSchema_ID) {
        return MAcctSchema.get(ctx, C_AcctSchema_ID, null);
    }

    public static MAcctSchema get(Properties ctx, int C_AcctSchema_ID, String trxName) {
        Integer key = C_AcctSchema_ID;
        MAcctSchema retValue = s_cache.get(ctx, key, e -> new MAcctSchema(ctx, (MAcctSchema)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MAcctSchema(ctx, C_AcctSchema_ID, trxName);
        if (retValue.get_ID() == C_AcctSchema_ID) {
            s_cache.put(key, retValue, e -> new MAcctSchema(Env.getCtx(), (MAcctSchema)e));
            return retValue;
        }
        return null;
    }

    public static MAcctSchema getCopy(Properties ctx, int C_AcctSchema_ID, String trxName) {
        MAcctSchema as = MAcctSchema.get(ctx, C_AcctSchema_ID, trxName);
        if (as != null) {
            as = new MAcctSchema(ctx, as, trxName);
        }
        return as;
    }

    public static MAcctSchema[] getClientAcctSchema(Properties ctx, int AD_Client_ID) {
        return MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID, null);
    }

    public static synchronized MAcctSchema[] getClientAcctSchema(Properties ctx, int AD_Client_ID, String trxName) {
        Integer key = AD_Client_ID;
        if (s_schema.containsKey(key)) {
            if (ctx == Env.getCtx()) {
                return s_schema.get(key);
            }
            return (MAcctSchema[])Arrays.stream(s_schema.get(key)).map(e -> new MAcctSchema(ctx, (MAcctSchema)e).markImmutable()).toArray(MAcctSchema[]::new);
        }
        ArrayList<MAcctSchema> list = new ArrayList<MAcctSchema>();
        MClientInfo info = MClientInfo.get(ctx, AD_Client_ID, trxName);
        MAcctSchema as = MAcctSchema.get(ctx, info.getC_AcctSchema1_ID(), trxName);
        if (as.get_ID() != 0) {
            list.add(as);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("IsActive=? ").append(" AND EXISTS (SELECT * FROM C_AcctSchema_GL gl WHERE C_AcctSchema.C_AcctSchema_ID=gl.C_AcctSchema_ID)").append(" AND EXISTS (SELECT * FROM C_AcctSchema_Default d WHERE C_AcctSchema.C_AcctSchema_ID=d.C_AcctSchema_ID)");
        params.add("Y");
        if (AD_Client_ID != 0) {
            whereClause.append(" AND AD_Client_ID=?");
            params.add(AD_Client_ID);
        }
        List ass = new Query(ctx, "C_AcctSchema", whereClause.toString(), trxName).setParameters(params).setOrderBy("C_AcctSchema_ID").list();
        for (MAcctSchema acctschema : ass) {
            if (acctschema.get_ID() == info.getC_AcctSchema1_ID() || acctschema.get_ID() == 0) continue;
            acctschema.markImmutable();
            list.add(acctschema);
        }
        MAcctSchema[] retValue = new MAcctSchema[list.size()];
        list.toArray(retValue);
        if (ctx == Env.getCtx()) {
            s_schema.put(key, retValue);
        } else {
            s_schema.put(key, (MAcctSchema[])Arrays.stream(retValue).map(e -> new MAcctSchema(Env.getCtx(), (MAcctSchema)e).markImmutable()).toArray(MAcctSchema[]::new));
        }
        return retValue;
    }

    public MAcctSchema(Properties ctx, int C_AcctSchema_ID, String trxName) {
        super(ctx, C_AcctSchema_ID, trxName);
        if (C_AcctSchema_ID == 0) {
            this.setAutoPeriodControl(true);
            this.setPeriod_OpenFuture(2);
            this.setPeriod_OpenHistory(2);
            this.setCostingMethod("S");
            this.setCostingLevel("C");
            this.setIsAdjustCOGS(false);
            this.setGAAP("UN");
            this.setHasAlias(true);
            this.setHasCombination(false);
            this.setIsAccrual(true);
            this.setCommitmentType("N");
            this.setIsDiscountCorrectsTax(false);
            this.setTaxCorrectionType("N");
            this.setIsTradeDiscountPosted(false);
            this.setIsPostServices(false);
            this.setIsExplicitCostAdjustment(false);
            this.setSeparator("-");
        }
    }

    public MAcctSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAcctSchema(MClient client, KeyNamePair currency) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setC_Currency_ID(currency.getKey());
        StringBuilder msgset = new StringBuilder().append(client.getName()).append(" ").append(this.getGAAP()).append("/").append(this.get_ColumnCount()).append(" ").append(currency.getName());
        this.setName(msgset.toString());
    }

    public MAcctSchema(MAcctSchema copy) {
        this(Env.getCtx(), copy);
    }

    public MAcctSchema(Properties ctx, MAcctSchema copy) {
        this(ctx, copy, null);
    }

    public MAcctSchema(Properties ctx, MAcctSchema copy, String trxName) {
        super(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_gl = copy.m_gl != null ? new MAcctSchemaGL(ctx, copy.m_gl) : null;
        this.m_default = copy.m_default != null ? new MAcctSchemaDefault(ctx, copy.m_default) : null;
        this.m_SuspenseError_Acct = copy.m_SuspenseError_Acct != null ? new MAccount(ctx, copy.m_SuspenseError_Acct) : null;
        this.m_CurrencyBalancing_Acct = copy.m_CurrencyBalancing_Acct != null ? new MAccount(ctx, copy.m_CurrencyBalancing_Acct) : null;
        this.m_DueTo_Acct = copy.m_DueTo_Acct != null ? new MAccount(ctx, copy.m_DueTo_Acct) : null;
        this.m_DueFrom_Acct = copy.m_DueFrom_Acct != null ? new MAccount(ctx, copy.m_DueFrom_Acct) : null;
        this.m_stdPrecision = copy.m_stdPrecision;
        this.m_costPrecision = copy.m_costPrecision;
        this.m_onlyOrg = copy.m_onlyOrg != null ? new MOrg(ctx, copy.m_onlyOrg) : null;
        this.m_onlyOrgs = copy.m_onlyOrgs;
    }

    public MAcctSchemaElement[] getAcctSchemaElements() {
        return MAcctSchemaElement.getAcctSchemaElements(this);
    }

    public MAcctSchemaElement getAcctSchemaElement(String elementType) {
        MAcctSchemaElement[] mAcctSchemaElementArray = this.getAcctSchemaElements();
        int n = mAcctSchemaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MAcctSchemaElement ase = mAcctSchemaElementArray[n2];
            if (ase.getElementType().equals(elementType)) {
                return ase;
            }
            ++n2;
        }
        return null;
    }

    public boolean isAcctSchemaElement(String segmentType) {
        return this.getAcctSchemaElement(segmentType) != null;
    }

    public MAcctSchemaGL getAcctSchemaGL() {
        if (this.m_gl == null) {
            this.m_gl = MAcctSchemaGL.get(this.getCtx(), this.getC_AcctSchema_ID());
            if (this.m_gl != null && this.is_Immutable()) {
                this.m_gl.markImmutable();
            }
        }
        if (this.m_gl == null) {
            throw new IllegalStateException("No GL Definition for C_AcctSchema_ID=" + this.getC_AcctSchema_ID());
        }
        return this.m_gl;
    }

    public MAcctSchemaDefault getAcctSchemaDefault() {
        if (this.m_default == null) {
            this.m_default = MAcctSchemaDefault.get(this.getCtx(), this.getC_AcctSchema_ID());
            if (this.m_default != null && this.is_Immutable()) {
                this.m_default.markImmutable();
            }
        }
        if (this.m_default == null) {
            throw new IllegalStateException("No Default Definition for C_AcctSchema_ID=" + this.getC_AcctSchema_ID());
        }
        return this.m_default;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("AcctSchema[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public boolean isSuspenseBalancing() {
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        return this.m_gl.isUseSuspenseBalancing() && this.m_gl.getSuspenseBalancing_Acct() != 0;
    }

    public MAccount getSuspenseBalancing_Acct() {
        if (this.m_SuspenseError_Acct != null) {
            return this.m_SuspenseError_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int C_ValidCombination_ID = this.m_gl.getSuspenseBalancing_Acct();
        this.m_SuspenseError_Acct = MAccount.get(C_ValidCombination_ID);
        return this.m_SuspenseError_Acct;
    }

    public boolean isCurrencyBalancing() {
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        return this.m_gl.isUseCurrencyBalancing();
    }

    public MAccount getCurrencyBalancing_Acct() {
        if (this.m_CurrencyBalancing_Acct != null) {
            return this.m_CurrencyBalancing_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int C_ValidCombination_ID = this.m_gl.getCurrencyBalancing_Acct();
        this.m_CurrencyBalancing_Acct = MAccount.get(C_ValidCombination_ID);
        return this.m_CurrencyBalancing_Acct;
    }

    public MAccount getDueTo_Acct(String segment) {
        if (this.m_DueTo_Acct != null) {
            return this.m_DueTo_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int C_ValidCombination_ID = this.m_gl.getIntercompanyDueTo_Acct();
        this.m_DueTo_Acct = MAccount.get(C_ValidCombination_ID);
        return this.m_DueTo_Acct;
    }

    public MAccount getDueFrom_Acct(String segment) {
        if (this.m_DueFrom_Acct != null) {
            return this.m_DueFrom_Acct;
        }
        if (this.m_gl == null) {
            this.getAcctSchemaGL();
        }
        int C_ValidCombination_ID = this.m_gl.getIntercompanyDueFrom_Acct();
        this.m_DueFrom_Acct = MAccount.get(C_ValidCombination_ID);
        return this.m_DueFrom_Acct;
    }

    public void setOnlyOrgs(Integer[] orgs) {
        throw new IllegalStateException("The OnlyOrgs are now fetched automatically");
    }

    public synchronized Integer[] getOnlyOrgs() {
        if (this.m_onlyOrgs == null) {
            MReportTree tree = new MReportTree(this.getCtx(), 0, true, "OO");
            this.m_onlyOrgs = tree.getChildIDs(this.getAD_OrgOnly_ID());
        }
        return this.m_onlyOrgs;
    }

    public synchronized boolean isSkipOrg(int AD_Org_ID) {
        if (this.getAD_OrgOnly_ID() == 0) {
            return false;
        }
        if (this.getAD_OrgOnly_ID() == AD_Org_ID) {
            return false;
        }
        if (this.m_onlyOrg == null) {
            this.m_onlyOrg = MOrg.get(this.getAD_OrgOnly_ID());
        }
        if (!this.m_onlyOrg.isSummary()) {
            return true;
        }
        Integer[] onlyOrgs = this.getOnlyOrgs();
        if (onlyOrgs == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < onlyOrgs.length) {
            if (AD_Org_ID == onlyOrgs[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public int getStdPrecision() {
        if (this.m_stdPrecision < 0) {
            MCurrency cur = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
            this.m_stdPrecision = cur.getStdPrecision();
            this.m_costPrecision = cur.getCostingPrecision();
        }
        return this.m_stdPrecision;
    }

    public int getCostingPrecision() {
        if (this.m_costPrecision < 0) {
            this.getStdPrecision();
        }
        return this.m_costPrecision;
    }

    public void checkCosting() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (this.getM_CostType_ID() == 0) {
            MCostType ct = new MCostType(this.getCtx(), 0, this.get_TrxName());
            ct.setClientOrg(this.getAD_Client_ID(), 0);
            ct.setName(this.getName());
            ct.saveEx();
            this.setM_CostType_ID(ct.getM_CostType_ID());
        }
        MCostElement.getMaterialCostElement(this, this.getCostingMethod());
        if (this.getCostingLevel() == null) {
            this.setCostingLevel("C");
        }
        if (this.getCostingMethod() == null) {
            this.setCostingMethod("S");
        }
        if (this.getGAAP() == null) {
            this.setGAAP("UN");
        }
    }

    public boolean isCostingLevelClient() {
        String s = this.getCostingLevel();
        return s == null || "C".equals(s);
    }

    public boolean isCostingLevelOrg() {
        return "O".equals(this.getCostingLevel());
    }

    public boolean isCostingLevelBatch() {
        return "B".equals(this.getCostingLevel());
    }

    public boolean isCreatePOCommitment() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "C".equals(s) || "B".equals(s) || "A".equals(s) || "O".equals(s);
    }

    public boolean isCreateSOCommitment() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "S".equals(s) || "A".equals(s) || "O".equals(s);
    }

    public boolean isCreateReservation() {
        String s = this.getCommitmentType();
        if (s == null) {
            return false;
        }
        return "B".equals(s) || "A".equals(s);
    }

    @Override
    public String getTaxCorrectionType() {
        if (super.getTaxCorrectionType() == null) {
            this.setTaxCorrectionType(this.isDiscountCorrectsTax() ? "B" : "N");
        }
        return super.getTaxCorrectionType();
    }

    public boolean isTaxCorrection() {
        return !this.getTaxCorrectionType().equals("N");
    }

    public boolean isTaxCorrectionDiscount() {
        return this.getTaxCorrectionType().equals("D") || this.getTaxCorrectionType().equals("B");
    }

    public boolean isTaxCorrectionWriteOff() {
        return this.getTaxCorrectionType().equals("W") || this.getTaxCorrectionType().equals("B");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String products;
        MClientInfo info;
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (super.getTaxCorrectionType() == null) {
            this.setTaxCorrectionType(this.isDiscountCorrectsTax() ? "B" : "N");
        }
        this.checkCosting();
        if (this.getAD_OrgOnly_ID() != 0 && (info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID())).getC_AcctSchema1_ID() == this.getC_AcctSchema_ID()) {
            this.setAD_OrgOnly_ID(0);
        }
        if (!newRecord && this.is_ValueChanged("CostingLevel") && !Util.isEmpty(products = this.getProductsWithCost())) {
            this.log.saveError("Error", String.valueOf(Msg.getMsg(this.getCtx(), "ChangeCostingLevelError")) + ". Products: " + products);
            return false;
        }
        return true;
    }

    private String getProductsWithCost() {
        StringBuilder products = new StringBuilder();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT p.Value FROM M_Product p JOIN M_CostDetail d ON p.M_Product_ID=d.M_Product_ID");
        sql.append(" JOIN M_Product_Category_Acct pc ON p.M_Product_Category_ID=pc.M_Product_Category_ID AND d.C_AcctSchema_ID=pc.C_AcctSchema_ID");
        sql.append(" WHERE p.IsActive='Y' AND pc.IsActive='Y' AND pc.CostingLevel IS NULL AND d.C_AcctSchema_ID=?");
        String query = DB.getDatabase().addPagingSQL(sql.toString(), 0, 50);
        List<List<Object>> list = DB.getSQLArrayObjectsEx(this.get_TrxName(), query, this.getC_AcctSchema_ID());
        if (list != null) {
            for (List<Object> entry : list) {
                String value = (String)entry.get(0);
                if (products.length() > 0) {
                    products.append(",");
                }
                products.append(value);
            }
        }
        return products.toString();
    }

    @Override
    public MAcctSchema markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_gl != null) {
            this.m_gl.markImmutable();
        }
        if (this.m_default != null) {
            this.m_default.markImmutable();
        }
        return this;
    }
}

