/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.IImageStore;
import org.compiere.model.MImage;
import org.compiere.model.MStorageProvider;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImageFileStorageImpl
implements IImageStore {
    private String IMAGE_FOLDER_PLACEHOLDER = "%IMAGE_FOLDER%";
    private final CLogger log = CLogger.getCLogger(this.getClass());
    private byte[] buffer = null;

    @Override
    public byte[] load(MImage image, MStorageProvider prov) {
        Node fileNode;
        String imagePathRoot;
        block17: {
            Node entryNode;
            NamedNodeMap attributes;
            imagePathRoot = this.getImagePathRoot(prov);
            if ("".equals(imagePathRoot)) {
                throw new IllegalArgumentException("no path defined");
            }
            this.buffer = null;
            byte[] data = image.getByteData();
            if (data == null) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data));
            NodeList entries = document.getElementsByTagName("entry");
            if (entries.getLength() != 1) {
                this.log.severe("no image entry found");
            }
            if ((fileNode = (attributes = (entryNode = entries.item(0)).getAttributes()).getNamedItem("file")) != null) break block17;
            this.log.severe("no filename for entry");
            return null;
        }
        try {
            File file;
            String filePath = fileNode.getNodeValue();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if (filePath != null) {
                filePath = filePath.replaceFirst(this.IMAGE_FOLDER_PLACEHOLDER, imagePathRoot.replaceAll("\\\\", "\\\\\\\\"));
                String replaceSeparator = File.separator;
                if (!replaceSeparator.equals("/")) {
                    replaceSeparator = "\\\\";
                }
                filePath = filePath.replaceAll("/", replaceSeparator);
                filePath = filePath.replaceAll("\\\\", replaceSeparator);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if ((file = new File(filePath)).exists()) {
                byte[] dataEntry = new byte[(int)file.length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    fileInputStream.read(dataEntry);
                    fileInputStream.close();
                }
                catch (FileNotFoundException e) {
                    this.log.severe("File Not Found.");
                    e.printStackTrace();
                }
                catch (IOException e1) {
                    this.log.severe("Error Reading The File.");
                    e1.printStackTrace();
                }
                return dataEntry;
            }
            this.log.severe("file not found: " + file.getAbsolutePath());
            return null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            this.log.severe(x.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            this.log.severe(pce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.log.severe(ioe.getMessage());
        }
        return null;
    }

    @Override
    public void save(MImage image, MStorageProvider prov, byte[] inflatedData) {
        if (inflatedData == null || inflatedData.length == 0) {
            image.setByteData(null);
            this.delete(image, prov);
            return;
        }
        if (image.get_ID() == 0) {
            image.setByteData(new byte[]{48});
            this.buffer = inflatedData;
        } else {
            this.write(image, prov, inflatedData);
        }
    }

    private void write(MImage image, MStorageProvider prov, byte[] inflatedData) {
        FilterOutputStream out = null;
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                String imagePathRoot = this.getImagePathRoot(prov);
                if ("".equals(imagePathRoot)) {
                    throw new IllegalArgumentException("no storage path defined");
                }
                StringBuilder msgfile = new StringBuilder().append(imagePathRoot).append(image.getImageStoragePath());
                File destFolder = new File(msgfile.toString());
                if (!destFolder.exists() && !destFolder.mkdirs()) {
                    this.log.warning("unable to create folder: " + destFolder.getPath());
                }
                msgfile = new StringBuilder().append(imagePathRoot).append(File.separator).append(image.getImageStoragePath()).append(image.get_ID());
                File destFile = new File(msgfile.toString());
                out = new BufferedOutputStream(new FileOutputStream(destFile));
                out.write(inflatedData);
                ((BufferedOutputStream)out).flush();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element root = document.createElement("image");
                document.appendChild(root);
                document.setXmlStandalone(true);
                Element entry = document.createElement("entry");
                StringBuilder msgsat = new StringBuilder(this.IMAGE_FOLDER_PLACEHOLDER).append(image.getImageStoragePath()).append(image.get_ID());
                entry.setAttribute("file", msgsat.toString());
                root.appendChild(entry);
                DOMSource source = new DOMSource(document);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(bos);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.transform(source, result);
                byte[] xmlData = bos.toByteArray();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(bos.toString());
                }
                image.setByteData(xmlData);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "saveLOBData", e);
                image.setByteData(null);
                throw new RuntimeException(e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getImagePathRoot(MStorageProvider prov) {
        String imagePathRoot = prov.getFolder();
        if (imagePathRoot == null) {
            imagePathRoot = "";
        }
        if (Util.isEmpty(imagePathRoot)) {
            this.log.severe("no image Path defined");
        } else if (!imagePathRoot.endsWith(File.separator)) {
            imagePathRoot = String.valueOf(imagePathRoot) + File.separator;
            this.log.fine(imagePathRoot);
        }
        return imagePathRoot;
    }

    @Override
    public boolean delete(MImage image, MStorageProvider prov) {
        String imagePathRoot = this.getImagePathRoot(prov);
        if ("".equals(imagePathRoot)) {
            throw new IllegalArgumentException("no image path defined");
        }
        StringBuilder msgfile = new StringBuilder().append(imagePathRoot).append(image.getImageStoragePath()).append(image.getAD_Image_ID());
        File file = new File(msgfile.toString());
        if (file != null && file.exists() && !file.delete()) {
            this.log.warning("unable to delete " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    @Override
    public boolean isPendingFlush() {
        return this.buffer != null && this.buffer.length > 0;
    }

    @Override
    public void flush(MImage image, MStorageProvider prov) {
        if (this.buffer != null && this.buffer.length > 0) {
            this.write(image, prov, this.buffer);
            this.buffer = null;
        }
    }
}

