/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.compiere.model.IImageStore;
import org.compiere.model.MImage;
import org.compiere.model.MStorageProvider;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;

public class ImageDBStorageImpl
implements IImageStore {
    private final CLogger log = CLogger.getCLogger(this.getClass());

    @Override
    public byte[] load(MImage image, MStorageProvider prov) {
        byte[] deflatedData = image.getByteData();
        if (deflatedData == null) {
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("ZipSize=" + deflatedData.length);
        }
        if (deflatedData.length == 0) {
            return null;
        }
        byte[] inflatedData = null;
        try {
            ZipInputStream zip = null;
            ZipEntry entry = null;
            if (MSysConfig.getBooleanValue("IMAGE_DB_STORAGE_SAVE_AS_ZIP", false)) {
                ByteArrayInputStream in = new ByteArrayInputStream(deflatedData);
                zip = new ZipInputStream(in);
                entry = zip.getNextEntry();
            }
            if (entry != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                inflatedData = out.toByteArray();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Size=" + inflatedData.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                }
            } else {
                inflatedData = deflatedData;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            inflatedData = null;
        }
        return inflatedData;
    }

    @Override
    public void save(MImage image, MStorageProvider prov, byte[] inflatedData) {
        if (inflatedData == null || inflatedData.length == 0) {
            image.setByteData(null);
            return;
        }
        byte[] deflatedData = null;
        if (MSysConfig.getBooleanValue("IMAGE_DB_STORAGE_SAVE_AS_ZIP", false)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zip = new ZipOutputStream(out);
            zip.setMethod(8);
            zip.setLevel(9);
            zip.setComment("idempiere");
            try {
                ZipEntry entry = new ZipEntry(image.getName());
                entry.setTime(System.currentTimeMillis());
                entry.setMethod(8);
                zip.putNextEntry(entry);
                zip.write(inflatedData, 0, inflatedData.length);
                zip.closeEntry();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.valueOf(entry.getCompressedSize()) + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                }
                zip.close();
                deflatedData = out.toByteArray();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Length=" + inflatedData.length);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "saveLOBData", e);
                deflatedData = null;
            }
        } else {
            deflatedData = inflatedData;
        }
        image.setByteData(deflatedData);
    }

    @Override
    public boolean delete(MImage image, MStorageProvider prov) {
        return true;
    }

    @Override
    public boolean isPendingFlush() {
        return false;
    }

    @Override
    public void flush(MImage image, MStorageProvider prov) {
    }
}

