/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridTabVO;
import org.compiere.model.MRole;
import org.compiere.model.MUserDefWin;
import org.compiere.model.MWindow;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GridWindowVO
implements Serializable {
    private static final long serialVersionUID = 6884332743173214735L;
    private static final CLogger log = CLogger.getCLogger(GridWindowVO.class);
    private static CCache<Integer, GridWindowVO> s_windowsvo = new CCache("AD_Window", "AD_Window|GridWindowVO", 10);
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID = 0;
    public String AD_Window_UU = "";
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public String WindowType = "";
    public int AD_Image_ID = 0;
    public int AD_Color_ID = 0;
    public String IsReadWrite = null;
    public int WinWidth = 0;
    public int WinHeight = 0;
    public boolean IsSOTrx = false;
    public ArrayList<GridTabVO> Tabs = null;
    public int AD_Table_ID = 0;
    public static final String WINDOWTYPE_QUERY = "Q";
    public static final String WINDOWTYPE_TRX = "T";
    public static final String WINDOWTYPE_MMAINTAIN = "M";

    public static GridWindowVO get(int AD_Window_ID, int windowNo) {
        return GridWindowVO.get(AD_Window_ID, windowNo, -1);
    }

    public static GridWindowVO get(int AD_Window_ID, int windowNo, int AD_Menu_ID) {
        GridWindowVO mWindowVO = s_windowsvo.get(AD_Window_ID);
        if (mWindowVO != null) {
            mWindowVO = mWindowVO.clone(windowNo);
            if (log.isLoggable(Level.INFO)) {
                log.info("Cached=" + mWindowVO);
            }
        }
        if (mWindowVO == null) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("create local");
            }
            if ((mWindowVO = GridWindowVO.create(Env.getCtx(), windowNo, AD_Window_ID, AD_Menu_ID)) != null) {
                s_windowsvo.put(AD_Window_ID, mWindowVO);
            }
        }
        return mWindowVO;
    }

    public static GridWindowVO create(int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(Env.getCtx(), WindowNo, AD_Window_ID);
    }

    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(ctx, WindowNo, AD_Window_ID, 0);
    }

    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        Boolean windowAccess;
        CLogger.get().config("#" + WindowNo + " - AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        GridWindowVO vo = new GridWindowVO(ctx, WindowNo);
        vo.AD_Window_ID = AD_Window_ID;
        if (vo.AD_Window_ID == 0 && AD_Menu_ID != 0) {
            String sql = "SELECT AD_Window_ID, IsSOTrx, IsReadOnly FROM AD_Menu WHERE AD_Menu_ID=? AND Action='W'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Menu_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        vo.AD_Window_ID = rs.getInt(1);
                        String IsSOTrx = rs.getString(2);
                        Env.setContext(ctx, WindowNo, "IsSOTrx", IsSOTrx != null && IsSOTrx.equals("Y"));
                        String IsReadOnly = rs.getString(3);
                        vo.IsReadWrite = IsReadOnly != null && IsReadOnly.equals("Y") ? "Y" : "N";
                    }
                }
                catch (SQLException e) {
                    CLogger.get().log(Level.SEVERE, "Menu", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            CLogger.get().config("AD_Window_ID=" + vo.AD_Window_ID);
        }
        MWindow window = MWindow.get(AD_Window_ID);
        boolean base = Env.isBaseLanguage(vo.ctx, "AD_Window");
        if (window != null) {
            vo.Name = base ? window.getName() : window.get_Translation("Name");
            String string = vo.Description = base ? window.getDescription() : window.get_Translation("Description");
            if (vo.Description == null) {
                vo.Description = "";
            }
            String string2 = vo.Help = base ? window.getHelp() : window.get_Translation("Help");
            if (vo.Help == null) {
                vo.Help = "";
            }
            vo.WindowType = window.getWindowType();
            vo.AD_Color_ID = window.getAD_Color_ID();
            vo.AD_Image_ID = window.getAD_Image_ID();
            vo.WinHeight = window.getWinHeight();
            vo.WinWidth = window.getWinWidth();
            vo.IsSOTrx = window.isSOTrx();
            Env.setContext(ctx, WindowNo, "IsSOTrx", vo.IsSOTrx);
            vo.AD_Window_UU = window.getAD_Window_UU();
        } else {
            vo = null;
        }
        MRole role = MRole.getDefault(ctx, false);
        Boolean bl = windowAccess = vo != null ? role.getWindowAccess(vo.AD_Window_ID) : null;
        if (vo != null && windowAccess == null) {
            vo = null;
        }
        if (vo != null && windowAccess != null) {
            String string = vo.IsReadWrite = windowAccess != false ? "Y" : "N";
        }
        if (vo == null) {
            CLogger.get().log(Level.SEVERE, "No Window - AD_Window_ID=" + AD_Window_ID + ", AD_Role_ID=" + role);
            CLogger.get().saveError("AccessTableNoView", "(Not found)");
            return null;
        }
        if (vo.IsReadWrite == null) {
            CLogger.get().saveError("AccessTableNoView", "(found)");
            return null;
        }
        MUserDefWin userDef = MUserDefWin.getBestMatch(ctx, AD_Window_ID);
        if (userDef != null) {
            if (userDef.getName() != null) {
                vo.Name = userDef.getName();
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
        }
        GridWindowVO.createTabs(vo);
        if (vo.Tabs == null || vo.Tabs.size() == 0) {
            return null;
        }
        return vo;
    }

    private static boolean createTabs(GridWindowVO mWindowVO) {
        mWindowVO.Tabs = new ArrayList();
        String sql = GridTabVO.getSQL(mWindowVO.ctx);
        int TabNo = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, mWindowVO.AD_Window_ID);
                rs = pstmt.executeQuery();
                boolean firstTab = true;
                while (rs.next()) {
                    GridTabVO mTabVO;
                    if (mWindowVO.AD_Table_ID == 0) {
                        mWindowVO.AD_Table_ID = rs.getInt("AD_Table_ID");
                    }
                    if ((mTabVO = GridTabVO.create(mWindowVO, TabNo, rs, mWindowVO.WindowType.equals(WINDOWTYPE_QUERY), mWindowVO.WindowType.equals(WINDOWTYPE_TRX))) != null || !firstTab) {
                        if (mTabVO == null) continue;
                        if (!mTabVO.IsReadOnly && "N".equals(mWindowVO.IsReadWrite)) {
                            mTabVO.IsReadOnly = true;
                        }
                        mWindowVO.Tabs.add(mTabVO);
                        ++TabNo;
                        firstTab = false;
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException e) {
                CLogger.get().log(Level.SEVERE, "createTabs", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (TabNo == 0 || mWindowVO.Tabs.size() == 0) {
            CLogger.get().log(Level.SEVERE, "No Tabs - AD_Window_ID=" + mWindowVO.AD_Window_ID + " - " + sql);
            return false;
        }
        Env.setContext(mWindowVO.ctx, mWindowVO.WindowNo, "BaseTable_ID", mWindowVO.AD_Table_ID);
        return true;
    }

    private GridWindowVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        int i2 = 0;
        while (i2 < this.Tabs.size()) {
            GridTabVO tab = this.Tabs.get(i2);
            tab.setCtx(newCtx);
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GridWindowVO clone(int windowNo) {
        GridWindowVO clone = null;
        try {
            clone = new GridWindowVO(this.ctx, windowNo);
            clone.AD_Window_ID = this.AD_Window_ID;
            clone.AD_Window_UU = this.AD_Window_UU;
            clone.Name = this.Name;
            clone.Description = this.Description;
            clone.Help = this.Help;
            clone.WindowType = this.WindowType;
            clone.AD_Image_ID = this.AD_Image_ID;
            clone.AD_Color_ID = this.AD_Color_ID;
            clone.IsReadWrite = this.IsReadWrite;
            clone.WinWidth = this.WinWidth;
            clone.WinHeight = this.WinHeight;
            clone.IsSOTrx = this.IsSOTrx;
            Env.setContext(this.ctx, windowNo, "IsSOTrx", clone.IsSOTrx);
            clone.AD_Table_ID = this.AD_Table_ID;
            Env.setContext(this.ctx, windowNo, "BaseTable_ID", clone.AD_Table_ID);
            clone.Tabs = new ArrayList();
            int i2 = 0;
            while (true) {
                if (i2 >= this.Tabs.size()) {
                    return clone;
                }
                GridTabVO tab = this.Tabs.get(i2);
                GridTabVO cloneTab = tab.clone(clone.ctx, windowNo);
                if (cloneTab == null) {
                    return null;
                }
                clone.Tabs.add(cloneTab);
                ++i2;
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

