/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.awt.Image;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Icon;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.h2;
import org.apache.ecs.xhtml.h3;
import org.apache.ecs.xhtml.h4;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.strong;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MColor;
import org.compiere.model.MImage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;

public class GridWindow
implements Serializable {
    private static final long serialVersionUID = 3342733142743698614L;
    private GridWindowVO m_vo;
    private boolean m_virtual;
    private ArrayList<GridTab> m_tabs = new ArrayList();
    private Timestamp m_modelUpdated = null;
    private Set<GridTab> initTabs = new HashSet<GridTab>();
    private static CLogger log = CLogger.getCLogger(GridWindow.class);

    public static GridWindow get(Properties ctx, int WindowNo, int AD_Window_ID) {
        return GridWindow.get(ctx, WindowNo, AD_Window_ID, false);
    }

    public static GridWindow get(Properties ctx, int WindowNo, int AD_Window_ID, boolean virtual) {
        GridWindowVO mWindowVO;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        }
        if ((mWindowVO = GridWindowVO.get(AD_Window_ID, WindowNo)) == null) {
            return null;
        }
        return new GridWindow(mWindowVO, virtual);
    }

    public GridWindow(GridWindowVO vo) {
        this(vo, false);
    }

    public GridWindow(GridWindowVO vo, boolean virtual) {
        this.m_vo = vo;
        this.m_virtual = virtual;
        if (this.loadTabData()) {
            this.enableEvents();
        }
    }

    public void dispose() {
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Window_ID=" + this.m_vo.AD_Window_ID);
        }
        int i = 0;
        while (i < this.getTabCount()) {
            this.getTab(i).dispose();
            ++i;
        }
        this.m_tabs.clear();
        this.m_tabs = null;
    }

    public void loadCompete() {
        int i = 0;
        while (i < this.getTabCount()) {
            this.getTab(i).getMTable().loadComplete();
            ++i;
        }
    }

    private boolean loadTabData() {
        log.config("");
        if (this.m_vo.Tabs == null) {
            return false;
        }
        int t = 0;
        while (t < this.m_vo.Tabs.size()) {
            GridTabVO mTabVO = this.m_vo.Tabs.get(t);
            if (mTabVO != null) {
                GridTab mTab = new GridTab(mTabVO, this, this.m_virtual);
                Env.setContext(this.m_vo.ctx, this.m_vo.WindowNo, t, "_TabInfo_TabLevel", Integer.toString(mTab.getTabLevel()));
                this.m_tabs.add(mTab);
            }
            ++t;
        }
        return true;
    }

    public boolean isTabInitialized(int index) {
        GridTab mTab = this.m_tabs.get(index);
        return this.initTabs.contains(mTab);
    }

    public void initTab(int index) {
        ArrayList<String> parents;
        GridTab mTab = this.m_tabs.get(index);
        if (this.initTabs.contains(mTab)) {
            return;
        }
        mTab.initTab(false);
        if (mTab.getLinkColumnName().length() == 0 && (parents = mTab.getParentColumnNames()).size() != 0) {
            if (parents.size() == 1) {
                mTab.setLinkColumnName(parents.get(0));
            } else {
                GridTab parentTab = null;
                int i = 0;
                while (i < index) {
                    if (this.m_tabs.get(i).getTabLevel() + 1 == mTab.getTabLevel()) {
                        parentTab = this.m_tabs.get(i);
                        break;
                    }
                    ++i;
                }
                if (parentTab != null) {
                    String tabKey = parentTab.getKeyColumnName();
                    int j = 0;
                    while (j < parents.size()) {
                        String parent = parents.get(j);
                        if (parent.equals(tabKey)) {
                            mTab.setLinkColumnName(parent);
                            break;
                        }
                        if (tabKey.equals("")) {
                            int k = 0;
                            while (k < parentTab.getParentColumnNames().size()) {
                                if (parent.equals(parentTab.getParentColumnNames().get(k))) {
                                    mTab.setLinkColumnName(parent);
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        mTab.setLinkColumnName(null);
        this.initTabs.add(mTab);
    }

    public Image getImage() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(Env.getCtx(), this.m_vo.AD_Image_ID);
        return mImage.getImage();
    }

    public MImage getMImage() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(Env.getCtx(), this.m_vo.AD_Image_ID);
        return mImage;
    }

    public Icon getIcon() {
        if (this.m_vo.AD_Image_ID == 0) {
            return null;
        }
        MImage mImage = MImage.get(Env.getCtx(), this.m_vo.AD_Image_ID);
        return mImage.getIcon();
    }

    public MColor getColor() {
        if (this.m_vo.AD_Color_ID == 0) {
            return null;
        }
        MColor mc = new MColor(this.m_vo.ctx, this.m_vo.AD_Color_ID, null);
        return mc;
    }

    public boolean isSOTrx() {
        return this.m_vo.IsSOTrx;
    }

    public void query() {
        log.info("");
        GridTab tab = this.getTab(0);
        tab.query(false, 0, 0);
        if (tab.getRowCount() > 0) {
            tab.navigate(0);
        }
    }

    private void enableEvents() {
        int i = 0;
        while (i < this.getTabCount()) {
            this.getTab(i).enableEvents();
            ++i;
        }
    }

    public int getTabCount() {
        return this.m_tabs.size();
    }

    public GridTab getTab(int i) {
        if (i < 0 || i + 1 > this.m_tabs.size()) {
            return null;
        }
        return this.m_tabs.get(i);
    }

    public int getTabIndex(GridTab tab) {
        return this.m_tabs.indexOf(tab);
    }

    public int getAD_Window_ID() {
        return this.m_vo.AD_Window_ID;
    }

    public int getWindowNo() {
        return this.m_vo.WindowNo;
    }

    public String getName() {
        return this.m_vo.Name;
    }

    public String getDescription() {
        return this.m_vo.Description;
    }

    public String getHelp() {
        return this.m_vo.Help;
    }

    public String getWindowType() {
        return this.m_vo.WindowType;
    }

    public boolean isTransaction() {
        return this.m_vo.WindowType.equals("T");
    }

    public Dimension getWindowSize() {
        if (this.m_vo.WinWidth != 0 && this.m_vo.WinHeight != 0) {
            return new Dimension(this.m_vo.WinWidth, this.m_vo.WinHeight);
        }
        return null;
    }

    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MWindow[").append(this.m_vo.WindowNo).append(",").append(this.m_vo.Name).append(" (").append(this.m_vo.AD_Window_ID).append(")]");
        return msgreturn.toString();
    }

    public WebDoc getHelpDoc(boolean javaClient) {
        StringBuilder title = new StringBuilder(Msg.getMsg(Env.getCtx(), "Window")).append(": ").append(this.getName());
        WebDoc doc = null;
        doc = WebDoc.create(false, title.toString(), javaClient);
        td center = doc.addPopupCenter(false);
        if (this.getDescription().length() != 0) {
            center.addElement((Element)new p().addElement((Element)new i(this.getDescription())));
        }
        if (this.getHelp().length() != 0) {
            center.addElement((Element)new p().addElement(this.getHelp()));
        }
        center.addElement((Element)new a().setName("Tabs")).addElement(new h3(Msg.getMsg(Env.getCtx(), "Tabs")).addAttribute("ALIGN", "left"));
        int size = this.getTabCount();
        p p2 = new p();
        int i2 = 0;
        while (i2 < size) {
            GridTab tab = this.getTab(i2);
            if (i2 > 0) {
                p2.addElement(" | ");
            }
            p2.addElement((Element)new a("#Tab" + i2).addElement(tab.getName()));
            ++i2;
        }
        center.addElement((Element)p2).addElement((Element)new p().addElement("&nbsp;"));
        i2 = 0;
        while (i2 < size) {
            String hdr;
            GridField field;
            table table2 = new table("1", "5", "5", "100%", null);
            table2.setBorder("1px").setCellSpacing(0);
            GridTab tab = this.getTab(i2);
            table tabHeader = new table();
            tabHeader.setBorder("0").setCellPadding(0).setCellSpacing(0);
            tabHeader.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new a().setName("Tab" + i2)).addElement((Element)new h2(String.valueOf(Msg.getMsg(Env.getCtx(), "Tab")) + ": " + tab.getName()))).addElement((Element)new td().addElement("&nbsp;").addElement("&nbsp;").addElement(new a("#Tabs").addElement("..").addAttribute("title", "Up one level"))));
            tr tr2 = new tr().addElement((Element)new th().addElement((Element)tabHeader));
            if (tab.getDescription().length() != 0) {
                tr2.addElement((Element)new th().addElement((Element)new i(tab.getDescription())));
            } else {
                tr2.addElement((Element)new th().addElement("&nbsp;"));
            }
            table2.addElement((Element)tr2);
            td td2 = new td().setColSpan(2);
            if (tab.getHelp().length() != 0) {
                td2.addElement((Element)new p().addElement(tab.getHelp()));
            }
            td2.addElement((Element)new a().setName("Fields" + i2));
            td2.addElement(new h4(Msg.getMsg(Env.getCtx(), "Fields")).addAttribute("ALIGN", "left"));
            p2 = new p();
            if (!tab.isLoadComplete()) {
                this.initTab(i2);
            }
            int j = 0;
            while (j < tab.getFieldCount()) {
                field = tab.getField(j);
                if (field.isDisplayed(false) && (hdr = field.getHeader()) != null && hdr.length() > 0) {
                    if (j > 0) {
                        p2.addElement(" | ");
                    }
                    p2.addElement((Element)new a("#Field" + i2 + "-" + j, hdr));
                }
                ++j;
            }
            td2.addElement((Element)p2);
            table2.addElement((Element)new tr().addElement((Element)td2));
            j = 0;
            while (j < tab.getFieldCount()) {
                field = tab.getField(j);
                if (field.isDisplayed(false) && (hdr = field.getHeader()) != null && hdr.length() > 0) {
                    table fieldHeader = new table();
                    fieldHeader.setBorder("0").setCellPadding(0).setCellSpacing(0);
                    fieldHeader.addElement((Element)new tr().addElement((Element)new td().addElement((Element)new a().setName("Field" + i2 + "-" + j)).addElement((Element)new h3(String.valueOf(Msg.getMsg(Env.getCtx(), "Field")) + ": " + hdr))).addElement((Element)new td().addElement("&nbsp;").addElement("&nbsp;").addElement((Element)new strong().addElement(new a("#Fields" + i2).addElement("..").addAttribute("title", "Up one level")))));
                    td2 = new td().setColSpan(2).addElement((Element)fieldHeader);
                    if (field.getDescription().length() != 0) {
                        td2.addElement((Element)new i(field.getDescription()));
                    }
                    if (field.getHelp().length() != 0) {
                        td2.addElement((Element)new p().addElement(field.getHelp()));
                    }
                    table2.addElement((Element)new tr().addElement((Element)td2));
                }
                ++j;
            }
            center.addElement((Element)table2);
            center.addElement((Element)new p().addElement("&nbsp;"));
            ++i2;
        }
        return doc;
    }

    public Timestamp getModelUpdated(boolean recalc) {
        block11: {
            if (recalc || this.m_modelUpdated == null) {
                String sql = "SELECT MAX(w.Updated), MAX(t.Updated), MAX(tt.Updated), MAX(f.Updated), MAX(c.Updated) FROM AD_Window w INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID) INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) INNER JOIN AD_Field f ON (t.AD_Tab_ID=f.AD_Tab_ID) INNER JOIN AD_Column c ON (f.AD_Column_ID=c.AD_Column_ID) WHERE w.AD_Window_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, this.getAD_Window_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_modelUpdated = rs.getTimestamp(1);
                            Timestamp ts = rs.getTimestamp(2);
                            if (ts.after(this.m_modelUpdated)) {
                                this.m_modelUpdated = ts;
                            }
                            if ((ts = rs.getTimestamp(3)).after(this.m_modelUpdated)) {
                                this.m_modelUpdated = ts;
                            }
                            if ((ts = rs.getTimestamp(4)).after(this.m_modelUpdated)) {
                                this.m_modelUpdated = ts;
                            }
                            if ((ts = rs.getTimestamp(5)).after(this.m_modelUpdated)) {
                                this.m_modelUpdated = ts;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var3_3 = null;
            }
        }
        return this.m_modelUpdated;
    }

    public String getAD_Window_UU() {
        return this.m_vo.AD_Window_UU;
    }

    public GridTab getGridTab(int ad_tab_id) {
        int i2 = 0;
        while (i2 < this.m_tabs.size()) {
            GridTab tab = this.getTab(i2);
            if (tab.getAD_Tab_ID() == ad_tab_id) {
                return tab;
            }
            ++i2;
        }
        return null;
    }

    public GridTab getGridTab(String ad_tab_uu) {
        int i2 = 0;
        while (i2 < this.m_tabs.size()) {
            GridTab tab = this.getTab(i2);
            if (tab.getAD_Tab_UU() != null && tab.getAD_Tab_UU().equals(ad_tab_uu)) {
                return tab;
            }
            ++i2;
        }
        return null;
    }
}

