/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MUserDefTab;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public class GridTabVO
implements Evaluatee,
Serializable {
    private static final long serialVersionUID = 8781340605954851838L;
    private static final CCache<String, ArrayList<GridFieldVO>> s_gridFieldCache = new CCache("AD_Field", "GridFieldVO Cache", 100, CCache.DEFAULT_EXPIRE_MINUTE, false, 1000);
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID;
    public int TabNo;
    public int AD_Tab_ID;
    public String AD_Tab_UU;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public boolean IsSingleRow = false;
    public boolean IsReadOnly = false;
    public boolean IsInsertRecord = true;
    public boolean HasTree = false;
    public String TreeDisplayedOn = "";
    public int MaxQueryRecords = 0;
    public int AD_Table_ID;
    public String AD_Table_UU;
    public int AD_Column_ID = 0;
    public int Parent_Column_ID = 0;
    public String TableName;
    public boolean IsView = false;
    public String AccessLevel;
    public boolean IsSecurityEnabled = false;
    public boolean IsDeleteable = false;
    public boolean IsHighVolume = false;
    public boolean IsAllowAdvancedLookup = false;
    public boolean IsLookupOnlySelection = false;
    public int AD_Process_ID = 0;
    public String AD_Process_UU;
    public String CommitWarning;
    public String WhereClause;
    public String OrderByClause;
    public String ReadOnlyLogic;
    public String DisplayLogic;
    public int TabLevel = 0;
    public int AD_Image_ID = 0;
    public int Included_Tab_ID = 0;
    public String ReplicationType = "L";
    public boolean IsSortTab = false;
    public int AD_ColumnSortOrder_ID = 0;
    public int AD_ColumnSortYesNo_ID = 0;
    public boolean onlyCurrentRows = true;
    public int onlyCurrentDays = 0;
    public String AD_TabType = null;
    private ArrayList<GridFieldVO> Fields = null;
    private boolean initFields = false;
    public String deleteConfirmationLogic = null;

    public static GridTabVO create(GridWindowVO wVO, int TabNo, ResultSet rs, boolean isRO, boolean onlyCurrentRows) {
        CLogger.get().config("#" + TabNo);
        GridTabVO vo = new GridTabVO(wVO.ctx, wVO.WindowNo);
        vo.AD_Window_ID = wVO.AD_Window_ID;
        vo.TabNo = TabNo;
        if (!GridTabVO.loadTabDetails(vo, rs)) {
            return null;
        }
        if (isRO) {
            CLogger.get().fine("Tab is ReadOnly");
            vo.IsReadOnly = true;
        }
        vo.onlyCurrentRows = onlyCurrentRows;
        if (vo.IsSortTab) {
            vo.Fields = new ArrayList();
        }
        return vo;
    }

    private static boolean loadTabDetails(GridTabVO vo, ResultSet rs) {
        MUserDefTab userDef;
        block57: {
            MRole role;
            block56: {
                block55: {
                    boolean showAcct;
                    block54: {
                        boolean showAdvanced;
                        block53: {
                            role = MRole.getDefault(vo.ctx, false);
                            boolean showTrl = "Y".equals(Env.getContext(vo.ctx, "#ShowTrl"));
                            showAcct = "Y".equals(Env.getContext(vo.ctx, "#ShowAcct"));
                            showAdvanced = "Y".equals(Env.getContext(vo.ctx, "#ShowAdvanced"));
                            try {
                                vo.AD_Tab_ID = rs.getInt("AD_Tab_ID");
                                Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(vo.AD_Tab_ID));
                                vo.AD_Tab_UU = rs.getString("AD_Tab_UU");
                                Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_UU", vo.AD_Tab_UU);
                                userDef = MUserDefTab.get(vo.ctx, vo.AD_Tab_ID, vo.AD_Window_ID);
                                MTab tab = MTab.get(vo.AD_Tab_ID);
                                vo.Name = rs.getString("Name");
                                if (userDef != null) {
                                    if (!Util.isEmpty(userDef.getName())) {
                                        vo.Name = userDef.getName();
                                    }
                                    if (!Util.isEmpty(userDef.getDeleteConfirmationLogic())) {
                                        vo.deleteConfirmationLogic = userDef.getDeleteConfirmationLogic();
                                    } else if (tab != null && !Util.isEmpty(tab.getDeleteConfirmationLogic())) {
                                        vo.deleteConfirmationLogic = tab.getDeleteConfirmationLogic();
                                    }
                                } else if (tab != null && !Util.isEmpty(tab.getDeleteConfirmationLogic())) {
                                    vo.deleteConfirmationLogic = tab.getDeleteConfirmationLogic();
                                }
                                Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_Name", vo.Name);
                                if (!rs.getString("IsTranslationTab").equals("Y")) break block53;
                                vo.TableName = rs.getString("TableName");
                                if (!Env.isBaseTranslation(vo.TableName) && !Env.isMultiLingualDocument(vo.ctx)) {
                                    showTrl = false;
                                }
                                if (showTrl) break block53;
                                CLogger.get().config("TrlTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + "=" + vo.Name + ", Table=" + vo.TableName + ", BaseTrl=" + Env.isBaseTranslation(vo.TableName) + ", MultiLingual=" + Env.isMultiLingualDocument(vo.ctx));
                                return false;
                            }
                            catch (SQLException ex) {
                                CLogger.get().log(Level.SEVERE, "", ex);
                                return false;
                            }
                        }
                        if (showAdvanced || !rs.getString("IsAdvancedTab").equals("Y")) break block54;
                        CLogger.get().config("AdvancedTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                        return false;
                    }
                    if (showAcct || !rs.getString("IsInfoTab").equals("Y")) break block55;
                    CLogger.get().fine("AcctTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                    return false;
                }
                vo.DisplayLogic = rs.getString("DisplayLogic");
                if (userDef != null && userDef.getDisplayLogic() != null) {
                    vo.DisplayLogic = userDef.getDisplayLogic();
                }
                vo.AccessLevel = rs.getString("AccessLevel");
                if (role.canView(vo.ctx, vo.AccessLevel)) break block56;
                CLogger.get().fine("No Role Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
                return false;
            }
            Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AccessLevel", vo.AccessLevel);
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(vo.AD_Table_ID));
            if (role.isTableAccess(vo.AD_Table_ID, true)) break block57;
            CLogger.get().config("No Table Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            return false;
        }
        vo.AD_Table_UU = rs.getString("AD_Table_UU");
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Table_UU", vo.AD_Table_UU);
        if (rs.getString("IsReadOnly").equals("Y")) {
            vo.IsReadOnly = true;
        }
        if (userDef != null && userDef.getIsReadOnly() != null) {
            vo.IsReadOnly = "Y".equals(userDef.getIsReadOnly());
        }
        vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
        if (userDef != null && userDef.getReadOnlyLogic() != null) {
            vo.ReadOnlyLogic = userDef.getReadOnlyLogic();
        }
        if (rs.getString("IsInsertRecord").equals("N")) {
            vo.IsInsertRecord = false;
        }
        vo.Description = rs.getString("Description");
        if (vo.Description == null) {
            vo.Description = "";
        }
        if (userDef != null && userDef.getDescription() != null) {
            vo.Description = userDef.getDescription();
        }
        vo.Help = rs.getString("Help");
        if (vo.Help == null) {
            vo.Help = "";
        }
        if (userDef != null && userDef.getHelp() != null) {
            vo.Help = userDef.getHelp();
        }
        if (rs.getString("IsSingleRow").equals("Y")) {
            vo.IsSingleRow = true;
        }
        if (userDef != null && userDef.getIsSingleRow() != null) {
            vo.IsSingleRow = "Y".equals(userDef.getIsSingleRow());
        }
        if (rs.getString("HasTree").equals("Y")) {
            vo.HasTree = true;
        }
        vo.TreeDisplayedOn = rs.getString("TreeDisplayedOn");
        vo.MaxQueryRecords = rs.getInt("MaxQueryRecords");
        vo.AD_Table_ID = rs.getInt("AD_Table_ID");
        vo.TableName = rs.getString("TableName");
        if (rs.getString("IsView").equals("Y")) {
            vo.IsView = true;
        }
        vo.AD_Column_ID = rs.getInt("AD_Column_ID");
        vo.Parent_Column_ID = rs.getInt("Parent_Column_ID");
        if (rs.getString("IsSecurityEnabled").equals("Y")) {
            vo.IsSecurityEnabled = true;
        }
        if (rs.getString("IsDeleteable").equals("Y")) {
            vo.IsDeleteable = true;
        }
        if (rs.getString("IsHighVolume").equals("Y")) {
            vo.IsHighVolume = true;
        }
        if (userDef != null && !Util.isEmpty(userDef.getIsHighVolume())) {
            vo.IsHighVolume = "Y".equals(userDef.getIsHighVolume());
        }
        if (rs.getString("IsLookupOnlySelection").equals("Y")) {
            vo.IsLookupOnlySelection = true;
        }
        if (userDef != null && userDef.getIsLookupOnlySelection() != null) {
            vo.IsLookupOnlySelection = "Y".equals(userDef.getIsLookupOnlySelection());
        }
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsLookupOnlySelection", vo.IsLookupOnlySelection);
        if (rs.getString("IsAllowAdvancedLookup").equals("Y")) {
            vo.IsAllowAdvancedLookup = true;
        }
        if (userDef != null && userDef.getIsAllowAdvancedLookup() != null) {
            vo.IsAllowAdvancedLookup = "Y".equals(userDef.getIsAllowAdvancedLookup());
        }
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsAllowAdvancedLookup", vo.IsAllowAdvancedLookup);
        vo.CommitWarning = rs.getString("CommitWarning");
        if (vo.CommitWarning == null) {
            vo.CommitWarning = "";
        }
        vo.WhereClause = rs.getString("WhereClause");
        if (vo.WhereClause == null) {
            vo.WhereClause = "";
        }
        if (vo.WhereClause.indexOf("=null") > 0) {
            vo.WhereClause = vo.WhereClause.replaceAll("=null", " IS NULL ");
        }
        if (vo.WhereClause.trim().length() > 0) {
            vo.WhereClause = "(" + vo.WhereClause + ")";
        }
        if (userDef != null && userDef.getWhereClause() != null && !userDef.getWhereClause().trim().isEmpty()) {
            if (vo.WhereClause.trim().length() > 0) {
                vo.WhereClause = String.valueOf(vo.WhereClause) + " AND ";
            }
            vo.WhereClause = String.valueOf(vo.WhereClause) + " (" + userDef.getWhereClause() + ")";
        }
        vo.OrderByClause = rs.getString("OrderByClause");
        if (vo.OrderByClause == null) {
            vo.OrderByClause = "";
        }
        if (userDef != null && userDef.getOrderByClause() != null && !userDef.getOrderByClause().trim().isEmpty()) {
            vo.OrderByClause = userDef.getOrderByClause();
        }
        vo.AD_Process_ID = rs.getInt("AD_Process_ID");
        if (rs.wasNull()) {
            vo.AD_Process_ID = 0;
        }
        if (userDef != null && userDef.getAD_Process_ID() > 0) {
            vo.AD_Process_ID = userDef.getAD_Process_ID();
        }
        vo.AD_Image_ID = rs.getInt("AD_Image_ID");
        if (rs.wasNull()) {
            vo.AD_Image_ID = 0;
        }
        vo.Included_Tab_ID = rs.getInt("Included_Tab_ID");
        if (rs.wasNull()) {
            vo.Included_Tab_ID = 0;
        }
        vo.TabLevel = rs.getInt("TabLevel");
        if (rs.wasNull()) {
            vo.TabLevel = 0;
        }
        vo.IsSortTab = rs.getString("IsSortTab").equals("Y");
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsSortTab", vo.IsSortTab ? "Y" : "N");
        if (vo.IsSortTab) {
            vo.AD_ColumnSortOrder_ID = rs.getInt("AD_ColumnSortOrder_ID");
            vo.AD_ColumnSortYesNo_ID = rs.getInt("AD_ColumnSortYesNo_ID");
        }
        vo.AD_TabType = rs.getString("AD_TabType");
        try {
            int index = rs.findColumn("ReplicationType");
            vo.ReplicationType = rs.getString(index);
            if ("R".equals(vo.ReplicationType)) {
                vo.IsReadOnly = true;
            }
        }
        catch (Exception exception) {}
        return true;
    }

    private static boolean createFields(GridTabVO mTabVO) {
        mTabVO.Fields = new ArrayList();
        String sql = GridFieldVO.getSQL(mTabVO.ctx);
        String cacheKey = String.valueOf(sql) + "|" + mTabVO.AD_Tab_ID;
        ArrayList<GridFieldVO> cache = s_gridFieldCache.get(cacheKey);
        if (cache != null) {
            for (GridFieldVO gvo : cache) {
                GridFieldVO clone = gvo.clone(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly);
                mTabVO.Fields.add(clone.afterCreate());
            }
        } else {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    cache = new ArrayList();
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, mTabVO.AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        GridFieldVO voF = GridFieldVO.createFromResultSet(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly, rs);
                        if (voF == null) continue;
                        cache.add(voF.clone(Env.getCtx(), mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly));
                        mTabVO.Fields.add(voF.afterCreate());
                    }
                    if (!cache.isEmpty()) {
                        s_gridFieldCache.put(cacheKey, cache);
                    }
                }
                catch (Exception e) {
                    CLogger.get().log(Level.SEVERE, "", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        Collections.sort(mTabVO.Fields, new GridFieldVO.SeqNoComparator());
        mTabVO.initFields = true;
        return mTabVO.Fields.size() != 0;
    }

    protected static String getSQL(Properties ctx) {
        StringBuilder sql;
        MClient client = MClient.get(ctx);
        String ASPFilter = "";
        if (client.isUseASP()) {
            StringBuilder stringBuilder = new StringBuilder().append("     AND (   AD_Tab_ID IN ( ").append("              SELECT t.AD_Tab_ID ").append("                FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl ").append("               WHERE w.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND cl.AD_Client_ID = ").append(client.getAD_Client_ID()).append("                 AND cl.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND t.ASP_Window_ID = w.ASP_Window_ID ").append("                 AND t.IsActive = 'Y' ").append("                 AND w.IsActive = 'Y' ").append("                 AND l.IsActive = 'Y' ").append("                 AND cl.IsActive = 'Y' ").append("                 AND t.ASP_Status = 'S') ").append("        OR AD_Tab_ID IN ( ").append("              SELECT AD_Tab_ID ").append("                FROM ASP_ClientException ce ").append("               WHERE ce.AD_Client_ID = ").append(client.getAD_Client_ID()).append("                 AND ce.IsActive = 'Y' ").append("                 AND ce.AD_Tab_ID IS NOT NULL ").append("                 AND ce.AD_Field_ID IS NULL ").append("                 AND ce.ASP_Status = 'S') ").append("       ) ").append("   AND AD_Tab_ID NOT IN ( ").append("          SELECT AD_Tab_ID ").append("            FROM ASP_ClientException ce ").append("           WHERE ce.AD_Client_ID = ").append(client.getAD_Client_ID()).append("             AND ce.IsActive = 'Y' ").append("             AND ce.AD_Tab_ID IS NOT NULL ").append("             AND ce.AD_Field_ID IS NULL ").append("             AND ce.ASP_Status = 'H')");
            ASPFilter = stringBuilder.toString();
        }
        MRole role = MRole.getDefault(ctx, false);
        String advancedFilter = " AND IsAdvancedTab='N' ";
        if (!Env.isBaseLanguage(ctx, "AD_Window")) {
            sql = new StringBuilder("SELECT * FROM AD_Tab_vt WHERE AD_Window_ID=?");
            sql.append(" AND AD_Language='" + Env.getAD_Language(ctx) + "'").append(ASPFilter);
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY SeqNo");
        } else {
            sql = new StringBuilder("SELECT * FROM AD_Tab_v WHERE AD_Window_ID=?");
            sql.append(ASPFilter);
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY SeqNo");
        }
        return sql.toString();
    }

    private GridTabVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public ArrayList<GridFieldVO> getFields() {
        if (!this.initFields) {
            GridTabVO.createFields(this);
        }
        return this.Fields;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.Fields != null) {
            int i = 0;
            while (i < this.Fields.size()) {
                GridFieldVO field = this.Fields.get(i);
                field.setCtx(newCtx);
                ++i;
            }
        }
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return Env.getContext(this.ctx, this.WindowNo, variableName, false);
    }

    protected GridTabVO clone(Properties Ctx, int windowNo) {
        GridTabVO clone = new GridTabVO(Ctx, windowNo);
        clone.AD_Window_ID = this.AD_Window_ID;
        clone.TabNo = this.TabNo;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(clone.AD_Tab_ID));
        clone.AD_Tab_ID = this.AD_Tab_ID;
        clone.AD_Tab_UU = this.AD_Tab_UU;
        clone.Name = this.Name;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_Name", clone.Name);
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.IsSingleRow = this.IsSingleRow;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsInsertRecord = this.IsInsertRecord;
        clone.HasTree = this.HasTree;
        clone.TreeDisplayedOn = this.TreeDisplayedOn;
        clone.MaxQueryRecords = this.MaxQueryRecords;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.Parent_Column_ID = this.Parent_Column_ID;
        clone.TableName = this.TableName;
        clone.IsView = this.IsView;
        clone.AccessLevel = this.AccessLevel;
        clone.IsSecurityEnabled = this.IsSecurityEnabled;
        clone.IsDeleteable = this.IsDeleteable;
        clone.IsHighVolume = this.IsHighVolume;
        clone.IsLookupOnlySelection = this.IsLookupOnlySelection;
        clone.IsAllowAdvancedLookup = this.IsAllowAdvancedLookup;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.CommitWarning = this.CommitWarning;
        clone.WhereClause = this.WhereClause;
        clone.OrderByClause = this.OrderByClause;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.DisplayLogic = this.DisplayLogic;
        clone.TabLevel = this.TabLevel;
        clone.AD_Image_ID = this.AD_Image_ID;
        clone.Included_Tab_ID = this.Included_Tab_ID;
        clone.ReplicationType = this.ReplicationType;
        clone.deleteConfirmationLogic = this.deleteConfirmationLogic;
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AccessLevel", clone.AccessLevel);
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_AD_Table_ID", String.valueOf(clone.AD_Table_ID));
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_IsLookupOnlySelection", clone.IsLookupOnlySelection);
        Env.setContext(Ctx, windowNo, clone.TabNo, "_TabInfo_IsAllowAdvancedLookup", clone.IsAllowAdvancedLookup);
        clone.IsSortTab = this.IsSortTab;
        clone.AD_ColumnSortOrder_ID = this.AD_ColumnSortOrder_ID;
        clone.AD_ColumnSortYesNo_ID = this.AD_ColumnSortYesNo_ID;
        clone.onlyCurrentRows = true;
        clone.onlyCurrentDays = 0;
        clone.AD_TabType = this.AD_TabType;
        clone.Fields = new ArrayList();
        int i = 0;
        while (i < this.Fields.size()) {
            GridFieldVO field = this.Fields.get(i);
            GridFieldVO cloneField = field.clone(Ctx, windowNo, this.TabNo, this.AD_Window_ID, this.AD_Tab_ID, this.IsReadOnly);
            if (cloneField == null) {
                return null;
            }
            clone.Fields.add(cloneField);
            ++i;
        }
        return clone;
    }

    public boolean isInitFields() {
        return this.initFields;
    }
}

