/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.AttachmentFileLazyDataSource;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MStorageProvider;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttachmentFileSystem
implements IAttachmentStore {
    private final CLogger log = CLogger.getCLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean save(MAttachment attach, MStorageProvider prov) {
        String attachmentPathRoot = this.getAttachmentPathRoot(prov);
        if (attach.m_items == null || attach.m_items.size() == 0) {
            attach.setBinaryData(null);
            return true;
        }
        byte[] data = (byte[])attach.get_ValueOld("BinaryData");
        NodeList xmlEntries = null;
        if (data != null && data.length > 0) {
            xmlEntries = this.getEntriesFromXML(data);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("attachments");
            document.appendChild(root);
            document.setXmlStandalone(true);
            int i = 0;
            while (i < attach.m_items.size()) {
                File entryFile;
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(attach.m_items.get(i).toString());
                }
                if ((entryFile = attach.m_items.get(i).getFile()) == null) {
                    String itemName = attach.m_items.get(i).getName();
                    if (!itemName.startsWith("~") || !itemName.endsWith("~")) throw new AdempiereException("Attachment file not found: " + itemName);
                    itemName = itemName.substring(1, itemName.length() - 1);
                    if (xmlEntries != null) {
                        int x = 0;
                        while (x < xmlEntries.getLength()) {
                            Node entryNode = xmlEntries.item(x);
                            NamedNodeMap attributes = entryNode.getAttributes();
                            Node fileNode = attributes.getNamedItem("file");
                            Node nameNode = attributes.getNamedItem("name");
                            if (itemName.equals(nameNode.getNodeValue())) {
                                Element entry = document.createElement("entry");
                                entry.setAttribute("name", itemName);
                                entry.setAttribute("file", fileNode.getNodeValue());
                                root.appendChild(entry);
                                break;
                            }
                            ++x;
                        }
                    }
                } else {
                    block39: {
                        String path = entryFile.getAbsolutePath();
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(String.valueOf(path) + " - " + attachmentPathRoot);
                        }
                        if (!path.startsWith(attachmentPathRoot)) {
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("move file: " + path);
                            }
                            FileChannel in = null;
                            FileChannel out = null;
                            FileInputStream fis = null;
                            FileOutputStream fos = null;
                            try {
                                try {
                                    StringBuilder msgfile = new StringBuilder().append(attachmentPathRoot).append(File.separator).append(this.getAttachmentPathSnippet(attach));
                                    File destFolder = new File(msgfile.toString());
                                    if (!destFolder.exists() && !destFolder.mkdirs()) {
                                        this.log.warning("unable to create folder: " + destFolder.getPath());
                                    }
                                    msgfile = new StringBuilder().append(attachmentPathRoot).append(File.separator).append(this.getAttachmentPathSnippet(attach)).append(File.separator).append(entryFile.getName());
                                    File destFile = new File(msgfile.toString());
                                    fis = new FileInputStream(entryFile);
                                    in = fis.getChannel();
                                    fos = new FileOutputStream(destFile);
                                    out = fos.getChannel();
                                    in.transferTo(0L, in.size(), out);
                                    entryFile = destFile;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    this.log.severe("unable to copy file " + entryFile.getAbsolutePath() + " to " + attachmentPathRoot + File.separator + this.getAttachmentPathSnippet(attach) + File.separator + entryFile.getName());
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    if (fos != null) {
                                        try {
                                            fos.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    break block39;
                                }
                            }
                            catch (Throwable throwable) {
                                if (fis != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (fos == null) throw throwable;
                                try {
                                    fos.close();
                                    throw throwable;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    Element entry = document.createElement("entry");
                    entry.setAttribute("name", attach.getEntryName(i));
                    String filePathToStore = entryFile.getAbsolutePath();
                    filePathToStore = filePathToStore.replaceFirst(attachmentPathRoot.replaceAll("\\\\", "\\\\\\\\"), attach.ATTACHMENT_FOLDER_PLACEHOLDER);
                    this.log.fine(filePathToStore);
                    entry.setAttribute("file", filePathToStore);
                    root.appendChild(entry);
                }
                ++i;
            }
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            byte[] xmlData = bos.toByteArray();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(bos.toString());
            }
            attach.setBinaryData(xmlData);
            attach.setTitle("xml");
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            attach.setBinaryData(null);
            return false;
        }
    }

    @Override
    public boolean loadLOBData(MAttachment attach, MStorageProvider prov) {
        String attachmentPathRoot = this.getAttachmentPathRoot(prov);
        if (Util.isEmpty(attachmentPathRoot)) {
            this.log.severe("no attachmentPath defined");
            return false;
        }
        attach.m_items = new ArrayList();
        byte[] data = attach.getBinaryData();
        if (data == null) {
            return true;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("TextFileSize=" + data.length);
        }
        if (data.length == 0) {
            return true;
        }
        NodeList entries = this.getEntriesFromXML(data);
        int i = 0;
        while (i < entries.getLength()) {
            File file;
            Node entryNode = entries.item(i);
            NamedNodeMap attributes = entryNode.getAttributes();
            Node fileNode = attributes.getNamedItem("file");
            Node nameNode = attributes.getNamedItem("name");
            if (fileNode == null || nameNode == null) {
                this.log.severe("no filename for entry " + i);
                attach.m_items = null;
                return false;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("name: " + nameNode.getNodeValue());
            }
            String filePath = fileNode.getNodeValue();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if (filePath != null) {
                filePath = filePath.replaceFirst(attach.ATTACHMENT_FOLDER_PLACEHOLDER, attachmentPathRoot.replaceAll("\\\\", "\\\\\\\\"));
                String replaceSeparator = File.separator;
                if (!replaceSeparator.equals("/")) {
                    replaceSeparator = "\\\\";
                }
                filePath = filePath.replaceAll("/", replaceSeparator);
                filePath = filePath.replaceAll("\\\\", replaceSeparator);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("filePath: " + filePath);
            }
            if ((file = new File(filePath)).exists()) {
                AttachmentFileLazyDataSource ds = new AttachmentFileLazyDataSource(file);
                MAttachmentEntry entry = new MAttachmentEntry(file.getName(), attach.m_items.size() + 1, ds);
                attach.m_items.add(entry);
            } else {
                this.log.severe("file not found: " + file.getAbsolutePath());
                attach.m_items.add(new MAttachmentEntry("~" + file.getName() + "~", "".getBytes(), attach.m_items.size() + 1));
            }
            ++i;
        }
        return true;
    }

    private NodeList getEntriesFromXML(byte[] data) {
        NodeList entries = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data));
            entries = document.getElementsByTagName("entry");
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            this.log.severe(x.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            this.log.severe(pce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.log.severe(ioe.getMessage());
        }
        return entries;
    }

    private String getAttachmentPathSnippet(MAttachment attach) {
        StringBuilder msgreturn = new StringBuilder().append(attach.getAD_Client_ID()).append(File.separator).append(attach.getAD_Org_ID()).append(File.separator).append(attach.getAD_Table_ID()).append(File.separator).append(attach.getRecord_ID());
        return msgreturn.toString();
    }

    @Override
    public boolean delete(MAttachment attach, MStorageProvider provider) {
        String attachmentPathRoot = this.getAttachmentPathRoot(provider);
        File folder = new File(String.valueOf(attachmentPathRoot) + this.getAttachmentPathSnippet(attach));
        while (attach.m_items.size() > 0) {
            this.deleteEntry(attach, provider, attach.m_items.size() - 1);
        }
        if (folder.exists() && !folder.delete()) {
            this.log.warning("unable to delete " + folder.getAbsolutePath());
        }
        return true;
    }

    @Override
    public boolean deleteEntry(MAttachment attach, MStorageProvider provider, int index) {
        String attachmentPathRoot = this.getAttachmentPathRoot(provider);
        File folder = new File(String.valueOf(attachmentPathRoot) + this.getAttachmentPathSnippet(attach));
        MAttachmentEntry entry = attach.m_items.get(index);
        File file = new File(folder, entry.getName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("delete: " + file.getAbsolutePath());
        }
        if (file != null && file.exists() && !file.delete()) {
            this.log.warning("unable to delete " + file.getAbsolutePath());
        }
        attach.m_items.remove(index);
        if (attach.get_ID() > 0) {
            attach.saveEx();
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Index=" + index + " - NewSize=" + attach.m_items.size());
        }
        return true;
    }

    private String getAttachmentPathRoot(MStorageProvider prov) {
        String attachmentPathRoot = prov.getFolder();
        if (attachmentPathRoot == null) {
            attachmentPathRoot = "";
        }
        if (Util.isEmpty(attachmentPathRoot)) {
            this.log.severe("no attachmentPath defined");
        } else if (!attachmentPathRoot.endsWith(File.separator)) {
            attachmentPathRoot = String.valueOf(attachmentPathRoot) + File.separator;
            this.log.fine(attachmentPathRoot);
        }
        return attachmentPathRoot;
    }
}

