/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.impexp.MImpFormat;
import org.compiere.impexp.MImpFormatRow;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class CopyImportFormat
extends SvrProcess {
    private int from_AD_ImpFormat_ID = 0;
    private int to_AD_ImpFormat_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_ImpFormat_ID")) {
                    this.from_AD_ImpFormat_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i]);
                }
            }
            ++i;
        }
        this.to_AD_ImpFormat_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MImpFormat from;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt = From=" + this.from_AD_ImpFormat_ID + " To=" + this.to_AD_ImpFormat_ID);
        }
        if ((from = new MImpFormat(this.getCtx(), this.from_AD_ImpFormat_ID, this.get_TrxName())).getAD_ImpFormat_ID() != this.from_AD_ImpFormat_ID) {
            throw new Exception("From Format not found - " + this.from_AD_ImpFormat_ID);
        }
        MImpFormat to = new MImpFormat(this.getCtx(), this.to_AD_ImpFormat_ID, this.get_TrxName());
        if (to.getAD_ImpFormat_ID() != this.to_AD_ImpFormat_ID) {
            throw new Exception("To Format not found - " + this.from_AD_ImpFormat_ID);
        }
        if (from.getAD_Table_ID() != to.getAD_Table_ID()) {
            throw new Exception("From-To do Not have same Format Table");
        }
        MImpFormatRow[] rows = from.getRows();
        int i = 0;
        while (i < rows.length) {
            MImpFormatRow row = rows[i];
            MImpFormatRow copy = new MImpFormatRow(to, row);
            if (!copy.save()) {
                throw new Exception("Copy error");
            }
            ++i;
        }
        String msg = "#" + rows.length;
        if (!from.getFormatType().equals(to.getFormatType())) {
            return String.valueOf(msg) + " - Note: Format Type different!";
        }
        return msg;
    }
}

