/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.dbPort;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Join;
import org.compiere.util.CLogger;
import org.compiere.util.Util;

public abstract class Convert_SQL92
extends Convert {
    private static final CLogger log = CLogger.getCLogger(Convert_SQL92.class);

    protected String convertOuterJoin(String sqlStatement) {
        boolean trace = false;
        int fromIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " FROM ");
        int whereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " WHERE ");
        int endWhereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " GROUP BY ");
        if (endWhereIndex == -1) {
            endWhereIndex = Util.findIndexOf(sqlStatement.toUpperCase(), " ORDER BY ");
        }
        if (endWhereIndex == -1) {
            endWhereIndex = sqlStatement.length();
        }
        if (trace && log.isLoggable(Level.INFO)) {
            log.info("OuterJoin<== " + sqlStatement);
        }
        String selectPart = sqlStatement.substring(0, fromIndex);
        String fromPart = sqlStatement.substring(fromIndex, whereIndex);
        String wherePart = sqlStatement.substring(whereIndex, endWhereIndex);
        String rest = sqlStatement.substring(endWhereIndex);
        String newWherePart = wherePart;
        ArrayList<String> joins = new ArrayList<String>();
        int pos = newWherePart.indexOf("(+)");
        while (pos != -1) {
            int start = newWherePart.lastIndexOf(" AND ", pos);
            int startOffset = 5;
            if (start == -1) {
                start = newWherePart.lastIndexOf(" OR ", pos);
                startOffset = 4;
            }
            if (start == -1) {
                start = newWherePart.lastIndexOf("WHERE ", pos);
                startOffset = 6;
            }
            if (start == -1) {
                String error = "Start point not found in clause " + wherePart;
                log.severe(error);
                this.m_conversionError = error;
                return sqlStatement;
            }
            int end = newWherePart.indexOf(" AND ", pos);
            if (end == -1) {
                end = newWherePart.indexOf(" OR ", pos);
            }
            if (end == -1) {
                end = newWherePart.length();
            }
            String condition = newWherePart.substring(start + startOffset, end);
            joins.add(condition);
            if (trace && log.isLoggable(Level.INFO)) {
                log.info("->" + condition);
            }
            newWherePart = String.valueOf(newWherePart.substring(0, start)) + newWherePart.substring(end);
            pos = newWherePart.indexOf("(+)");
        }
        if ((newWherePart = newWherePart.trim()).startsWith("AND ")) {
            newWherePart = "WHERE" + newWherePart.substring(3);
        } else if (newWherePart.startsWith("OR ")) {
            newWherePart = "WHERE" + newWherePart.substring(2);
        }
        if (trace && log.isLoggable(Level.INFO)) {
            log.info("=> " + newWherePart);
        }
        String[] fromParts = fromPart.trim().substring(4).split(",");
        HashMap<String, String> fromAlias = new HashMap<String, String>();
        HashMap<String, String> fromLookup = new HashMap<String, String>();
        int i = 0;
        while (i < fromParts.length) {
            String entry;
            String alias = entry = fromParts[i].trim();
            String table = entry;
            int aPos = entry.lastIndexOf(32);
            if (aPos != -1) {
                alias = entry.substring(aPos + 1);
                table = entry.substring(0, entry.indexOf(32));
            }
            fromAlias.put(alias, table);
            fromLookup.put(alias, table);
            if (trace && log.isLoggable(Level.INFO)) {
                log.info("Alias=" + alias + ", Table=" + table);
            }
            ++i;
        }
        StringBuilder newFrom = new StringBuilder();
        int i2 = 0;
        while (i2 < joins.size()) {
            Join third;
            int k;
            Join first = new Join((String)joins.get(i2));
            first.setMainTable((String)fromLookup.get(first.getMainAlias()));
            fromAlias.remove(first.getMainAlias());
            first.setJoinTable((String)fromLookup.get(first.getJoinAlias()));
            fromAlias.remove(first.getJoinAlias());
            if (trace && log.isLoggable(Level.INFO)) {
                log.info("-First: " + first);
            }
            if (newFrom.length() == 0) {
                newFrom.append(" FROM ");
            } else {
                newFrom.append(", ");
            }
            newFrom.append(first.getMainTable()).append(" ").append(first.getMainAlias()).append(first.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(first.getJoinTable()).append(" ").append(first.getJoinAlias()).append(" ON (").append(first.getCondition());
            int j = i2 + 1;
            while (j < joins.size()) {
                Join second = new Join((String)joins.get(j));
                second.setMainTable((String)fromLookup.get(second.getMainAlias()));
                second.setJoinTable((String)fromLookup.get(second.getJoinAlias()));
                if (first.getMainTable().equals(second.getMainTable()) && first.getJoinTable().equals(second.getJoinTable()) || second.isConditionOf(first)) {
                    if (trace && log.isLoggable(Level.INFO)) {
                        log.info("-Second/key: " + second);
                    }
                    newFrom.append(" AND ").append(second.getCondition());
                    joins.remove(j);
                    fromAlias.remove(first.getJoinAlias());
                    k = i2 + 1;
                    while (k < joins.size()) {
                        third = new Join((String)joins.get(k));
                        third.setMainTable((String)fromLookup.get(third.getMainAlias()));
                        third.setJoinTable((String)fromLookup.get(third.getJoinAlias()));
                        if (third.isConditionOf(second)) {
                            if (trace && log.isLoggable(Level.INFO)) {
                                log.info("-Third/key: " + third);
                            }
                            newFrom.append(" AND ").append(third.getCondition());
                            joins.remove(k);
                            fromAlias.remove(third.getJoinAlias());
                        } else if (trace && log.isLoggable(Level.INFO)) {
                            log.info("-Third/key-skip: " + third);
                        }
                        ++k;
                    }
                } else if (trace && log.isLoggable(Level.INFO)) {
                    log.info("-Second/key-skip: " + second);
                }
                ++j;
            }
            newFrom.append(")");
            j = i2 + 1;
            while (j < joins.size()) {
                Join second = new Join((String)joins.get(j));
                second.setMainTable((String)fromLookup.get(second.getMainAlias()));
                second.setJoinTable((String)fromLookup.get(second.getJoinAlias()));
                if (first.getMainTable().equals(second.getMainTable())) {
                    if (trace && log.isLoggable(Level.INFO)) {
                        log.info("-Second/dep: " + second);
                    }
                    newFrom.insert(6, '(');
                    newFrom.append(')');
                    newFrom.append(second.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(second.getJoinTable()).append(" ").append(second.getJoinAlias()).append(" ON (").append(second.getCondition());
                    joins.remove(j);
                    fromAlias.remove(second.getJoinAlias());
                    newFrom.append(")");
                    k = i2 + 1;
                    while (k < joins.size()) {
                        third = new Join((String)joins.get(k));
                        third.setMainTable((String)fromLookup.get(third.getMainAlias()));
                        third.setJoinTable((String)fromLookup.get(third.getJoinAlias()));
                        if (second.getJoinTable().equals(third.getMainTable())) {
                            if (trace && log.isLoggable(Level.INFO)) {
                                log.info("-Third-dep: " + third);
                            }
                            newFrom.insert(6, '(');
                            newFrom.append(')');
                            newFrom.append(third.isLeft() ? " LEFT" : " RIGHT").append(" OUTER JOIN ").append(third.getJoinTable()).append(" ").append(third.getJoinAlias()).append(" ON (").append(third.getCondition());
                            joins.remove(k);
                            fromAlias.remove(third.getJoinAlias());
                            newFrom.append(")");
                        } else if (trace && log.isLoggable(Level.INFO)) {
                            log.info("-Third-skip: " + third);
                        }
                        ++k;
                    }
                } else if (trace && log.isLoggable(Level.INFO)) {
                    log.info("-Second/dep-skip: " + second);
                }
                ++j;
            }
            ++i2;
        }
        for (String alias : fromAlias.keySet()) {
            Object table = fromAlias.get(alias);
            newFrom.append(", ").append(table);
            if (table.equals(alias)) continue;
            newFrom.append(" ").append((Object)alias);
        }
        if (trace && log.isLoggable(Level.INFO)) {
            log.info(newFrom.toString());
        }
        StringBuilder retValue = new StringBuilder(sqlStatement.length() + 20);
        retValue.append(selectPart).append((CharSequence)newFrom).append(" ").append(newWherePart).append(rest);
        if (trace && log.isLoggable(Level.INFO)) {
            log.info("OuterJoin==> " + retValue.toString());
        }
        return retValue.toString();
    }

    protected String convertDecode(String sqlStatement, int fromIndex) {
        String statement = sqlStatement;
        StringBuilder sb = new StringBuilder("CASE");
        int index = statement.toUpperCase().indexOf("DECODE", fromIndex);
        if (index <= 0) {
            return sqlStatement;
        }
        char previousChar = statement.charAt(index - 1);
        if (!Character.isWhitespace(previousChar) && !this.isOperator(previousChar)) {
            return sqlStatement;
        }
        String firstPart = statement.substring(0, index);
        index += 6;
        while (index < statement.length()) {
            char c = statement.charAt(index);
            if (Character.isWhitespace(c)) {
                ++index;
                continue;
            }
            if (c == '(') break;
            return sqlStatement;
        }
        statement = statement.substring(index + 1);
        index = Util.findIndexOf(statement, ',');
        String expression = statement.substring(0, index).trim();
        statement = statement.substring(index + 1);
        index = Util.findIndexOf(statement, ',');
        while (index != -1) {
            String first = statement.substring(0, index);
            char cc = statement.charAt(index);
            statement = statement.substring(index + 1);
            boolean error = false;
            if (cc == ',') {
                index = Util.findIndexOf(statement, ',', ')');
                if (index == -1) {
                    error = true;
                } else {
                    String second = statement.substring(0, index);
                    sb.append(" WHEN ").append(expression).append("=").append(first.trim()).append(" THEN ").append(second.trim());
                    statement = statement.substring(index + 1);
                    index = Util.findIndexOf(statement, ',', ')');
                }
            } else if (cc == ')') {
                sb.append(" ELSE ").append(first.trim()).append(" END");
                index = -1;
            } else {
                error = true;
            }
            if (!error) continue;
            log.log(Level.SEVERE, "SQL=(" + sqlStatement + ")\n====Result=(" + sb.toString() + ")\n====Statement=(" + statement + ")\n====First=(" + first + ")\n====Index=" + index);
            this.m_conversionError = "Decode conversion error";
        }
        sb.append(statement);
        sb.insert(0, firstPart);
        return sb.toString();
    }

    protected String convertDelete(String sqlStatement) {
        int index = sqlStatement.toUpperCase().indexOf("DELETE ");
        if (index < 7) {
            return "DELETE FROM " + sqlStatement.substring(index + 7);
        }
        return sqlStatement;
    }

    protected boolean isOperator(char c) {
        if ('=' == c) {
            return true;
        }
        if ('<' == c) {
            return true;
        }
        if ('>' == c) {
            return true;
        }
        if ('|' == c) {
            return true;
        }
        if ('(' == c) {
            return true;
        }
        if (')' == c) {
            return true;
        }
        if ('+' == c) {
            return true;
        }
        if ('-' == c) {
            return true;
        }
        if ('*' == c) {
            return true;
        }
        if ('/' == c) {
            return true;
        }
        if ('!' == c) {
            return true;
        }
        if (',' == c) {
            return true;
        }
        if ('?' == c) {
            return true;
        }
        if ('#' == c) {
            return true;
        }
        if ('@' == c) {
            return true;
        }
        if ('~' == c) {
            return true;
        }
        if ('&' == c) {
            return true;
        }
        if ('^' == c) {
            return true;
        }
        return '!' == c;
    }
}

