/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.DBException;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CLogger;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.DBReadReplica;

public class ReadReplicaPreparedStatementProxy
implements InvocationHandler {
    private boolean close = false;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected transient PreparedStatement p_stmt = null;
    protected CStatementVO p_vo = null;

    public ReadReplicaPreparedStatementProxy(int resultSetType, int resultSetConcurrency, String sql) {
        if (sql == null || sql.length() == 0) {
            throw new IllegalArgumentException("sql required");
        }
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency, DB.getDatabase().convertStatement(sql));
        this.init();
    }

    private void init() {
        try {
            Connection conn = DBReadReplica.getConnectionRO();
            if (conn != null) {
                this.p_stmt = conn.prepareStatement(this.p_vo.getSql(), this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.p_vo.getSql(), e);
            throw new DBException(e);
        }
    }

    private RowSet getRowSet() {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("local_getRowSet");
        }
        RowSet rowSet = null;
        ResultSet rs = null;
        try {
            try {
                rs = this.p_stmt.executeQuery();
                rowSet = CCachedRowSet.getRowSet(rs);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            throw throwable;
        }
        DB.close(rs);
        return rowSet;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if (name.equals("executeQuery") || name.equals("executeUpdate") || name.equals("execute") || name.equals("addBatch")) {
            if (args != null && args.length > 0 && args[0] != null && args[0] instanceof String) {
                String sql = (String)args[0];
                this.p_vo.setSql(DB.getDatabase().convertStatement(sql));
                args[0] = this.p_vo.getSql();
            }
        } else {
            if (name.equals("close") && (args == null || args.length == 0)) {
                this.close();
                return null;
            }
            if (name.equals("getRowSet") && (args == null || args.length == 0)) {
                return this.getRowSet();
            }
            if (name.equals("isClosed") && (args == null || args.length == 0)) {
                return this.close;
            }
            if (name.equals("finalize") && (args == null || args.length == 0)) {
                if (this.p_stmt != null && !this.close) {
                    this.close();
                }
                return null;
            }
            if (name.equals("getSql") && (args == null || args.length == 0)) {
                return this.getSql();
            }
            if (name.equals("equals") && args != null && args.length == 1) {
                return this.equals(args[0]);
            }
        }
        Method m = PreparedStatement.class.getMethod(name, method.getParameterTypes());
        try {
            return m.invoke((Object)this.p_stmt, args);
        }
        catch (InvocationTargetException e) {
            throw DB.getSQLException(e);
        }
    }

    private void close() throws SQLException {
        if (this.close) {
            return;
        }
        if (this.p_stmt != null) {
            try {
                try {
                    this.p_stmt.close();
                }
                catch (SQLException sQLException) {
                    try {
                        try {
                            DBReadReplica.closeReadReplicaStatement(this.p_stmt);
                        }
                        catch (Exception exception) {
                            this.p_stmt = null;
                            this.close = true;
                        }
                    }
                    finally {
                        this.p_stmt = null;
                        this.close = true;
                    }
                }
            }
            finally {
                block22: {
                    try {
                        try {
                            DBReadReplica.closeReadReplicaStatement(this.p_stmt);
                        }
                        catch (Exception exception) {
                            this.p_stmt = null;
                            this.close = true;
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        this.p_stmt = null;
                        this.close = true;
                        throw throwable;
                    }
                    this.p_stmt = null;
                    this.close = true;
                }
            }
        } else {
            this.close = true;
        }
    }

    public String getSql() {
        if (this.p_vo != null) {
            return this.p_vo.getSql();
        }
        return null;
    }

    public boolean isValid() {
        return this.p_stmt != null;
    }
}

