/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.sql.RowSet;
import org.adempiere.exceptions.DBException;
import org.compiere.db.StatementProxy;
import org.compiere.util.CCachedRowSet;
import org.compiere.util.CStatementVO;
import org.compiere.util.DB;
import org.compiere.util.Trx;
import org.idempiere.db.util.AutoCommitConnectionBroker;

public class PreparedStatementProxy
extends StatementProxy {
    public PreparedStatementProxy(int resultSetType, int resultSetConcurrency, String sql0, String trxName) {
        if (sql0 == null || sql0.length() == 0) {
            throw new IllegalArgumentException("sql required");
        }
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency, DB.getDatabase().convertStatement(sql0));
        this.p_vo.setTrxName(trxName);
        this.init();
    }

    public PreparedStatementProxy(int resultSetType, int resultSetConcurrency, String sql0, Connection connection) {
        if (sql0 == null || sql0.length() == 0) {
            throw new IllegalArgumentException("sql required");
        }
        this.p_vo = new CStatementVO(resultSetType, resultSetConcurrency, DB.getDatabase().convertStatement(sql0));
        this.init(connection);
    }

    public PreparedStatementProxy(CStatementVO vo) {
        super(vo);
    }

    @Override
    protected void init() {
        try {
            Connection conn = null;
            Trx trx = this.p_vo.getTrxName() == null ? null : Trx.get(this.p_vo.getTrxName(), false);
            conn = trx != null ? trx.getConnection() : (this.m_conn = AutoCommitConnectionBroker.getConnection());
            if (conn == null) {
                throw new DBException("No Connection");
            }
            this.p_stmt = conn.prepareStatement(this.p_vo.getSql(), this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.p_vo.getSql(), e);
            throw new DBException(e);
        }
    }

    protected void init(Connection connection) {
        try {
            this.p_stmt = connection.prepareStatement(this.p_vo.getSql(), this.p_vo.getResultSetType(), this.p_vo.getResultSetConcurrency());
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.p_vo.getSql(), e);
            throw new DBException(e);
        }
    }

    @Override
    protected RowSet getRowSet() {
        this.log.finest("local_getRowSet");
        RowSet rowSet = null;
        ResultSet rs = null;
        PreparedStatement pstmt = (PreparedStatement)this.p_stmt;
        try {
            try {
                rs = pstmt.executeQuery();
                rowSet = CCachedRowSet.getRowSet(rs);
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, this.p_vo.toString(), ex);
                throw new RuntimeException(ex);
            }
        }
        finally {
            DB.close(rs);
        }
        return rowSet;
    }
}

