/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MProductionLineMA;
import org.compiere.model.ProductCost;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Production
extends Doc {
    private Map<Integer, BigDecimal> mQtyProduced;

    public Doc_Production(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, X_M_Production.class, rs, "MMP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        X_M_Production prod = (X_M_Production)this.getPO();
        this.setDateDoc(prod.getMovementDate());
        this.setDateAcct(prod.getMovementDate());
        this.p_lines = this.loadLines(prod);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private BigDecimal manipulateQtyProduced(Map<Integer, BigDecimal> mQtyProduced, X_M_ProductionLine line, Boolean isUsePlan, BigDecimal addMoreQty) {
        BigDecimal qtyProduced = null;
        Integer key = isUsePlan != false ? line.getM_ProductionPlan_ID() : line.getM_Production_ID();
        if (mQtyProduced.containsKey(key)) {
            qtyProduced = mQtyProduced.get(key);
        } else {
            qtyProduced = BigDecimal.ZERO;
            mQtyProduced.put(key, qtyProduced);
        }
        if (addMoreQty != null) {
            qtyProduced = qtyProduced.add(addMoreQty);
            mQtyProduced.put(key, qtyProduced);
        }
        return qtyProduced;
    }

    private DocLine[] loadLines(X_M_Production prod) {
        ArrayList<DocLine> list;
        block11: {
            list = new ArrayList<DocLine>();
            this.mQtyProduced = new HashMap<Integer, BigDecimal>();
            String sqlPL = null;
            sqlPL = prod.isUseProductionPlan() ? "SELECT * FROM  M_ProductionLine pro_line INNER JOIN M_ProductionPlan plan ON pro_line.M_ProductionPlan_id = plan.M_ProductionPlan_id  INNER JOIN M_Production pro ON pro.M_Production_id = plan.M_Production_id  WHERE pro.M_Production_ID=?  ORDER BY plan.M_ProductionPlan_id, pro_line.Line" : "SELECT * FROM M_ProductionLine pl WHERE pl.M_Production_ID=? ORDER BY pl.Line";
            CPreparedStatement pstmtPL = null;
            ResultSet rsPL = null;
            try {
                try {
                    pstmtPL = DB.prepareStatement(sqlPL, this.getTrxName());
                    pstmtPL.setInt(1, this.get_ID());
                    rsPL = pstmtPL.executeQuery();
                    while (rsPL.next()) {
                        X_M_ProductionLine line = new X_M_ProductionLine(this.getCtx(), rsPL, this.getTrxName());
                        if (line.getMovementQty().signum() == 0) {
                            if (!this.log.isLoggable(Level.INFO)) continue;
                            this.log.info("LineQty=0 - " + line);
                            continue;
                        }
                        DocLine docLine = new DocLine(line, this);
                        docLine.setQty(line.getMovementQty(), false);
                        if (prod.isUseProductionPlan()) {
                            docLine.setProductionBOM(line.getM_Product_ID() == line.getM_ProductionPlan().getM_Product_ID());
                        } else {
                            docLine.setProductionBOM(line.getM_Product_ID() == prod.getM_Product_ID());
                        }
                        if (docLine.isProductionBOM()) {
                            this.manipulateQtyProduced(this.mQtyProduced, line, prod.isUseProductionPlan(), line.getMovementQty());
                        }
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine(docLine.toString());
                        }
                        list.add(docLine);
                    }
                }
                catch (Exception ee) {
                    this.log.log(Level.SEVERE, sqlPL, ee);
                    DB.close(rsPL, pstmtPL);
                    rsPL = null;
                    pstmtPL = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rsPL, pstmtPL);
                rsPL = null;
                pstmtPL = null;
                throw throwable;
            }
            DB.close(rsPL, pstmtPL);
            rsPL = null;
            pstmtPL = null;
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine fl = null;
        X_M_Production prod = (X_M_Production)this.getPO();
        HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>();
        int i = 0;
        while (i < this.p_lines.length) {
            String description;
            DocLine line = this.p_lines[i];
            BigDecimal costs = BigDecimal.ZERO;
            X_M_ProductionLine prodline = (X_M_ProductionLine)line.getPO();
            MProductionLineMA[] mas = MProductionLineMA.get(this.getCtx(), prodline.get_ID(), this.getTrxName());
            MProduct product = (MProduct)prodline.getM_Product();
            String CostingLevel = product.getCostingLevel(as);
            String costingMethod = product.getCostingMethod(as);
            if ("B".equals(CostingLevel)) {
                if (line.getM_AttributeSetInstance_ID() == 0 && mas != null && mas.length > 0) {
                    int j = 0;
                    while (j < mas.length) {
                        MProductionLineMA ma = mas[j];
                        MCostDetail cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line.get_ID(), ma.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                        if (cd != null) {
                            costs = costs.add(cd.getAmt());
                        } else {
                            ProductCost pc = line.getProductCost();
                            pc.setQty(ma.getMovementQty());
                            pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                            costs = costs.add(line.getProductCosts(as, line.getAD_Org_ID(), false));
                        }
                        costMap.put(String.valueOf(line.get_ID()) + "_" + ma.getM_AttributeSetInstance_ID(), costs);
                        ++j;
                    }
                } else {
                    MCostDetail cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line.get_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                    costs = cd != null ? cd.getAmt() : line.getProductCosts(as, line.getAD_Org_ID(), false);
                    costMap.put(String.valueOf(line.get_ID()) + "_" + line.getM_AttributeSetInstance_ID(), costs);
                }
            } else {
                MCostDetail cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line.get_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                costs = cd != null ? cd.getAmt() : line.getProductCosts(as, line.getAD_Org_ID(), false);
                costMap.put(String.valueOf(line.get_ID()) + "_" + line.getM_AttributeSetInstance_ID(), costs);
            }
            int stdPrecision = as.getStdPrecision();
            BigDecimal bomCost = Env.ZERO;
            BigDecimal qtyProduced = null;
            if (line.isProductionBOM()) {
                BigDecimal variance;
                X_M_ProductionLine endProLine = (X_M_ProductionLine)line.getPO();
                int parentEndPro = prod.isUseProductionPlan() ? endProLine.getM_ProductionPlan_ID() : endProLine.getM_Production_ID();
                int ii = 0;
                while (ii < this.p_lines.length) {
                    int parentBomPro;
                    DocLine line0 = this.p_lines[ii];
                    X_M_ProductionLine bomProLine = (X_M_ProductionLine)line0.getPO();
                    int n = parentBomPro = prod.isUseProductionPlan() ? bomProLine.getM_ProductionPlan_ID() : bomProLine.getM_Production_ID();
                    if (parentBomPro == parentEndPro && !line0.isProductionBOM()) {
                        MCostDetail cd0;
                        BigDecimal costs0;
                        MProduct product0 = (MProduct)bomProLine.getM_Product();
                        String CostingLevel0 = product0.getCostingLevel(as);
                        if ("B".equals(CostingLevel0)) {
                            if (bomProLine.getM_AttributeSetInstance_ID() == 0) {
                                MProductionLineMA[] bomLineMA = MProductionLineMA.get(this.getCtx(), line0.get_ID(), this.getTrxName());
                                if (bomLineMA != null && bomLineMA.length > 0) {
                                    costs0 = BigDecimal.ZERO;
                                    int j = 0;
                                    while (j < bomLineMA.length) {
                                        BigDecimal maCost = BigDecimal.ZERO;
                                        MProductionLineMA ma = bomLineMA[j];
                                        MCostDetail cd02 = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line0.get_ID(), ma.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                                        if (cd02 != null) {
                                            maCost = cd02.getAmt();
                                        } else {
                                            ProductCost pc = line0.getProductCost();
                                            pc.setQty(ma.getMovementQty());
                                            pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                            maCost = line0.getProductCosts(as, line0.getAD_Org_ID(), false);
                                        }
                                        costMap.put(String.valueOf(line0.get_ID()) + "_" + ma.getM_AttributeSetInstance_ID(), maCost);
                                        costs0 = costs0.add(maCost);
                                        ++j;
                                    }
                                    bomCost = bomCost.add(costs0);
                                } else {
                                    this.p_Error = "Failed to post - No Attribute Set for line";
                                }
                            } else {
                                cd0 = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line0.get_ID(), line0.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                                costs0 = cd0 != null ? cd0.getAmt() : line0.getProductCosts(as, line0.getAD_Org_ID(), false);
                                costMap.put(String.valueOf(line0.get_ID()) + "_" + line0.getM_AttributeSetInstance_ID(), costs0);
                                bomCost = bomCost.add(costs0);
                            }
                        } else {
                            cd0 = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line0.get_ID(), line0.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
                            costs0 = cd0 != null ? cd0.getAmt() : line0.getProductCosts(as, line0.getAD_Org_ID(), false);
                            costMap.put(String.valueOf(line0.get_ID()) + "_" + line0.getM_AttributeSetInstance_ID(), costs0);
                            bomCost = bomCost.add(costs0);
                        }
                    }
                    ++ii;
                }
                qtyProduced = this.manipulateQtyProduced(this.mQtyProduced, endProLine, prod.isUseProductionPlan(), null);
                if (line.getQty().compareTo(qtyProduced) != 0) {
                    BigDecimal factor = line.getQty().divide(qtyProduced, 12, RoundingMode.HALF_UP);
                    bomCost = bomCost.multiply(factor);
                }
                if ("B".equals(CostingLevel)) {
                    fl = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), bomCost.negate().setScale(stdPrecision, RoundingMode.HALF_UP));
                    if (fl == null) {
                        this.p_Error = "Couldn't post roll-up " + line.getLine() + " - " + line;
                        return null;
                    }
                    fl.setQty(qtyProduced);
                } else if ("S".equals(costingMethod) && (variance = costs.subtract(bomCost.negate()).setScale(stdPrecision, RoundingMode.HALF_UP)).signum() != 0) {
                    fl = fact.createLine(line, line.getAccount(14, as), as.getC_Currency_ID(), variance.negate());
                    if (fl == null) {
                        this.p_Error = "Couldn't post variance " + line.getLine() + " - " + line;
                        return null;
                    }
                    fl.setQty(Env.ZERO);
                }
            }
            if (!line.isProductionBOM() || !"B".equals(CostingLevel)) {
                BigDecimal factLineAmt = costs;
                if (line.isProductionBOM() && !"S".equals(costingMethod)) {
                    factLineAmt = bomCost.negate();
                }
                if ((fl = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), factLineAmt.setScale(stdPrecision, RoundingMode.HALF_UP))) == null) {
                    this.p_Error = "No Costs for Line " + line.getLine() + " - " + line;
                    return null;
                }
                fl.setM_Locator_ID(line.getM_Locator_ID());
                fl.setQty(line.getQty());
            }
            if ((description = line.getDescription()) == null) {
                description = "";
            }
            if (line.isProductionBOM()) {
                description = String.valueOf(description) + "(*)";
            }
            if ("B".equals(CostingLevel)) {
                if (line.isProductionBOM()) {
                    if (!MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, bomCost.negate(), qtyProduced, description, this.getTrxName())) {
                        this.p_Error = "Failed to create cost detail record";
                        return null;
                    }
                } else if (line.getM_AttributeSetInstance_ID() == 0 && mas != null && mas.length > 0) {
                    int j = 0;
                    while (j < mas.length) {
                        MProductionLineMA ma = mas[j];
                        BigDecimal maCost = (BigDecimal)costMap.get(String.valueOf(line.get_ID()) + "_" + ma.getM_AttributeSetInstance_ID());
                        if (!MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, maCost, ma.getMovementQty(), description, this.getTrxName())) {
                            this.p_Error = "Failed to create cost detail record";
                            return null;
                        }
                        ++j;
                    }
                } else if (!MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), description, this.getTrxName())) {
                    this.p_Error = "Failed to create cost detail record";
                    return null;
                }
            } else if (line.isProductionBOM() && !"S".equals(costingMethod)) {
                if (!MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, bomCost.negate(), line.getQty(), description, this.getTrxName())) {
                    this.p_Error = "Failed to create cost detail record";
                    return null;
                }
            } else if (!MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), description, this.getTrxName())) {
                this.p_Error = "Failed to create cost detail record";
                return null;
            }
            ++i;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

