/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.adempiere.exceptions.AverageCostingZeroQtyException;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MTax;
import org.compiere.model.ProductCost;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class Doc_Invoice
extends Doc {
    protected DocTax[] m_taxes = null;
    private DocTax[] m_addToLineTaxes = null;
    protected int m_precision = -1;
    protected boolean m_allLinesService = true;
    protected boolean m_allLinesItem = true;

    public Doc_Invoice(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MInvoice.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MInvoice invoice = (MInvoice)this.getPO();
        this.setDateDoc(invoice.getDateInvoiced());
        this.setIsTaxIncluded(invoice.isTaxIncluded());
        this.setAmount(0, invoice.getGrandTotal());
        this.setAmount(1, invoice.getTotalLines());
        this.setAmount(2, invoice.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(invoice);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length + ", Taxes=" + this.m_taxes.length);
        }
        return null;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        ArrayList<DocTax> distributeList = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_InvoiceTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "Y".equals(rs.getString(6));
                    MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
                    DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(taxLine.toString());
                    }
                    if (!tax.isDistributeTaxWithLineItem()) {
                        list.add(taxLine);
                        continue;
                    }
                    distributeList.add(taxLine);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        this.m_addToLineTaxes = distributeList.toArray(new DocTax[0]);
        return tl;
    }

    private DocLine[] loadLines(MInvoice invoice) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInvoiceLine[] lines = invoice.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInvoiceLine line = lines[i];
            if (!line.isDescription()) {
                int n;
                DocLine docLine = new DocLine(line, this);
                BigDecimal Qty = line.getQtyInvoiced();
                boolean cm = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
                docLine.setQty(cm ? Qty.negate() : Qty, invoice.isSOTrx());
                BigDecimal LineNetAmt = line.getLineNetAmt();
                BigDecimal PriceList = line.getPriceList();
                int C_Tax_ID = docLine.getC_Tax_ID();
                if (this.isTaxIncluded() && C_Tax_ID != 0) {
                    MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
                    if (!tax.isZeroTax()) {
                        BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision());
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                        }
                        if (tax.isSummary()) {
                            BigDecimal base = LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                            BigDecimal sumChildLineNetAmtTax = Env.ZERO;
                            DocTax taxToApplyDiff = null;
                            MTax[] mTaxArray = tax.getChildTaxes(false);
                            int n2 = mTaxArray.length;
                            n = 0;
                            while (n < n2) {
                                MTax childTax = mTaxArray[n];
                                if (!childTax.isZeroTax()) {
                                    BigDecimal childLineNetAmtTax = childTax.calculateTax(base, false, this.getStdPrecision());
                                    if (this.log.isLoggable(Level.FINE)) {
                                        this.log.fine("LineNetAmt=" + base + " - Child Tax=" + childLineNetAmtTax);
                                    }
                                    if (childTax.isDistributeTaxWithLineItem()) {
                                        LineNetAmt = LineNetAmt.add(childLineNetAmtTax);
                                        LineNetAmtTax = LineNetAmtTax.subtract(childLineNetAmtTax);
                                    } else {
                                        int t = 0;
                                        while (t < this.m_taxes.length) {
                                            if (this.m_taxes[t].getC_Tax_ID() == childTax.getC_Tax_ID()) {
                                                this.m_taxes[t].addIncludedTax(childLineNetAmtTax);
                                                taxToApplyDiff = this.m_taxes[t];
                                                sumChildLineNetAmtTax = sumChildLineNetAmtTax.add(childLineNetAmtTax);
                                                break;
                                            }
                                            ++t;
                                        }
                                    }
                                }
                                ++n;
                            }
                            BigDecimal diffChildVsSummary = LineNetAmtTax.subtract(sumChildLineNetAmtTax);
                            if (diffChildVsSummary.signum() != 0 && taxToApplyDiff != null) {
                                taxToApplyDiff.addIncludedTax(diffChildVsSummary);
                            }
                        } else if (!tax.isDistributeTaxWithLineItem()) {
                            LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                            int t = 0;
                            while (t < this.m_taxes.length) {
                                if (this.m_taxes[t].getC_Tax_ID() == C_Tax_ID) {
                                    this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                                    break;
                                }
                                ++t;
                            }
                        }
                        BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision());
                        PriceList = PriceList.subtract(PriceListTax);
                    }
                } else {
                    int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), invoice.getC_Currency_ID());
                    MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
                    if (tax.isSummary()) {
                        MTax[] cTaxes = tax.getChildTaxes(false);
                        BigDecimal base = LineNetAmt;
                        MTax[] mTaxArray = cTaxes;
                        n = cTaxes.length;
                        int n3 = 0;
                        while (n3 < n) {
                            MTax cTax = mTaxArray[n3];
                            if (cTax.isDistributeTaxWithLineItem()) {
                                BigDecimal taxAmt = cTax.calculateTax(base, false, stdPrecision);
                                LineNetAmt = LineNetAmt.add(taxAmt);
                            }
                            ++n3;
                        }
                    } else if (tax.isDistributeTaxWithLineItem()) {
                        BigDecimal taxAmt = tax.calculateTax(LineNetAmt, false, stdPrecision);
                        LineNetAmt = LineNetAmt.add(taxAmt);
                    }
                }
                docLine.setAmount(LineNetAmt, PriceList, Qty);
                if (docLine.isItem()) {
                    this.m_allLinesService = false;
                } else {
                    this.m_allLinesItem = false;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(docLine.toString());
                }
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        if (this.isTaxIncluded()) {
            int i2 = 0;
            while (i2 < this.m_taxes.length) {
                if (this.m_taxes[i2].isIncludedTaxDifference()) {
                    BigDecimal diff = this.m_taxes[i2].getIncludedTaxDifference();
                    int j = 0;
                    while (j < dls.length) {
                        MTax lineTax = MTax.get(this.getCtx(), dls[j].getC_Tax_ID());
                        MTax[] composingTaxes = null;
                        composingTaxes = lineTax.isSummary() ? lineTax.getChildTaxes(false) : new MTax[]{lineTax};
                        MTax[] mTaxArray = composingTaxes;
                        int n = composingTaxes.length;
                        int n4 = 0;
                        while (n4 < n) {
                            MTax mTax = mTaxArray[n4];
                            if (mTax.getC_Tax_ID() == this.m_taxes[i2].getC_Tax_ID()) {
                                dls[j].setLineNetAmtDifference(diff);
                                this.m_taxes[i2].addIncludedTax(diff.negate());
                                diff = Env.ZERO;
                                break;
                            }
                            ++n4;
                        }
                        if (diff.signum() == 0) break;
                        ++j;
                    }
                }
                ++i2;
            }
        }
        return dls;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        int i = 0;
        while (i < this.m_taxes.length) {
            retValue = retValue.subtract(this.m_taxes[i].getAmount());
            sb.append("-").append(this.m_taxes[i].getAmount());
            ++i;
        }
        i = 0;
        while (i < this.p_lines.length) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
            ++i;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        }
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        if (!as.isAccrual()) {
            return facts;
        }
        if (this.getDocumentType().equals("ARI") || this.getDocumentType().equals("ARF")) {
            int receivables_ID;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, amt);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, amt)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), dAmt, null);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), null, amt);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            int receivablesServices_ID = receivables_ID = this.getValidCombination_ID(1, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            FactLine[] fLines = fact.getLines();
            int i2 = 0;
            while (i2 < fLines.length) {
                if (fLines[i2] != null) {
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i2;
            }
        } else if (this.getDocumentType().equals("ARC")) {
            int receivables_ID;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            BigDecimal amt = this.getAmount(2);
            if (amt != null && amt.signum() != 0) {
                fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), amt, null);
            }
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl;
                amt = this.m_taxes[i].getAmount();
                if (amt != null && amt.signum() != 0 && (tl = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt, null)) != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                BigDecimal discount;
                amt = this.p_lines[i].getAmtSource();
                BigDecimal dAmt = null;
                if (as.isTradeDiscountPosted() && (discount = this.p_lines[i].getDiscount()) != null && discount.signum() != 0) {
                    amt = amt.add(discount);
                    dAmt = discount;
                    fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(8, as), this.getC_Currency_ID(), null, dAmt);
                }
                fact.createLine(this.p_lines[i], this.p_lines[i].getAccount(1, as), this.getC_Currency_ID(), amt, null);
                if (!this.p_lines[i].isItem()) {
                    grossAmt = grossAmt.subtract(amt);
                    serviceAmt = serviceAmt.add(amt);
                }
                ++i;
            }
            int receivablesServices_ID = receivables_ID = this.getValidCombination_ID(1, as);
            if (this.m_allLinesItem || !as.isPostServices() || receivables_ID == receivablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), receivablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            FactLine[] fLines = fact.getLines();
            int i3 = 0;
            while (i3 < fLines.length) {
                if (fLines[i3] != null) {
                    fLines[i3].setLocationFromOrg(fLines[i3].getAD_Org_ID(), true);
                    fLines[i3].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
                ++i3;
            }
        } else if (this.getDocumentType().equals("API")) {
            int payables_ID;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), this.getAmount(2), null);
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), this.m_taxes[i].getAmount(), null);
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, true);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), null, dAmt);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), amt, null);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            int payablesServices_ID = payables_ID = this.getValidCombination_ID(2, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), null, grossAmt);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), null, serviceAmt);
            }
            FactLine[] fLines = fact.getLines();
            int i4 = 0;
            while (i4 < fLines.length) {
                if (fLines[i4] != null) {
                    fLines[i4].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i4].setLocationFromOrg(fLines[i4].getAD_Org_ID(), false);
                }
                ++i4;
            }
            this.updateProductPO(as);
        } else if (this.getDocumentType().equals("APC")) {
            int payables_ID;
            BigDecimal grossAmt = this.getAmount(0);
            BigDecimal serviceAmt = Env.ZERO;
            fact.createLine(null, this.getAccount(0, as), this.getC_Currency_ID(), null, this.getAmount(2));
            int i = 0;
            while (i < this.m_taxes.length) {
                FactLine tl = fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), null, this.m_taxes[i].getAmount());
                if (tl != null) {
                    tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
                }
                ++i;
            }
            i = 0;
            while (i < this.p_lines.length) {
                DocLine line = this.p_lines[i];
                boolean landedCost = this.landedCost(as, fact, line, false);
                if (landedCost && as.isExplicitCostAdjustment()) {
                    fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                    FactLine fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                    String desc = line.getDescription();
                    desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                    fl.setDescription(desc);
                }
                if (!landedCost) {
                    BigDecimal discount;
                    MAccount expense = line.getAccount(2, as);
                    if (line.isItem()) {
                        expense = line.getAccount(10, as);
                    }
                    BigDecimal amt = line.getAmtSource();
                    BigDecimal dAmt = null;
                    if (as.isTradeDiscountPosted() && !line.isItem() && (discount = line.getDiscount()) != null && discount.signum() != 0) {
                        amt = amt.add(discount);
                        dAmt = discount;
                        MAccount tradeDiscountReceived = line.getAccount(7, as);
                        fact.createLine(line, tradeDiscountReceived, this.getC_Currency_ID(), dAmt, null);
                    }
                    fact.createLine(line, expense, this.getC_Currency_ID(), null, amt);
                    if (!line.isItem()) {
                        grossAmt = grossAmt.subtract(amt);
                        serviceAmt = serviceAmt.add(amt);
                    }
                    if (line.getM_Product_ID() != 0 && line.getProduct().isService()) {
                        MCostDetail.createInvoice(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, line.getAmtSource().negate(), line.getQty(), line.getDescription(), this.getTrxName());
                    }
                }
                ++i;
            }
            int payablesServices_ID = payables_ID = this.getValidCombination_ID(2, as);
            if (this.m_allLinesItem || !as.isPostServices() || payables_ID == payablesServices_ID) {
                grossAmt = this.getAmount(0);
                serviceAmt = Env.ZERO;
            } else if (this.m_allLinesService) {
                serviceAmt = this.getAmount(0);
                grossAmt = Env.ZERO;
            }
            if (grossAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payables_ID), this.getC_Currency_ID(), grossAmt, null);
            }
            if (serviceAmt.signum() != 0) {
                fact.createLine(null, MAccount.get(this.getCtx(), payablesServices_ID), this.getC_Currency_ID(), serviceAmt, null);
            }
            FactLine[] fLines = fact.getLines();
            int i5 = 0;
            while (i5 < fLines.length) {
                if (fLines[i5] != null) {
                    fLines[i5].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i5].setLocationFromOrg(fLines[i5].getAD_Org_ID(), false);
                }
                ++i5;
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }

    public BigDecimal createFactCash(MAcctSchema as, Fact fact, BigDecimal multiplier) {
        boolean creditMemo = this.getDocumentType().equals("ARC") || this.getDocumentType().equals("APC");
        boolean payables = this.getDocumentType().equals("API") || this.getDocumentType().equals("APC");
        BigDecimal acctAmt = Env.ZERO;
        FactLine fl = null;
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            boolean landedCost = false;
            if (payables) {
                landedCost = this.landedCost(as, fact, line, false);
            }
            if (landedCost && as.isExplicitCostAdjustment()) {
                fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), null, line.getAmtSource());
                fl = fact.createLine(line, line.getAccount(2, as), this.getC_Currency_ID(), line.getAmtSource(), null);
                String desc = line.getDescription();
                desc = desc == null ? "100%" : String.valueOf(desc) + " 100%";
                fl.setDescription(desc);
            }
            if (!landedCost) {
                MAccount acct = line.getAccount(payables ? 2 : 1, as);
                if (payables && line.isItem()) {
                    acct = line.getAccount(10, as);
                }
                BigDecimal amt = line.getAmtSource().multiply(multiplier);
                BigDecimal amt2 = null;
                if (creditMemo) {
                    amt2 = amt;
                    amt = null;
                }
                if ((fl = payables ? fact.createLine(line, acct, this.getC_Currency_ID(), amt, amt2) : fact.createLine(line, acct, this.getC_Currency_ID(), amt2, amt)) != null) {
                    acctAmt = acctAmt.add(fl.getAcctBalance());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_taxes.length) {
            BigDecimal amt = this.m_taxes[i].getAmount();
            BigDecimal amt2 = null;
            if (creditMemo) {
                amt2 = amt;
                amt = null;
            }
            FactLine tl = null;
            tl = payables ? fact.createLine(null, this.m_taxes[i].getAccount(this.m_taxes[i].getAPTaxType(), as), this.getC_Currency_ID(), amt, amt2) : fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), amt2, amt);
            if (tl != null) {
                tl.setC_Tax_ID(this.m_taxes[i].getC_Tax_ID());
            }
            ++i;
        }
        FactLine[] fLines = fact.getLines();
        int i2 = 0;
        while (i2 < fLines.length) {
            if (fLines[i2] != null) {
                if (payables) {
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), false);
                } else {
                    fLines[i2].setLocationFromOrg(fLines[i2].getAD_Org_ID(), true);
                    fLines[i2].setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                }
            }
            ++i2;
        }
        return acctAmt;
    }

    protected boolean landedCost(MAcctSchema as, Fact fact, DocLine line, boolean dr) {
        int C_InvoiceLine_ID = line.get_ID();
        MLandedCostAllocation[] lcas = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        if (lcas.length == 0) {
            return false;
        }
        double totalBase = 0.0;
        int i = 0;
        while (i < lcas.length) {
            totalBase += lcas[i].getBase().doubleValue();
            ++i;
        }
        HashMap<String, BigDecimal> costDetailAmtMap = new HashMap<String, BigDecimal>();
        MInvoiceLine il = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        int i2 = 0;
        while (i2 < lcas.length) {
            MLandedCostAllocation lca = lcas[i2];
            if (lca.getBase().signum() != 0) {
                double percent = lca.getBase().doubleValue() / totalBase;
                String desc = il.getDescription();
                desc = desc == null ? String.valueOf(percent) + "%" : String.valueOf(desc) + " - " + percent + "%";
                if (line.getDescription() != null) {
                    desc = String.valueOf(desc) + " - " + line.getDescription();
                }
                BigDecimal drAmt = null;
                BigDecimal crAmt = null;
                MAccount account = null;
                ProductCost pc = new ProductCost(Env.getCtx(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), this.getTrxName());
                String costingMethod = pc.getProduct().getCostingMethod(as);
                if ("I".equals(costingMethod) || "A".equals(costingMethod)) {
                    boolean zeroQty;
                    boolean usesSchemaCurrency;
                    BigDecimal estimatedAmt;
                    BigDecimal allocationAmt;
                    block55: {
                        I_M_InOutLine iol;
                        allocationAmt = lca.getAmt();
                        estimatedAmt = BigDecimal.ZERO;
                        int oCurrencyId = 0;
                        usesSchemaCurrency = false;
                        Timestamp oDateAcct = this.getDateAcct();
                        if (lca.getM_InOutLine_ID() > 0 && (iol = lca.getM_InOutLine()).getC_OrderLine_ID() > 0) {
                            MOrderLandedCostAllocation[] allocations;
                            oCurrencyId = iol.getC_OrderLine().getC_Currency_ID();
                            oDateAcct = iol.getC_OrderLine().getC_Order().getDateAcct();
                            MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = allocations = MOrderLandedCostAllocation.getOfOrderLine(iol.getC_OrderLine_ID(), this.getTrxName());
                            int n = allocations.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MOrderLandedCostAllocation allocation = mOrderLandedCostAllocationArray[n2];
                                if (allocation.getC_OrderLandedCost().getM_CostElement_ID() == lca.getM_CostElement_ID()) {
                                    BigDecimal amt = allocation.getAmt();
                                    BigDecimal qty = allocation.getQty();
                                    if (qty.compareTo(iol.getMovementQty()) != 0) {
                                        amt = amt.multiply(iol.getMovementQty()).divide(qty, 12, RoundingMode.HALF_UP);
                                    }
                                    estimatedAmt = estimatedAmt.add(amt);
                                }
                                ++n2;
                            }
                        }
                        if (estimatedAmt.scale() > as.getCostingPrecision()) {
                            estimatedAmt = estimatedAmt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
                        }
                        BigDecimal costAdjustmentAmt = allocationAmt;
                        if (estimatedAmt.signum() > 0) {
                            StringBuilder sql = new StringBuilder("SELECT Sum(Amt) FROM C_LandedCostAllocation WHERE M_InOutLine_ID=? ").append("AND C_LandedCostAllocation_ID<>? ").append("AND M_CostElement_ID=? ").append("AND AD_Client_ID=? ");
                            BigDecimal otherAmt = DB.getSQLValueBD(this.getTrxName(), sql.toString(), lca.getM_InOutLine_ID(), lca.getC_LandedCostAllocation_ID(), lca.getM_CostElement_ID(), lca.getAD_Client_ID());
                            if (otherAmt != null) {
                                estimatedAmt = estimatedAmt.subtract(otherAmt);
                                if (allocationAmt.signum() < 0) {
                                    estimatedAmt = estimatedAmt.add(allocationAmt.negate());
                                }
                            }
                            if (estimatedAmt.signum() > 0 && oCurrencyId != this.getC_Currency_ID()) {
                                estimatedAmt = MConversionRate.convert(this.getCtx(), estimatedAmt, oCurrencyId, as.getC_Currency_ID(), oDateAcct, this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                                allocationAmt = MConversionRate.convert(this.getCtx(), allocationAmt, this.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                                this.setC_Currency_ID(as.getC_Currency_ID());
                                usesSchemaCurrency = true;
                            }
                            if (estimatedAmt.signum() > 0) {
                                if (allocationAmt.signum() > 0) {
                                    costAdjustmentAmt = allocationAmt.subtract(estimatedAmt);
                                } else if (allocationAmt.signum() < 0) {
                                    costAdjustmentAmt = allocationAmt.add(estimatedAmt);
                                }
                            }
                        }
                        if (!dr) {
                            costAdjustmentAmt = costAdjustmentAmt.negate();
                        }
                        zeroQty = false;
                        if (costAdjustmentAmt.signum() != 0) {
                            Trx trx = Trx.get(this.getTrxName(), false);
                            Savepoint savepoint = null;
                            try {
                                try {
                                    String key;
                                    BigDecimal prevAmt;
                                    savepoint = trx.setSavepoint(null);
                                    BigDecimal costDetailAmt = costAdjustmentAmt;
                                    if (this.getC_Currency_ID() != as.getC_Currency_ID()) {
                                        costDetailAmt = MConversionRate.convert(this.getCtx(), costDetailAmt, this.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                                    }
                                    if (costDetailAmt.scale() > as.getCostingPrecision()) {
                                        costDetailAmt = costDetailAmt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
                                    }
                                    if ((prevAmt = (BigDecimal)costDetailAmtMap.remove(key = String.valueOf(lca.getM_Product_ID()) + "_" + lca.getM_AttributeSetInstance_ID())) != null) {
                                        costDetailAmt = costDetailAmt.add(prevAmt);
                                    }
                                    costDetailAmtMap.put(key, costDetailAmt);
                                    if (!MCostDetail.createInvoice(as, lca.getAD_Org_ID(), lca.getM_Product_ID(), lca.getM_AttributeSetInstance_ID(), C_InvoiceLine_ID, lca.getM_CostElement_ID(), costDetailAmt, lca.getQty(), desc, this.getTrxName())) {
                                        throw new RuntimeException("Failed to create cost detail record.");
                                    }
                                }
                                catch (SQLException e) {
                                    throw new RuntimeException(e.getLocalizedMessage(), e);
                                }
                                catch (AverageCostingZeroQtyException e) {
                                    zeroQty = true;
                                    try {
                                        trx.rollback(savepoint);
                                        savepoint = null;
                                    }
                                    catch (SQLException e1) {
                                        throw new RuntimeException(e1.getLocalizedMessage(), e1);
                                    }
                                    if (savepoint != null) {
                                        try {
                                            trx.releaseSavepoint(savepoint);
                                        }
                                        catch (SQLException sQLException) {}
                                    }
                                    break block55;
                                }
                            }
                            catch (Throwable throwable) {
                                if (savepoint != null) {
                                    try {
                                        trx.releaseSavepoint(savepoint);
                                    }
                                    catch (SQLException sQLException) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                            if (savepoint != null) {
                                try {
                                    trx.releaseSavepoint(savepoint);
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    boolean reversal = false;
                    if (allocationAmt.signum() < 0) {
                        allocationAmt = allocationAmt.negate();
                        reversal = true;
                    }
                    if (allocationAmt.signum() > 0) {
                        int compare;
                        if (allocationAmt.scale() > as.getStdPrecision()) {
                            allocationAmt = allocationAmt.setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                        }
                        if (estimatedAmt.scale() > as.getStdPrecision()) {
                            estimatedAmt = estimatedAmt.setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
                        }
                        if ((compare = allocationAmt.compareTo(estimatedAmt)) > 0) {
                            BigDecimal bigDecimal = dr ? (reversal ? null : estimatedAmt) : (drAmt = reversal ? estimatedAmt : null);
                            crAmt = dr ? (reversal ? estimatedAmt : null) : (reversal ? null : estimatedAmt);
                            account = pc.getAccount(24, as);
                            FactLine fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                            fl.setDescription(desc);
                            fl.setM_Product_ID(lca.getM_Product_ID());
                            fl.setQty(line.getQty());
                            BigDecimal overAmt = allocationAmt.subtract(estimatedAmt);
                            BigDecimal bigDecimal2 = dr ? (reversal ? null : overAmt) : (drAmt = reversal ? overAmt : null);
                            crAmt = dr ? (reversal ? overAmt : null) : (reversal ? null : overAmt);
                            account = zeroQty ? pc.getAccount(23, as) : pc.getAccount(3, as);
                            fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                            fl.setDescription(desc);
                            fl.setM_Product_ID(lca.getM_Product_ID());
                            fl.setQty(line.getQty());
                        } else if (compare < 0) {
                            BigDecimal bigDecimal = dr ? (reversal ? null : estimatedAmt) : (drAmt = reversal ? estimatedAmt : null);
                            crAmt = dr ? (reversal ? estimatedAmt : null) : (reversal ? null : estimatedAmt);
                            account = pc.getAccount(24, as);
                            FactLine fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                            fl.setDescription(desc);
                            fl.setM_Product_ID(lca.getM_Product_ID());
                            fl.setQty(line.getQty());
                            BigDecimal underAmt = estimatedAmt.subtract(allocationAmt);
                            BigDecimal bigDecimal3 = dr ? (reversal ? underAmt : null) : (drAmt = reversal ? null : underAmt);
                            crAmt = dr ? (reversal ? null : underAmt) : (reversal ? underAmt : null);
                            account = zeroQty ? pc.getAccount(23, as) : pc.getAccount(3, as);
                            fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                            fl.setDescription(desc);
                            fl.setM_Product_ID(lca.getM_Product_ID());
                            fl.setQty(line.getQty());
                        } else {
                            BigDecimal bigDecimal = dr ? (reversal ? null : allocationAmt) : (drAmt = reversal ? allocationAmt : null);
                            crAmt = dr ? (reversal ? allocationAmt : null) : (reversal ? null : allocationAmt);
                            account = pc.getAccount(24, as);
                            FactLine fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                            fl.setDescription(desc);
                            fl.setM_Product_ID(lca.getM_Product_ID());
                            fl.setQty(line.getQty());
                        }
                    }
                    if (usesSchemaCurrency) {
                        this.setC_Currency_ID(line.getC_Currency_ID());
                    }
                } else {
                    if (dr) {
                        drAmt = lca.getAmt();
                    } else {
                        crAmt = lca.getAmt();
                    }
                    account = pc.getAccount(9, as);
                    FactLine fl = fact.createLine(line, account, this.getC_Currency_ID(), drAmt, crAmt);
                    fl.setDescription(desc);
                    fl.setM_Product_ID(lca.getM_Product_ID());
                    fl.setQty(line.getQty());
                }
            }
            ++i2;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Created #" + lcas.length);
        }
        return true;
    }

    protected void updateProductPO(MAcctSchema as) {
        MClientInfo ci = MClientInfo.get(this.getCtx(), as.getAD_Client_ID());
        if (ci.getC_AcctSchema1_ID() != as.getC_AcctSchema_ID()) {
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE M_Product_PO po ").append("SET PriceLastInv = ").append("(SELECT currencyConvertInvoice(i.C_Invoice_ID,po.C_Currency_ID,il.PriceActual,i.DateInvoiced) ").append("FROM C_Invoice i, C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID");
        if (DB.isOracle()) {
            sql.append(" AND ROWNUM=1 ");
        } else {
            sql.append(" AND il.C_InvoiceLine_ID = (SELECT MIN(il1.C_InvoiceLine_ID) ").append("FROM C_Invoice i1, C_InvoiceLine il1 ").append("WHERE i1.C_Invoice_ID=il1.C_Invoice_ID").append(" AND po.M_Product_ID=il1.M_Product_ID AND po.C_BPartner_ID=i1.C_BPartner_ID").append("  AND i1.C_Invoice_ID=").append(this.get_ID()).append(") ");
        }
        sql.append("  AND i.C_Invoice_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * ").append("FROM C_Invoice i, C_InvoiceLine il ").append("WHERE i.C_Invoice_ID=il.C_Invoice_ID").append(" AND po.M_Product_ID=il.M_Product_ID AND po.C_BPartner_ID=i.C_BPartner_ID").append(" AND i.C_Invoice_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Updated=" + no);
        }
    }

    @Override
    public BigDecimal getCurrencyRate() {
        if (this.getC_Currency_ID() == this.getAcctSchema().getC_Currency_ID()) {
            return null;
        }
        MInvoice inv = (MInvoice)this.getPO();
        int baseCurrencyId = MClientInfo.get(this.getCtx(), inv.getAD_Client_ID()).getC_Currency_ID();
        if (baseCurrencyId != this.getAcctSchema().getC_Currency_ID()) {
            return null;
        }
        if (inv.isOverrideCurrencyRate()) {
            return inv.getCurrencyRate();
        }
        return null;
    }

    @Override
    public boolean isConvertible(MAcctSchema acctSchema) {
        int baseCurrencyId;
        MInvoice inv = (MInvoice)this.getPO();
        if (inv.getC_Currency_ID() != acctSchema.getC_Currency_ID() && (baseCurrencyId = MClientInfo.get(this.getCtx(), inv.getAD_Client_ID()).getC_Currency_ID()) == acctSchema.getC_Currency_ID() && inv.isOverrideCurrencyRate()) {
            return true;
        }
        return super.isConvertible(acctSchema);
    }
}

