/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_InOut;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class Doc_InOut
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";
    private boolean m_deferPosting = false;

    public Doc_InOut(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MInOut.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInOut inout = (MInOut)this.getPO();
        this.setDateDoc(inout.getMovementDate());
        this.m_Reversal_ID = inout.getReversal_ID();
        this.m_DocStatus = inout.getDocStatus();
        this.p_lines = this.loadLines(inout);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        if (inout.isSOTrx()) {
            MInOutLine[] lines;
            MInOutLine[] mInOutLineArray = lines = inout.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MInOutLine line = mInOutLineArray[n2];
                I_C_OrderLine orderLine = line.getC_OrderLine();
                if (orderLine != null && orderLine.getLink_OrderLine_ID() > 0) {
                    String sql = "SELECT COUNT(*) FROM M_InOutLine iol WHERE iol.C_OrderLine_ID=? AND EXISTS (SELECT * FROM M_InOut io WHERE io.M_InOut_ID=iol.M_InOut_ID AND io.IsSOTrx='N' AND io.Posted<>'Y')";
                    int count = DB.getSQLValueEx(this.getTrxName(), sql, orderLine.getLink_OrderLine_ID());
                    if (count > 0) {
                        this.m_deferPosting = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private DocLine[] loadLines(MInOut inout) {
        ArrayList<DocLine_InOut> list = new ArrayList<DocLine_InOut>();
        MInOutLine[] lines = inout.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInOutLine line = lines[i];
            if (line.isDescription() || line.getM_Product_ID() == 0 || line.getMovementQty().signum() == 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Ignored: " + line);
                }
            } else {
                DocLine_InOut docLine = new DocLine_InOut(line, this);
                BigDecimal Qty = line.getMovementQty();
                docLine.setReversalLine_ID(line.getReversalLine_ID());
                docLine.setQty(Qty, this.getDocumentType().equals("MMS"));
                String sql = "SELECT PP_Cost_Collector_ID  FROM C_OrderLine WHERE C_OrderLine_ID=? AND PP_Cost_Collector_ID IS NOT NULL";
                int PP_Cost_Collector_ID = DB.getSQLValueEx(this.getTrxName(), sql, line.getC_OrderLine_ID());
                docLine.setPP_Cost_Collector_ID(PP_Cost_Collector_ID);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(docLine.toString());
                }
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        block148: {
            block155: {
                block153: {
                    block149: {
                        block145: {
                            facts = new ArrayList<Fact>();
                            fact = new Fact(this, as, "A");
                            this.setC_Currency_ID(as.getC_Currency_ID());
                            dr = null;
                            cr = null;
                            if (!this.getDocumentType().equals("MMS") || !this.isSOTrx()) break block145;
                            i = 0;
                            while (i < this.p_lines.length) {
                                block147: {
                                    block146: {
                                        batchLotCostMap = null;
                                        line = (DocLine_InOut)this.p_lines[i];
                                        product = line.getProduct();
                                        costs = null;
                                        if (this.isReversal(line)) ** GOTO lbl-1000
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                if (mas != null && mas.length > 0) {
                                                    batchLotCostMap = new HashMap<String, BigDecimal>();
                                                    costs = BigDecimal.ZERO;
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        QtyMA = ma.getMovementQty();
                                                        if (QtyMA.signum() != line.getQty().signum()) {
                                                            QtyMA = QtyMA.negate();
                                                        }
                                                        pc = line.getProductCost();
                                                        pc.setQty(QtyMA);
                                                        pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                                        maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                                        batchLotCostMap.put(ma.getM_InOutLineMA_UU(), maCosts);
                                                        costs = costs.add(maCosts);
                                                        ++j;
                                                    }
                                                }
                                            } else {
                                                costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            }
                                        } else {
                                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                        }
                                        if (costs != null && costs.signum() != 0) break block146;
                                        if (product.isStocked()) {
                                            count = DB.getSQLValue(null, "SELECT Count(*) FROM M_CostDetail WHERE M_Product_ID=? AND Processed='Y' AND Amt=0.00 AND Qty > 0 AND (C_OrderLine_ID > 0 OR C_InvoiceLine_ID > 0)", product.getM_Product_ID());
                                            if (count > 0) {
                                                costs = BigDecimal.ZERO;
                                            } else {
                                                this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "No Costs for")) + " " + line.getProduct().getName();
                                                this.log.log(Level.WARNING, this.p_Error);
                                                return null;
                                            }
                                        }
                                        break block147;
lbl-1000:
                                        // 1 sources

                                        {
                                            costs = BigDecimal.ZERO;
                                        }
                                    }
                                    if ((dr = fact.createLine((DocLine)line, line.getAccount(4, as), as.getC_Currency_ID(), costs, null)) == null) {
                                        this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "FactLine DR not created: ")) + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    dr.setM_Locator_ID(line.getM_Locator_ID());
                                    dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                    dr.setAD_Org_ID(line.getOrder_Org_ID());
                                    dr.setQty(line.getQty().negate());
                                    if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl67
                                    if (!product.isStocked()) {
                                        fact.remove(dr);
                                    } else {
                                        this.p_Error = Msg.getMsg(this.getCtx(), "Original Shipment/Receipt not posted yet");
                                        return null;
lbl67:
                                        // 1 sources

                                        cr = fact.createLine((DocLine)line, line.getAccount(3, as), as.getC_Currency_ID(), null, costs);
                                        if (cr == null) {
                                            this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "FactLine CR not created:")) + " " + line;
                                            this.log.log(Level.WARNING, this.p_Error);
                                            return null;
                                        }
                                        cr.setM_Locator_ID(line.getM_Locator_ID());
                                        cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                        cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                        if (this.isReversal(line)) {
                                            if (!cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE, dr)) {
                                                this.p_Error = Msg.getMsg(this.getCtx(), "Original Shipment/Receipt not posted yet");
                                                return null;
                                            }
                                            costs = cr.getAcctBalance();
                                        }
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                if (mas != null && mas.length > 0) {
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        qty = ma.getMovementQty();
                                                        if (qty.signum() != line.getQty().signum()) {
                                                            qty = qty.negate();
                                                        }
                                                        v0 = amt = batchLotCostMap != null ? (BigDecimal)batchLotCostMap.get(ma.getM_InOutLineMA_UU()) : null;
                                                        if (amt == null && this.isReversal(line) && (amt = this.findReversalCostDetailAmt(as, line.getM_Product_ID(), ma, line.getReversalLine_ID())) != null) {
                                                            amt = amt.negate();
                                                        }
                                                        if (amt == null) {
                                                            amt = costs.divide(line.getProductCost().getQty(), RoundingMode.HALF_UP);
                                                            amt = amt.multiply(qty);
                                                        } else if (!this.isReversal(line) && line.getProductCost().getQty().signum() != line.getQty().signum() && amt.signum() != costs.signum() * -1) {
                                                            amt = amt.negate();
                                                        }
                                                        if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, qty, line.getDescription(), true, this.getTrxName())) {
                                                            this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                                            return null;
                                                        }
                                                        ++j;
                                                    }
                                                }
                                            } else if (line.getM_Product_ID() != 0) {
                                                amt = costs;
                                                if (line.getProductCost().getQty().signum() != line.getQty().signum() && !this.isReversal(line)) {
                                                    amt = amt.negate();
                                                }
                                                if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                                    this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                                    return null;
                                                }
                                            }
                                        } else if (line.getM_Product_ID() != 0) {
                                            amt = costs;
                                            if (line.getProductCost().getQty().signum() != line.getQty().signum() && !this.isReversal(line)) {
                                                amt = amt.negate();
                                            }
                                            if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                                this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                                return null;
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (as.isAccrual() && as.isCreateSOCommitment()) {
                                i = 0;
                                while (i < this.p_lines.length) {
                                    line = (DocLine_InOut)this.p_lines[i];
                                    factcomm = Doc_Order.getCommitmentSalesRelease(as, this, line.getQty(), line.get_ID(), Env.ONE);
                                    if (factcomm != null) {
                                        facts.add(factcomm);
                                    }
                                    ++i;
                                }
                            }
                            break block148;
                        }
                        if (!this.getDocumentType().equals("MMR") || !this.isSOTrx()) break block149;
                        i = 0;
                        while (i < this.p_lines.length) {
                            block152: {
                                block151: {
                                    block150: {
                                        line = (DocLine_InOut)this.p_lines[i];
                                        product = line.getProduct();
                                        costs = null;
                                        batchLotCostMap = null;
                                        if (this.isReversal(line)) break block150;
                                        if ("B".equals(product.getCostingLevel(as))) {
                                            if (line.getM_AttributeSetInstance_ID() == 0) {
                                                ioLine = (MInOutLine)line.getPO();
                                                mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                                costs = BigDecimal.ZERO;
                                                if (mas != null && mas.length > 0) {
                                                    batchLotCostMap = new HashMap<String, BigDecimal>();
                                                    j = 0;
                                                    while (j < mas.length) {
                                                        ma = mas[j];
                                                        QtyMA = ma.getMovementQty();
                                                        if (QtyMA.signum() != line.getQty().signum()) {
                                                            QtyMA = QtyMA.negate();
                                                        }
                                                        pc = line.getProductCost();
                                                        pc.setQty(QtyMA);
                                                        pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                                        maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                                        batchLotCostMap.put(ma.getM_InOutLineMA_UU(), maCosts);
                                                        costs = costs.add(maCosts);
                                                        ++j;
                                                    }
                                                }
                                            } else {
                                                costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            }
                                        } else {
                                            costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                        }
                                        if (costs != null && costs.signum() != 0) break block151;
                                        if (product.isStocked()) {
                                            this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "No Costs for")) + " " + line.getProduct().getName();
                                            this.log.log(Level.WARNING, this.p_Error);
                                            return null;
                                        }
                                        break block152;
                                    }
                                    costs = BigDecimal.ZERO;
                                }
                                if ((dr = fact.createLine((DocLine)line, line.getAccount(3, as), as.getC_Currency_ID(), costs, null)) == null) {
                                    this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "FactLine DR not created: ")) + line;
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                                dr.setM_Locator_ID(line.getM_Locator_ID());
                                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                if (!this.isReversal(line)) ** GOTO lbl194
                                if (dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl193
                                if (!product.isStocked()) {
                                    fact.remove(dr);
                                } else {
                                    this.p_Error = Msg.getMsg(this.getCtx(), "Original Shipment/Receipt not posted yet");
                                    return null;
lbl193:
                                    // 1 sources

                                    costs = dr.getAcctBalance();
lbl194:
                                    // 2 sources

                                    if ("B".equals(product.getCostingLevel(as))) {
                                        if (line.getM_AttributeSetInstance_ID() == 0) {
                                            ioLine = (MInOutLine)line.getPO();
                                            mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                            if (mas != null && mas.length > 0) {
                                                j = 0;
                                                while (j < mas.length) {
                                                    ma = mas[j];
                                                    qty = ma.getMovementQty();
                                                    if (qty.signum() != line.getQty().signum()) {
                                                        qty = qty.negate();
                                                    }
                                                    v1 = amt = batchLotCostMap != null ? (BigDecimal)batchLotCostMap.get(ma.getM_InOutLineMA_UU()) : null;
                                                    if (amt == null && this.isReversal(line) && (amt = this.findReversalCostDetailAmt(as, line.getM_Product_ID(), ma, line.getReversalLine_ID())) != null) {
                                                        amt = amt.negate();
                                                    }
                                                    if (amt == null) {
                                                        amt = costs.divide(line.getProductCost().getQty(), RoundingMode.HALF_UP);
                                                        amt = amt.multiply(qty);
                                                    } else if (!this.isReversal(line) && line.getProductCost().getQty().signum() != line.getQty().signum() && amt.signum() != costs.signum() * -1) {
                                                        amt = amt.negate();
                                                    }
                                                    if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, qty, line.getDescription(), true, this.getTrxName())) {
                                                        this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                                        return null;
                                                    }
                                                    ++j;
                                                }
                                            }
                                        } else if (line.getM_Product_ID() != 0) {
                                            amt = costs;
                                            if (line.getProductCost().getQty().signum() != line.getQty().signum() && !this.isReversal(line)) {
                                                amt = amt.negate();
                                            }
                                            if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                                this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                                return null;
                                            }
                                        }
                                    } else if (line.getM_Product_ID() != 0) {
                                        amt = costs;
                                        if (line.getProductCost().getQty().signum() != line.getQty().signum() && !this.isReversal(line)) {
                                            amt = amt.negate();
                                        }
                                        if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, amt, line.getQty(), line.getDescription(), true, this.getTrxName())) {
                                            this.p_Error = Msg.getMsg(this.getCtx(), "Failed to create cost detail record");
                                            return null;
                                        }
                                    }
                                    if ((cr = fact.createLine((DocLine)line, line.getAccount(4, as), as.getC_Currency_ID(), null, costs)) == null) {
                                        this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "FactLine CR not created:")) + " " + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    cr.setM_Locator_ID(line.getM_Locator_ID());
                                    cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), false);
                                    cr.setAD_Org_ID(line.getOrder_Org_ID());
                                    cr.setQty(line.getQty().negate());
                                    if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE, dr)) {
                                        this.p_Error = Msg.getMsg(this.getCtx(), "Original Shipment/Receipt not posted yet");
                                        return null;
                                    }
                                }
                            }
                            ++i;
                        }
                        break block148;
                    }
                    if (!this.getDocumentType().equals("MMR") || this.isSOTrx()) break block153;
                    i = 0;
                    while (i < this.p_lines.length) {
                        block154: {
                            C_Currency_ID = as.getC_Currency_ID();
                            line = (DocLine_InOut)this.p_lines[i];
                            costs = null;
                            product = line.getProduct();
                            orderLine = null;
                            landedCost = BigDecimal.ZERO;
                            costingMethod = product.getCostingMethod(as);
                            if (this.isReversal(line)) ** GOTO lbl-1000
                            C_OrderLine_ID = line.getC_OrderLine_ID();
                            if (C_OrderLine_ID > 0) {
                                orderLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.getTrxName());
                                var19_67 = allocations = MOrderLandedCostAllocation.getOfOrderLine(C_OrderLine_ID, this.getTrxName());
                                var18_63 = allocations.length;
                                maCosts = 0;
                                while (maCosts < var18_63) {
                                    allocation = var19_67[maCosts];
                                    totalAmt = allocation.getAmt();
                                    totalQty = allocation.getQty();
                                    amt = totalAmt.multiply(line.getQty()).divide(totalQty, RoundingMode.HALF_UP);
                                    landedCost = landedCost.add(amt);
                                    ++maCosts;
                                }
                            }
                            if (!"A".equals(costingMethod) && !"I".equals(costingMethod) && !"p".equals(costingMethod) && (!"S".equals(costingMethod) || !"B".equals(product.getCostingLevel(as)))) ** GOTO lbl342
                            if (orderLine != null) {
                                C_Currency_ID = orderLine.getC_Currency_ID();
                                costs = orderLine.getPriceCost();
                                if (costs == null || costs.signum() == 0) {
                                    costs = orderLine.getPriceActual();
                                    C_Tax_ID = orderLine.getC_Tax_ID();
                                    if (orderLine.isTaxIncluded() && C_Tax_ID != 0) {
                                        tax = MTax.get(this.getCtx(), C_Tax_ID);
                                        if (!tax.isZeroTax()) {
                                            stdPrecision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
                                            costTax = tax.calculateTax(costs, true, stdPrecision);
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                            }
                                            if (tax.isSummary()) {
                                                cTaxes = tax.getChildTaxes(false);
                                                toSubtract = new ArrayList<MTax>();
                                                var24_85 = cTaxes;
                                                var23_81 = cTaxes.length;
                                                amt = 0;
                                                while (amt < var23_81) {
                                                    cTax = var24_85[amt];
                                                    if (!cTax.isDistributeTaxWithLineItem()) {
                                                        toSubtract.add(cTax);
                                                    }
                                                    ++amt;
                                                }
                                                if (toSubtract.size() > 0) {
                                                    base = costs.subtract(costTax);
                                                    for (MTax cTax : toSubtract) {
                                                        ts = cTax.calculateTax(base, false, stdPrecision);
                                                        costs = costs.subtract(ts);
                                                    }
                                                }
                                            } else if (!tax.isDistributeTaxWithLineItem()) {
                                                costs = costs.subtract(costTax);
                                            }
                                        }
                                    } else if (C_Tax_ID != 0) {
                                        tax = MTax.get(this.getCtx(), C_Tax_ID);
                                        if (tax.isSummary()) {
                                            cTaxes = tax.getChildTaxes(false);
                                            base = costs;
                                            var22_76 = cTaxes;
                                            var21_74 = cTaxes.length;
                                            toSubtract = 0;
                                            while (toSubtract < var21_74) {
                                                cTax = var22_76[toSubtract];
                                                if (cTax.isDistributeTaxWithLineItem()) {
                                                    costTax = cTax.calculateTax(base, false, 12);
                                                    if (this.log.isLoggable(Level.FINE)) {
                                                        this.log.fine("Costs=" + base + " - Tax=" + costTax);
                                                    }
                                                    costs = costs.add(costTax);
                                                }
                                                ++toSubtract;
                                            }
                                        } else if (tax.isDistributeTaxWithLineItem()) {
                                            costTax = tax.calculateTax(costs, false, 12);
                                            if (this.log.isLoggable(Level.FINE)) {
                                                this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                            }
                                            costs = costs.add(costTax);
                                        }
                                    }
                                }
                                costs = costs.multiply(line.getQty());
                            } else {
                                this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "Resubmit - No Costs for")) + " " + product.getName() + Msg.getMsg(this.getCtx(), " (required order line)");
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
lbl342:
                                // 1 sources

                                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                            }
                            if (costs == null || costs.signum() == 0) {
                                if (orderLine != null && orderLine.getPriceActual().signum() == 0) {
                                    costs = BigDecimal.ZERO;
                                } else {
                                    this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "Resubmit - No Costs for")) + " " + product.getName();
                                    this.log.log(Level.WARNING, this.p_Error);
                                    return null;
                                }
                            }
                            break block154;
lbl-1000:
                            // 1 sources

                            {
                                costs = BigDecimal.ZERO;
                            }
                        }
                        assets = line.getAccount(3, as);
                        if (product.isService()) {
                            assets = line.getPP_Cost_Collector_ID() > 0 ? line.getAccount(11, as) : line.getAccount(2, as);
                        }
                        drAsset = costs;
                        if (landedCost.signum() != 0 && ("I".equals(costingMethod) || "A".equals(costingMethod))) {
                            drAsset = drAsset.add(landedCost);
                        }
                        if ((dr = fact.createLine((DocLine)line, assets, C_Currency_ID, drAsset, null)) == null) {
                            this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "DR not created:")) + " " + line;
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                        dr.setM_Locator_ID(line.getM_Locator_ID());
                        dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                        dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                        if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl372
                        if (!product.isStocked()) {
                            fact.remove(dr);
                        } else {
                            this.p_Error = Msg.getMsg(this.getCtx(), "Original Receipt not posted yet");
                            return null;
lbl372:
                            // 1 sources

                            cr = fact.createLine((DocLine)line, this.getAccount(51, as), C_Currency_ID, null, costs);
                            if (cr == null) {
                                this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "CR not created:")) + " " + line;
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                            cr.setM_Locator_ID(line.getM_Locator_ID());
                            cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                            cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                            cr.setQty(line.getQty().negate());
                            if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE, dr)) {
                                this.p_Error = Msg.getMsg(this.getCtx(), "Original Receipt not posted yet");
                                return null;
                            }
                            if (!fact.isAcctBalanced()) {
                                if (this.isReversal(line)) {
                                    dr = fact.createLine((DocLine)line, line.getAccount(24, as), C_Currency_ID, Env.ONE, null);
                                    if (!dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                                        this.p_Error = Msg.getMsg(this.getCtx(), "Original Receipt not posted yet");
                                        return null;
                                    }
                                } else if (landedCost.signum() != 0) {
                                    cr = fact.createLine((DocLine)line, line.getAccount(24, as), C_Currency_ID, null, landedCost);
                                    if (cr == null) {
                                        this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "CR not created:")) + " " + line;
                                        this.log.log(Level.WARNING, this.p_Error);
                                        return null;
                                    }
                                    cr.setM_Locator_ID(line.getM_Locator_ID());
                                    cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                                    cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                                    cr.setQty(line.getQty().negate());
                                }
                            }
                        }
                        ++i;
                    }
                    break block148;
                }
                if (!this.getDocumentType().equals("MMS") || this.isSOTrx()) break block155;
                i = 0;
                while (i < this.p_lines.length) {
                    C_Currency_ID = as.getC_Currency_ID();
                    line = (DocLine_InOut)this.p_lines[i];
                    costs = null;
                    product = line.getProduct();
                    if (!this.isReversal(line)) {
                        ioLine = (MInOutLine)line.getPO();
                        rmaLine = ioLine.getM_RMALine();
                        costs = rmaLine != null ? rmaLine.getAmt() : BigDecimal.ZERO;
                        v2 = originalInOutLine = rmaLine != null ? rmaLine.getM_InOutLine() : null;
                        if (originalInOutLine != null && originalInOutLine.getC_OrderLine_ID() > 0) {
                            originalOrderLine = (MOrderLine)originalInOutLine.getC_OrderLine();
                            C_Tax_ID = originalOrderLine.getC_Tax_ID();
                            tax = MTax.get(this.getCtx(), C_Tax_ID);
                            stdPrecision = MCurrency.getStdPrecision(this.getCtx(), originalOrderLine.getC_Currency_ID());
                            if (originalOrderLine.isTaxIncluded() && C_Tax_ID != 0) {
                                costTax = tax.calculateTax(costs, true, stdPrecision);
                                if (this.log.isLoggable(Level.FINE)) {
                                    this.log.fine("Costs=" + costs + " - Tax=" + costTax);
                                }
                                if (tax.isSummary()) {
                                    base = costs = costs.subtract(costTax);
                                    costTax /* !! */  = tax.getChildTaxes(false);
                                    var22_79 = costTax /* !! */ .length;
                                    var21_75 = 0;
                                    while (var21_75 < var22_79) {
                                        cTax = costTax /* !! */ [var21_75];
                                        if (!cTax.isZeroTax() && cTax.isDistributeTaxWithLineItem()) {
                                            costTax = cTax.calculateTax(base, false, stdPrecision);
                                            costs = costs.add(costTax);
                                        }
                                        ++var21_75;
                                    }
                                } else if (!tax.isZeroTax() && !tax.isDistributeTaxWithLineItem()) {
                                    costs = costs.subtract(costTax);
                                }
                            } else if (tax.isSummary()) {
                                base = costs;
                                var22_80 = tax.getChildTaxes(false);
                                var21_75 = var22_80.length;
                                var20_72 = 0;
                                while (var20_72 < var21_75) {
                                    cTax = var22_80[var20_72];
                                    if (!cTax.isZeroTax() && cTax.isDistributeTaxWithLineItem()) {
                                        costTax /* !! */  = cTax.calculateTax(base, false, stdPrecision);
                                        costs = costs.add((BigDecimal)costTax /* !! */ );
                                    }
                                    ++var20_72;
                                }
                            } else if (tax.isDistributeTaxWithLineItem()) {
                                costTax = tax.calculateTax(costs, false, stdPrecision);
                                costs = costs.add(costTax);
                            }
                            if (C_Currency_ID != originalOrderLine.getC_Currency_ID()) {
                                costs = MConversionRate.convert(this.getCtx(), costs, originalOrderLine.getC_Currency_ID(), C_Currency_ID, this.getDateAcct(), line.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), true);
                            }
                            costs = costs.multiply(line.getQty());
                            costs = costs.negate();
                        } else {
                            if ("B".equals(product.getCostingLevel(as))) {
                                if (line.getM_AttributeSetInstance_ID() == 0) {
                                    mas = MInOutLineMA.get(this.getCtx(), ioLine.get_ID(), this.getTrxName());
                                    costs = BigDecimal.ZERO;
                                    if (mas != null && mas.length > 0) {
                                        j = 0;
                                        while (j < mas.length) {
                                            ma = mas[j];
                                            QtyMA = ma.getMovementQty();
                                            if (QtyMA.signum() != line.getQty().signum()) {
                                                QtyMA = QtyMA.negate();
                                            }
                                            pc = line.getProductCost();
                                            pc.setQty(QtyMA);
                                            pc.setM_M_AttributeSetInstance_ID(ma.getM_AttributeSetInstance_ID());
                                            maCosts = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_InOutLine_ID=?");
                                            costs = costs.add(maCosts);
                                            ++j;
                                        }
                                    }
                                } else {
                                    costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                                }
                            } else {
                                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
                            }
                            if (costs == null || costs.signum() == 0) {
                                this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "Resubmit - No Costs for")) + " " + product.getName();
                                this.log.log(Level.WARNING, this.p_Error);
                                return null;
                            }
                        }
                    } else {
                        costs = Env.ONE;
                    }
                    dr = fact.createLine((DocLine)line, this.getAccount(51, as), C_Currency_ID, costs, null);
                    if (dr == null) {
                        this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "CR not created:")) + " " + line;
                        this.log.log(Level.WARNING, this.p_Error);
                        return null;
                    }
                    dr.setM_Locator_ID(line.getM_Locator_ID());
                    dr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                    dr.setLocationFromLocator(line.getM_Locator_ID(), false);
                    dr.setQty(line.getQty().negate());
                    if (!this.isReversal(line) || dr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) ** GOTO lbl506
                    if (!product.isStocked()) {
                        fact.remove(dr);
                    } else {
                        this.p_Error = Msg.getMsg(this.getCtx(), "Original Receipt not posted yet");
                        return null;
lbl506:
                        // 1 sources

                        assets = line.getAccount(3, as);
                        if (product.isService()) {
                            assets = line.getAccount(2, as);
                        }
                        if ((cr = fact.createLine((DocLine)line, assets, C_Currency_ID, null, costs)) == null) {
                            this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "DR not created:")) + " " + line;
                            this.log.log(Level.WARNING, this.p_Error);
                            return null;
                        }
                        cr.setM_Locator_ID(line.getM_Locator_ID());
                        cr.setLocationFromBPartner(this.getC_BPartner_Location_ID(), true);
                        cr.setLocationFromLocator(line.getM_Locator_ID(), false);
                        if (this.isReversal(line) && !cr.updateReverseLine(319, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE, dr)) {
                            this.p_Error = Msg.getMsg(this.getCtx(), "Original Receipt not posted yet");
                            return null;
                        }
                        costingError = this.createVendorRMACostDetail(as, line, costs);
                        if (!Util.isEmpty(costingError)) {
                            this.p_Error = costingError;
                            return null;
                        }
                    }
                    ++i;
                }
                break block148;
            }
            this.p_Error = String.valueOf(Msg.getMsg(this.getCtx(), "DocumentType unknown:")) + " " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        facts.add(fact);
        return facts;
    }

    private BigDecimal findReversalCostDetailAmt(MAcctSchema as, int M_Product_ID, MInOutLineMA ma, int reversalLine_ID) {
        StringBuilder select = new StringBuilder("SELECT ").append("Amt").append(" FROM ").append("M_CostDetail").append(" WHERE ").append("C_AcctSchema_ID").append("=? ").append("AND ").append("M_AttributeSetInstance_ID").append("=? ").append("AND ").append("M_InOutLine_ID").append("=? ").append("AND ").append("M_Product_ID").append("=? ");
        BigDecimal amt = DB.getSQLValueBDEx(this.getTrxName(), select.toString(), as.getC_AcctSchema_ID(), ma.getM_AttributeSetInstance_ID(), reversalLine_ID, M_Product_ID);
        return amt;
    }

    private boolean isReversal(DocLine line) {
        return this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0;
    }

    private String createVendorRMACostDetail(MAcctSchema as, DocLine line, BigDecimal costs) {
        MProduct product;
        BigDecimal tQty = line.getQty();
        BigDecimal tAmt = costs;
        if (tAmt.signum() != tQty.signum()) {
            tAmt = tAmt.negate();
        }
        if ("B".equals((product = line.getProduct()).getCostingLevel(as))) {
            if (line.getM_AttributeSetInstance_ID() == 0) {
                MInOutLineMA[] mas = MInOutLineMA.get(this.getCtx(), line.get_ID(), this.getTrxName());
                if (mas != null && mas.length > 0) {
                    int j = 0;
                    while (j < mas.length) {
                        MInOutLineMA ma = mas[j];
                        if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, ma.getMovementQty().negate(), line.getDescription(), false, this.getTrxName())) {
                            return "SaveError";
                        }
                        ++j;
                    }
                }
            } else if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, tQty, line.getDescription(), false, this.getTrxName())) {
                return "SaveError";
            }
        } else if (!MCostDetail.createShipment(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, tAmt, tQty, line.getDescription(), false, this.getTrxName())) {
            return "SaveError";
        }
        return "";
    }

    @Override
    public boolean isDeferPosting() {
        return this.m_deferPosting;
    }

    @Override
    public int getC_Currency_ID() {
        MInOut io = (MInOut)this.getPO();
        if (io.getC_Order_ID() > 0) {
            return io.getC_Order().getC_Currency_ID();
        }
        if (io.getM_RMA_ID() > 0 && io.getM_RMA().getInOut_ID() > 0 && io.getM_RMA().getInOut().getC_Order_ID() > 0) {
            return io.getM_RMA().getInOut().getC_Order().getC_Currency_ID();
        }
        return super.getC_Currency_ID();
    }

    @Override
    public int getC_ConversionType_ID() {
        MInOut io = (MInOut)this.getPO();
        if (io.getC_Order_ID() > 0) {
            return io.getC_Order().getC_ConversionType_ID();
        }
        if (io.getM_RMA_ID() > 0 && io.getM_RMA().getInOut_ID() > 0 && io.getM_RMA().getInOut().getC_Order_ID() > 0) {
            return io.getM_RMA().getInOut().getC_Order().getC_ConversionType_ID();
        }
        return super.getC_ConversionType_ID();
    }
}

