/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.base.IDocFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.base.ServiceQuery;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTable;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DocManager {
    public static final String IDOC_FACTORY_CACHE_TABLE_NAME = "_IDocFactory_Cache";
    private static final CLogger s_log = CLogger.getCLogger(DocManager.class);
    private static int[] documentsTableID = null;
    private static String[] documentsTableName = null;
    private static final CCache<String, IServiceReferenceHolder<IDocFactory>> s_DocFactoryCache = new CCache("_IDocFactory_Cache", "IDocFactory", 100, false);

    public static int[] getDocumentsTableID() {
        DocManager.fillDocumentsTableArrays();
        return documentsTableID;
    }

    public static String[] getDocumentsTableName() {
        DocManager.fillDocumentsTableArrays();
        return documentsTableName;
    }

    private static synchronized void fillDocumentsTableArrays() {
        if (documentsTableID == null) {
            String sql = "SELECT t.AD_Table_ID, t.TableName FROM AD_Table t, AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND IsView='N' ORDER BY t.AD_Table_ID";
            ArrayList<Integer> tableIDs = new ArrayList<Integer>();
            ArrayList<String> tableNames = new ArrayList<String>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        tableIDs.add(rs.getInt(1));
                        tableNames.add(rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            documentsTableID = new int[tableIDs.size()];
            documentsTableName = new String[tableIDs.size()];
            int i = 0;
            while (i < documentsTableID.length) {
                DocManager.documentsTableID[i] = (Integer)tableIDs.get(i);
                DocManager.documentsTableName[i] = (String)tableNames.get(i);
                ++i;
            }
        }
    }

    public static Doc getDocument(MAcctSchema as, int AD_Table_ID, int Record_ID, String trxName) {
        Doc doc;
        IDocFactory service;
        String TableName = null;
        int i = 0;
        while (i < DocManager.getDocumentsTableID().length) {
            if (DocManager.getDocumentsTableID()[i] == AD_Table_ID) {
                TableName = DocManager.getDocumentsTableName()[i];
                break;
            }
            ++i;
        }
        if (TableName == null) {
            s_log.severe("Not found AD_Table_ID=" + AD_Table_ID);
            return null;
        }
        String cacheKey = String.valueOf(as.getC_AcctSchema_ID()) + "|" + AD_Table_ID;
        IServiceReferenceHolder<IDocFactory> cache = s_DocFactoryCache.get(cacheKey);
        if (cache != null) {
            Doc doc2;
            IDocFactory service2 = cache.getService();
            if (service2 != null && (doc2 = service2.getDocument(as, AD_Table_ID, Record_ID, trxName)) != null) {
                return doc2;
            }
            s_DocFactoryCache.remove(cacheKey);
        }
        ServiceQuery query = new ServiceQuery();
        query.put("gaap", as.getGAAP());
        List<IServiceReferenceHolder<IDocFactory>> factoryList = Service.locator().list(IDocFactory.class, query).getServiceReferences();
        if (factoryList != null) {
            for (IServiceReferenceHolder<IDocFactory> factory : factoryList) {
                service = factory.getService();
                if (service == null || (doc = service.getDocument(as, AD_Table_ID, Record_ID, trxName)) == null) continue;
                s_DocFactoryCache.put(cacheKey, factory);
                return doc;
            }
        }
        query.clear();
        query.put("gaap", "*");
        factoryList = Service.locator().list(IDocFactory.class, query).getServiceReferences();
        if (factoryList != null) {
            for (IServiceReferenceHolder<IDocFactory> factory : factoryList) {
                service = factory.getService();
                if (service == null || (doc = service.getDocument(as, AD_Table_ID, Record_ID, trxName)) == null) continue;
                s_DocFactoryCache.put(cacheKey, factory);
                return doc;
            }
        }
        return null;
    }

    public static Doc getDocument(MAcctSchema as, int AD_Table_ID, ResultSet rs, String trxName) {
        Doc doc;
        IDocFactory service;
        String cacheKey = String.valueOf(as.getC_AcctSchema_ID()) + "|" + AD_Table_ID;
        IServiceReferenceHolder<IDocFactory> cache = s_DocFactoryCache.get(cacheKey);
        if (cache != null) {
            Doc doc2;
            IDocFactory service2 = cache.getService();
            if (service2 != null && (doc2 = service2.getDocument(as, AD_Table_ID, rs, trxName)) != null) {
                return doc2;
            }
            s_DocFactoryCache.remove(cacheKey);
        }
        ServiceQuery query = new ServiceQuery();
        query.put("gaap", as.getGAAP());
        List<IServiceReferenceHolder<IDocFactory>> factoryList = Service.locator().list(IDocFactory.class, query).getServiceReferences();
        if (factoryList != null) {
            for (IServiceReferenceHolder<IDocFactory> factory : factoryList) {
                service = factory.getService();
                if (service == null || (doc = service.getDocument(as, AD_Table_ID, rs, trxName)) == null) continue;
                s_DocFactoryCache.put(cacheKey, factory);
                return doc;
            }
        }
        query.clear();
        query.put("gaap", "*");
        factoryList = Service.locator().list(IDocFactory.class, query).getServiceReferences();
        if (factoryList != null) {
            for (IServiceReferenceHolder<IDocFactory> factory : factoryList) {
                service = factory.getService();
                if (service == null || (doc = service.getDocument(as, AD_Table_ID, rs, trxName)) == null) continue;
                s_DocFactoryCache.put(cacheKey, factory);
                return doc;
            }
        }
        return null;
    }

    public static String postDocument(MAcctSchema[] ass, int AD_Table_ID, int Record_ID, boolean force, boolean repost, String trxName) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String tableName;
        block9: {
            tableName = null;
            int i = 0;
            while (i < DocManager.getDocumentsTableID().length) {
                if (DocManager.getDocumentsTableID()[i] == AD_Table_ID) {
                    tableName = DocManager.getDocumentsTableName()[i];
                    break;
                }
                ++i;
            }
            if (tableName == null) {
                s_log.severe("Table not a financial document. AD_Table_ID=" + AD_Table_ID);
                StringBuilder msgreturn = new StringBuilder("Table not a financial document. AD_Table_ID=").append(AD_Table_ID);
                return msgreturn.toString();
            }
            StringBuilder sql = new StringBuilder("SELECT * FROM ").append(tableName).append(" WHERE ").append(tableName).append("_ID=? AND Processed='Y'");
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            pstmt.setInt(1, Record_ID);
            rs = pstmt.executeQuery();
            if (!rs.next()) break block9;
            String string = DocManager.postDocument(ass, AD_Table_ID, rs, force, repost, trxName);
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return string;
        }
        try {
            s_log.severe("Not Found: " + tableName + "_ID=" + Record_ID);
        }
        catch (Exception e) {
            try {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "NoDoc";
    }

    /*
     * Exception decompiling
     */
    public static String postDocument(MAcctSchema[] ass, int AD_Table_ID, ResultSet rs, boolean force, boolean repost, String trxName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final boolean save(String trxName, int AD_Table_ID, int Record_ID, String status) {
        MTable table = MTable.get(Env.getCtx(), AD_Table_ID);
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(table.getTableName()).append(" SET Posted='").append(status).append("',Processing='N' ").append("WHERE ").append(table.getTableName()).append("_ID=").append(Record_ID);
        CLogger.resetLast();
        int no = DB.executeUpdate(sql.toString(), trxName);
        return no == 1;
    }
}

