/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.util.ModelClassGenerator;
import org.adempiere.util.ModelInterfaceGenerator;
import org.compiere.Adempiere;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateModel {
    private static final CLogger log = CLogger.getCLogger(GenerateModel.class);

    public String toString() {
        StringBuilder sb = new StringBuilder("GenerateModel[").append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        int count;
        block19: {
            Adempiere.startupEnvironment(args.length > 4 && args[4].equals("Client"));
            CLogMgt.setLevel(Level.FINE);
            log.info("Generate Model   $Revision: 1.42 $");
            log.info("----------------------------------");
            String directory = "C:\\Compiere\\compiere-all\\extend\\src\\compiere\\model\\";
            if (args.length > 0) {
                directory = args[0];
            }
            if (directory == null || directory.length() == 0) {
                System.err.println("No Directory");
                System.exit(1);
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Directory: " + directory);
            }
            String packageName = "compiere.model";
            if (args.length > 1) {
                packageName = args[1];
            }
            if (packageName == null || packageName.length() == 0) {
                System.err.println("No package");
                System.exit(1);
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Package:   " + packageName);
            }
            String entityType = "'U','A'";
            if (args.length > 2) {
                entityType = args[2];
            }
            if (entityType == null || entityType.length() == 0) {
                System.err.println("No EntityType");
                System.exit(1);
            }
            StringBuilder entityTypeFilter = new StringBuilder("EntityType IN (").append(entityType).append(")");
            log.info(entityTypeFilter.toString());
            log.info("----------------------------------");
            String tableLike = null;
            tableLike = "'%'";
            if (args.length > 3) {
                tableLike = args[3];
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Table Like: " + tableLike);
            }
            StringBuilder sql = new StringBuilder("SELECT AD_Table_ID FROM AD_Table WHERE (TableName IN ('RV_WarehousePrice','RV_BPartner') OR IsView='N') AND IsActive = 'Y' AND TableName NOT LIKE '%_Trl' AND ");
            sql.append((CharSequence)entityTypeFilter);
            if (tableLike.indexOf(",") == -1) {
                sql.append(" AND TableName LIKE ").append(tableLike);
            } else {
                sql.append(" AND TableName IN (").append(tableLike).append(")");
            }
            sql.append(" ORDER BY TableName");
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        new ModelInterfaceGenerator(rs.getInt(1), directory, packageName, entityTypeFilter.toString());
                        new ModelClassGenerator(rs.getInt(1), directory, packageName, entityTypeFilter.toString());
                        ++count;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Generated = " + count);
        }
    }
}

