/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.X_M_ShipperLabelsCfg;
import org.compiere.model.X_M_ShipperPackagingCfg;
import org.compiere.model.X_M_ShipperPickupTypesCfg;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class ShipperCopyFrom
extends SvrProcess {
    private int p_M_ShipperCfg_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_ShipperCfg_ID")) {
                    this.p_M_ShipperCfg_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i]);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int To_M_ShipperCfg_ID = this.getRecord_ID();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("From M_ShipperCfg_ID=" + this.p_M_ShipperCfg_ID + " to " + To_M_ShipperCfg_ID);
        }
        if (To_M_ShipperCfg_ID == 0) {
            throw new IllegalArgumentException("Target M_ShipperCfg_ID == 0");
        }
        if (this.p_M_ShipperCfg_ID == 0) {
            throw new IllegalArgumentException("Source M_ShipperCfg_ID == 0");
        }
        this.createShipperPackaging(To_M_ShipperCfg_ID);
        this.createShipperLabels(To_M_ShipperCfg_ID);
        this.createShipperPickupTypes(To_M_ShipperCfg_ID);
        return "OK";
    }

    private void createShipperPackaging(int To_M_ShipperCfg_ID) {
        int[] xspIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.p_M_ShipperCfg_ID + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperPackagingCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperPackagingCfg_ID ");
        whereClause.append("FROM M_ShipperPackagingCfg ");
        whereClause.append("WHERE M_ShipperCfg_ID=" + To_M_ShipperCfg_ID + ")");
        int[] nArray = xspIds = X_M_ShipperPackagingCfg.getAllIDs("M_ShipperPackagingCfg", whereClause.toString(), this.get_TrxName());
        int n = xspIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xspId = nArray[n2];
            X_M_ShipperPackagingCfg xsp = new X_M_ShipperPackagingCfg(this.getCtx(), xspId, this.get_TrxName());
            X_M_ShipperPackagingCfg sp = new X_M_ShipperPackagingCfg(this.getCtx(), 0, null);
            sp.setDescription(xsp.getDescription());
            sp.setIsActive(xsp.isActive());
            sp.setIsDefault(xsp.isDefault());
            sp.setName(xsp.getName());
            sp.setValue(xsp.getValue());
            sp.setWeight(xsp.getWeight());
            sp.setM_ShipperCfg_ID(To_M_ShipperCfg_ID);
            sp.saveEx();
            ++n2;
        }
    }

    private void createShipperLabels(int To_M_ShipperCfg_ID) {
        int[] xslIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.p_M_ShipperCfg_ID + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperLabelsCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperLabelsCfg_ID ");
        whereClause.append("FROM M_ShipperLabelsCfg ");
        whereClause.append("WHERE M_ShipperCfg_ID=" + To_M_ShipperCfg_ID + ")");
        int[] nArray = xslIds = X_M_ShipperLabelsCfg.getAllIDs("M_ShipperLabelsCfg", whereClause.toString(), this.get_TrxName());
        int n = xslIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xslId = nArray[n2];
            X_M_ShipperLabelsCfg xsl = new X_M_ShipperLabelsCfg(this.getCtx(), xslId, this.get_TrxName());
            X_M_ShipperLabelsCfg sl = new X_M_ShipperLabelsCfg(this.getCtx(), 0, null);
            sl.setDescription(xsl.getDescription());
            sl.setHeight(xsl.getHeight());
            sl.setIsActive(xsl.isActive());
            sl.setIsDefault(xsl.isDefault());
            sl.setLabelPrintMethod(xsl.getLabelPrintMethod());
            sl.setName(xsl.getName());
            sl.setValue(xsl.getValue());
            sl.setWidth(xsl.getWidth());
            sl.setM_ShipperCfg_ID(To_M_ShipperCfg_ID);
            sl.saveEx();
            ++n2;
        }
    }

    private void createShipperPickupTypes(int To_M_ShipperCfg_ID) {
        int[] xsptIds;
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_ShipperCfg_ID=" + this.p_M_ShipperCfg_ID + " ");
        whereClause.append("AND IsActive='Y' ");
        whereClause.append("AND M_ShipperPickupTypesCfg_ID NOT IN ( ");
        whereClause.append("SELECT M_ShipperPickupTypesCfg_ID ");
        whereClause.append("FROM M_ShipperPickupTypesCfg ");
        whereClause.append("WHERE M_ShipperCfg_ID=" + To_M_ShipperCfg_ID + ")");
        int[] nArray = xsptIds = X_M_ShipperPickupTypesCfg.getAllIDs("M_ShipperPickupTypesCfg", whereClause.toString(), this.get_TrxName());
        int n = xsptIds.length;
        int n2 = 0;
        while (n2 < n) {
            int xsptId = nArray[n2];
            X_M_ShipperPickupTypesCfg xspt = new X_M_ShipperPickupTypesCfg(this.getCtx(), xsptId, this.get_TrxName());
            X_M_ShipperPickupTypesCfg spt = new X_M_ShipperPickupTypesCfg(this.getCtx(), 0, null);
            spt.setDescription(xspt.getDescription());
            spt.setIsActive(xspt.isActive());
            spt.setIsDefault(xspt.isDefault());
            spt.setName(xspt.getName());
            spt.setValue(xspt.getValue());
            spt.setM_ShipperCfg_ID(To_M_ShipperCfg_ID);
            spt.saveEx();
            ++n2;
        }
    }
}

