/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.base.annotation.Process;
import org.adempiere.process.IPrintShippingLabel;
import org.compiere.model.MAttachment;
import org.compiere.model.MPackage;
import org.compiere.model.MShipperLabels;
import org.compiere.process.SvrProcess;

@Process
public class PrintShippingLabel
extends SvrProcess {
    private MPackage m_package;
    private static IServiceReferenceHolder<IPrintShippingLabel> s_serviceReference = null;

    @Override
    protected void prepare() {
        this.m_package = new MPackage(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        MAttachment attachment = this.m_package.getAttachment(true);
        if (attachment == null) {
            return "No labels";
        }
        int labelId = this.m_package.getM_ShipperLabels_ID();
        if (labelId <= 0) {
            return "Label format not defined.";
        }
        IPrintShippingLabel service = PrintShippingLabel.getService();
        if (service != null) {
            MShipperLabels label = new MShipperLabels(this.getCtx(), labelId, this.get_TrxName());
            if ("I".equals(label.getLabelPrintMethod())) {
                return service.printImageLabel(attachment, label, this.getProcessInfo().getTitle());
            }
            return service.printToLabelPrinter(attachment, label);
        }
        return "Not found in service/extension registry and classpath";
    }

    private static synchronized IPrintShippingLabel getService() {
        IPrintShippingLabel service;
        IPrintShippingLabel service2;
        if (s_serviceReference != null && (service2 = s_serviceReference.getService()) != null) {
            return service2;
        }
        IServiceReferenceHolder<IPrintShippingLabel> serviceReference = Service.locator().locate(IPrintShippingLabel.class).getServiceReference();
        if (serviceReference != null && (service = serviceReference.getService()) != null) {
            s_serviceReference = serviceReference;
            return service;
        }
        return null;
    }
}

