/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.model.GenericZoomProvider;
import org.adempiere.model.MRelationType;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ZoomInfoFactory {
    private static final CLogger logger = CLogger.getCLogger(ZoomInfoFactory.class);

    public static List<ZoomInfo> retrieveZoomInfos(PO po, int windowID) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("PO=" + po + " - AD_Window_ID=" + windowID);
        }
        ArrayList<ZoomInfo> result = new ArrayList<ZoomInfo>();
        HashSet<String> alreadySeen = new HashSet<String>();
        for (ZoomInfo zoomInfo : MRelationType.retrieveZoomInfos(po, windowID)) {
            if (!alreadySeen.add(String.valueOf(zoomInfo.destinationDisplay) + "|" + zoomInfo.windowId)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding zoomInfo " + zoomInfo);
            }
            result.add(zoomInfo);
        }
        GenericZoomProvider genericZoomProvider = new GenericZoomProvider();
        for (ZoomInfo zoomInfo : genericZoomProvider.retrieveZoomInfos(po)) {
            if (alreadySeen.add(String.valueOf(zoomInfo.destinationDisplay) + "|" + zoomInfo.windowId)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Adding zoomInfo " + zoomInfo + " from " + GenericZoomProvider.class.getSimpleName());
                }
                result.add(zoomInfo);
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("Skipping zoomInfo " + zoomInfo + " from " + GenericZoomProvider.class.getSimpleName() + " because there is already one for destination '" + zoomInfo.destinationDisplay + "'");
        }
        return result;
    }

    public static final class ZoomInfo {
        public final String destinationDisplay;
        public final MQuery query;
        public final int windowId;

        public ZoomInfo(int windowId, MQuery query, String destinationDisplay) {
            this.windowId = windowId;
            this.query = query;
            this.destinationDisplay = destinationDisplay;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ZoomInfo[");
            sb.append("Display=");
            sb.append(this.destinationDisplay);
            sb.append(", AD_Window_ID=").append(this.windowId);
            sb.append(", RecordCount=").append(this.query == null ? "<no query>" : Integer.valueOf(this.query.getRecordCount()));
            sb.append("]");
            return sb.toString();
        }
    }
}

