/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Wlistbox_Customization;
import org.compiere.util.Util;

public class MWlistboxCustomization
extends X_AD_Wlistbox_Customization {
    private static final long serialVersionUID = -493650011622455985L;

    public MWlistboxCustomization(Properties ctx, int AD_Wlistbox_Customization_ID, String trxName) {
        super(ctx, AD_Wlistbox_Customization_ID, trxName);
    }

    public MWlistboxCustomization(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MWlistboxCustomization get(Properties ctx, int AD_User_ID, String AD_WListboxName, String trxName) {
        Query query = new Query(ctx, "AD_Wlistbox_Customization", "AD_User_ID=? AND WListboxName=?", trxName);
        return (MWlistboxCustomization)query.setClient_ID().setOnlyActiveRecords(true).setParameters(AD_User_ID, AD_WListboxName).first();
    }

    private static List<String> cleanCustomization(String[] CustomizationNew) {
        int i = 0;
        while (i < CustomizationNew.length) {
            CustomizationNew[i] = CustomizationNew[i].substring(0, CustomizationNew[i].indexOf("="));
            ++i;
        }
        return Arrays.asList(CustomizationNew);
    }

    private static int columnIndex(String searchColumnName, List<String> columnList) {
        int i = 0;
        while (i < columnList.size()) {
            if (columnList.get(i).equals(searchColumnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void saveData(Properties ctx, String AD_WListboxName, int AD_User_ID, String Custom, String trxName) {
        MWlistboxCustomization WlistBoxCust = MWlistboxCustomization.get(ctx, AD_User_ID, AD_WListboxName, trxName);
        if (WlistBoxCust != null && WlistBoxCust.getAD_Wlistbox_Customization_ID() > 0) {
            String[] custOrg = WlistBoxCust.getCustom().split(",");
            List<String> newColumnList = Arrays.asList(Custom.trim().split(","));
            ArrayList<String> orgColumnList = new ArrayList<String>(Arrays.asList(WlistBoxCust.getCustom().trim().split(",")));
            if (!orgColumnList.equals(newColumnList)) {
                List<String> columnSearch = MWlistboxCustomization.cleanCustomization(custOrg);
                ArrayList<String> addColumn = new ArrayList<String>();
                int i = 0;
                while (i < newColumnList.size()) {
                    String searchColumnName = newColumnList.get(i).substring(0, newColumnList.get(i).indexOf("="));
                    int n = MWlistboxCustomization.columnIndex(searchColumnName, columnSearch);
                    if (n > -1) {
                        orgColumnList.set(n, newColumnList.get(i).stripLeading());
                    } else {
                        addColumn.add(newColumnList.get(i).stripLeading());
                    }
                    ++i;
                }
                if (addColumn.size() > 0) {
                    orgColumnList.addAll(addColumn);
                }
                int maxLength = MColumn.get(ctx, "AD_Wlistbox_Customization", "Custom").getFieldLength();
                String custom = orgColumnList.toString().substring(1, orgColumnList.toString().length() - 1).replaceAll("\\s", "");
                if (custom.length() > maxLength) {
                    while (custom.length() > maxLength) {
                        custom = custom.substring(0, custom.lastIndexOf(","));
                    }
                }
                WlistBoxCust.setCustom(custom);
            }
        } else if (!Util.isEmpty(Custom)) {
            WlistBoxCust = new MWlistboxCustomization(ctx, 0, trxName);
            WlistBoxCust.setWlistboxName(AD_WListboxName);
            WlistBoxCust.set_ValueNoCheck("AD_User_ID", AD_User_ID);
            WlistBoxCust.setCustom(Custom);
        }
        if (WlistBoxCust != null) {
            WlistBoxCust.saveEx();
        }
    }
}

