/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IZoomProvider;
import org.adempiere.model.ZoomInfoFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class GenericZoomProvider
implements IZoomProvider {
    private static final CLogger logger = CLogger.getCLogger(GenericZoomProvider.class);
    private Map<String, Integer> queries;

    @Override
    public List<ZoomInfoFactory.ZoomInfo> retrieveZoomInfos(PO po) {
        ArrayList<ZoomInfoFactory.ZoomInfo> arrayList;
        boolean detailedZoom = "Y".equals(Env.getContext(Env.getCtx(), "P|IsDetailedZoomAcross"));
        StringBuilder sqlb = new StringBuilder().append("SELECT w.AD_Window_ID, w.Name, tt.Name, f.Name, t.TableName, c.ColumnName, tt.AD_Tab_ID, ");
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
        String tabAlias = baseLanguage ? "tt" : "tt0";
        String justFirstTab = "";
        if (!detailedZoom) {
            justFirstTab = " AND " + tabAlias + ".SeqNo=10 ";
        }
        if (baseLanguage) {
            sqlb.append("tt.SeqNo FROM AD_Table t JOIN AD_Tab tt ON (tt.AD_Table_ID=t.AD_Table_ID AND tt.IsActive='Y' AND tt.Name NOT LIKE 'Used in%' AND tt.IsReadOnly='N' AND tt.IsSortTab='N'").append(justFirstTab).append(") JOIN AD_Window w ON (tt.AD_Window_ID=w.AD_Window_ID AND w.IsActive='Y') JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID AND c.IsActive='Y' AND c.IsKey='N' AND c.IsParent='N' AND c.ColumnSQL IS NULL) JOIN AD_Field f ON (f.AD_Column_ID=c.AD_Column_ID AND f.AD_Tab_ID=tt.AD_Tab_ID AND f.IsActive='Y' AND f.IsDisplayed='Y') ");
        } else {
            sqlb.append("tt0.SeqNo FROM AD_Table t JOIN AD_Tab tt0 ON (tt0.AD_Table_ID=t.AD_Table_ID AND tt0.IsActive='Y' AND tt0.Name NOT LIKE 'Used in%' AND tt0.IsReadOnly='N' AND tt0.IsSortTab='N'").append(justFirstTab).append(") JOIN AD_Tab_Trl tt ON (tt.AD_Tab_ID=tt0.AD_Tab_ID AND tt.AD_Language=?) JOIN AD_Window w0 ON (tt0.AD_Window_ID=w0.AD_Window_ID AND w0.IsActive='Y') JOIN AD_Window_Trl w ON (w.AD_Window_ID=w0.AD_Window_ID AND w.AD_Language=?) JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID AND c.IsActive='Y' AND c.IsKey='N' AND c.IsParent='N' AND c.ColumnSQL IS NULL) JOIN AD_Field f0 ON (f0.AD_Column_ID=c.AD_Column_ID AND f0.AD_Tab_ID=tt0.AD_Tab_ID AND f0.IsActive='Y' AND f0.IsDisplayed='Y') JOIN AD_Field_Trl f ON (f.AD_Field_ID=f0.AD_Field_ID AND f.AD_Language=?) ");
        }
        sqlb.append("LEFT JOIN AD_Ref_Table r ON (c.AD_Reference_Value_ID=r.AD_Reference_ID) LEFT JOIN AD_Table tr ON (r.AD_Table_ID=tr.AD_Table_ID) WHERE t.IsActive='Y' \tAND t.TableName NOT LIKE 'I|_%' ESCAPE '|' \tAND t.TableName NOT LIKE 'T|_%' ESCAPE '|' \tAND t.IsView='N' ");
        if (detailedZoom) {
            sqlb.append(" AND (    ( c.ColumnName=? AND c.AD_Reference_ID=19) ");
            if ("C_Location_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(21);
            } else if ("C_ValidCombination_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(25);
            } else if ("M_Locator_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(31);
            } else if ("AD_Image_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(32);
            } else if ("S_ResourceAssignment_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(33);
            } else if ("M_AttributeSetInstance_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(35);
            } else if ("AD_Chart_ID".equals(po.get_KeyColumns()[0])) {
                sqlb.append(" OR c.AD_Reference_ID=").append(53370);
            }
            sqlb.append("     OR ( c.ColumnName=? AND c.AD_Reference_ID=30 AND c.AD_Reference_Value_ID IS NULL )        OR ( c.AD_Reference_ID IN (18, 30) AND c.AD_Reference_Value_ID=r.AD_Reference_ID AND tr.TableName=? ) ) ");
        } else {
            sqlb.append(" AND c.ColumnName=? ");
        }
        sqlb.append(" ORDER BY 2, 8");
        CPreparedStatement pstmt = DB.prepareStatement(sqlb.toString(), null);
        ResultSet rs = null;
        try {
            int index = 1;
            if (!baseLanguage) {
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
                pstmt.setString(index++, Env.getAD_Language(Env.getCtx()));
            }
            pstmt.setString(index++, po.get_KeyColumns()[0]);
            if (detailedZoom) {
                pstmt.setString(index++, po.get_KeyColumns()[0]);
                pstmt.setString(index++, po.get_TableName());
            }
            rs = pstmt.executeQuery();
            ArrayList<ZoomInfoFactory.ZoomInfo> result = new ArrayList<ZoomInfoFactory.ZoomInfo>();
            this.queries = new HashMap<String, Integer>();
            while (rs.next()) {
                MQuery query;
                int AD_Window_ID = rs.getInt(1);
                String winName = rs.getString(2);
                String tabName = rs.getString(3);
                String fldName = rs.getString(4);
                String targetTableName = rs.getString(5);
                String targetColumnName = rs.getString(6);
                int AD_Tab_ID = rs.getInt(7);
                Boolean access = MRole.getDefault().getWindowAccess(AD_Window_ID);
                if (access == null || (query = this.evaluateQuery(targetTableName, targetColumnName, AD_Tab_ID, po)) == null || query.getRecordCount() <= 0) continue;
                if (detailedZoom) {
                    result.add(new ZoomInfoFactory.ZoomInfo(AD_Window_ID, query, String.valueOf(winName) + " / " + tabName + " / " + fldName));
                    continue;
                }
                result.add(new ZoomInfoFactory.ZoomInfo(AD_Window_ID, query, winName));
            }
            this.queries = null;
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                logger.log(Level.SEVERE, sqlb.toString(), e);
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return arrayList;
    }

    private MQuery evaluateQuery(String targetTableName, String targetColumnName, int AD_Tab_ID, PO po) {
        MTab tab;
        Properties ctx = Env.getCtx();
        int clientID = Env.getAD_Client_ID(ctx);
        MQuery query = new MQuery();
        MTable table = MTable.get(ctx, targetTableName);
        if (!table.columnExistsInDB("AD_Client_ID")) {
            return null;
        }
        int tabIDLoop = AD_Tab_ID;
        int levelUp = 0;
        do {
            String whereCtx;
            if (!Util.isEmpty(whereCtx = (tab = MTab.get(tabIDLoop)).getWhereClause(), true)) {
                if (whereCtx.indexOf("@") != -1) {
                    whereCtx = Env.parseVariable(whereCtx, po, null, true);
                }
                if (whereCtx.indexOf("@") != -1) {
                    return null;
                }
                if (levelUp == 0) {
                    query.addRestriction("(" + whereCtx + ")");
                } else if (levelUp == 1) {
                    MTable parentTable = MTable.get(ctx, tab.getAD_Table_ID());
                    String parentTableName = parentTable.getTableName();
                    StringBuilder subquery = new StringBuilder().append(parentTableName).append("_ID IN (SELECT ").append(parentTableName).append("_ID FROM ").append(parentTableName).append(" WHERE ").append(whereCtx).append(")");
                    query.addRestriction("(" + subquery + ")");
                } else {
                    return null;
                }
            }
            ++levelUp;
        } while ((tabIDLoop = tab.getParentTabID()) >= 0);
        query.addRestriction(String.valueOf(targetTableName) + "." + targetColumnName + "=" + po.get_ID());
        query.setZoomTableName(targetTableName);
        query.setZoomColumnName(targetColumnName);
        query.setZoomValue(po.get_ID());
        String accessLevel = table.getAccessLevel();
        if (clientID != 0 && "4".equals(accessLevel)) {
            return null;
        }
        if (clientID != 0 && ("7".equals(accessLevel) || "6".equals(accessLevel))) {
            query.addRestriction(String.valueOf(targetTableName) + ".AD_Client_ID IN (0, " + clientID + ")");
        } else {
            query.addRestriction(String.valueOf(targetTableName) + ".AD_Client_ID=" + clientID);
        }
        StringBuilder sqlb = new StringBuilder("SELECT COUNT(*) FROM ").append(targetTableName).append(" WHERE ").append(query.getWhereClause(true));
        String sql = sqlb.toString();
        int count = -1;
        if (this.queries.containsKey(sql)) {
            count = this.queries.get(sql);
        } else {
            int timeout = MSysConfig.getIntValue("ZOOM_ACROSS_QUERY_TIMEOUT", 5, Env.getAD_Client_ID(Env.getCtx()));
            count = this.getSQLValueTimeout(null, sql, timeout);
            this.queries.put(sql, count);
        }
        query.setRecordCount(count);
        return query;
    }

    private int getSQLValueTimeout(Object object, String sql, int timeOut) {
        int retValue;
        block7: {
            retValue = -1;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    if (timeOut > 0) {
                        pstmt.setQueryTimeout(timeOut);
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    logger.warning(String.valueOf(e.getMessage()) + " -> " + sql);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

