/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.adempiere.base.IGridTabImporter;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MColumn;
import org.compiere.model.MLocation;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MRefTable;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Location;
import org.compiere.process.ProcessInfo;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWFProcess;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCsvCellProcessorException;
import org.supercsv.io.CsvMapReader;
import org.supercsv.io.ICsvMapReader;
import org.supercsv.prefs.CsvPreference;

public class GridTabCSVImporter
implements IGridTabImporter {
    private static final String ERROR_HEADER = "_ERROR_";
    private static final String LOG_HEADER = "_LOG_";
    private static final String IMPORT_MODE_MERGE = "M";
    private static final String IMPORT_MODE_UPDATE = "U";
    private static final String IMPORT_MODE_INSERT = "I";
    private boolean m_isError = false;
    private String m_import_mode = null;
    private List<String> header;
    private List<CellProcessor> readProcArray;
    private List<GridField> locationFields;
    private boolean isThereKey;
    private boolean isThereDocAction;
    private Map<GridTab, Integer> tabMapIndexes;
    private List<Map<String, Object>> data;
    private ICsvMapReader mapReader;
    private TreeMap<GridTab, Integer> sortedtTabMapIndexes;
    private List<String> rawData;
    private boolean isMasterok = true;
    private boolean isDetailok = true;
    private boolean error = false;
    private List<String> rowsTmpResult;
    private PO masterRecord;
    private File errFile;
    private File logFile;
    private PrintWriter errFileW;
    private PrintWriter logFileW;
    private CsvPreference csvpref = CsvPreference.STANDARD_PREFERENCE;
    private String delimiter = String.valueOf((char)this.csvpref.getDelimiterChar());
    private String quoteChar = String.valueOf(this.csvpref.getQuoteChar());
    private Trx trx;
    private String trxName;
    private boolean isSingleTrx = false;
    private static final CLogger log = CLogger.getCLogger(GridTabCSVImporter.class);

    @Override
    public File fileImport(GridTab gridTab, List<GridTab> childs, InputStream filestream, Charset charset, String importMode) {
        return this.fileImport(gridTab, childs, filestream, charset, importMode, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File fileImport(GridTab gridTab, List<GridTab> childs, InputStream filestream, Charset charset, String importMode, IProcessUI processUI) {
        if (!gridTab.isInsertRecord() && this.isInsertMode()) {
            this.throwAdempiereException("Insert record disabled for Tab");
        }
        try {
            try {
                errFileName = FileUtil.getTempMailName("Import_" + gridTab.getTableName(), "_err.csv");
                this.initValues();
                this.m_import_mode = importMode;
                this.errFile = new File(errFileName);
                this.errFileW = new PrintWriter(this.errFile, charset.name());
                this.mapReader = new CsvMapReader((Reader)new InputStreamReader(filestream, charset), this.csvpref);
                this.header = Arrays.asList(this.mapReader.getHeader(true));
                indxDetail = this.mapCSVHeader(gridTab);
                if (this.isUpdateOrMergeMode() && !this.isThereKey) {
                    this.throwAdempiereException(String.valueOf(gridTab.getTableName()) + ": " + Msg.getMsg(Env.getCtx(), "NoKeyFound"));
                }
                this.tabMapIndexes.put(gridTab, indxDetail - 1);
                this.isThereKey = false;
                this.locationFields = null;
                this.mapCSVDetail(indxDetail, childs);
                this.sortedtTabMapIndexes = null;
                if (childs.size() > 0 && !this.tabMapIndexes.isEmpty()) {
                    bvc = new ValueComparator(this.tabMapIndexes);
                    this.sortedtTabMapIndexes = new TreeMap<GridTab, V>(bvc);
                    this.sortedtTabMapIndexes.putAll(this.tabMapIndexes);
                } else {
                    localMapIndexes = new HashMap<GridTab, Integer>();
                    localMapIndexes.put(gridTab, this.header.size() - 1);
                    bvc = new ValueComparator(localMapIndexes);
                    this.sortedtTabMapIndexes = new TreeMap<GridTab, V>(bvc);
                    this.sortedtTabMapIndexes.putAll(localMapIndexes);
                }
                this.m_isError = false;
                rawHeader = this.mapReader.getUntokenizedRow();
                this.errFileW.write(String.valueOf(rawHeader) + this.delimiter + "_ERROR_" + "\n");
                this.data = new ArrayList<Map<String, Object>>();
                this.rawData = new ArrayList<String>();
                this.preProcess(processUI, gridTab, indxDetail);
                if (!this.m_isError) {
                    logFileName = FileUtil.getTempMailName("Import_" + gridTab.getTableName(), "_log.csv");
                    this.logFile = new File(logFileName);
                    this.logFileW = new PrintWriter(this.logFile, charset.name());
                    this.logFileW.write(String.valueOf(rawHeader) + this.delimiter + "_LOG_" + "\n");
                    this.isMasterok = true;
                    this.isDetailok = true;
                    this.error = false;
                    this.trx = null;
                    this.trxName = null;
                    this.rowsTmpResult = new ArrayList<String>();
                    lastOutput = new Date().getTime();
                    idx = 0;
                    while (idx < this.data.size()) {
                        if (processUI != null && new Date().getTime() - lastOutput > 1000L) {
                            processUI.statusUpdate(this.refreshImportStatus(idx + 1, this.data.size() + 1));
                            lastOutput = new Date().getTime();
                        }
                        rawLine = this.rawData.get(idx);
                        rowResult = new StringBuilder();
                        isDetail = false;
                        if (rawLine.charAt(0) == ',') {
                            isDetail = true;
                            rowMap = this.data.get(idx);
                            i = 0;
                            while (i < indxDetail - 1) {
                                if (rowMap.get(this.header.get(i)) != null) {
                                    isDetail = false;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (!this.isMasterok && isDetail) {
                            rawLine = String.valueOf(rawLine) + this.delimiter + this.quoteChar + Msg.getMsg(Env.getCtx(), "NotProcessed") + this.quoteChar + "\n";
                            this.rowsTmpResult.add(rawLine);
                        } else if (this.isMasterok && isDetail && !this.isDetailok) {
                            rawLine = String.valueOf(rawLine) + this.delimiter + this.quoteChar + "Record not proccesed due to detail record failure" + this.quoteChar + "\n";
                            this.rowsTmpResult.add(rawLine);
                        } else {
                            if (this.isSingleTrx() && this.trx == null) {
                                this.createTrx(gridTab);
                            }
                            if (!isDetail && !this.isSingleTrx()) {
                                this.manageMasterTrx(gridTab, null);
                                this.createTrx(gridTab);
                            }
                            if (this.trx != null) {
                                this.trx.setDisplayName(String.valueOf(GridTabCSVImporter.class.getName()) + "_fileImport_" + gridTab.getTableName());
                            }
                            recordResult = this.processRecord(importMode, gridTab, indxDetail, isDetail, idx, rowResult, childs);
                            rowResult.append(recordResult);
                            rawLine = String.valueOf(rawLine) + this.delimiter + this.quoteChar + rowResult.toString().replaceAll(this.delimiter, "") + this.quoteChar + "\n";
                            this.rowsTmpResult.add(rawLine);
                            if (this.isSingleTrx() && this.isError()) break;
                        }
                        ++idx;
                    }
                    this.manageMasterTrx(gridTab, childs);
                }
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
            catch (Exception ex) {
                throw new AdempiereException(ex);
            }
        }
        finally {
            try {
                if (this.mapReader != null) {
                    this.mapReader.close();
                }
                if (this.errFileW != null) {
                    this.errFileW.flush();
                    this.errFileW.close();
                }
                if (this.logFileW != null) {
                    this.logFileW.flush();
                    this.logFileW.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            gridTab.getTableModel().setImportingMode(false, null);
            ** for (detail : childs)
        }
lbl-1000:
        // 1 sources

        {
            detail.getTableModel().setImportingMode(false, null);
            continue;
        }
lbl119:
        // 1 sources

        gridTab.dataRefreshAll();
        if (this.logFile != null) {
            return this.logFile;
        }
        return this.errFile;
    }

    private void initValues() {
        this.mapReader = null;
        this.errFile = null;
        this.logFile = null;
        this.errFileW = null;
        this.logFileW = null;
        this.masterRecord = null;
        this.readProcArray = new ArrayList<CellProcessor>();
        this.tabMapIndexes = new HashMap<GridTab, Integer>();
        this.locationFields = null;
        this.isThereKey = false;
        this.isThereDocAction = false;
    }

    private void rollbackTrx() {
        this.trx.rollback();
        for (String row : this.rowsTmpResult) {
            row = row.replaceAll("Updated", "RolledBack");
            row = row.replaceAll("Inserted", "RolledBack");
            this.logFileW.write(row);
        }
    }

    private String commitTrx() {
        try {
            this.trx.commit(true);
        }
        catch (SQLException e) {
            this.setError(true);
            return e.getLocalizedMessage();
        }
        for (String row : this.rowsTmpResult) {
            this.logFileW.write(row);
        }
        return null;
    }

    private int mapCSVHeader(GridTab gridTab) {
        int indxDetail = 0;
        int idx = 0;
        while (idx < this.header.size()) {
            String headName = this.header.get(idx);
            if (headName == null) {
                this.throwAdempiereException("Header column cannot be empty, Col: " + (idx + 1));
            }
            if (headName.equals(ERROR_HEADER) || headName.equals(LOG_HEADER)) {
                this.header.set(idx, null);
                this.readProcArray.add(null);
            } else if (headName.indexOf(">") > 0) {
                if (idx == 0) {
                    this.throwAdempiereException(Msg.getMsg(Env.getCtx(), "WrongHeader", new Object[]{headName}));
                } else {
                    if (!headName.contains(MTable.getTableName(Env.getCtx(), 162)) || this.locationFields != null) break;
                    this.locationFields = this.getSpecialMColumn(this.header, MTable.getTableName(Env.getCtx(), 162), idx);
                    for (GridField sField : this.locationFields) {
                        this.readProcArray.add(this.getProccesorFromColumn(sField));
                        ++indxDetail;
                    }
                    idx = indxDetail;
                }
            } else {
                boolean isForeing;
                boolean isKeyColumn = headName.indexOf("/") > 0;
                String columnName = this.getColumnName(isKeyColumn, isForeing = headName.indexOf("[") > 0 && headName.indexOf("]") > 0, false, headName);
                GridField field = gridTab.getField(columnName);
                if (field == null) {
                    this.throwAdempiereException(Msg.getMsg(Env.getCtx(), "FieldNotFound", new Object[]{columnName}));
                } else if (isKeyColumn && !this.isThereKey) {
                    this.isThereKey = true;
                } else if (!this.isThereDocAction && MColumn.get(Env.getCtx(), field.getAD_Column_ID()).getAD_Reference_Value_ID() == 135) {
                    this.isThereDocAction = true;
                }
                this.readProcArray.add(this.getProccesorFromColumn(field));
                ++indxDetail;
            }
            ++idx;
        }
        return indxDetail;
    }

    private void mapCSVDetail(int indxDetail, List<GridTab> childs) {
        String childTableName = null;
        GridTab currentDetailTab = null;
        int idx = indxDetail;
        while (idx < this.header.size()) {
            String detailName = this.header.get(idx);
            if (detailName != null && detailName.indexOf(">") > 0) {
                String columnName;
                childTableName = detailName.substring(0, detailName.indexOf(">"));
                if (currentDetailTab == null || currentDetailTab != null && !childTableName.equals(currentDetailTab.getTableName())) {
                    if (currentDetailTab != null) {
                        if (this.isUpdateOrMergeMode() && !this.isThereKey) {
                            this.throwAdempiereException(String.valueOf(currentDetailTab.getTableName()) + ": " + Msg.getMsg(Env.getCtx(), "NoKeyFound"));
                        } else {
                            this.tabMapIndexes.put(currentDetailTab, idx - 1);
                            this.isThereKey = false;
                        }
                    }
                    for (GridTab detail : childs) {
                        if (!detail.getTableName().equals(childTableName)) continue;
                        currentDetailTab = detail;
                        break;
                    }
                }
                if (currentDetailTab == null) {
                    this.throwAdempiereException(Msg.getMsg(Env.getCtx(), "NoChildTab", new Object[]{childTableName}));
                }
                if ((columnName = detailName).contains(MTable.getTableName(Env.getCtx(), 162)) && this.locationFields == null) {
                    this.locationFields = this.getSpecialMColumn(this.header, MTable.getTableName(Env.getCtx(), 162), idx);
                    for (GridField sField : this.locationFields) {
                        this.readProcArray.add(this.getProccesorFromColumn(sField));
                        ++idx;
                    }
                    --idx;
                } else {
                    boolean isForeing;
                    boolean isKeyColumn = columnName.indexOf("/") > 0;
                    GridField field = currentDetailTab.getField(columnName = this.getColumnName(isKeyColumn, isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0, true, columnName));
                    if (field == null) {
                        this.throwAdempiereException(Msg.getMsg(Env.getCtx(), "FieldNotFound", new Object[]{detailName}));
                    } else if (isKeyColumn && !this.isThereKey) {
                        this.isThereKey = true;
                    }
                    this.readProcArray.add(this.getProccesorFromColumn(field));
                }
            } else {
                this.throwAdempiereException(Msg.getMsg(Env.getCtx(), "WrongDetailName", new Object[]{" col(" + idx + ") ", detailName}));
            }
            ++idx;
        }
        if (currentDetailTab != null) {
            if (this.isUpdateOrMergeMode() && !this.isThereKey) {
                this.throwAdempiereException(String.valueOf(currentDetailTab.getTableName()) + ": " + Msg.getMsg(Env.getCtx(), "NoKeyFound"));
            }
            this.tabMapIndexes.put(currentDetailTab, this.header.size() - 1);
        }
    }

    private void preProcess(IProcessUI processUI, GridTab gridTab, int indxDetail) {
        CellProcessor[] processors = this.readProcArray.toArray(new CellProcessor[this.readProcArray.size()]);
        long lastOutput = new Date().getTime();
        while (true) {
            if (processUI != null && new Date().getTime() - lastOutput > 1000L) {
                processUI.statusUpdate(this.refreshImportStatus(this.data.size(), 0));
                lastOutput = new Date().getTime();
            }
            Map map = null;
            boolean isLineError = false;
            StringBuilder errMsg = new StringBuilder();
            try {
                String[] hdrs = new String[this.header.size()];
                this.header.toArray(hdrs);
                map = this.mapReader.read(hdrs, processors);
            }
            catch (SuperCsvCellProcessorException e) {
                int idx = e.getCsvContext().getColumnNumber() - 1;
                errMsg.append(this.header.get(idx)).append(": ").append(e.getMessage());
                isLineError = true;
            }
            catch (IOException e) {
                throw new AdempiereException(e);
            }
            String rawLine = this.mapReader.getUntokenizedRow();
            if (!isLineError) {
                if (map == null) break;
                List<Object> tmpRow = this.getOrderedRowFromMap(this.header, map);
                int initIndx = 0;
                for (Map.Entry<GridTab, Integer> tabIndex : this.sortedtTabMapIndexes.entrySet()) {
                    GridTab tmpGrid = tabIndex.getKey();
                    if (gridTab.equals(tmpGrid) && tmpRow.get(0) == null) {
                        initIndx = indxDetail;
                        continue;
                    }
                    int endindx = tabIndex.getValue();
                    StringBuilder lineError = this.preprocessRow(tmpGrid, this.header, tmpRow, initIndx, endindx);
                    if (lineError != null && lineError.length() > 0) {
                        isLineError = true;
                        if (errMsg.length() > 0) {
                            errMsg.append(" / ");
                        }
                        errMsg.append((CharSequence)lineError);
                    }
                    initIndx = endindx + 1;
                }
            }
            if (isLineError && !this.m_isError) {
                this.m_isError = true;
            }
            if (!this.m_isError) {
                this.data.add(map);
                this.rawData.add(rawLine);
            }
            rawLine = String.valueOf(rawLine) + this.delimiter + this.quoteChar + errMsg.toString().replaceAll(this.quoteChar, "") + this.quoteChar + "\n";
            this.errFileW.write(rawLine);
        }
    }

    private void manageMasterTrx(GridTab gridTab, List<GridTab> childs) {
        if (this.trx != null) {
            try {
                if (this.isError()) {
                    gridTab.dataDelete();
                    this.rollbackTrx();
                    this.setError(false);
                } else {
                    boolean commit = false;
                    if (this.isThereDocAction) {
                        boolean isError = false;
                        int AD_Process_ID = MColumn.get(Env.getCtx(), gridTab.getField("DocAction").getAD_Column_ID()).getAD_Process_ID();
                        if (AD_Process_ID > 0) {
                            String docResult = this.processDocAction(this.masterRecord, AD_Process_ID);
                            if (docResult.contains("error")) {
                                isError = true;
                            }
                            this.rowsTmpResult.set(0, this.rowsTmpResult.get(0).replace(String.valueOf(this.quoteChar) + "\n", String.valueOf(docResult) + this.quoteChar + "\n"));
                        } else {
                            this.throwAdempiereException("No Process found for document action.");
                        }
                        if (isError) {
                            gridTab.dataDelete();
                            this.rollbackTrx();
                        } else {
                            commit = true;
                        }
                    } else {
                        commit = true;
                    }
                    if (commit) {
                        String commitResult = this.commitTrx();
                        if (this.isError()) {
                            this.rowsTmpResult.set(0, this.rowsTmpResult.get(0).replace(String.valueOf(this.quoteChar) + "\n", String.valueOf(commitResult) + this.quoteChar + "\n"));
                            gridTab.dataDelete();
                            this.rollbackTrx();
                        }
                    }
                }
            }
            finally {
                this.trx.close();
                this.trx = null;
            }
        }
    }

    private void createTrx(GridTab gridTab) {
        this.trxName = Trx.createTrxName("CSVImport");
        gridTab.getTableModel().setImportingMode(true, this.trxName);
        this.trx = Trx.get(this.trxName, true);
        this.masterRecord = null;
        this.rowsTmpResult.clear();
        this.isMasterok = true;
        this.isDetailok = true;
    }

    private String processRecord(String importMode, GridTab gridTab, int indxDetail, boolean isDetail, int idx, StringBuilder rowResult, List<GridTab> childs) {
        block31: {
            String logMsg = null;
            GridTab currentGridTab = null;
            int currentColumn = 0;
            try {
                try {
                    for (Map.Entry<GridTab, Integer> tabIndex : this.sortedtTabMapIndexes.entrySet()) {
                        block36: {
                            block32: {
                                block35: {
                                    block33: {
                                        PO po;
                                        block34: {
                                            int recordId;
                                            currentGridTab = tabIndex.getKey();
                                            if (isDetail && gridTab.equals(currentGridTab)) {
                                                currentColumn = indxDetail;
                                                continue;
                                            }
                                            if (!gridTab.equals(currentGridTab)) {
                                                currentGridTab.getTableModel().setImportingMode(true, this.trxName);
                                                isDetail = true;
                                            }
                                            int j = tabIndex.getValue();
                                            logMsg = this.areValidKeysAndColumns(currentGridTab, this.data.get(idx), this.header, currentColumn, j, this.masterRecord, this.trx);
                                            if (logMsg == null) {
                                                if (this.isInsertMode()) {
                                                    if (!currentGridTab.getTableModel().isOpen()) {
                                                        currentGridTab.getTableModel().open(0);
                                                    }
                                                    if (!currentGridTab.dataNew(false)) {
                                                        logMsg = "[" + currentGridTab.getName() + "]" + "- Was not able to create a new record!";
                                                    } else {
                                                        currentGridTab.navigateCurrent();
                                                        if (!isDetail) {
                                                            for (GridTab child : childs) {
                                                                child.query(false);
                                                            }
                                                        }
                                                    }
                                                }
                                                if (logMsg == null) {
                                                    logMsg = this.proccessRow(currentGridTab, this.header, this.data.get(idx), currentColumn, j, this.masterRecord, this.trx);
                                                }
                                                currentColumn = j + 1;
                                                if (logMsg != null) {
                                                    this.m_import_mode = importMode;
                                                    if ("NO_DATA_TO_IMPORT".equals(logMsg)) {
                                                        logMsg = "";
                                                        continue;
                                                    }
                                                    this.setError(true);
                                                }
                                            } else {
                                                this.setError(true);
                                                currentColumn = j + 1;
                                            }
                                            if (this.isError()) break block32;
                                            if (!currentGridTab.dataSave(false)) break block33;
                                            po = currentGridTab.getTableModel().getPO(currentGridTab.getCurrentRow());
                                            if (currentGridTab.equals(gridTab)) {
                                                this.masterRecord = po;
                                            }
                                            if (!this.isInsertMode()) break block34;
                                            logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "Inserted")) + " " + po.toString();
                                            if (!Util.isEmpty(currentGridTab.getKeyColumnName()) && currentGridTab.getKeyColumnName().endsWith("_ID") && (recordId = currentGridTab.getRecord_ID()) > 0) {
                                                if (currentGridTab.getTabNo() == 0) {
                                                    Env.setContext(Env.getCtx(), currentGridTab.getWindowNo(), currentGridTab.getKeyColumnName(), recordId);
                                                }
                                                Env.setContext(Env.getCtx(), currentGridTab.getWindowNo(), currentGridTab.getTabNo(), currentGridTab.getKeyColumnName(), Integer.toString(recordId));
                                            }
                                            break block35;
                                        }
                                        logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "Updated")) + " " + po.toString();
                                        if (!currentGridTab.equals(gridTab) || this.sortedtTabMapIndexes.size() <= 1) break block35;
                                        currentGridTab.dataRefresh(true);
                                        break block35;
                                    }
                                    ValueNamePair ppE = CLogger.retrieveWarning();
                                    if (ppE == null) {
                                        ppE = CLogger.retrieveError();
                                    }
                                    String info = null;
                                    if (ppE != null) {
                                        info = ppE.getName();
                                    }
                                    if (info == null) {
                                        info = "";
                                    }
                                    logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "Error")) + " " + Msg.getMsg(Env.getCtx(), "SaveError") + " (" + info + ")";
                                    currentGridTab.dataIgnore();
                                    if (currentGridTab.equals(gridTab) && this.masterRecord == null) {
                                        this.isMasterok = false;
                                        rowResult.append("<" + currentGridTab.getTableName() + ">: ");
                                        rowResult.append(logMsg);
                                        rowResult.append(" / ");
                                        break;
                                    }
                                    if (!currentGridTab.equals(gridTab) && this.masterRecord != null) {
                                        this.isDetailok = false;
                                        rowResult.append("<" + currentGridTab.getTableName() + ">: ");
                                        rowResult.append(logMsg);
                                        rowResult.append(" / ");
                                        break;
                                    }
                                }
                                rowResult.append("<" + currentGridTab.getTableName() + ">: ");
                                rowResult.append(logMsg);
                                rowResult.append(" / ");
                                break block36;
                            }
                            currentGridTab.dataIgnore();
                            rowResult.append("<" + currentGridTab.getTableName() + ">: ");
                            rowResult.append(logMsg);
                            rowResult.append(" / ");
                            if (currentGridTab.equals(gridTab) && this.masterRecord == null) {
                                this.isMasterok = false;
                                break;
                            }
                            if (!currentGridTab.equals(gridTab) && this.masterRecord != null) {
                                this.isDetailok = false;
                                break;
                            }
                        }
                        this.m_import_mode = importMode;
                    }
                }
                catch (Exception e) {
                    rowResult.append("<" + currentGridTab.getTableName() + ">: ");
                    rowResult.append(String.valueOf(Msg.getMsg(Env.getCtx(), "Error")) + " " + e);
                    rowResult.append(" / ");
                    currentGridTab.dataIgnore();
                    this.setError(true);
                    if (currentGridTab.equals(gridTab) && this.masterRecord == null) {
                        this.isMasterok = false;
                    }
                    if (!currentGridTab.equals(gridTab) && this.masterRecord != null) {
                        this.isDetailok = false;
                    }
                    this.m_import_mode = importMode;
                    break block31;
                }
            }
            catch (Throwable throwable) {
                this.m_import_mode = importMode;
                throw throwable;
            }
            this.m_import_mode = importMode;
        }
        return rowResult.toString();
    }

    private void throwAdempiereException(String msg) {
        throw new AdempiereException(msg);
    }

    private String refreshImportStatus(int currentRecord, int total) {
        int percent = currentRecord * 100;
        percent = total > 0 ? (percent /= total) : 0;
        if (percent == 0) {
            Object[] args = new Object[]{currentRecord};
            return Msg.getMsg(Env.getCtx(), "PreProcessingCVSProgress", args);
        }
        Object[] args = new Object[]{currentRecord, total, percent};
        return Msg.getMsg(Env.getCtx(), "PercentProcessingProgress", args);
    }

    private String processDocAction(PO document, int AD_Process_ID) {
        int AD_Workflow_ID = MProcess.get(Env.getCtx(), AD_Process_ID).getAD_Workflow_ID();
        if (AD_Workflow_ID > 0) {
            ProcessInfo wfProcess = new ProcessInfo(document.get_TrxName(), AD_Process_ID, document.get_Table_ID(), document.get_ID());
            wfProcess.setTransactionName(document.get_TrxName());
            MWFProcess wdPro = ProcessUtil.startWorkFlow(Env.getCtx(), wfProcess, AD_Workflow_ID);
            if (wdPro == null) {
                return "Document action could not be proccesed";
            }
            if (wfProcess.isError()) {
                return "Document action error: " + wfProcess.getSummary();
            }
            return "Document action processed [" + wfProcess.getSummary() + "]";
        }
        return "No workflow was found";
    }

    private boolean isInsertMode() {
        return IMPORT_MODE_INSERT.equals(this.m_import_mode);
    }

    private boolean isUpdateMode() {
        return IMPORT_MODE_UPDATE.equals(this.m_import_mode);
    }

    private boolean isMergeMode() {
        return IMPORT_MODE_MERGE.equals(this.m_import_mode);
    }

    private boolean isUpdateOrMergeMode() {
        return this.isUpdateMode() || this.isMergeMode();
    }

    private String getColumnName(boolean isKey, boolean isForeing, boolean isDetail, String headName) {
        if (isKey && headName.indexOf("/") > 0) {
            if (headName.endsWith("K")) {
                headName = headName.substring(0, headName.length() - 2);
            } else if (headName.endsWith("KT")) {
                this.setSingleTrx(true);
                headName = headName.substring(0, headName.length() - 3);
            } else {
                throw new AdempiereException(String.valueOf(Msg.getMsg(Env.getCtx(), "ColumnKey")) + " " + headName);
            }
        }
        if (isForeing) {
            headName = headName.substring(0, headName.indexOf("["));
        }
        if (isDetail && (headName = headName.substring(headName.indexOf(">") + 1, headName.length())).indexOf(">") > 0) {
            headName = headName.substring(headName.indexOf(">") + 1, headName.length());
        }
        return headName;
    }

    private List<GridField> getSpecialMColumn(List<String> header, String tableName, int idx) {
        ArrayList<GridField> lsField = new ArrayList<GridField>();
        if (tableName.equals(MTable.getTableName(Env.getCtx(), 162))) {
            GridWindowVO gWindowVO = Env.getMWindowVO(0, 121, 0);
            GridWindow m_mWindow = new GridWindow(gWindowVO);
            GridTab m_mTab = m_mWindow.getTab(0);
            m_mWindow.initTab(0);
            int i = idx;
            while (i < header.size()) {
                boolean isForeing;
                if (!header.get(i).contains(MTable.getTableName(Env.getCtx(), 162))) break;
                boolean isKeyColumn = header.get(i).indexOf("/") > 0;
                String columnName = this.getColumnName(isKeyColumn, isForeing = header.get(i).indexOf("[") > 0 && header.get(i).indexOf("]") > 0, true, header.get(i));
                GridField field = m_mTab.getField(columnName);
                if (field == null) {
                    throw new AdempiereException(Msg.getMsg(Env.getCtx(), "FieldNotFound", new Object[]{header.get(i)}));
                }
                lsField.add(field);
                ++i;
            }
        }
        return lsField;
    }

    private List<Object> getOrderedRowFromMap(List<String> header, Map<String, Object> map) {
        ArrayList<Object> tmpRow = new ArrayList<Object>();
        int i = 0;
        while (i < header.size()) {
            tmpRow.add(null);
            ++i;
        }
        for (Map.Entry<String, Object> record : map.entrySet()) {
            String Column = record.getKey();
            Object value = record.getValue();
            int toIndx = header.indexOf(Column);
            tmpRow.set(toIndx, value);
        }
        return tmpRow;
    }

    private StringBuilder preprocessRow(GridTab gridTab, List<String> header, List<Object> tmpRow, int startindx, int endindx) {
        boolean isEmptyRow = true;
        boolean isAddressValidated = false;
        StringBuilder mandatoryColumns = new StringBuilder();
        int i = startindx;
        while (i < endindx + 1) {
            block24: {
                GridField field;
                Object value;
                String columnName;
                block22: {
                    block23: {
                        columnName = header.get(i);
                        value = tmpRow.get(i);
                        if ("C_Location".equals(gridTab.getTableName())) break block22;
                        if (!header.get(i).contains(MTable.getTableName(Env.getCtx(), 162)) || isAddressValidated) break block23;
                        StringBuilder specialColumns = new StringBuilder();
                        specialColumns = this.validateSpecialFields(gridTab, header, tmpRow, i, "C_Location_ID");
                        isAddressValidated = true;
                        if (specialColumns != null) {
                            return specialColumns;
                        }
                        break block24;
                    }
                    if (header.get(i).contains(MTable.getTableName(Env.getCtx(), 162)) && isAddressValidated) break block24;
                }
                if (value != null) {
                    isEmptyRow = false;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Setting " + columnName + " to " + value);
                }
                boolean isKeyColumn = columnName.indexOf("/") > 0;
                boolean isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0;
                boolean isDetail = columnName.indexOf(">") > 0;
                columnName = this.getColumnName(isKeyColumn, isForeing, isDetail, columnName);
                String foreignColumn = null;
                if (isForeing) {
                    foreignColumn = header.get(i).substring(header.get(i).indexOf("[") + 1, header.get(i).indexOf("]"));
                }
                if ((field = gridTab.getField(columnName)) == null) {
                    return new StringBuilder(Msg.getMsg(Env.getCtx(), "NotAWindowField", new Object[]{header.get(i)}));
                }
                if (!field.isParentValue()) {
                    if (!field.isDisplayed() && !field.isDisplayedGrid()) {
                        return new StringBuilder(Msg.getMsg(Env.getCtx(), "FieldNotDisplayed", new Object[]{header.get(i)}));
                    }
                    MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                    boolean isWrongValueForMandatory = false;
                    if (field.isMandatory(false) || column.isMandatory()) {
                        if (this.isInsertMode() && value == null && field.getDefault() == null) {
                            isWrongValueForMandatory = true;
                        } else if (!this.isInsertMode() && "(null)".equals(value)) {
                            isWrongValueForMandatory = true;
                        }
                    }
                    if (isWrongValueForMandatory) {
                        mandatoryColumns.append(" / ");
                        mandatoryColumns.append(header.get(i));
                    }
                    if (isForeing && value != null && !"(null)".equals(value)) {
                        String foreignTable = column.getReferenceTableName();
                        String idS = null;
                        int id = -1;
                        if ("AD_Ref_List".equals(foreignTable)) {
                            idS = this.resolveForeignList(column, foreignColumn, value, null);
                        } else {
                            id = this.resolveForeign(foreignTable, foreignColumn, value, field, null);
                        }
                        if (idS == null && id < 0 && this.isUpdateMode()) {
                            return new StringBuilder(Msg.getMsg(Env.getCtx(), id == -2 ? "ForeignMultipleResolved" : "ForeignNotResolved", new Object[]{header.get(i), value}));
                        }
                    }
                }
            }
            ++i;
        }
        if (mandatoryColumns.length() > 1 && !isEmptyRow) {
            return new StringBuilder(String.valueOf(Msg.getMsg(Env.getCtx(), "FillMandatory")) + " " + mandatoryColumns);
        }
        return null;
    }

    private StringBuilder validateSpecialFields(GridTab gridTab, List<String> header, List<Object> tmpRow, int i, String sField) {
        GridField field = gridTab.getField(sField);
        if (field == null) {
            return new StringBuilder(Msg.getMsg(Env.getCtx(), "NotAWindowField", new Object[]{sField}));
        }
        if (!field.isDisplayed() && !field.isDisplayedGrid()) {
            return new StringBuilder(Msg.getMsg(Env.getCtx(), "FieldNotDisplayed", new Object[]{field.getColumnName()}));
        }
        if (header.get(i).contains(MTable.getTableName(Env.getCtx(), 162))) {
            boolean thereIsCountry = false;
            boolean isEmptyRow = true;
            int j = i;
            while (j < header.size()) {
                if (!header.get(j).contains(MTable.getTableName(Env.getCtx(), 162))) break;
                if (!header.get(j).contains(gridTab.getTableName())) {
                    return new StringBuilder().append("Invalid location column's name, it must contain its parent table: ").append(gridTab.getTableName().toString()).append("[").append(header.get(j)).append("]");
                }
                String columnName = header.get(j);
                Object value = tmpRow.get(j);
                if (value != null) {
                    String foreignTable;
                    int id;
                    if (columnName.contains("C_Country_ID")) {
                        thereIsCountry = true;
                    }
                    boolean isKeyColumn = columnName.indexOf("/") > 0;
                    boolean isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0;
                    boolean isDetail = columnName.indexOf(">") > 0;
                    String foreignColumn = null;
                    columnName = this.getColumnName(isKeyColumn, isForeing, isDetail, columnName);
                    if (isForeing) {
                        foreignColumn = header.get(j).substring(header.get(j).indexOf("[") + 1, header.get(j).indexOf("]"));
                    }
                    if (isForeing && !"(null)".equals(value) && (id = this.resolveForeign(foreignTable = columnName.substring(0, columnName.length() - 3), foreignColumn, value, field, null)) < 0) {
                        return new StringBuilder(Msg.getMsg(Env.getCtx(), id == -2 ? "ForeignMultipleResolved" : "ForeignNotResolved", new Object[]{header.get(j), value}));
                    }
                    isEmptyRow = false;
                }
                ++j;
            }
            MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
            if ((field.isMandatory(true) || column.isMandatory()) && !isEmptyRow && !thereIsCountry) {
                return new StringBuilder(String.valueOf(Msg.getMsg(Env.getCtx(), "FillMandatory")) + " " + field.getColumnName() + "[" + "C_Country_ID]");
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String proccessRow(GridTab gridTab, List<String> header, Map<String, Object> map, int startindx, int endindx, PO masterRecord, Trx trx) {
        boolean checkParentKey;
        String logMsg = null;
        boolean isThereRow = false;
        PO address = null;
        ArrayList<String> parentColumns = new ArrayList<String>();
        int i = startindx;
        while (i < endindx + 1) {
            String columnName = header.get(i);
            Object value = map.get(header.get(i));
            boolean isDetail = false;
            if (!(value == null || columnName.endsWith("_ID") && "0".equals(value) && !MTable.isZeroIDTable(gridTab.getTableName()))) {
                GridField field;
                boolean isKeyColumn = columnName.indexOf("/") > 0;
                boolean isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0;
                isDetail = columnName.indexOf(">") > 0;
                columnName = this.getColumnName(isKeyColumn, isForeing, isDetail, columnName);
                String foreignColumn = null;
                Object setValue = null;
                if (isForeing) {
                    foreignColumn = header.get(i).substring(header.get(i).indexOf("[") + 1, header.get(i).indexOf("]"));
                }
                if (!isForeing && !isKeyColumn && ("AD_Language".equals(columnName) || "EntityType".equals(columnName))) {
                    setValue = value;
                    field = gridTab.getField(columnName);
                    logMsg = gridTab.setValue(field, setValue);
                    if (logMsg != null && logMsg.equals("")) {
                        logMsg = null;
                    }
                } else if (!"C_Location".equals(gridTab.getTableName()) && header.get(i).contains(MTable.getTableName(Env.getCtx(), 162))) {
                    if (address == null) {
                        if (this.isInsertMode()) {
                            address = new MLocation(Env.getCtx(), 0, trx.getTrxName());
                        } else {
                            Integer location = gridTab.getValue("C_Location_ID") == null ? Integer.valueOf(0) : gridTab.getValue("C_Location_ID").toString();
                            int C_Location_ID = Integer.parseInt(((Object)location).toString());
                            address = new MLocation(Env.getCtx(), C_Location_ID, trx.getTrxName());
                        }
                    }
                    field = gridTab.getField(columnName);
                    if (!"(null)".equals(value.toString().trim())) {
                        if (isForeing) {
                            String foreignTable = columnName.substring(0, columnName.length() - 3);
                            setValue = this.resolveForeign(foreignTable, foreignColumn, value, field, trx);
                            if ("C_City".equals(foreignTable)) {
                                ((X_C_Location)address).setCity(value.toString());
                            }
                        } else {
                            setValue = value;
                        }
                    }
                    address.set_ValueOfColumn(columnName, setValue);
                } else if (!isKeyColumn || !this.isUpdateMode()) {
                    String foreignTable;
                    field = gridTab.getField(columnName);
                    if (field.isParentValue()) {
                        if ("(null)".equals(value.toString())) {
                            logMsg = Msg.getMsg(Env.getCtx(), "NoParentDelete", new Object[]{header.get(i)});
                            break;
                        }
                        if (isForeing && masterRecord != null) {
                            if (masterRecord.get_Value(foreignColumn).toString().equals(value)) {
                                logMsg = gridTab.setValue(field, (Object)masterRecord.get_ID());
                                if (!logMsg.equals("")) break;
                                logMsg = null;
                            } else if (value != null) {
                                logMsg = String.valueOf(header.get(i)) + " - " + Msg.getMsg(Env.getCtx(), "DiffParentValue", new Object[]{masterRecord.get_Value(foreignColumn).toString(), value});
                                break;
                            }
                        } else if (isForeing && masterRecord == null && gridTab.getTabLevel() > 0) {
                            Object master = gridTab.getParentTab().getValue(foreignColumn);
                            if (master != null && value != null && !master.toString().equals(value)) {
                                logMsg = String.valueOf(header.get(i)) + " - " + Msg.getMsg(Env.getCtx(), "DiffParentValue", new Object[]{master.toString(), value});
                                break;
                            }
                        } else if (masterRecord == null && isDetail) {
                            MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                            foreignTable = column.getReferenceTableName();
                            String idS = null;
                            int id = -1;
                            if ("AD_Ref_List".equals(foreignTable)) {
                                idS = this.resolveForeignList(column, foreignColumn, value, trx);
                            } else {
                                id = this.resolveForeign(foreignTable, foreignColumn, value, field, trx);
                            }
                            if (idS == null && id < 0) {
                                return Msg.getMsg(Env.getCtx(), id == -2 ? "ForeignMultipleResolved" : "ForeignNotResolved", new Object[]{header.get(i), value});
                            }
                            if (id >= 0) {
                                logMsg = gridTab.setValue(field, (Object)id);
                            } else if (idS != null) {
                                logMsg = gridTab.setValue(field, (Object)idS);
                            }
                            if (logMsg == null || !logMsg.equals("")) break;
                            logMsg = null;
                        }
                        parentColumns.add(columnName);
                    } else if (field.isDisplayed(true)) {
                        if ("(null)".equals(value.toString().trim())) {
                            logMsg = gridTab.setValue(field, null);
                            if (!logMsg.equals("")) break;
                            logMsg = null;
                        } else {
                            Object oldValue;
                            MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                            if (isForeing) {
                                foreignTable = column.getReferenceTableName();
                                if ("AD_Ref_List".equals(foreignTable)) {
                                    String idS = this.resolveForeignList(column, foreignColumn, value, trx);
                                    if (idS == null) {
                                        return Msg.getMsg(Env.getCtx(), "ForeignNotResolved", new Object[]{header.get(i), value});
                                    }
                                    setValue = idS;
                                    isThereRow = true;
                                } else {
                                    int actualId;
                                    int id = this.resolveForeign(foreignTable, foreignColumn, value, field, trx);
                                    if (id < 0) {
                                        return Msg.getMsg(Env.getCtx(), id == -2 ? "ForeignMultipleResolved" : "ForeignNotResolved", new Object[]{header.get(i), value});
                                    }
                                    setValue = id;
                                    if (field.isParentValue() && (actualId = ((Integer)field.getValue()).intValue()) != id) {
                                        logMsg = Msg.getMsg(Env.getCtx(), "ParentCannotChange", new Object[]{header.get(i)});
                                        break;
                                    }
                                    isThereRow = true;
                                }
                            } else if (value != null) {
                                int n;
                                int n2;
                                ValueNamePair[] valueNamePairArray;
                                if (value instanceof Date) {
                                    value = new Timestamp(((Date)value).getTime());
                                }
                                if (200012 == field.getDisplayType()) {
                                    oldValue = value.toString();
                                    valueNamePairArray = MRefList.getList(Env.getCtx(), 195, false);
                                    n2 = valueNamePairArray.length;
                                    n = 0;
                                    while (n < n2) {
                                        ValueNamePair pList = valueNamePairArray[n];
                                        if (pList.getName().equals(((String)oldValue).toString())) {
                                            oldValue = pList.getValue();
                                            break;
                                        }
                                        ++n;
                                    }
                                    if (value.toString().equals(oldValue)) return Msg.getMsg(Env.getCtx(), "ForeignNotResolved", new Object[]{header.get(i), value});
                                    value = oldValue;
                                } else if (28 == field.getDisplayType()) {
                                    if (column.getAD_Reference_Value_ID() != 135) return String.valueOf(Msg.getMsg(Env.getCtx(), "Invalid")) + " Column [" + column.getColumnName() + "]";
                                    oldValue = value.toString();
                                    valueNamePairArray = MRefList.getList(Env.getCtx(), 135, false);
                                    n2 = valueNamePairArray.length;
                                    n = 0;
                                    while (n < n2) {
                                        ValueNamePair pList = valueNamePairArray[n];
                                        if (pList.getName().equals(((String)oldValue).toString())) {
                                            oldValue = pList.getValue();
                                            break;
                                        }
                                        ++n;
                                    }
                                    if (value.toString().equals(oldValue)) return Msg.getMsg(Env.getCtx(), "ForeignNotResolved", new Object[]{header.get(i), value});
                                    value = oldValue;
                                } else if (DisplayType.isNumeric(field.getDisplayType()) || DisplayType.isID(field.getDisplayType())) {
                                    if (columnName.endsWith("_ID")) {
                                        if (!(value instanceof Integer)) {
                                            Integer idValue = Integer.valueOf(value.toString());
                                            value = idValue;
                                        }
                                    } else if (!(value instanceof BigDecimal)) {
                                        BigDecimal decValue = new BigDecimal(value.toString());
                                        value = decValue;
                                    }
                                }
                                setValue = value;
                                isThereRow = true;
                            }
                            if (setValue != null) {
                                oldValue = gridTab.getValue(field);
                                if (this.isValueChanged(oldValue, setValue)) {
                                    if (!field.isEditable(true)) {
                                        return Msg.getMsg(Env.getCtx(), "FieldIsReadOnly", new Object[]{header.get(i)});
                                    }
                                    logMsg = gridTab.setValue(field, setValue);
                                } else {
                                    logMsg = "";
                                }
                            }
                            if (logMsg == null || !logMsg.equals("")) break;
                            logMsg = null;
                        }
                    }
                }
            }
            ++i;
        }
        if (address != null) {
            if (!address.save()) {
                logMsg = CLogger.retrieveError() + " Address : " + address;
            } else {
                logMsg = gridTab.setValue("C_Location_ID", (Object)((X_C_Location)address).getC_Location_ID());
                if (!logMsg.equals("")) return logMsg;
                logMsg = null;
                isThereRow = true;
            }
        }
        boolean bl = checkParentKey = parentColumns.size() != gridTab.getParentColumnNames().size();
        if (isThereRow && logMsg == null && masterRecord != null && checkParentKey) {
            Iterator<String> iterator = gridTab.getParentColumnNames().iterator();
            while (iterator.hasNext()) {
                String linkColumn;
                String columnName = linkColumn = iterator.next();
                Object setValue = masterRecord.get_Value(linkColumn);
                if (setValue == null) {
                    columnName = null;
                    int j = startindx;
                    while (j < endindx + 1) {
                        if (header.get(j).contains(linkColumn)) {
                            columnName = header.get(j);
                            setValue = map.get(columnName);
                            break;
                        }
                        ++j;
                    }
                    if (columnName != null) {
                        boolean isForeing;
                        String foreignColumn = null;
                        boolean bl2 = isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0;
                        if (isForeing) {
                            foreignColumn = columnName.substring(columnName.indexOf("[") + 1, columnName.indexOf("]"));
                        }
                        columnName = this.getColumnName(false, isForeing, true, columnName);
                        GridField field = gridTab.getField(columnName);
                        MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                        if (isForeing) {
                            String foreignTable = column.getReferenceTableName();
                            if ("AD_Ref_List".equals(foreignTable)) {
                                String idS = this.resolveForeignList(column, foreignColumn, setValue, trx);
                                if (idS == null) {
                                    return Msg.getMsg(Env.getCtx(), "ForeignNotResolved", new Object[]{columnName, setValue});
                                }
                                setValue = idS;
                            } else {
                                int id = this.resolveForeign(foreignTable, foreignColumn, setValue, field, trx);
                                if (id < 0) {
                                    return Msg.getMsg(Env.getCtx(), id == -2 ? "ForeignMultipleResolved" : "ForeignNotResolved", new Object[]{columnName, setValue});
                                }
                                setValue = id;
                            }
                        }
                    } else {
                        logMsg = "Key: " + linkColumn + " " + Msg.getMsg(Env.getCtx(), "NotFound");
                        break;
                    }
                }
                if (!(logMsg = gridTab.setValue(linkColumn, setValue)).equals("")) continue;
                logMsg = null;
            }
        }
        if (logMsg != null) return logMsg;
        if (isThereRow) return logMsg;
        return "NO_DATA_TO_IMPORT";
    }

    private CellProcessor getProccesorFromColumn(GridField field) {
        if (15 == field.getDisplayType()) {
            return new Optional((CellProcessor)new ParseDate("yyyy-MM-dd"));
        }
        if (16 == field.getDisplayType()) {
            return new Optional((CellProcessor)new ParseDate("yyyy-MM-dd HH:mm:ss"));
        }
        if (24 == field.getDisplayType()) {
            return new Optional((CellProcessor)new ParseDate("HH:mm:ss"));
        }
        if (11 == field.getDisplayType()) {
            return new Optional((CellProcessor)new ParseInt());
        }
        if (DisplayType.isNumeric(field.getDisplayType())) {
            return new Optional((CellProcessor)new ParseBigDecimal(new DecimalFormatSymbols(Language.getLoginLanguage().getLocale())));
        }
        if (20 == field.getDisplayType()) {
            return new Optional((CellProcessor)new ParseBool("y", "n"));
        }
        if (36 == field.getDisplayType()) {
            return new Optional((CellProcessor)new StrMinMax(1L, Long.MAX_VALUE));
        }
        if (DisplayType.isText(field.getDisplayType())) {
            return new Optional((CellProcessor)new StrMinMax(1L, (long)field.getFieldLength()));
        }
        return null;
    }

    private String areValidKeysAndColumns(GridTab gridTab, Map<String, Object> map, List<String> header, int startindx, int endindx, PO masterRecord, Trx trx) {
        MQuery pquery = new MQuery(gridTab.getAD_Table_ID());
        String logMsg = null;
        Object tmpValue = null;
        String columnwithKey = null;
        Object setValue = null;
        ArrayList<String> parentColumns = new ArrayList<String>();
        int i = startindx;
        while (i < endindx + 1) {
            boolean isKeyColumn;
            boolean bl = isKeyColumn = header.get(i).indexOf("/") > 0 && (header.get(i).endsWith("K") || header.get(i).endsWith("KT"));
            if (isKeyColumn && ("C_Location".equals(gridTab.getTableName()) || !header.get(i).contains(MTable.getTableName(Env.getCtx(), 162)))) {
                boolean isForeing = header.get(i).indexOf("[") > 0 && header.get(i).indexOf("]") > 0;
                boolean isDetail = header.get(i).indexOf(">") > 0;
                columnwithKey = this.getColumnName(isKeyColumn, isForeing, isDetail, header.get(i));
                tmpValue = map.get(header.get(i)) instanceof Date ? new Timestamp(((Date)map.get(header.get(i))).getTime()) : map.get(header.get(i));
                if (tmpValue != null) {
                    GridField field = gridTab.getField(columnwithKey);
                    MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                    if (field.isParentValue()) {
                        parentColumns.add(column.getColumnName());
                    }
                    String foreignColumn = null;
                    if (isForeing) {
                        foreignColumn = header.get(i).substring(header.get(i).indexOf("[") + 1, header.get(i).indexOf("]"));
                        String foreignTable = column.getReferenceTableName();
                        if ("AD_Ref_List".equals(foreignTable)) {
                            String idS = this.resolveForeignList(column, foreignColumn, tmpValue, trx);
                            setValue = idS;
                        } else {
                            int id = this.resolveForeign(foreignTable, foreignColumn, tmpValue, field, trx);
                            setValue = id;
                        }
                    } else {
                        setValue = tmpValue;
                    }
                    pquery.addRestriction(columnwithKey, "=", setValue);
                }
            }
            ++i;
        }
        if (pquery.getRestrictionCount() > 0) {
            if (gridTab.isDetail()) {
                for (String linkColumn : gridTab.getParentColumnNames()) {
                    Object value;
                    if (pquery.getWhereClause().contains(linkColumn)) continue;
                    Object object = value = masterRecord != null ? masterRecord.get_Value(linkColumn) : null;
                    if (value == null) {
                        String columnName = null;
                        int j = startindx;
                        while (j < endindx + 1) {
                            if (header.get(j).contains(linkColumn)) {
                                columnName = header.get(j);
                                value = map.get(header.get(j));
                                break;
                            }
                            ++j;
                        }
                        if (columnName != null) {
                            boolean isForeing = columnName.indexOf("[") > 0 && columnName.indexOf("]") > 0;
                            columnwithKey = this.getColumnName(false, isForeing, true, columnName);
                            GridField field = gridTab.getField(columnwithKey);
                            MColumn column = MColumn.get(Env.getCtx(), field.getAD_Column_ID());
                            String foreignColumn = null;
                            if (isForeing) {
                                foreignColumn = columnName.substring(columnName.indexOf("[") + 1, columnName.indexOf("]"));
                                String foreignTable = column.getReferenceTableName();
                                if ("AD_Ref_List".equals(foreignTable)) {
                                    String idS = this.resolveForeignList(column, foreignColumn, value, trx);
                                    value = idS;
                                } else {
                                    int id = this.resolveForeign(foreignTable, foreignColumn, value, field, trx);
                                    value = id;
                                }
                            }
                        } else {
                            return String.valueOf(Msg.getMsg(Env.getCtx(), "FillMandatory")) + " " + linkColumn;
                        }
                    }
                    if (value == null) continue;
                    pquery.addRestriction(linkColumn, "=", value);
                }
            }
            gridTab.getTableModel().dataRequery(pquery.getWhereClause(), false, 0, false);
            if (this.isInsertMode()) {
                if (gridTab.getTableModel().getRowCount() >= 1) {
                    logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "AlreadyExists")) + " " + pquery;
                } else {
                    return null;
                }
            }
            if (this.isUpdateMode()) {
                if (gridTab.getTableModel().getRowCount() == 1) {
                    gridTab.navigateCurrent();
                    return null;
                }
                if (gridTab.getTableModel().getRowCount() <= 0) {
                    logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "not.found")) + " " + pquery;
                } else if (gridTab.getTableModel().getRowCount() > 1) {
                    logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "TooManyRows")) + " " + pquery;
                }
            }
            if (this.isMergeMode()) {
                if (gridTab.getTableModel().getRowCount() == 1) {
                    gridTab.navigateCurrent();
                    this.m_import_mode = IMPORT_MODE_UPDATE;
                } else if (gridTab.getTableModel().getRowCount() <= 0) {
                    this.m_import_mode = IMPORT_MODE_INSERT;
                } else if (gridTab.getTableModel().getRowCount() > 1) {
                    logMsg = String.valueOf(Msg.getMsg(Env.getCtx(), "TooManyRows")) + " " + pquery;
                }
            }
        }
        return logMsg;
    }

    private String resolveForeignList(MColumn column, String foreignColumn, Object value, Trx trx) {
        String idS = null;
        String trxName = trx != null ? trx.getTrxName() : null;
        StringBuilder select = new StringBuilder("SELECT Value FROM AD_Ref_List WHERE ").append(foreignColumn).append("=? AND AD_Reference_ID=? AND IsActive='Y'");
        idS = DB.getSQLValueStringEx(trxName, select.toString(), value, column.getAD_Reference_Value_ID());
        return idS;
    }

    private int resolveForeign(String foreignTable, String foreignColumn, Object value, GridField field, Trx trx) {
        MTable ft;
        String accessLevel;
        boolean systemAccess = false;
        if (!"AD_Client".equals(foreignTable) && ("7".equals(accessLevel = (ft = MTable.get(Env.getCtx(), foreignTable)).getAccessLevel()) || "4".equals(accessLevel) || "6".equals(accessLevel))) {
            systemAccess = true;
        }
        int thisClientId = Env.getAD_Client_ID(Env.getCtx());
        String trxName = trx != null ? trx.getTrxName() : null;
        StringBuilder postSelect = new StringBuilder(" FROM ").append(foreignTable).append(" WHERE ").append(foreignColumn).append("=? AND IsActive='Y' AND AD_Client_ID=?");
        if (field != null) {
            MRefTable refTable;
            String whereClause;
            if (!Util.isEmpty(field.getVO().ValidationCode)) {
                String dynamicValid = Env.parseContext(Env.getCtx(), field.getWindowNo(), field.getGridTab().getTabNo(), field.getVO().ValidationCode, false);
                if (Util.isEmpty(dynamicValid)) {
                    return 0;
                }
                postSelect.append(" AND (").append(dynamicValid).append(")");
            }
            int ref = field.getVO().displayType;
            int refval = field.getVO().AD_Reference_Value_ID;
            if (!(refval <= 0 || ref != 18 && ref != 30 || Util.isEmpty(whereClause = (refTable = (MRefTable)new Query(Env.getCtx(), "AD_Ref_Table", "AD_Reference_ID=?", trxName).setParameters(refval).firstOnly()).getWhereClause()))) {
                String dynamicValid = Env.parseContext(Env.getCtx(), field.getWindowNo(), field.getGridTab().getTabNo(), whereClause, false);
                if (Util.isEmpty(dynamicValid)) {
                    return 0;
                }
                postSelect.append(" AND (").append(dynamicValid).append(")");
            }
        }
        StringBuilder selectCount = new StringBuilder("SELECT COUNT(*)").append((CharSequence)postSelect);
        StringBuilder selectId = new StringBuilder("SELECT ").append(foreignTable).append("_ID").append((CharSequence)postSelect);
        int count = DB.getSQLValueEx(trxName, selectCount.toString(), value, thisClientId);
        if (count == 1) {
            return DB.getSQLValueEx(trxName, selectId.toString(), value, thisClientId);
        }
        if (count > 1) {
            return -2;
        }
        if (count == 0 && systemAccess && thisClientId != 0) {
            count = DB.getSQLValueEx(trxName, selectCount.toString(), value, 0);
            if (count == 1) {
                return DB.getSQLValueEx(trxName, selectId.toString(), value, 0);
            }
            if (count > 1) {
                return -2;
            }
        }
        return -3;
    }

    private boolean isValueChanged(Object oldValue, Object value) {
        boolean bChanged;
        if (this.isNotNullAndIsEmpty(oldValue)) {
            oldValue = null;
        }
        if (this.isNotNullAndIsEmpty(value)) {
            value = null;
        }
        boolean bl = bChanged = oldValue == null && value != null || oldValue != null && value == null;
        if (!bChanged && oldValue != null) {
            if (oldValue.getClass().equals(value.getClass())) {
                bChanged = oldValue instanceof Comparable ? ((Comparable)oldValue).compareTo(value) != 0 : !oldValue.equals(value);
            } else if (value != null) {
                bChanged = !oldValue.toString().equals(value.toString());
            }
        }
        return bChanged;
    }

    private boolean isNotNullAndIsEmpty(Object value) {
        return value != null && value instanceof String && value.toString().equals("");
    }

    @Override
    public String getFileExtension() {
        return "csv";
    }

    @Override
    public String getFileExtensionLabel() {
        return Msg.getMsg(Env.getCtx(), "FileCSV");
    }

    @Override
    public String getContentType() {
        return "application/csv";
    }

    @Override
    public String getSuggestedFileName(GridTab gridTab) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dt = sdf.format(cal.getTime());
        String localFile = "Import_" + gridTab.getTableName() + "_" + dt + (this.m_isError ? "_err" : "_log") + "." + this.getFileExtension();
        return localFile;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isSingleTrx() {
        return this.isSingleTrx;
    }

    public void setSingleTrx(boolean isSingleTrx) {
        this.isSingleTrx = isSingleTrx;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    static class ValueComparator
    implements Comparator<GridTab> {
        Map<GridTab, Integer> base;

        public ValueComparator(Map<GridTab, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(GridTab a, GridTab b) {
            if (this.base.get(a) >= this.base.get(b)) {
                return 1;
            }
            return -1;
        }
    }
}

