/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.base.event.AbstractEventHandler;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.RequestSendEMailEventData;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestAction;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.Event;

public class RequestEventHandler
extends AbstractEventHandler
implements ManagedService {
    private static final CLogger s_log = CLogger.getCLogger(RequestEventHandler.class);
    public static final String IGNORE_REQUEST_TYPES = "ignoreRequestTypes";
    private static ArrayList<String> ignoreRequestTypes = new ArrayList();

    @Override
    protected void doHandleEvent(Event event) {
        PO po;
        String topic = event.getTopic();
        if (topic.equals("idempiere/requestSendEMail")) {
            RequestSendEMailEventData eventData = (RequestSendEMailEventData)event.getProperty("event.data");
            if (!eventData.getClient().sendEMail(eventData.getFrom(), eventData.getTo(), eventData.getSubject(), eventData.getMessage(), eventData.getAttachment())) {
                int AD_Message_ID = 834;
                MNote note = new MNote(Env.getCtx(), AD_Message_ID, eventData.getTo().getAD_User_ID(), 417, eventData.getRequestID(), eventData.getSubject(), eventData.getMessage(), null);
                note.saveEx();
            }
        } else if ((topic.equals("adempiere/po/beforeNew") || topic.equals("adempiere/po/beforeChange") || topic.equals("adempiere/po/afterNew") || topic.equals("adempiere/po/afterChange")) && (po = this.getPO(event)).get_TableName().equals("R_Request")) {
            MRequest r = (MRequest)po;
            MRequestType rt = r.getRequestType();
            if (ignoreRequestTypes.contains(rt.getName())) {
                return;
            }
            if (topic.equals("adempiere/po/beforeNew") || topic.equals("adempiere/po/beforeChange")) {
                this.beforeSaveRequest(r, topic.equals("adempiere/po/beforeNew"));
            } else if (topic.equals("adempiere/po/afterNew") || topic.equals("adempiere/po/afterChange")) {
                this.afterSaveRequest(r, topic.equals("adempiere/po/afterNew"));
            }
        }
    }

    @Override
    protected void initialize() {
        this.registerEvent("idempiere/requestSendEMail");
        this.registerTableEvent("adempiere/po/beforeNew", "R_Request");
        this.registerTableEvent("adempiere/po/beforeChange", "R_Request");
        this.registerTableEvent("adempiere/po/afterNew", "R_Request");
        this.registerTableEvent("adempiere/po/afterChange", "R_Request");
    }

    private String beforeSaveRequest(MRequest r, boolean newRecord) {
        MRequestUpdate update;
        if (newRecord) {
            return null;
        }
        r.setIsChanged(false);
        ArrayList<String> sendInfo = new ArrayList<String>();
        MRequestAction ra = new MRequestAction(r, false);
        if (this.checkChange(r, ra, "R_RequestType_ID")) {
            sendInfo.add("R_RequestType_ID");
        }
        if (this.checkChange(r, ra, "R_Group_ID")) {
            sendInfo.add("R_Group_ID");
        }
        if (this.checkChange(r, ra, "R_Category_ID")) {
            sendInfo.add("R_Category_ID");
        }
        if (this.checkChange(r, ra, "R_Status_ID")) {
            sendInfo.add("R_Status_ID");
        }
        if (this.checkChange(r, ra, "R_Resolution_ID")) {
            sendInfo.add("R_Resolution_ID");
        }
        if (this.checkChange(r, ra, "SalesRep_ID")) {
            int AD_User_ID = Env.getContextAsInt(r.getCtx(), "#AD_User_ID");
            if (AD_User_ID == 0) {
                AD_User_ID = r.getUpdatedBy();
            }
            Object oo = r.get_ValueOld("SalesRep_ID");
            int oldSalesRep_ID = 0;
            if (oo instanceof Integer) {
                oldSalesRep_ID = (Integer)oo;
            }
            if (oldSalesRep_ID != 0) {
                Object[] args = new Object[]{r.getDocumentNo(), MUser.getNameOfUser(AD_User_ID), MUser.getNameOfUser(oldSalesRep_ID), MUser.getNameOfUser(r.getSalesRep_ID())};
                String msg = Msg.getMsg(r.getCtx(), "RequestActionTransfer", args);
                r.addToResult(msg);
                sendInfo.add("SalesRep_ID");
            }
        }
        this.checkChange(r, ra, "AD_Role_ID");
        this.checkChange(r, ra, "Priority");
        if (this.checkChange(r, ra, "PriorityUser")) {
            sendInfo.add("PriorityUser");
        }
        if (this.checkChange(r, ra, "IsEscalated")) {
            sendInfo.add("IsEscalated");
        }
        this.checkChange(r, ra, "ConfidentialType");
        this.checkChange(r, ra, "Summary");
        this.checkChange(r, ra, "IsSelfService");
        this.checkChange(r, ra, "C_BPartner_ID");
        this.checkChange(r, ra, "AD_User_ID");
        this.checkChange(r, ra, "C_Project_ID");
        this.checkChange(r, ra, "A_Asset_ID");
        this.checkChange(r, ra, "C_Order_ID");
        this.checkChange(r, ra, "C_Invoice_ID");
        this.checkChange(r, ra, "M_Product_ID");
        this.checkChange(r, ra, "C_Payment_ID");
        this.checkChange(r, ra, "M_InOut_ID");
        this.checkChange(r, ra, "M_RMA_ID");
        this.checkChange(r, ra, "IsInvoiced");
        this.checkChange(r, ra, "C_Activity_ID");
        this.checkChange(r, ra, "DateNextAction");
        this.checkChange(r, ra, "M_ProductSpent_ID");
        this.checkChange(r, ra, "QtySpent");
        this.checkChange(r, ra, "QtyInvoiced");
        this.checkChange(r, ra, "StartDate");
        this.checkChange(r, ra, "CloseDate");
        this.checkChange(r, ra, "TaskStatus");
        this.checkChange(r, ra, "DateStartPlan");
        this.checkChange(r, ra, "DateCompletePlan");
        if (r.is_Changed()) {
            ra.saveEx();
        }
        if ((update = new MRequestUpdate(r)).isNewInfo()) {
            update.saveEx();
        } else {
            update = null;
        }
        if (update != null || sendInfo.size() > 0) {
            this.sendNotices(r, sendInfo);
            r.setDateLastAction(r.getUpdated());
            r.setLastResult(r.getResult());
            r.setConfidentialTypeEntry(r.getConfidentialType());
            r.setEndTime(null);
            r.setR_StandardResponse_ID(0);
            r.setR_MailText_ID(0);
            r.setResult(null);
        }
        return null;
    }

    private String afterSaveRequest(MRequest r, boolean newRecord) {
        if (newRecord) {
            this.sendNotices(r, new ArrayList<String>());
        }
        return null;
    }

    public boolean checkChange(MRequest r, MRequestAction ra, String columnName) {
        if (r.is_ValueChanged(columnName)) {
            Object value = r.get_ValueOld(columnName);
            if (value == null) {
                ra.addNullColumn(columnName);
            } else if (value instanceof Boolean && ("IsEscalated".equals(columnName) || "IsSelfService".equals(columnName))) {
                ra.set_ValueNoCheck(columnName, (Boolean)value != false ? "Y" : "N");
            } else {
                ra.set_ValueNoCheck(columnName, value);
            }
            r.setIsChanged(true);
            return true;
        }
        return false;
    }

    private void sendNotices(MRequest r, ArrayList<String> list) {
        String subject = String.valueOf(Msg.translate(r.getCtx(), "R_Request_ID")) + " " + Msg.getMsg(r.getCtx(), "Updated") + ": " + r.getDocumentNo();
        StringBuilder message = new StringBuilder();
        int UpdatedBy = Env.getAD_User_ID(r.getCtx());
        MUser from = MUser.get(r.getCtx(), UpdatedBy);
        if (from != null) {
            message.append(Msg.translate(r.getCtx(), "UpdatedBy")).append(": ").append(from.getName());
        }
        if (r.getDateLastAction() != null) {
            message.append("\n").append(Msg.translate(r.getCtx(), "DateLastAction")).append(": ").append(r.getDateLastAction());
        } else {
            message.append("\n").append(Msg.translate(r.getCtx(), "Created")).append(": ").append(r.getCreated());
        }
        int i = 0;
        while (i < list.size()) {
            String columnName = list.get(i);
            message.append("\n").append(Msg.getElement(r.getCtx(), columnName)).append(": ").append(r.get_DisplayValue(columnName, false)).append(" -> ").append(r.get_DisplayValue(columnName, true));
            ++i;
        }
        if (r.getDateNextAction() != null) {
            message.append("\n").append(Msg.translate(r.getCtx(), "DateNextAction")).append(": ").append(r.getDateNextAction());
        }
        message.append("\n---------.----------.----------.----------.----------.----------\n").append(r.getSummary());
        if (r.getResult() != null) {
            message.append("\n----------\n").append(r.getResult());
        }
        message.append(this.getMailTrailer(r, null));
        File pdf = r.createPDF();
        if (s_log.isLoggable(Level.FINER)) {
            s_log.finer(message.toString());
        }
        MClient client = MClient.get(r.getCtx());
        if (from.getEMailUser() == null || from.getEMailUserPW() == null) {
            from = null;
        }
        ArrayList<Integer> userList = new ArrayList<Integer>();
        String sql = "SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement("SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name", r.get_TrxName());
                pstmt.setInt(1, r.getSalesRep_ID());
                pstmt.setInt(2, r.getR_Request_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_User_ID = rs.getInt(1);
                    String NotificationType = rs.getString(2);
                    if (NotificationType == null) {
                        NotificationType = "E";
                    }
                    String email = rs.getString(3);
                    String Name = rs.getString(4);
                    int AD_Role_ID = rs.getInt(5);
                    if (rs.wasNull()) {
                        AD_Role_ID = -1;
                    }
                    if (AD_Role_ID == -1 && (r.getConfidentialTypeEntry().equals("I") || r.getConfidentialTypeEntry().equals("P"))) continue;
                    if ("X".equals(NotificationType)) {
                        if (!s_log.isLoggable(Level.CONFIG)) continue;
                        s_log.config("Opt out: " + Name);
                        continue;
                    }
                    if (("E".equals(NotificationType) || "B".equals(NotificationType)) && (email == null || email.length() == 0)) {
                        if (AD_Role_ID >= 0) {
                            NotificationType = "N";
                        } else {
                            if (!s_log.isLoggable(Level.CONFIG)) continue;
                            s_log.config("No EMail: " + Name);
                            continue;
                        }
                    }
                    if ("N".equals(NotificationType) && AD_Role_ID < 0) {
                        if (!s_log.isLoggable(Level.CONFIG)) continue;
                        s_log.config("No internal User: " + Name);
                        continue;
                    }
                    Integer ii = AD_User_ID;
                    if (userList.contains(ii)) continue;
                    userList.add(ii);
                    MUser to = MUser.get(r.getCtx(), AD_User_ID);
                    if ("E".equals(NotificationType) || "B".equals(NotificationType)) {
                        RequestSendEMailEventData eventData = new RequestSendEMailEventData(client, from, to, subject, message.toString(), pdf, r.getR_Request_ID());
                        Event event = EventManager.newEvent("idempiere/requestSendEMail", eventData);
                        EventManager.getInstance().postEvent(event);
                    }
                    if (!"N".equals(NotificationType) && !"B".equals(NotificationType)) continue;
                    int AD_Message_ID = 834;
                    MNote note = new MNote(r.getCtx(), AD_Message_ID, AD_User_ID, 417, r.getR_Request_ID(), subject, message.toString(), r.get_TrxName());
                    note.saveEx();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, "SELECT u.AD_User_ID, u.NotificationType, u.EMail, u.Name, MAX(r.AD_Role_ID) FROM RV_RequestUpdates_Only ru INNER JOIN AD_User u ON (ru.AD_User_ID=u.AD_User_ID OR u.AD_User_ID=?) LEFT OUTER JOIN AD_User_Roles r ON (u.AD_User_ID=r.AD_User_ID) WHERE ru.R_Request_ID=? GROUP BY u.AD_User_ID, u.NotificationType, u.EMail, u.Name");
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private String getMailTrailer(MRequest r, String serverAddress) {
        StringBuilder sb = new StringBuilder("\n").append("\n---------.----------.----------.----------.----------.----------\n").append(Msg.translate(r.getCtx(), "R_Request_ID")).append(": ").append(r.getDocumentNo()).append("  ").append(r.getMailTag()).append("\n").append(Msg.getMsg(r.getCtx(), "RequestSentBy"));
        if (serverAddress != null) {
            sb.append(" from ").append(serverAddress);
        }
        return sb.toString();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        String p;
        if (properties != null && !Util.isEmpty(p = (String)properties.get(IGNORE_REQUEST_TYPES))) {
            ignoreRequestTypes.clear();
            StringTokenizer st = new StringTokenizer(p, ";");
            while (st.hasMoreTokens()) {
                ignoreRequestTypes.add(st.nextToken().trim());
            }
        }
    }
}

