/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event;

import java.util.List;
import org.adempiere.base.event.POEventData;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.osgi.service.event.Event;

public final class EventHelper {
    private EventHelper() {
    }

    public static PO getPO(Event event) {
        PO po = null;
        Object data = EventHelper.getEventData(event);
        if (data instanceof PO) {
            po = (PO)data;
        } else if (data instanceof POEventData) {
            po = ((POEventData)data).getPo();
        }
        return po;
    }

    public static ProcessInfo getProcessInfo(Event event) {
        return (ProcessInfo)EventHelper.getEventProperty(event, "event.data");
    }

    public static <T> T getEventData(Event event) {
        return EventHelper.getEventProperty(event, "event.data");
    }

    public static <T> T getEventProperty(Event event, String property) {
        return (T)event.getProperty(property);
    }

    public static void addError(Event event, Throwable e) {
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = e.toString();
        }
        EventHelper.addErrorMessage(event, msg);
        if (e instanceof Exception) {
            CLogger.get().saveError("Error", (Exception)e);
        }
    }

    public static void addErrorMessage(Event event, String errorMessage) {
        List errors = (List)EventHelper.getEventProperty(event, "event.errorMessages");
        if (errors != null) {
            errors.add(errorMessage);
        }
    }
}

